/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;

public class EnvUtil {
    private EnvUtil() {
    }

    public static String logbackVersion() {
        String moduleVersion = EnvUtil.logbackVersionByModule();
        if (moduleVersion != null) {
            return moduleVersion;
        }
        Package pkg = EnvUtil.class.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getImplementationVersion();
    }

    private static String logbackVersionByModule() {
        Module module = EnvUtil.class.getModule();
        if (module == null) {
            return null;
        }
        ModuleDescriptor md2 = module.getDescriptor();
        if (md2 == null) {
            return null;
        }
        Optional<String> opt = md2.rawVersion();
        return opt.orElse(null);
    }

    public static int getJDKVersion(String javaVersionStr) {
        int version = 0;
        for (char ch2 : javaVersionStr.toCharArray()) {
            if (Character.isDigit(ch2)) {
                version = version * 10 + (ch2 - 48);
                continue;
            }
            if (version != 1) break;
            version = 0;
        }
        return version;
    }

    private static boolean isJDK_N_OrHigher(int n2) {
        String javaVersionStr = System.getProperty("java.version", "");
        if (javaVersionStr.isEmpty()) {
            return false;
        }
        int version = EnvUtil.getJDKVersion(javaVersionStr);
        return version > 0 && n2 <= version;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK16OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(16);
    }

    public static boolean isJDK18OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(18);
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> bindingClass = classLoader.loadClass("org.codehaus.janino.ScriptEvaluator");
            return bindingClass != null;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean isWindows() {
        String os2 = System.getProperty("os.name");
        return os2.startsWith("Windows");
    }

    public static boolean isClassAvailable(Class callerClass, String className) {
        ClassLoader classLoader = Loader.getClassLoaderOfClass(callerClass);
        try {
            Class<?> bindingClass = classLoader.loadClass(className);
            return bindingClass != null;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }
}

