/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import java.util.List;

class Token {
    static final int PERCENT = 37;
    static final int RIGHT_PARENTHESIS = 41;
    static final int MINUS = 45;
    static final int DOT = 46;
    static final int CURLY_LEFT = 123;
    static final int CURLY_RIGHT = 125;
    static final int LITERAL = 1000;
    static final int FORMAT_MODIFIER = 1002;
    static final int SIMPLE_KEYWORD = 1004;
    static final int COMPOSITE_KEYWORD = 1005;
    static final int OPTION = 1006;
    static final int EOF = Integer.MAX_VALUE;
    static Token EOF_TOKEN = new Token(Integer.MAX_VALUE, "EOF");
    static Token RIGHT_PARENTHESIS_TOKEN = new Token(41);
    static Token BARE_COMPOSITE_KEYWORD_TOKEN = new Token(1005, "BARE");
    static Token PERCENT_TOKEN = new Token(37);
    private final int type;
    private final String value;
    private final List<String> optionsList;

    public Token(int type) {
        this(type, null, null);
    }

    public Token(int type, String value) {
        this(type, value, null);
    }

    public Token(int type, List<String> optionsList) {
        this(type, null, optionsList);
    }

    public Token(int type, String value, List<String> optionsList) {
        this.type = type;
        this.value = value;
        this.optionsList = optionsList;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getOptionsList() {
        return this.optionsList;
    }

    public String toString() {
        String typeStr = null;
        switch (this.type) {
            case 37: {
                typeStr = "%";
                break;
            }
            case 1002: {
                typeStr = "FormatModifier";
                break;
            }
            case 1000: {
                typeStr = "LITERAL";
                break;
            }
            case 1006: {
                typeStr = "OPTION";
                break;
            }
            case 1004: {
                typeStr = "SIMPLE_KEYWORD";
                break;
            }
            case 1005: {
                typeStr = "COMPOSITE_KEYWORD";
                break;
            }
            case 41: {
                typeStr = "RIGHT_PARENTHESIS";
                break;
            }
            default: {
                typeStr = "UNKNOWN";
            }
        }
        if (this.value == null) {
            return "Token(" + typeStr + ")";
        }
        return "Token(" + typeStr + ", \"" + this.value + "\")";
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Token)) {
            return false;
        }
        Token token = (Token)o2;
        if (this.type != token.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(token.value) : token.value != null);
    }
}

