/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> head) {
        for (Converter<E> c2 = head; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof CompositeConverter) {
                CompositeConverter cc2 = (CompositeConverter)c2;
                Converter childConverter = cc2.childConverter;
                ConverterUtil.startConverters(childConverter);
                cc2.start();
                continue;
            }
            if (!(c2 instanceof DynamicConverter)) continue;
            DynamicConverter dc2 = (DynamicConverter)c2;
            dc2.start();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> head) {
        Converter<E> next;
        Converter<E> p2 = head;
        while (p2 != null && (next = p2.getNext()) != null) {
            p2 = next;
        }
        return p2;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> head) {
        for (Converter<E> c2 = head; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof ContextAware) {
                ((ContextAware)((Object)c2)).setContext(context);
            }
            if (!(c2 instanceof CompositeConverter)) continue;
            CompositeConverter cc2 = (CompositeConverter)c2;
            Converter childConverter = cc2.childConverter;
            ConverterUtil.setContextForConverters(context, childConverter);
        }
    }
}

