/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.PropertyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;

public class PrefixCompositeConverter
extends CompositeConverter<ILoggingEvent> {
    @Override
    public String convert(ILoggingEvent event) {
        Converter<ILoggingEvent> childConverter;
        StringBuilder buf = new StringBuilder();
        for (Converter<ILoggingEvent> c2 = childConverter = this.getChildConverter(); c2 != null; c2 = c2.getNext()) {
            String key;
            if (c2 instanceof MDCConverter) {
                MDCConverter mdcConverter = (MDCConverter)c2;
                key = mdcConverter.getKey();
                if (key != null) {
                    buf.append(key).append("=");
                }
            } else if (c2 instanceof PropertyConverter) {
                PropertyConverter pc2 = (PropertyConverter)c2;
                key = pc2.getKey();
                if (key != null) {
                    buf.append(key).append("=");
                }
            } else {
                String classOfConverter = c2.getClass().getName();
                key = PatternLayout.CONVERTER_CLASS_TO_KEY_MAP.get(classOfConverter);
                if (key != null) {
                    buf.append(key).append("=");
                }
            }
            buf.append(c2.convert(event));
        }
        return buf.toString();
    }

    @Override
    protected String transform(ILoggingEvent event, String in2) {
        throw new UnsupportedOperationException();
    }
}

