/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util.mqtt;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttListener
implements Callable<JSONObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttListener.class);
    private final CountDownLatch barrier;
    private final String topic;
    private final String mqttServerUri;
    private MqttAsyncClient mqttClient;
    private JSONObject result;

    public MqttListener(String mqttServer, String topic) {
        this.mqttServerUri = mqttServer;
        this.topic = topic;
        this.barrier = new CountDownLatch(1);
    }

    public void connect() {
        try {
            final CountDownLatch connectBarrier = new CountDownLatch(1);
            this.mqttClient = new MqttAsyncClient(this.mqttServerUri, "STA-test_suite-" + this.topic + "-" + UUID.randomUUID(), (MqttClientPersistence)new MemoryPersistence());
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(true);
            this.mqttClient.connect((Object)connOpts, new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    MqttListener.this.mqttClient.setCallback(new MqttCallback(){

                        public void connectionLost(Throwable thrwbl) {
                            LOGGER.error("Exception:", thrwbl);
                            Assertions.fail((String)"MQTT connection lost.");
                        }

                        public void messageArrived(String topic, MqttMessage mm) {
                            if (MqttListener.this.barrier.getCount() > 0L) {
                                MqttListener.this.result = new JSONObject(new String(mm.getPayload(), StandardCharsets.UTF_8));
                                MqttListener.this.barrier.countDown();
                                LOGGER.debug("Received on {}. To go: {}", (Object)topic, (Object)MqttListener.this.barrier.getCount());
                            } else {
                                LOGGER.error("Received on {}. Barrier already empty!", (Object)topic);
                            }
                        }

                        public void deliveryComplete(IMqttDeliveryToken imdt) {
                        }
                    });
                    try {
                        MqttListener.this.mqttClient.subscribe(MqttListener.this.topic, 2, null, new IMqttActionListener(){

                            public void onSuccess(IMqttToken imt) {
                                LOGGER.debug("Subscribed to {}", (Object)MqttListener.this.topic);
                                connectBarrier.countDown();
                            }

                            public void onFailure(IMqttToken imt, Throwable thrwbl) {
                                LOGGER.error("Exception:", thrwbl);
                                Assertions.fail((String)("MQTT subscribe failed: " + thrwbl.getMessage()));
                            }
                        });
                    }
                    catch (MqttException ex) {
                        LOGGER.error("Exception:", (Throwable)ex);
                        Assertions.fail((String)("Error MQTT subscribe: " + ex.getMessage()));
                    }
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    LOGGER.error("Exception:", exception);
                    Assertions.fail((String)("MQTT connect failed: " + exception.getMessage()));
                }
            });
            try {
                connectBarrier.await();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Exception:", (Throwable)ex);
            }
        }
        catch (IllegalArgumentException | MqttException ex) {
            LOGGER.error("Exception:", ex);
            Assertions.fail((String)("Could not connect to MQTT server: " + ex.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject call() throws InterruptedException, MqttException {
        try {
            this.barrier.await();
            if (this.mqttClient == null) return this.result;
        }
        catch (InterruptedException ex) {
            try {
                LOGGER.error("waiting for MQTT events on {} timed out.", (Object)this.topic);
                LOGGER.error("Exception:", (Throwable)ex);
                Assertions.fail((String)("waiting for MQTT events on " + this.topic + " timed out: " + ex.getMessage()));
                if (this.mqttClient == null) return this.result;
            }
            catch (Throwable throwable) {
                if (this.mqttClient == null) throw throwable;
                LOGGER.trace("        Closing client: unsubscribing...");
                CountDownLatch unsubBarrier = new CountDownLatch(1);
                CountDownLatch disconnectBarrier = new CountDownLatch(1);
                if (this.mqttClient.isConnected()) {
                    this.mqttClient.unsubscribe(this.topic, null, new IMqttActionListener(){
                        final /* synthetic */ CountDownLatch val$unsubBarrier;
                        {
                            this.val$unsubBarrier = countDownLatch;
                        }

                        public void onSuccess(IMqttToken imt) {
                            this.val$unsubBarrier.countDown();
                        }

                        public void onFailure(IMqttToken imt, Throwable exception) {
                            LOGGER.error("Exception:", exception);
                            this.val$unsubBarrier.countDown();
                        }
                    });
                    unsubBarrier.await(10L, TimeUnit.SECONDS);
                    LOGGER.trace("        Closing client: disconnecting...");
                    this.mqttClient.disconnect(null, new IMqttActionListener(){
                        final /* synthetic */ CountDownLatch val$disconnectBarrier;
                        {
                            this.val$disconnectBarrier = countDownLatch;
                        }

                        public void onSuccess(IMqttToken asyncActionToken) {
                            this.val$disconnectBarrier.countDown();
                        }

                        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                            LOGGER.error("Exception:", exception);
                            this.val$disconnectBarrier.countDown();
                        }
                    });
                    disconnectBarrier.await(10L, TimeUnit.SECONDS);
                }
                LOGGER.trace("        Closing client: closing...");
                new Thread(() -> {
                    try {
                        this.mqttClient.close();
                    }
                    catch (MqttException ex) {
                        LOGGER.error("Exception closing MQTT connection.", (Throwable)ex);
                    }
                }, "MQTT-Close").start();
                LOGGER.trace("        Closing client: done.");
                throw throwable;
            }
            LOGGER.trace("        Closing client: unsubscribing...");
            CountDownLatch unsubBarrier = new CountDownLatch(1);
            CountDownLatch disconnectBarrier = new CountDownLatch(1);
            if (this.mqttClient.isConnected()) {
                this.mqttClient.unsubscribe(this.topic, null, new /* invalid duplicate definition of identical inner class */);
                unsubBarrier.await(10L, TimeUnit.SECONDS);
                LOGGER.trace("        Closing client: disconnecting...");
                this.mqttClient.disconnect(null, new /* invalid duplicate definition of identical inner class */);
                disconnectBarrier.await(10L, TimeUnit.SECONDS);
            }
            LOGGER.trace("        Closing client: closing...");
            new Thread(() -> {
                try {
                    this.mqttClient.close();
                }
                catch (MqttException ex) {
                    LOGGER.error("Exception closing MQTT connection.", (Throwable)ex);
                }
            }, "MQTT-Close").start();
            LOGGER.trace("        Closing client: done.");
            return this.result;
        }
        LOGGER.trace("        Closing client: unsubscribing...");
        CountDownLatch unsubBarrier = new CountDownLatch(1);
        CountDownLatch disconnectBarrier = new CountDownLatch(1);
        if (this.mqttClient.isConnected()) {
            this.mqttClient.unsubscribe(this.topic, null, new /* invalid duplicate definition of identical inner class */);
            unsubBarrier.await(10L, TimeUnit.SECONDS);
            LOGGER.trace("        Closing client: disconnecting...");
            this.mqttClient.disconnect(null, new /* invalid duplicate definition of identical inner class */);
            disconnectBarrier.await(10L, TimeUnit.SECONDS);
        }
        LOGGER.trace("        Closing client: closing...");
        new Thread(() -> {
            try {
                this.mqttClient.close();
            }
            catch (MqttException ex) {
                LOGGER.error("Exception closing MQTT connection.", (Throwable)ex);
            }
        }, "MQTT-Close").start();
        LOGGER.trace("        Closing client: done.");
        return this.result;
    }
}

