/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.sta.model.Entity;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static String urlEncode(String link) {
        try {
            return URLEncoder.encode(link, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return link;
        }
    }

    public static String quoteIdForJson(Object id) {
        if (id instanceof Number) {
            return id.toString();
        }
        return "\"" + id + "\"";
    }

    public static String quoteIdForUrl(Object id) {
        if (id instanceof Number) {
            return id.toString();
        }
        return "'" + id + "'";
    }

    public static Object idObjectFromPostResult(String postResultLine) {
        int pos1 = postResultLine.lastIndexOf("(") + 1;
        int pos2 = postResultLine.lastIndexOf(")");
        String part = postResultLine.substring(pos1, pos2);
        try {
            return Long.parseLong(part);
        }
        catch (NumberFormatException exc) {
            if (!part.startsWith("'") || !part.endsWith("'")) {
                throw new IllegalArgumentException("Strings in urls must be quoted with single quotes.");
            }
            return part.substring(1, part.length() - 1);
        }
    }

    public static <T extends Entity<T>> List<T> getFromList(List<T> list, int ... ids) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (int i : ids) {
            result.add((Entity)list.get(i));
        }
        return result;
    }

    public static <T extends Entity<T>> List<T> getFromListExcept(List<T> list, int ... ids) {
        ArrayList<T> result = new ArrayList<T>(list);
        for (int i : ids) {
            result.remove(list.get(i));
        }
        return result;
    }

    public static <T extends Entity<T>> List<T> removeFromList(List<T> sourceList, List<T> remaining, int ... ids) {
        for (int i : ids) {
            remaining.remove(sourceList.get(i));
        }
        return remaining;
    }
}

