/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public class ServiceUrlHelper {
    private ServiceUrlHelper() {
    }

    public static String buildURLString(String rootURI, EntityType parentEntityType, Object parentId, EntityType relationEntityType, String property) {
        Object urlString = rootURI;
        urlString = (String)urlString + "/" + parentEntityType.plural;
        if (parentId != null) {
            urlString = (String)urlString + "(" + Utils.quoteIdForUrl(parentId) + ")";
        }
        if (relationEntityType != null) {
            if (parentEntityType.getRelations(relationEntityType.extension).contains(relationEntityType.singular)) {
                urlString = (String)urlString + "/" + relationEntityType.singular;
            } else if (parentEntityType.getRelations(relationEntityType.extension).contains(relationEntityType.plural)) {
                urlString = (String)urlString + "/" + relationEntityType.plural;
            } else {
                Assertions.fail((String)("Entity type relation is not recognized in SensorThings API : " + parentEntityType + " and " + relationEntityType));
            }
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? (String)urlString + property : (String)urlString + "/" + property;
        }
        return urlString;
    }

    public static String buildURLString(String rootURI, List<String> entityTypes, List<Object> ids, String property) {
        Object urlString = rootURI;
        if (entityTypes.size() != ids.size() && entityTypes.size() != ids.size() + 1) {
            Assertions.fail((String)"There is problem with the path of entities!!!");
        }
        if (((String)urlString).charAt(((String)urlString).length() - 1) != '/') {
            urlString = (String)urlString + "/";
        }
        for (int i = 0; i < entityTypes.size(); ++i) {
            urlString = (String)urlString + entityTypes.get(i);
            if (i >= ids.size()) continue;
            Object id = ids.get(i);
            urlString = id == null ? (String)urlString + "/" : (String)urlString + "(" + Utils.quoteIdForUrl(id) + ")/";
        }
        if (((String)urlString).charAt(((String)urlString).length() - 1) == '/') {
            urlString = ((String)urlString).substring(0, ((String)urlString).length() - 1);
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? (String)urlString + property : (String)urlString + "/" + property;
        }
        return urlString;
    }
}

