/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Utils;

public class PathElement
implements Cloneable {
    private final EntityType entityType;
    private final boolean plural;
    private final Object id;

    public PathElement(EntityType entityType, boolean plural, Object id) {
        this.entityType = entityType;
        this.plural = plural;
        this.id = id;
    }

    public PathElement(String pathPart) {
        this(pathPart, null);
    }

    public PathElement(String pathPart, Object id) {
        this.entityType = EntityType.getForRelation(pathPart);
        this.plural = EntityType.isPlural(pathPart);
        this.id = id;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getPropertyName() {
        return this.plural ? this.entityType.plural : this.entityType.singular;
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        value.append(this.plural ? this.entityType.plural : this.entityType.singular);
        if (this.id != null) {
            value.append('(').append(Utils.quoteIdForUrl(this.id)).append(')');
        }
        return value.toString();
    }

    public boolean isCollection() {
        return this.plural && this.id == null;
    }

    public Object getId() {
        return this.id;
    }

    protected PathElement clone() {
        PathElement clone;
        try {
            clone = (PathElement)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        return clone;
    }
}

