/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import java.util.UUID;

public enum IdType {
    LONG(() -> 9223372036854774807L),
    STRING(() -> java.util.UUID.randomUUID()),
    UUID(() -> java.util.UUID.randomUUID());

    private final RandomGenerator generator;

    private IdType(RandomGenerator generator) {
        this.generator = generator;
    }

    public Object generateUnlikely() {
        return this.generator.generate();
    }

    public static IdType findFor(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("null object can not be converted.");
        }
        if (id instanceof Number) {
            return LONG;
        }
        try {
            java.util.UUID.fromString(id.toString());
            return UUID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (id instanceof String) {
                return STRING;
            }
            throw new IllegalArgumentException("Can not detect id type from " + id);
        }
    }

    private static interface RandomGenerator {
        public Object generate();
    }
}

