/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.DeepInsertInfo;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityHelper.class);
    private final String rootUri;
    private final ServerVersion version;
    private final ServerSettings serverSettings;
    private final Map<EntityType, Object> latestEntities = new HashMap<EntityType, Object>();

    public EntityHelper(ServerVersion version, ServerSettings serverSettings) {
        this.rootUri = serverSettings.getServiceUrl(version);
        this.version = version;
        this.serverSettings = serverSettings;
    }

    private static String concatOverlapping(String s1, String s2) {
        if (!s1.contains(s2.substring(0, 1))) {
            return s1 + s2;
        }
        int idx = s2.length();
        try {
            while (!s1.endsWith(s2.substring(0, idx))) {
                --idx;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s1 + s2.substring(idx);
    }

    public void deleteEverything() {
        this.deleteEntityType(EntityType.FEATURE_OF_INTEREST);
        this.deleteEntityType(EntityType.SENSOR);
        this.deleteEntityType(EntityType.OBSERVED_PROPERTY);
        this.deleteEntityType(EntityType.HISTORICAL_LOCATION);
        this.deleteEntityType(EntityType.LOCATION);
        this.deleteEntityType(EntityType.THING);
        this.deleteEntityType(EntityType.DATASTREAM);
        this.deleteEntityType(EntityType.OBSERVATION);
        if (this.serverSettings.implementsRequirement(this.version, ServerSettings.TASKING_REQ)) {
            this.deleteEntityType(EntityType.ACTUATOR);
            this.deleteEntityType(EntityType.TASKING_CAPABILITY);
            this.deleteEntityType(EntityType.TASK);
        }
        this.latestEntities.clear();
    }

    public void deleteEntityType(EntityType entityType) {
        JSONArray array = null;
        do {
            try {
                String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, null, null, null);
                HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
                JSONObject result = new JSONObject(responseMap.response);
                array = result.getJSONArray("value");
                for (int i = 0; i < array.length(); ++i) {
                    Object id = array.getJSONObject(i).get("@iot.id");
                    this.deleteEntity(entityType, id);
                }
            }
            catch (JSONException e) {
                LOGGER.error("Exception: ", (Throwable)e);
                Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            }
        } while (array.length() > 0);
    }

    public Object createDatastream(Object thingId, Object observedPropertyId, Object sensorId) {
        try {
            String urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"phenomenonTime\": \"2014-03-01T13:00:00Z/2015-05-11T15:30:00Z\",\n  \"resultTime\": \"2014-03-01T13:00:00Z/2015-05-11T15:30:00Z\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(observedPropertyId) + "},\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(sensorId) + " }\n}";
            JSONObject entity = this.postEntity(EntityType.DATASTREAM, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createDatastreamWithDeepInsert(Object thingId) {
        try {
            String urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n   \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
            JSONObject entity = this.postEntity(EntityType.DATASTREAM, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("An Exception occurred during testing: " + ex));
            return -1L;
        }
    }

    public Object createFeatureOfInterest() {
        try {
            String urlParameters = "{\n  \"name\": \"A weather station.\",\n  \"description\": \"A weather station.\",\n  \"encodingType\": \"application/vnd.geo+json\",\n  \"feature\": {\n    \"type\": \"Point\",\n    \"coordinates\": [\n      10,\n      10\n    ]\n  }\n}";
            JSONObject entity = this.postEntity(EntityType.FEATURE_OF_INTEREST, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createHistoricalLocation(Object thingId, Object locationId) {
        try {
            String urlParameters = "{\n  \"time\": \"2015-03-01T00:40:00.000Z\",\n  \"Thing\":{\"@iot.id\": " + Utils.quoteIdForJson(thingId) + "},\n  \"Locations\": [{\"@iot.id\": " + Utils.quoteIdForJson(locationId) + "}]  \n}";
            JSONObject entity = this.postEntity(EntityType.HISTORICAL_LOCATION, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createLocation(Object thingId) {
        try {
            String urlParameters = "{\n  \"name\": \"bow river\",\n  \"description\": \"bow river\",\n  \"encodingType\": \"application/vnd.geo+json\",\n  \"Things\":[{\"@iot.id\": " + Utils.quoteIdForJson(thingId) + "}],\n  \"location\": { \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }\n}";
            JSONObject entity = this.postEntity(EntityType.LOCATION, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createObservation(Object datastreamId, Object featureOfInterstId) {
        try {
            String urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"validTime\": \"2016-01-01T02:01:01+01:00/2016-01-02T00:59:59+01:00\",\n  \"result\": 8,\n  \"parameters\":{\"param1\": \"some value1\", \"param2\": \"some value2\"},\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "},\n  \"FeatureOfInterest\": {\"@iot.id\": " + Utils.quoteIdForJson(featureOfInterstId) + "}\n}";
            JSONObject entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createObservation(Object datastreamId) {
        try {
            String urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"validTime\": \"2016-01-01T02:01:01+01:00/2016-01-02T00:59:59+01:00\",\n  \"result\": 8,\n  \"parameters\":{\"param1\": \"some value1\", \"param2\": \"some value2\"},\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
            JSONObject entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createObservationWithDeepInsert(Object datastreamId) {
        try {
            String urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"FeatureOfInterest\": {\n  \t\"name\": \"A weather station.\",\n  \t\"description\": \"A weather station.\",\n  \t\"encodingType\": \"application/vnd.geo+json\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  },\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
            JSONObject entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException ex) {
            Assertions.fail((String)("An Exception occurred during testing: " + ex));
            return -1L;
        }
    }

    public Object createObservedProperty() {
        try {
            String urlParameters = "{\n  \"name\": \"DewPoint Temperature\",\n  \"definition\": \"http://dbpedia.org/page/Dew_point\",\n  \"description\": \"The dewpoint temperature is the temperature to which the air must be cooled, at constant pressure, for dew to form. As the grass and other objects near the ground cool to the dewpoint, some of the water vapor in the atmosphere condenses into liquid water on the objects.\"\n}";
            JSONObject entity = this.postEntity(EntityType.OBSERVED_PROPERTY, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createSensor() {
        try {
            String urlParameters = "{\n  \"name\": \"Fuguro Barometer\",\n  \"description\": \"Fuguro Barometer\",\n  \"encodingType\": \"http://schema.org/description\",\n  \"metadata\": \"Barometer\"\n}";
            JSONObject entity = this.postEntity(EntityType.SENSOR, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createThing() {
        try {
            String urlParameters = "{\"name\":\"Test Thing\",\"description\":\"This is a Test Thing From TestNG\"}";
            JSONObject entity = this.postEntity(EntityType.THING, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1;
        }
    }

    public Object createThingWithDeepInsert() {
        try {
            String urlParameters = "{\n  \"name\": \"Office Building\",\n  \"description\": \"Office Building\",\n  \"properties\": {\n    \"reference\": \"Third Floor\"\n  },\n  \"Locations\": [\n    {\n      \"name\": \"West Roof\",\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"application/vnd.geo+json\"\n    }\n  ],\n  \"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"name\": \"Light exposure.\",\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n      \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n      \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n      }\n    }\n  ]\n}";
            JSONObject entity = this.postEntity(EntityType.THING, urlParameters);
            return entity.get("@iot.id");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("An Exception occurred during testing: " + ex.getMessage()));
            return -1L;
        }
    }

    public void deleteEntity(EntityType entityType, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, id, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = responseMap.code;
        String message = "DELETE does not work properly for " + entityType + " with id " + id + ". Returned with response code " + responseCode + ".";
        Assertions.assertEquals((int)200, (int)responseCode, (String)message);
        responseMap = HTTPMethods.doGet(urlString);
        responseCode = responseMap.code;
        message = "Deleted entity was not actually deleted : " + entityType + "(" + id + ").";
        Assertions.assertEquals((int)404, (int)responseCode, (String)message);
    }

    public DeepInsertInfo getDeepInsertInfo(EntityType entityType) {
        DeepInsertInfo result = new DeepInsertInfo(entityType);
        switch (entityType) {
            case THING: {
                result.getSubEntityTypes().add(EntityType.LOCATION);
                result.getSubEntityTypes().add(EntityType.DATASTREAM);
                result.getSubEntityTypes().add(EntityType.OBSERVED_PROPERTY);
                result.getSubEntityTypes().add(EntityType.SENSOR);
                break;
            }
            case DATASTREAM: {
                result.getSubEntityTypes().add(EntityType.OBSERVATION);
                result.getSubEntityTypes().add(EntityType.OBSERVED_PROPERTY);
                result.getSubEntityTypes().add(EntityType.SENSOR);
                break;
            }
            case OBSERVATION: {
                result.getSubEntityTypes().add(EntityType.FEATURE_OF_INTEREST);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public JSONObject getEntity(EntityType entityType, Object id) {
        if (id == null) {
            return null;
        }
        String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, id, null, null);
        try {
            return new JSONObject(HTTPMethods.doGet((String)urlString).response);
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!: " + e.getMessage()));
            return null;
        }
    }

    public JSONObject getEntity(String relativeUrl) {
        String urlString = EntityHelper.concatOverlapping(this.rootUri, relativeUrl);
        try {
            return new JSONObject(HTTPMethods.doGet((String)urlString).response);
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!: " + e.getMessage()));
            return null;
        }
    }

    public Object getLastestEntityId(EntityType entityType) {
        return this.latestEntities.get((Object)entityType);
    }

    public JSONObject getAnyEntity(EntityType entityType, String queryOptions, int retries) {
        String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, null, null, null) + "?$top=1";
        if (queryOptions != null && !queryOptions.isEmpty()) {
            urlString = urlString + "&" + queryOptions;
        }
        try {
            int retry = 0;
            while (retry < retries) {
                String json = HTTPMethods.doGet((String)urlString).response;
                JSONArray items = new JSONObject(json).getJSONArray("value");
                if (!items.isEmpty()) {
                    return items.getJSONObject(0);
                }
                LOGGER.debug("No data yet. Retries: {}, URL: {}", (Object)(++retry), (Object)urlString);
                MqttHelper.waitMillis(100L);
            }
            LOGGER.error("Failed to read an entity from url after {} tries: {}", (Object)retries, (Object)urlString);
            return null;
        }
        catch (JSONException e) {
            LOGGER.error("Failed while reading from url {}", (Object)urlString);
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!: " + e.getMessage()));
            return null;
        }
    }

    public Map<String, Object> getEntityChanges(EntityType entityType, List<String> selectedProperties) {
        return this.getEntityChanges(entityType).entrySet().stream().filter(x -> selectedProperties.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()));
    }

    public Map<String, Object> getEntityChanges(EntityType entityType) {
        switch (entityType) {
            case THING: {
                return this.getThingChanges();
            }
            case DATASTREAM: {
                return this.getDatastreamChanges();
            }
            case FEATURE_OF_INTEREST: {
                return this.getFeatureOfInterestChanges();
            }
            case HISTORICAL_LOCATION: {
                return this.getHistoricalLocationChanges();
            }
            case LOCATION: {
                return this.getLocationChanges();
            }
            case OBSERVATION: {
                return this.getObservationChanges();
            }
            case OBSERVED_PROPERTY: {
                return this.getObservedPropertyChanges();
            }
            case SENSOR: {
                return this.getSensorChanges();
            }
        }
        throw new IllegalStateException("Unsupported entityType '" + entityType + "'");
    }

    public JSONObject patchEntity(EntityType entityType, Map<String, Object> changes, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, id, null, null);
        HTTPMethods.HttpResponse responseMap = null;
        try {
            responseMap = HTTPMethods.doPatch(urlString, new JSONObject(changes).toString());
            int responseCode = responseMap.code;
            String message = "Error during updating(PATCH) of entity " + entityType.name();
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            LOGGER.error("Response: {}", responseMap);
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    public JSONObject putEntity(EntityType entityType, Map<String, Object> changes, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, id, null, null);
        try {
            JSONObject entity = this.getEntity(entityType, id);
            this.clearLinks(entity);
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                entity.put(entry.getKey(), entry.getValue());
            }
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doPut(urlString, entity.toString());
            int responseCode = responseMap.code;
            String message = "Error during updating(PUT) of entity " + entityType.name() + ": " + responseMap.response;
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    public JSONObject updateEntitywithPATCH(EntityType entityType, Object id) {
        this.latestEntities.put(entityType, id);
        return this.patchEntity(entityType, this.getEntityChanges(entityType), id);
    }

    public JSONObject updateEntitywithPUT(EntityType entityType, Object id) {
        this.latestEntities.put(entityType, id);
        return this.putEntity(entityType, this.getEntityChanges(entityType), id);
    }

    private void clearLinks(Object obj) {
        if (!(obj instanceof JSONObject)) {
            return;
        }
        JSONObject entity = (JSONObject)obj;
        Iterator iterator = entity.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (key.contains("@")) {
                iterator.remove();
                continue;
            }
            try {
                Object val = entity.get(key);
                if (val instanceof JSONObject) {
                    this.clearLinks((JSONObject)val);
                    continue;
                }
                if (!(val instanceof JSONArray)) continue;
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.length(); ++i) {
                    this.clearLinks(arr.get(i));
                }
            }
            catch (JSONException ex) {
                Assertions.fail();
            }
        }
    }

    private Map<String, Object> getDatastreamChanges() {
        try {
            HashMap<String, Object> changes = new HashMap<String, Object>();
            changes.put("name", "Data coming from sensor on ISS.");
            changes.put("description", "Data coming from sensor on ISS.");
            changes.put("observationType", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation");
            changes.put("unitOfMeasurement", new JSONObject("{\"name\": \"Entropy\",\"symbol\": \"S\",\"definition\": \"http://qudt.org/vocab/unit#Entropy\"}"));
            return changes;
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Generating Datastream changes failed: " + ex.getMessage()));
            throw new IllegalStateException();
        }
    }

    private Map<String, Object> getFeatureOfInterestChanges() {
        try {
            HashMap<String, Object> changes = new HashMap<String, Object>();
            changes.put("encodingType", "SQUARE");
            changes.put("feature", new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }"));
            changes.put("name", "POIUYTREW");
            changes.put("description", "POIUYTREW");
            return changes;
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Generating FeatureOfInterest changes failed: " + ex.getMessage()));
            throw new IllegalStateException();
        }
    }

    private Map<String, Object> getHistoricalLocationChanges() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("time", "2015-08-01T00:00:00.000Z");
        return changes;
    }

    private Map<String, Object> getLocationChanges() {
        try {
            HashMap<String, Object> changes = new HashMap<String, Object>();
            changes.put("encodingType", "UPDATED ENCODING");
            changes.put("name", "UPDATED NAME");
            changes.put("description", "UPDATED DESCRIPTION");
            changes.put("location", new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 50] }}"));
            return changes;
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Generating Location changes failed: " + ex.getMessage()));
            throw new IllegalStateException();
        }
    }

    private Map<String, Object> getObservationChanges() {
        try {
            HashMap<String, Object> changes = new HashMap<String, Object>();
            changes.put("result", "99");
            changes.put("phenomenonTime", "2015-08-01T00:40:00.000Z");
            changes.put("resultTime", "2015-12-12T12:12:12.000Z");
            changes.put("validTime", "2016-12-12T12:12:12+01:00/2016-12-12T23:59:59+01:00");
            changes.put("parameters", new JSONObject("{\"param1\": \"some updated value1\", \"param2\": \"some updated value2\"}"));
            return changes;
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Generating Observation changes failed: " + ex.getMessage()));
            throw new IllegalStateException();
        }
    }

    private Map<String, Object> getObservedPropertyChanges() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("name", "QWERTY");
        changes.put("definition", "ZXCVB");
        changes.put("description", "POIUYTREW");
        return changes;
    }

    private Map<String, Object> getSensorChanges() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("name", "UPDATED");
        changes.put("description", "UPDATED");
        changes.put("encodingType", "http://schema.org/newDescription");
        changes.put("metadata", "UPDATED");
        return changes;
    }

    private Map<String, Object> getThingChanges() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("name", "This is a Updated Test Thing From TestNG");
        changes.put("description", "This is a Updated Test Thing From TestNG");
        return changes;
    }

    public Map<String, Object> getThingChangesLocation(Object locationId) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("@iot.id", locationId);
        ArrayList<HashMap<String, Object>> locations = new ArrayList<HashMap<String, Object>>();
        locations.add(location);
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("Locations", locations);
        return changes;
    }

    private JSONObject postEntity(EntityType entityType, String urlParameters) {
        Object urlString = ServiceUrlHelper.buildURLString(this.rootUri, entityType, null, null, null);
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost((String)urlString, urlParameters);
            int responseCode = responseMap.code;
            Object message = "Error during creation of entity " + entityType.name();
            Assertions.assertEquals((int)201, (int)responseCode, (String)message);
            String response = responseMap.response;
            String id = response.substring(response.indexOf("(") + 1, response.indexOf(")"));
            urlString = (String)urlString + "(" + id + ")";
            responseMap = HTTPMethods.doGet((String)urlString);
            responseCode = responseMap.code;
            message = "The POSTed entity is not created.";
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }
}

