/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class EntityCounts {
    private final Map<EntityType, Long> globalCounts = new EnumMap<EntityType, Long>(EntityType.class);
    private final Map<EntityType, Map<Object, Map<EntityType, Long>>> linkedCounts = new EnumMap<EntityType, Map<Object, Map<EntityType, Long>>>(EntityType.class);

    public long getCount(EntityType type) {
        Long count = this.globalCounts.get((Object)type);
        return count == null ? -1L : count;
    }

    public long getCount(EntityType parentType, Object parentId, EntityType linkedType) {
        Map<Object, Map<EntityType, Long>> parents = this.linkedCounts.get((Object)parentType);
        if (parents == null) {
            return -1L;
        }
        Map<EntityType, Long> parent = parents.get(parentId);
        if (parent == null) {
            return -1L;
        }
        Long count = parent.get((Object)linkedType);
        return count == null ? -1L : count;
    }

    private Map<Object, Map<EntityType, Long>> getParents(EntityType type) {
        Map<Object, Map<EntityType, Long>> parents = this.linkedCounts.get((Object)type);
        if (parents == null) {
            parents = new HashMap<Object, Map<EntityType, Long>>();
            this.linkedCounts.put(type, parents);
        }
        return parents;
    }

    private Map<EntityType, Long> getCounts(EntityType parentType, Object parentId) {
        Map<Object, Map<EntityType, Long>> parents = this.getParents(parentType);
        Map<EntityType, Long> parent = parents.get(parentId);
        if (parent == null) {
            parent = new EnumMap<EntityType, Long>(EntityType.class);
            parents.put(parentId, parent);
        }
        return parent;
    }

    public EntityCounts setGlobalCount(EntityType type, long count) {
        this.globalCounts.put(type, count);
        return this;
    }

    public EntityCounts setCount(EntityType parentType, Object parentId, EntityType linkedType, long count) {
        this.getCounts(parentType, parentId).put(linkedType, count);
        return this;
    }

    public void clear() {
        this.globalCounts.clear();
        this.linkedCounts.clear();
    }
}

