/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.f03metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.IdLong;
import de.fraunhofer.iosb.ilt.sta.model.IdString;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.geojson.GeoJsonObject;
import org.geojson.Point;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class MetadataTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MetadataTests.class.getName());
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<FeatureOfInterest> FEATURES = new ArrayList<FeatureOfInterest>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final Properties SERVER_PROPERTIES = new Properties();

    public MetadataTests(ServerVersion version) {
        super(version, SERVER_PROPERTIES);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)MetadataTests.version.urlPart);
        MetadataTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        LOGGER.info("Cleaning up after version {}.", (Object)MetadataTests.version.urlPart);
        MetadataTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        MetadataTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        FEATURES.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing1 = new Thing("Thing 1", "The first thing.");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        thing1.setProperties(properties);
        service.create((Entity)thing1);
        THINGS.add(thing1);
        Thing thing2 = new Thing("Thing 2", "The second thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing1.getId().getValue());
        thing2.setProperties(properties);
        service.create((Entity)thing2);
        THINGS.add(thing2);
        Thing thing3 = new Thing("Thing 3", "The third thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing1.getId().getValue());
        thing3.setProperties(properties);
        service.create((Entity)thing3);
        THINGS.add(thing3);
        Thing thing4 = new Thing("Thing 4", "The fourth thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing2.getId().getValue());
        thing4.setProperties(properties);
        service.create((Entity)thing4);
        THINGS.add(thing4);
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        sensor = new Sensor("Sensor 2", "The second sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://dbpedia.org/page/Temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        O_PROPS.add(obsProp);
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(THINGS.get(0));
        datastream.setSensor(SENSORS.get(0));
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        datastream = new Datastream("Datastream 2", "The temperature of thing 1, sensor 2.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(THINGS.get(0));
        datastream.setSensor(SENSORS.get(1));
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        FeatureOfInterest foi = new FeatureOfInterest("Feature 1", "Feature 1 for thing 1, sensor 1", "application/vnd.geo+json", (GeoJsonObject)new Point(8.0, 51.0));
        service.create((Entity)foi);
        FEATURES.add(foi);
        foi = new FeatureOfInterest("Feature 2", "Feature 2 for thing 1, sensor 2", "application/vnd.geo+json", (GeoJsonObject)new Point(8.0, 51.0));
        service.create((Entity)foi);
        FEATURES.add(foi);
        Observation o = new Observation((Object)1, DATASTREAMS.get(0));
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-01T01:01:01.000Z"));
        o.setFeatureOfInterest(FEATURES.get(0));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        o = new Observation((Object)2, DATASTREAMS.get(1));
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-02T01:01:01.000Z"));
        o.setFeatureOfInterest(FEATURES.get(0));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        o = new Observation((Object)3, DATASTREAMS.get(0));
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-03T01:01:01.000Z"));
        o.setFeatureOfInterest(FEATURES.get(1));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        o = new Observation((Object)4, DATASTREAMS.get(1));
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-04T01:01:01.000Z"));
        o.setFeatureOfInterest(FEATURES.get(1));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    @Test
    void test01InvalidMetadata() {
        LOGGER.info("  test01InvalidMetadata");
        HTTPMethods.HttpResponse result = this.getEntity("invalid");
        Assertions.assertEquals((int)400, (int)result.code);
    }

    @Test
    void test02EntityMetadata() {
        LOGGER.info("  test02EntityMetadata");
        this.testEntityMetadata("full", true);
        this.testEntityMetadata("minimal", false);
        this.testEntityMetadata("off", false);
    }

    private void testEntityMetadata(String metadata, boolean hasNavigationLink) {
        HTTPMethods.HttpResponse result = this.getEntity(metadata);
        Assertions.assertEquals((int)200, (int)result.code);
        JSONObject thing = new JSONObject(result.response);
        Assertions.assertEquals((Object)hasNavigationLink, (Object)thing.getJSONObject("properties").has("parent.Thing@iot.navigationLink"), (String)(metadata + " metadata navigationLink"));
        if (hasNavigationLink) {
            Assertions.assertEquals((Object)this.generateSelfLink(0), (Object)thing.getJSONObject("properties").get("parent.Thing@iot.navigationLink"), (String)(metadata + " metadata navigationLink expected"));
        }
    }

    private HTTPMethods.HttpResponse getEntity(String metadata) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, THINGS.get(1).getId().getValue(), null, "?$resultMetadata=" + metadata);
        HTTPMethods.HttpResponse result = HTTPMethods.doGet(urlString);
        return result;
    }

    @Test
    void test03MetadataInExpand() {
        LOGGER.info("  test03MetadataInExpand");
        this.testMetadataInExpand("full", true, true);
        this.testMetadataInExpand("minimal", false, false);
        this.testMetadataInExpand("none", false, false);
        this.testMetadataInExpand("off", false, false);
    }

    private void testMetadataInExpand(String metadata, boolean hasSelfLink, boolean hasNavigationLink) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, null, null, "?$filter=id%20eq%20" + THINGS.get(1).getId().getUrl() + "&$expand=properties/parent.Thing&$resultMetadata=" + metadata);
        HTTPMethods.HttpResponse result = HTTPMethods.doGet(urlString);
        Assertions.assertEquals((int)200, (int)result.code);
        JSONObject response = new JSONObject(result.response);
        Assertions.assertFalse((boolean)response.has("@iot.nextLink"), (String)(metadata + " metadata nextLink"));
        JSONObject thing = response.getJSONArray("value").getJSONObject(0);
        Assertions.assertEquals((Object)hasSelfLink, (Object)thing.has("@iot.selfLink"), (String)(metadata + " metadata selfLink"));
        if (hasSelfLink) {
            Assertions.assertEquals((Object)this.generateSelfLink(1), (Object)thing.get("@iot.selfLink"), (String)(metadata + " metadata selfLink"));
        }
        JSONObject properties = thing.getJSONObject("properties");
        Assertions.assertEquals((Object)hasNavigationLink, (Object)properties.has("parent.Thing@iot.navigationLink"), (String)(metadata + " metadata navigationLink"));
        if (hasNavigationLink) {
            Assertions.assertEquals((Object)this.generateSelfLink(0), (Object)properties.get("parent.Thing@iot.navigationLink"), (String)(metadata + " metadata navigationLink"));
        }
        JSONObject parent = thing.getJSONObject("properties").getJSONObject("parent.Thing");
        Assertions.assertEquals((Object)THINGS.get(0).getName(), (Object)parent.get("name"), (String)"parent.Thing should have expanded");
    }

    private String generateSelfLink(int thingIndex) {
        return MetadataTests.getServerSettings().getServiceRootUrl() + '/' + MetadataTests.version.urlPart + "/Things(" + THINGS.get(thingIndex).getId().getUrl() + ')';
    }

    @Test
    void test04PostDataArray() {
        LOGGER.info("  test04PostDataArray");
        this.testPostDataArray("full", true);
        this.testPostDataArray("minimal", true);
        this.testPostDataArray("none", true);
        this.testPostDataArray("off", false);
    }

    private void testPostDataArray(String metadata, boolean hasLinks) {
        JsonNode json;
        Datastream ds1 = DATASTREAMS.get(0);
        Datastream ds2 = DATASTREAMS.get(1);
        FeatureOfInterest foi1 = FEATURES.get(0);
        String jsonString = "[\n  {\n    \"Datastream\": {\n      \"@iot.id\": " + ds1.getId().getJson() + "\n    },\n    \"components\": [\n      \"phenomenonTime\",\n      \"result\",\n      \"FeatureOfInterest/id\"\n    ],\n    \"dataArray@iot.count\":2,\n    \"dataArray\": [\n      [\n        \"2010-12-23T10:20:00-07:00\",\n        20,\n        " + foi1.getId().getJson() + "\n      ],\n      [\n        \"2010-12-23T10:21:00-07:00\",\n        30,\n        \"probablyNotAValidId\"\n      ]\n    ]\n  },\n  {\n    \"Datastream\": {\n      \"@iot.id\": " + ds2.getId().getJson() + "\n    },\n    \"components\": [\n      \"phenomenonTime\",\n      \"result\"\n    ],\n    \"dataArray@iot.count\":2,\n    \"dataArray\": [\n      [\n        \"2010-12-23T10:20:00-07:00\",\n        65\n      ],\n      [\n        \"2010-12-23T10:21:00-07:00\",\n        60\n      ]\n    ]\n  }\n]";
        String urlString = serverSettings.getServiceUrl(version) + "/CreateObservations?$resultMetadata=" + metadata;
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, jsonString);
        String response = responseMap.response;
        int responseCode = responseMap.code;
        Object message = "Error posting Observations using Data Array: Code " + responseCode;
        Assertions.assertEquals((int)201, (int)responseCode, (String)message);
        try {
            json = new ObjectMapper().readTree(response);
        }
        catch (IOException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Server returned malformed JSON for request: " + urlString + " Exception: " + ex));
            return;
        }
        if (!json.isArray()) {
            Assertions.fail((String)("Server did not return a JSON array for request: " + urlString));
        }
        int i = 0;
        for (JsonNode resultLine : json) {
            ++i;
            if (!resultLine.isTextual()) {
                Assertions.fail((String)("Server returned a non-text result line for request: " + urlString));
                return;
            }
            String textValue = resultLine.textValue();
            if (textValue.toLowerCase().startsWith("error") && i != 2) {
                Assertions.fail((String)("Server returned an error for request: " + urlString));
            }
            if (!textValue.toLowerCase().startsWith("error") && i == 2) {
                Assertions.fail((String)("Server should have returned an error for non-valid id for request: " + urlString));
            }
            if (i == 2) continue;
            if (hasLinks) {
                Observation obs;
                Id obsId = this.idFromPostResult(textValue);
                try {
                    obs = (Observation)service.observations().find(obsId);
                }
                catch (ServiceFailureException ex) {
                    Assertions.fail((String)("Failed to retrieve created observation for request: " + urlString));
                    return;
                }
                OBSERVATIONS.add(obs);
                continue;
            }
            Assertions.assertEquals((Object)"", (Object)textValue, (String)(metadata + " metadata should remove links"));
        }
        if (hasLinks) {
            FeatureOfInterest foiObs8;
            FeatureOfInterest foiObs7;
            Observation obs7 = OBSERVATIONS.get(5);
            Observation obs8 = OBSERVATIONS.get(6);
            try {
                foiObs7 = obs7.getFeatureOfInterest();
                foiObs8 = obs8.getFeatureOfInterest();
            }
            catch (ServiceFailureException ex) {
                Assertions.fail((String)("Failed to retrieve feature of interest for created observation for request: " + urlString));
                return;
            }
            message = "Autogenerated Features of interest should be equal.";
            Assertions.assertEquals((Object)foiObs8.getId(), (Object)foiObs7.getId(), (String)message);
        }
    }

    private Id idFromPostResult(String postResultLine) {
        int pos1 = postResultLine.lastIndexOf("(") + 1;
        int pos2 = postResultLine.lastIndexOf(")");
        String part = postResultLine.substring(pos1, pos2);
        try {
            return new IdLong(Long.valueOf(Long.parseLong(part)));
        }
        catch (NumberFormatException exc) {
            if (!part.startsWith("'") || !part.endsWith("'")) {
                throw new IllegalArgumentException("Strings in urls must be quoted with single quotes.");
            }
            return new IdString(part.substring(1, part.length() - 1));
        }
    }

    @Test
    void test05PostData() {
        LOGGER.info("  test05PostData");
        this.testPostData("full", true);
        this.testPostData("minimal", true);
        this.testPostData("none", true);
        this.testPostData("off", false);
    }

    private void testPostData(String metadata, boolean hasLinks) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, null, null, "?$resultMetadata=" + metadata);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, "{\"description\": \"thing description\",\"name\": \"thing name\"}");
        String response = responseMap.response;
        Assertions.assertEquals((int)201, (int)responseMap.code, (String)"HTTP code should be 201");
        if (hasLinks) {
            Assertions.assertNotNull((Object)HTTPMethods.idFromSelfLink(response));
        } else {
            Assertions.assertEquals((Object)"", (Object)response);
        }
    }

    static {
        SERVER_PROPERTIES.put("extension.customLinks.enable", "true");
    }

    public static class Implementation11
    extends MetadataTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends MetadataTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

