/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.f02customlinks;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class CustomLinksTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomLinksTests.class.getName());
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<FeatureOfInterest> FEATURESOFINTEREST = new ArrayList<FeatureOfInterest>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final Properties SERVER_PROPERTIES = new Properties();

    public CustomLinksTests(ServerVersion version) {
        super(version, SERVER_PROPERTIES);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)CustomLinksTests.version.urlPart);
        CustomLinksTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        LOGGER.info("Cleaning up after version {}.", (Object)CustomLinksTests.version.urlPart);
        CustomLinksTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        CustomLinksTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        FEATURESOFINTEREST.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        CustomLinksTests.createThings();
        CustomLinksTests.createLocations();
    }

    private static void createThings() throws ServiceFailureException {
        Thing thing1 = new Thing("Thing 1", "The first thing.");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        thing1.setProperties(properties);
        service.create((Entity)thing1);
        THINGS.add(thing1);
        Thing thing2 = new Thing("Thing 2", "The second thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing1.getId().getValue());
        thing2.setProperties(properties);
        service.create((Entity)thing2);
        THINGS.add(thing2);
        Thing thing3 = new Thing("Thing 3", "The third thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing1.getId().getValue());
        thing3.setProperties(properties);
        service.create((Entity)thing3);
        THINGS.add(thing3);
        Thing thing4 = new Thing("Thing 4", "The fourt thing.");
        properties = new HashMap();
        properties.put("parent.Thing@iot.id", thing2.getId().getValue());
        thing4.setProperties(properties);
        service.create((Entity)thing4);
        THINGS.add(thing4);
    }

    private static void createLocations() throws ServiceFailureException {
        Point gjo = new Point(8.0, 51.0);
        Location location = new Location("Location 1.0", "First Location of Thing 1.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().addAll(THINGS);
        service.create((Entity)location);
        LOCATIONS.add(location);
    }

    @Test
    void testCustomLinks1() throws ServiceFailureException {
        LOGGER.info("  testCustomLinks1");
        Thing thing = (Thing)service.things().find(THINGS.get(1).getId());
        Object navLink = thing.getProperties().get("parent.Thing@iot.navigationLink");
        String expected = CustomLinksTests.getServerSettings().getServiceRootUrl() + "/" + CustomLinksTests.version.urlPart + "/Things(" + THINGS.get(0).getId().getUrl() + ")";
        Assertions.assertEquals((Object)expected, navLink, (String)"Custom link does not have (correct) navigationLink.");
    }

    @Test
    void testCustomLinks2() throws ServiceFailureException {
        LOGGER.info("  testCustomLinks2");
        Thing thing = (Thing)service.things().query().filter("id eq " + THINGS.get(1).getId().getUrl()).expand("properties/parent.Thing").first();
        Object expected = CustomLinksTests.getServerSettings().getServiceRootUrl() + "/" + CustomLinksTests.version.urlPart + "/Things(" + THINGS.get(0).getId().getUrl() + ")";
        Object navLink = thing.getProperties().get("parent.Thing@iot.navigationLink");
        Assertions.assertEquals((Object)expected, navLink, (String)"Custom link does not have (correct) navigationLink.");
        expected = THINGS.get(0).getName();
        Object parent = thing.getProperties().get("parent.Thing");
        if (!(parent instanceof Map)) {
            Assertions.fail((String)"parent.Thing did not expand.");
        }
        Object name = ((Map)parent).get("name");
        Assertions.assertEquals((Object)expected, name, (String)"Custom link does not have (correct) navigationLink.");
    }

    static {
        SERVER_PROPERTIES.put("extension.customLinks.enable", "true");
    }

    public static class Implementation11
    extends CustomLinksTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends CustomLinksTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

