/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c07mqttcreate;

import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityHelper;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttHelper;
import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Collectors;
import net.time4j.range.MomentInterval;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Capability7Tests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(Capability7Tests.class);
    private static MqttHelper mqttHelper;
    private static EntityHelper entityHelper;

    public Capability7Tests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)Capability7Tests.version.urlPart);
        long mqttTimeout = serverSettings.getMqttTimeOut();
        entityHelper = new EntityHelper(version, serverSettings);
        mqttHelper = new MqttHelper(version, serverSettings.getMqttUrl(), mqttTimeout);
    }

    @Override
    protected void tearDownVersion() {
        entityHelper.deleteEverything();
        entityHelper = null;
        mqttHelper = null;
    }

    @AfterAll
    public static void tearDown() {
        LOGGER.info("Tearing down.");
        entityHelper.deleteEverything();
        entityHelper = null;
        mqttHelper = null;
    }

    @Test
    void checkCreateObservationDirect() {
        LOGGER.info("  checkCreateObservationDirect");
        entityHelper.deleteEntityType(EntityType.OBSERVATION);
        JSONObject createdObservation = this.getObservation();
        mqttHelper.publish(mqttHelper.getTopic(EntityType.OBSERVATION), createdObservation.toString());
        JSONObject latestObservation = entityHelper.getAnyEntity(EntityType.OBSERVATION, "$expand=Datastream($select=id),FeatureOfInterest($select=id)&$select=result,phenomenonTime,validTime,parameters", 10);
        Assertions.assertTrue((boolean)Capability7Tests.jsonEquals(latestObservation, createdObservation));
    }

    @Test
    void checkCreateObservationViaDatastream() {
        LOGGER.info("  checkCreateObservationViaDatastream");
        entityHelper.deleteEntityType(EntityType.OBSERVATION);
        JSONObject createdObservation = this.getObservation();
        Object datastreamId = -1;
        try {
            datastreamId = createdObservation.getJSONObject("Datastream").get("@iot.id");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Datastream of created observation does not contain @iot.id: " + ex.getMessage()));
        }
        mqttHelper.publish(mqttHelper.getTopic(EntityType.DATASTREAM, datastreamId, "Observations"), createdObservation.toString());
        JSONObject latestObservation = entityHelper.getAnyEntity(EntityType.OBSERVATION, "$expand=Datastream($select=id),FeatureOfInterest($select=id)&$select=result,phenomenonTime,validTime,parameters", 10);
        Assertions.assertTrue((boolean)Capability7Tests.jsonEquals(latestObservation, createdObservation));
    }

    @Test
    void checkCreateObservationViaFeatureOfInterest() {
        LOGGER.info("  checkCreateObservationViaFeatureOfInterest");
        entityHelper.deleteEntityType(EntityType.OBSERVATION);
        JSONObject createdObservation = this.getObservation();
        Object featureOfInterestId = -1;
        try {
            featureOfInterestId = createdObservation.getJSONObject("FeatureOfInterest").get("@iot.id");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("created observation does not contain @iot.id: " + ex.getMessage()));
        }
        mqttHelper.publish(mqttHelper.getTopic(EntityType.FEATURE_OF_INTEREST, featureOfInterestId, "Observations"), createdObservation.toString());
        JSONObject latestObservation = entityHelper.getAnyEntity(EntityType.OBSERVATION, "$expand=Datastream($select=id),FeatureOfInterest($select=id)&$select=result,phenomenonTime,validTime,parameters", 10);
        Assertions.assertTrue((boolean)Capability7Tests.jsonEquals(latestObservation, createdObservation));
    }

    @Test
    void checkCreateObservationWithDeepInsert() {
        LOGGER.info("  checkCreateObservationWithDeepInsert");
        entityHelper.deleteEntityType(EntityType.OBSERVATION);
        JSONObject createdObservation = this.getObservationWithDeepInsert();
        mqttHelper.publish(mqttHelper.getTopic(EntityType.OBSERVATION), createdObservation.toString());
        JSONObject latestObservation = entityHelper.getAnyEntity(EntityType.OBSERVATION, this.expandQueryFromJsonObject(createdObservation), 10);
        Assertions.assertTrue((boolean)Capability7Tests.jsonEquals(latestObservation, createdObservation));
    }

    private String expandQueryFromJsonObject(JSONObject expectedResult) {
        return this.expandQueryFromJsonObject(expectedResult, "&");
    }

    private String expandQueryFromJsonObject(JSONObject expectedResult, String seperator) {
        Object result = "";
        ArrayList<String> selects = new ArrayList<String>();
        ArrayList<CallSite> expands = new ArrayList<CallSite>();
        Iterator iterator = expectedResult.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            EntityType relationType = null;
            try {
                relationType = EntityType.getForRelation(key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (relationType != null) {
                try {
                    expands.add((CallSite)((Object)(key + "(" + this.expandQueryFromJsonObject(expectedResult.getJSONObject(key), ";") + ")")));
                }
                catch (JSONException ex) {
                    LOGGER.error("Exception:", (Throwable)ex);
                    Assertions.fail((String)("JSON element addressed by navigationLink is no valid JSON object: " + ex.getMessage()));
                }
                continue;
            }
            selects.add(key);
        }
        if (!selects.isEmpty()) {
            result = (String)result + "$select=" + selects.stream().collect(Collectors.joining(","));
        }
        if (!expands.isEmpty()) {
            if (!((String)result).isEmpty()) {
                result = (String)result + seperator;
            }
            result = (String)result + "$expand=" + expands.stream().collect(Collectors.joining(","));
        }
        return result;
    }

    private static boolean jsonEquals(JSONObject obj1, JSONObject obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        if (obj1.getClass() != obj2.getClass()) {
            return false;
        }
        if (obj1.length() != obj2.length()) {
            return false;
        }
        Iterator iterator = obj1.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (!obj2.has(key)) {
                return false;
            }
            try {
                JSONArray arr2;
                JSONArray arr1;
                Object val1 = obj1.get(key);
                if (!(val1 instanceof JSONObject ? !Capability7Tests.jsonEquals((JSONObject)val1, obj2.getJSONObject(key)) : (val1 instanceof JSONArray ? !Capability7Tests.jsonEquals(arr1 = (JSONArray)val1, arr2 = obj2.getJSONArray(key)) : (key.toLowerCase().endsWith("time") ? !Capability7Tests.checkTimeEquals(val1.toString(), obj2.get(key).toString()) : !val1.equals(obj2.get(key)))))) continue;
                return false;
            }
            catch (JSONException ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean jsonEquals(JSONArray arr1, JSONArray arr2) {
        if (arr1.length() != arr2.length()) {
            return false;
        }
        for (int i = 0; i < arr1.length(); ++i) {
            Object val1 = arr1.get(i);
            if (!(val1 instanceof JSONObject ? !Capability7Tests.jsonEquals((JSONObject)val1, arr2.getJSONObject(i)) : (val1 instanceof JSONArray ? !Capability7Tests.jsonEquals((JSONArray)val1, arr2.getJSONArray(i)) : !val1.equals(arr2.get(i))))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkTimeEquals(String val1, String val2) {
        try {
            ZonedDateTime dateTime1 = ZonedDateTime.parse(val1);
            ZonedDateTime dateTime2 = ZonedDateTime.parse(val2);
            return dateTime1.isEqual(dateTime2);
        }
        catch (Exception dateTime1) {
            try {
                MomentInterval interval1 = MomentInterval.parseISO((String)val1);
                MomentInterval interval2 = MomentInterval.parseISO((String)val2);
                return interval1.equals((Object)interval2);
            }
            catch (Exception ex) {
                Assertions.fail((String)"time properies could neither be parsed as time nor as interval");
                return false;
            }
        }
    }

    private JSONObject getObservation() {
        long value = new Random().nextLong();
        Object thingId = entityHelper.createThing();
        Object observedPropertyId = entityHelper.createObservedProperty();
        Object sensorId = entityHelper.createSensor();
        Object datastreamId = entityHelper.createDatastream(thingId, observedPropertyId, sensorId);
        Object featureOfInterestId = entityHelper.createFeatureOfInterest();
        try {
            return new JSONObject("{\n  \"phenomenonTime\": \"2015-03-01T02:40:00+02:00\",\n  \"validTime\": \"2016-01-01T01:01:01.000Z/2016-01-01T23:59:59.000Z\",\n  \"result\": " + value + ",\n  \"parameters\":{\"param1\": \"some value1\", \"param2\": \"some value2\"},\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "},\n  \"FeatureOfInterest\": {\"@iot.id\": " + featureOfInterestId + "}  \n}");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("error converting obsveration to JSON: " + ex.getMessage()));
            return null;
        }
    }

    private JSONObject getObservationWithDeepInsert() {
        long value = new Random().nextLong();
        try {
            return new JSONObject("{\n\t\"phenomenonTime\": \"2015-03-01T00:00:00.000Z\",\n\t\"result\": " + value + ",\n\t\"FeatureOfInterest\": {\n\t\t\"name\": \"A weather station.\",\n\t\t\"description\": \"A weather station for " + value + ".\",\n\t\t\"encodingType\": \"application/vnd.geo+json\",\n\t\t\"feature\": {\n\t\t\t\"type\": \"Point\",\n\t\t\t\"coordinates\": [\n\t\t\t\t-114.05,\n\t\t\t\t51.05\n\t\t\t]\n\t\t}\n\t},\n\t\"Datastream\": {\n\t\t\"unitOfMeasurement\": {\n\t\t\t\"name\": \"Celsius\",\n\t\t\t\"symbol\": \"degC\",\n\t\t\t\"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n\t\t},\n\t\t\"name\": \"test datastream.\",\n\t\t\"description\": \"test datastream for " + value + ".\",\n\t\t\"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n\t\t\"Thing\": {\n\t\t\t\"name\": \"Test Thing\",\n\t\t\t\"description\": \"This is a Test Thing for " + value + "\"\n\t\t},\n\t\t\"ObservedProperty\": {\n\t\t\t\"name\": \"Luminous Flux\",\n\t\t\t\"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n\t\t\t\"description\": \"Luminous Flux for " + value + ".\"\n\t\t},\n\t\t\"Sensor\": {        \n\t\t\t\"name\": \"Acme Fluxomatic 1000\",\n\t\t\t\"description\": \"Acme Fluxomatic for " + value + "\",\n\t\t\t\"encodingType\": \"http://schema.org/description\",\n\t\t\t\"metadata\": \"Light flux sensor\"\n\t\t}\n\t}\n}\n");
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("error converting obsveration to JSON: " + ex.getMessage()));
            return null;
        }
    }

    public static class Implementation11
    extends Capability7Tests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends Capability7Tests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

