/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c05multidatastream;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.MultiDatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class MdDateTimeTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdDateTimeTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static final List<MultiDatastream> MULTI_DATASTREAMS = new ArrayList<MultiDatastream>();
    private static final ZonedDateTime T2014 = ZonedDateTime.parse("2014-01-01T06:00:00.000Z");
    private static final ZonedDateTime T2015 = ZonedDateTime.parse("2015-01-01T06:00:00.000Z");
    private static final ZonedDateTime T600 = ZonedDateTime.parse("2016-01-01T06:00:00.000Z");
    private static final ZonedDateTime T659 = ZonedDateTime.parse("2016-01-01T06:59:00.000Z");
    private static final ZonedDateTime T700 = ZonedDateTime.parse("2016-01-01T07:00:00.000Z");
    private static final ZonedDateTime T701 = ZonedDateTime.parse("2016-01-01T07:01:00.000Z");
    private static final ZonedDateTime T759 = ZonedDateTime.parse("2016-01-01T07:59:00.000Z");
    private static final ZonedDateTime T800 = ZonedDateTime.parse("2016-01-01T08:00:00.000Z");
    private static final ZonedDateTime T801 = ZonedDateTime.parse("2016-01-01T08:01:00.000Z");
    private static final ZonedDateTime T900 = ZonedDateTime.parse("2016-01-01T09:00:00.000Z");
    private static final ZonedDateTime T2017 = ZonedDateTime.parse("2017-01-01T09:00:00.000Z");
    private static final ZonedDateTime T2017_2 = T2017.plus(1L, ChronoUnit.HOURS);
    private static final ZonedDateTime T2018 = ZonedDateTime.parse("2018-01-01T09:00:00.000Z");
    private static final Interval I2015 = Interval.of((Instant)T2015.toInstant(), (Instant)T2015.plus(1L, ChronoUnit.HOURS).toInstant());
    private static final Interval I600_659 = Interval.of((Instant)T600.toInstant(), (Instant)T659.toInstant());
    private static final Interval I600_700 = Interval.of((Instant)T600.toInstant(), (Instant)T700.toInstant());
    private static final Interval I600_701 = Interval.of((Instant)T600.toInstant(), (Instant)T701.toInstant());
    private static final Interval I700_800 = Interval.of((Instant)T700.toInstant(), (Instant)T800.toInstant());
    private static final Interval I701_759 = Interval.of((Instant)T701.toInstant(), (Instant)T759.toInstant());
    private static final Interval I759_900 = Interval.of((Instant)T759.toInstant(), (Instant)T900.toInstant());
    private static final Interval I800_900 = Interval.of((Instant)T800.toInstant(), (Instant)T900.toInstant());
    private static final Interval I801_900 = Interval.of((Instant)T801.toInstant(), (Instant)T900.toInstant());
    private static final Interval I659_801 = Interval.of((Instant)T659.toInstant(), (Instant)T801.toInstant());
    private static final Interval I700_759 = Interval.of((Instant)T700.toInstant(), (Instant)T759.toInstant());
    private static final Interval I700_801 = Interval.of((Instant)T700.toInstant(), (Instant)T801.toInstant());
    private static final Interval I659_800 = Interval.of((Instant)T659.toInstant(), (Instant)T800.toInstant());
    private static final Interval I701_800 = Interval.of((Instant)T701.toInstant(), (Instant)T800.toInstant());
    private static final Interval I2017 = Interval.of((Instant)T2017.toInstant(), (Instant)T2017_2.toInstant());
    private static final Interval I2014_2015 = Interval.of((Instant)T2014.toInstant(), (Instant)T2015.toInstant());
    private static final Interval I2014_2017_2 = Interval.of((Instant)T2014.toInstant(), (Instant)T2017_2.toInstant());
    private static final Interval I2014_2018 = Interval.of((Instant)T2014.toInstant(), (Instant)T2018.toInstant());
    private static final Interval I2015_2017_2 = Interval.of((Instant)T2015.toInstant(), (Instant)T2017_2.toInstant());
    private static final Interval I2015_2018 = Interval.of((Instant)T2015.toInstant(), (Instant)T2018.toInstant());
    private static final Interval I2017_2_2018 = Interval.of((Instant)T2017_2.toInstant(), (Instant)T2018.toInstant());

    public MdDateTimeTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)MdDateTimeTests.version.urlPart);
        MdDateTimeTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        MdDateTimeTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        MdDateTimeTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        MULTI_DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        THINGS.add(thing);
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        thing.getLocations().add((Entity)location);
        service.create((Entity)thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        MultiDatastream datastream = new MultiDatastream("Datastream 1", "The temperature of thing 1, sensor 1.", Arrays.asList("someType"), Arrays.asList(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T")));
        datastream.setThing(thing);
        datastream.setSensor(sensor);
        datastream.getObservedProperties().add((Entity)obsProp);
        service.create((Entity)datastream);
        MULTI_DATASTREAMS.add(datastream);
        MdDateTimeTests.createObservation(0.0, datastream, T600, T600, null);
        MdDateTimeTests.createObservation(1.0, datastream, T659, T659, null);
        MdDateTimeTests.createObservation(2.0, datastream, T700, T700, null);
        MdDateTimeTests.createObservation(3.0, datastream, T701, T701, null);
        MdDateTimeTests.createObservation(4.0, datastream, T759, T759, null);
        MdDateTimeTests.createObservation(5.0, datastream, T800, T800, null);
        MdDateTimeTests.createObservation(6.0, datastream, T801, T801, null);
        MdDateTimeTests.createObservation(7.0, datastream, T900, T900, null);
        MdDateTimeTests.createObservation(8.0, datastream, I600_659, null, I600_659);
        MdDateTimeTests.createObservation(9.0, datastream, I600_700, null, I600_700);
        MdDateTimeTests.createObservation(10.0, datastream, I600_701, null, I600_701);
        MdDateTimeTests.createObservation(11.0, datastream, I700_800, null, I700_800);
        MdDateTimeTests.createObservation(12.0, datastream, I701_759, null, I701_759);
        MdDateTimeTests.createObservation(13.0, datastream, I759_900, null, I759_900);
        MdDateTimeTests.createObservation(14.0, datastream, I800_900, null, I800_900);
        MdDateTimeTests.createObservation(15.0, datastream, I801_900, null, I801_900);
        MdDateTimeTests.createObservation(16.0, datastream, I659_801, null, I659_801);
        MdDateTimeTests.createObservation(17.0, datastream, I700_759, null, I700_759);
        MdDateTimeTests.createObservation(18.0, datastream, I700_801, null, I700_801);
        MdDateTimeTests.createObservation(19.0, datastream, I659_800, null, I659_800);
        MdDateTimeTests.createObservation(20.0, datastream, I701_800, null, I701_800);
        MdDateTimeTests.createObservation(21.0, datastream, T2015, T2015, null);
        MdDateTimeTests.createObservation(22.0, datastream, T2017, T2017, null);
        MdDateTimeTests.createObservation(23.0, datastream, I2015, T2015, I2015);
        MdDateTimeTests.createObservation(24.0, datastream, I2017, T2017.plus(1L, ChronoUnit.HOURS), I2017);
        MultiDatastream datastream2 = new MultiDatastream("Datastream 2", "The second temperature of thing 1, sensor 1.", Arrays.asList("someType"), Arrays.asList(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T")));
        datastream2.setThing(thing);
        datastream2.setSensor(sensor);
        datastream2.getObservedProperties().add((Entity)obsProp);
        service.create((Entity)datastream2);
        MULTI_DATASTREAMS.add(datastream2);
    }

    private static void createObservation(double result, MultiDatastream ds, Interval pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        MdDateTimeTests.createObservation(result, ds, new TimeObject(pt), rt, vt);
    }

    private static void createObservation(double result, MultiDatastream ds, ZonedDateTime pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        MdDateTimeTests.createObservation(result, ds, new TimeObject(pt), rt, vt);
    }

    private static void createObservation(double result, MultiDatastream ds, TimeObject pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        Observation o = new Observation((Object)new double[]{result}, ds);
        o.setPhenomenonTime(pt);
        o.setResultTime(rt);
        o.setValidTime(vt);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    public <T extends Entity<T>> void testFilterResultsDs(BaseDao<T> doa, String filter, List<T> expected) {
        if (expected == null) {
            return;
        }
        EntityUtils.testFilterResults(doa, filter.replace("{}", "phenomenonTime"), expected);
        EntityUtils.testFilterResults(doa, filter.replace("{}", "resultTime"), expected);
    }

    public void testDsTpl(String tpl, List<MultiDatastream> t2014, List<MultiDatastream> t2015, List<MultiDatastream> t700, List<MultiDatastream> t2017_2, List<MultiDatastream> t2018, List<MultiDatastream> i78, List<MultiDatastream> i2014_2015, List<MultiDatastream> i2014_2017_2, List<MultiDatastream> i2014_2018, List<MultiDatastream> i2015_2017_2, List<MultiDatastream> i2015_2018, List<MultiDatastream> i2017_2_2018) {
        MultiDatastreamDao dsDoa = service.multiDatastreams();
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, T2014), (List)t2014);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, T2015), (List)t2015);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, T700), (List)t700);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, T2017_2), (List)t2017_2);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, T2018), (List)t2018);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I700_800), (List)i78);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2014_2015), (List)i2014_2015);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2014_2017_2), (List)i2014_2017_2);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2014_2018), (List)i2014_2018);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2015_2017_2), (List)i2015_2017_2);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2015_2018), (List)i2015_2018);
        this.testFilterResultsDs((BaseDao)dsDoa, String.format(tpl, I2017_2_2018), (List)i2017_2_2018);
    }

    public void testTimeValue(String tpl, List<Observation> rtOpT7, List<Observation> vtOpT7, List<Observation> ptOpT7, List<Observation> rtOpT78, List<Observation> vtOpT78, List<Observation> ptOpT78) {
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, String.format(tpl, "resultTime", T700), rtOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, "validTime", T700), vtOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, "phenomenonTime", T700), ptOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, "resultTime", I700_800), rtOpT78);
        EntityUtils.testFilterResults(doa, String.format(tpl, "validTime", I700_800), vtOpT78);
        EntityUtils.testFilterResults(doa, String.format(tpl, "phenomenonTime", I700_800), ptOpT78);
    }

    public void testValueTime(String tpl, List<Observation> rtOpT7, List<Observation> vtOpT7, List<Observation> ptOpT7, List<Observation> rtOpT78, List<Observation> vtOpT78, List<Observation> ptOpT78) {
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, String.format(tpl, T700, "resultTime"), rtOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, T700, "validTime"), vtOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, T700, "phenomenonTime"), ptOpT7);
        EntityUtils.testFilterResults(doa, String.format(tpl, I700_800, "resultTime"), rtOpT78);
        EntityUtils.testFilterResults(doa, String.format(tpl, I700_800, "validTime"), vtOpT78);
        EntityUtils.testFilterResults(doa, String.format(tpl, I700_800, "phenomenonTime"), ptOpT78);
    }

    public void testTimeOpValue(String op, List<Observation> rtOpT7, List<Observation> vtOpT7, List<Observation> ptOpT7, List<Observation> rtOpT78, List<Observation> vtOpT78, List<Observation> ptOpT78) {
        this.testTimeValue("%s " + op + " %s", rtOpT7, vtOpT7, ptOpT7, rtOpT78, vtOpT78, ptOpT78);
    }

    public void testValueOpTime(String op, List<Observation> rtOpT7, List<Observation> vtOpT7, List<Observation> ptOpT7, List<Observation> rtOpT78, List<Observation> vtOpT78, List<Observation> ptOpT78) {
        this.testValueTime("%s " + op + " %s", rtOpT7, vtOpT7, ptOpT7, rtOpT78, vtOpT78, ptOpT78);
    }

    @Test
    void test01Lt() throws ServiceFailureException {
        LOGGER.info("  test01Lt");
        String op = "lt";
        this.testTimeOpValue(op, Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23));
        this.testValueOpTime(op, Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 12, 13, 14, 15, 20, 24), Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 12, 13, 14, 15, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 14, 15, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 14, 15, 22, 24));
        String tpl = "{} " + op + " %s";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0));
    }

    @Test
    void test02Gt() throws ServiceFailureException {
        LOGGER.info("  test02Gt");
        String op = "gt";
        this.testTimeOpValue(op, Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 12, 13, 14, 15, 20, 24), Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 12, 13, 14, 15, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 14, 15, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 14, 15, 22, 24));
        this.testValueOpTime(op, Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23));
        String tpl = "{} " + op + " %s";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test03Le() throws ServiceFailureException {
        LOGGER.info("  test03Le");
        String op = "le";
        this.testTimeOpValue(op, Utils.getFromList(OBSERVATIONS, 0, 1, 2, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 10, 11, 17, 19, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 8, 9, 10, 11, 17, 19, 21, 23));
        this.testValueOpTime(op, Utils.getFromList(OBSERVATIONS, 2, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 11, 12, 13, 14, 15, 17, 18, 20, 24), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 5, 6, 7, 11, 12, 13, 14, 15, 17, 18, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 11, 13, 14, 15, 18, 20, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 11, 13, 14, 15, 18, 20, 22, 24));
        String tpl = "{} " + op + " %s";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0));
    }

    @Test
    void test04Ge() throws ServiceFailureException {
        LOGGER.info("  test04Ge");
        String op = "ge";
        this.testTimeOpValue(op, Utils.getFromList(OBSERVATIONS, 2, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 11, 12, 13, 14, 15, 17, 18, 20, 24), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 5, 6, 7, 11, 12, 13, 14, 15, 17, 18, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 11, 13, 14, 15, 18, 20, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 11, 13, 14, 15, 18, 20, 22, 24));
        this.testValueOpTime(op, Utils.getFromList(OBSERVATIONS, 0, 1, 2, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 10, 11, 17, 19, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 2, 8, 9, 10, 11, 17, 19, 21, 23));
        String tpl = "{} " + op + " %s";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test05Eq() throws ServiceFailureException {
        LOGGER.info("  test05Eq");
        String op = "eq";
        this.testTimeOpValue(op, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, new int[0]), Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, new int[0]), Utils.getFromList(OBSERVATIONS, 11), Utils.getFromList(OBSERVATIONS, 11));
        this.testValueOpTime(op, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, new int[0]), Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, new int[0]), Utils.getFromList(OBSERVATIONS, 11), Utils.getFromList(OBSERVATIONS, 11));
        String tpl = "{} " + op + " %s";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test06Before() throws ServiceFailureException {
        LOGGER.info("  test06Before");
        String tpl = "before(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 12, 13, 14, 15, 20, 24), Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 12, 13, 14, 15, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 14, 15, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 14, 15, 22, 24));
        tpl = "before({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0));
    }

    @Test
    void test07After() throws ServiceFailureException {
        LOGGER.info("  test07After");
        String tpl = "after(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 12, 13, 14, 15, 20, 24), Utils.getFromList(OBSERVATIONS, 3, 4, 5, 6, 7, 12, 13, 14, 15, 20, 22, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24), Utils.getFromList(OBSERVATIONS, 14, 15, 24), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 14, 15, 22, 24));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23), Utils.getFromList(OBSERVATIONS, 8, 9, 23), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23));
        tpl = "after({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test08Meets() throws ServiceFailureException {
        LOGGER.info("  test08Meets");
        String tpl = "meets(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 9, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 9, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 5), Utils.getFromList(OBSERVATIONS, 9, 14), Utils.getFromList(OBSERVATIONS, 2, 5, 9, 14));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 9, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 9, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 5), Utils.getFromList(OBSERVATIONS, 9, 14), Utils.getFromList(OBSERVATIONS, 2, 5, 9, 14));
        tpl = "meets({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0));
    }

    @Test
    void test09During() throws ServiceFailureException {
        LOGGER.info("  test09During");
        ObservationDao doa = service.observations();
        EntityUtils.filterForException((BaseDao)doa, String.format("during(resultTime,%s)", T700), 400);
        EntityUtils.filterForException((BaseDao)doa, String.format("during(validTime,%s)", T700), 400);
        EntityUtils.filterForException((BaseDao)doa, String.format("during(phenomenonTime,%s)", T700), 400);
        EntityUtils.testFilterResults(doa, String.format("during(resultTime,%s)", I700_800), Utils.getFromList(OBSERVATIONS, 2, 3, 4));
        EntityUtils.testFilterResults(doa, String.format("during(validTime,%s)", I700_800), Utils.getFromList(OBSERVATIONS, 11, 12, 17, 20));
        EntityUtils.testFilterResults(doa, String.format("during(phenomenonTime,%s)", I700_800), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 11, 12, 17, 20));
        EntityUtils.filterForException((BaseDao)doa, String.format("during(%s,resultTime)", T700), 400);
        EntityUtils.testFilterResults(doa, String.format("during(%s,validTime)", T700), Utils.getFromList(OBSERVATIONS, 10, 11, 16, 17, 18, 19));
        EntityUtils.testFilterResults(doa, String.format("during(%s,phenomenonTime)", T700), Utils.getFromList(OBSERVATIONS, 10, 11, 16, 17, 18, 19));
        EntityUtils.filterForException((BaseDao)doa, String.format("during(%s,resultTime)", I700_800), 400);
        EntityUtils.testFilterResults(doa, String.format("during(%s,validTime)", I700_800), Utils.getFromList(OBSERVATIONS, 11, 16, 18, 19));
        EntityUtils.testFilterResults(doa, String.format("during(%s,phenomenonTime)", I700_800), Utils.getFromList(OBSERVATIONS, 11, 16, 18, 19));
        String tpl = "during({}, %s)";
        this.testDsTpl(tpl, null, null, null, null, null, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test10Overlaps() throws ServiceFailureException {
        LOGGER.info("  test10Overlaps");
        String tpl = "overlaps(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 10, 11, 16, 17, 18, 19), Utils.getFromList(OBSERVATIONS, 2, 10, 11, 16, 17, 18, 19), Utils.getFromList(OBSERVATIONS, 2, 3, 4), Utils.getFromList(OBSERVATIONS, 10, 11, 12, 13, 16, 17, 18, 19, 20), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 10, 11, 12, 13, 16, 17, 18, 19, 20));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 10, 11, 16, 17, 18, 19), Utils.getFromList(OBSERVATIONS, 2, 10, 11, 16, 17, 18, 19), Utils.getFromList(OBSERVATIONS, 2, 3, 4), Utils.getFromList(OBSERVATIONS, 10, 11, 12, 13, 16, 17, 18, 19, 20), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 10, 11, 12, 13, 16, 17, 18, 19, 20));
        tpl = "overlaps({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test11Starts() throws ServiceFailureException {
        LOGGER.info("  test11Starts");
        String tpl = "starts(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 11, 17, 18));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 11, 17, 18), Utils.getFromList(OBSERVATIONS, 2, 11, 17, 18));
        tpl = "starts({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test12Finishes() throws ServiceFailureException {
        LOGGER.info("  test12Finishes");
        String tpl = "finishes(%s,%s)";
        this.testTimeValue(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 9), Utils.getFromList(OBSERVATIONS, 2, 9), Utils.getFromList(OBSERVATIONS, 5), Utils.getFromList(OBSERVATIONS, 11, 19, 20), Utils.getFromList(OBSERVATIONS, 5, 11, 19, 20));
        this.testValueTime(tpl, Utils.getFromList(OBSERVATIONS, 2), Utils.getFromList(OBSERVATIONS, 9), Utils.getFromList(OBSERVATIONS, 2, 9), Utils.getFromList(OBSERVATIONS, 5), Utils.getFromList(OBSERVATIONS, 11, 19, 20), Utils.getFromList(OBSERVATIONS, 5, 11, 19, 20));
        tpl = "finishes({}, %s)";
        this.testDsTpl(tpl, Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, 0), Utils.getFromList(MULTI_DATASTREAMS, new int[0]), Utils.getFromList(MULTI_DATASTREAMS, new int[0]));
    }

    @Test
    void test13Year() throws ServiceFailureException {
        LOGGER.info("  test13Year");
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, String.format("year(resultTime) eq 2015", new Object[0]), Utils.getFromList(OBSERVATIONS, 21, 23));
        EntityUtils.testFilterResults(doa, String.format("year(validTime) eq 2015", new Object[0]), Utils.getFromList(OBSERVATIONS, 23));
        EntityUtils.testFilterResults(doa, String.format("year(phenomenonTime) eq 2015", new Object[0]), Utils.getFromList(OBSERVATIONS, 21, 23));
    }

    @Test
    void test14Durations() throws ServiceFailureException {
        LOGGER.info("  test14Durations");
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, String.format("resultTime add duration'PT1H' gt %s", T900), Utils.getFromList(OBSERVATIONS, 6, 7, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("validTime add duration'PT1H' gt %s", T900), Utils.getFromList(OBSERVATIONS, 15, 24));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime add duration'PT1H' gt %s", T900), Utils.getFromList(OBSERVATIONS, 6, 7, 15, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("resultTime gt %s sub duration'PT1H'", T900), Utils.getFromList(OBSERVATIONS, 6, 7, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("validTime gt %s sub duration'PT1H'", T900), Utils.getFromList(OBSERVATIONS, 15, 24));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime gt %s sub duration'PT1H'", T900), Utils.getFromList(OBSERVATIONS, 6, 7, 15, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("resultTime sub duration'PT1H' gt %s", T700), Utils.getFromList(OBSERVATIONS, 6, 7, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("validTime sub duration'PT1H' gt %s", T700), Utils.getFromList(OBSERVATIONS, 15, 24));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime sub duration'PT1H' gt %s", T700), Utils.getFromList(OBSERVATIONS, 6, 7, 15, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("resultTime lt %s add duration'PT1H'", I600_700), Utils.getFromList(OBSERVATIONS, 0, 1, 21, 23));
        EntityUtils.testFilterResults(doa, String.format("validTime lt %s add duration'PT1H'", I600_700), Utils.getFromList(OBSERVATIONS, 8, 9, 23));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime lt %s add duration'PT1H'", I600_700), Utils.getFromList(OBSERVATIONS, 0, 1, 8, 9, 21, 23));
        EntityUtils.testFilterResults(doa, String.format("resultTime gt %s sub duration'PT1H'", I800_900), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("validTime gt %s sub duration'PT1H'", I800_900), Utils.getFromList(OBSERVATIONS, 14, 15, 24));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime gt %s sub duration'PT1H'", I800_900), Utils.getFromList(OBSERVATIONS, 5, 6, 7, 14, 15, 22, 24));
        EntityUtils.testFilterResults(doa, String.format("phenomenonTime sub %s eq duration'PT1H'", T800), Utils.getFromList(OBSERVATIONS, 7));
    }

    @Test
    void test15AlternativeOverlaps() throws ServiceFailureException {
        LOGGER.info("  test15AlternativeOverlaps");
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, String.format("not resultTime lt %s and not resultTime ge %s", T700, T800), Utils.getFromList(OBSERVATIONS, 2, 3, 4));
        EntityUtils.testFilterResults(doa, String.format("not validTime lt %s and not validTime ge %s", T700, T800), Utils.getFromList(OBSERVATIONS, 10, 11, 12, 13, 16, 17, 18, 19, 20));
        EntityUtils.testFilterResults(doa, String.format("not phenomenonTime lt %s and not phenomenonTime ge %s", T700, T800), Utils.getFromList(OBSERVATIONS, 2, 3, 4, 10, 11, 12, 13, 16, 17, 18, 19, 20));
    }

    @Test
    void test19PhenomenonTimeAfterDelete() throws ServiceFailureException {
        LOGGER.info("  test19PhenomenonTimeAfterDelete");
        EntityUtils.deleteAll(service.observations());
        MultiDatastream ds1 = (MultiDatastream)service.multiDatastreams().find(MULTI_DATASTREAMS.get(0).getId());
        Assertions.assertNull((Object)ds1.getPhenomenonTime(), (String)"phenomenonTime should be null");
        MultiDatastream ds2 = (MultiDatastream)service.multiDatastreams().find(MULTI_DATASTREAMS.get(1).getId());
        Assertions.assertNull((Object)ds2.getPhenomenonTime(), (String)"phenomenonTime should be null");
    }

    public static class Implementation11
    extends MdDateTimeTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends MdDateTimeTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

