/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c04batch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.c04batch.BatchResponseJson;
import de.fraunhofer.iosb.ilt.statests.util.EntityHelper;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.IdType;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class BatchTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<ObservedProperty> OBSERVED_PROPS = new ArrayList<ObservedProperty>();
    private static final Map<EntityType, IdType> ID_TYPES = new HashMap<EntityType, IdType>();
    private final ObjectMapper mapper = new ObjectMapper();

    public BatchTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)BatchTests.version.urlPart);
        try {
            BatchTests.createEntities();
        }
        catch (ServiceFailureException | URISyntaxException ex) {
            LOGGER.error("Failed to set up.", ex);
        }
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        BatchTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        BatchTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        OBSERVED_PROPS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        for (int i = 0; i < 6; ++i) {
            HashMap<String, Integer> properties = new HashMap<String, Integer>();
            properties.put("int", i + 8);
            Thing thing = new Thing("Thing " + i, "It's a thing.");
            thing.setProperties(properties);
            service.create((Entity)thing);
            THINGS.add(thing);
        }
        ObservedProperty obsProp = new ObservedProperty("ObservedProperty 1", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        ID_TYPES.put(EntityType.THING, IdType.findFor(THINGS.get(0).getId().getValue()));
        ID_TYPES.put(EntityType.OBSERVED_PROPERTY, IdType.findFor(OBSERVED_PROPS.get(0).getId().getValue()));
    }

    @Test
    void test01BatchRequest() {
        LOGGER.info("  test01BatchRequest");
        String response = this.postBatch("batch_36522ad7-fc75-4b56-8c71-56071383e77b", "--batch_36522ad7-fc75-4b56-8c71-56071383e77b\r\nContent-Type: application/http\r\n\r\nGET /" + BatchTests.version.urlPart + "/Things(" + THINGS.get(0).getId().getUrl() + ")?$select=name HTTP/1.1\r\nHost: localhost\r\n\r\n\r\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b\r\nContent-Type: multipart/mixed;boundary=changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\n\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\nContent-Type: application/http\r\nContent-ID: 1\r\n\r\nPOST /" + BatchTests.version.urlPart + "/Things HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/json\r\nContent-Length: 36\r\n\r\n{\"name\":\"New\",\"description\":\"Thing\"}\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\nContent-Type: application/http\r\nContent-ID: 2\r\n\r\nPATCH /" + BatchTests.version.urlPart + "/Things(" + THINGS.get(0).getId().getUrl() + ") HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/json\r\nContent-Length: 18\r\n\r\n{\"name\":\"Patched\"}\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd--\r\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b\r\nContent-Type: application/http\r\n\r\nGET /" + BatchTests.version.urlPart + "/Things(" + Utils.quoteIdForUrl(ID_TYPES.get((Object)EntityType.THING).generateUnlikely()) + ") HTTP/1.1\r\nHost: localhost\r\n\r\n\r\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b--");
        String thingId = this.getLastestEntityIdForPath(EntityType.THING);
        String batchBoundary = response.split("\n", 2)[0];
        int mixedBoundaryStart = response.indexOf("boundary=") + 9;
        String mixedBoundary = response.substring(mixedBoundaryStart, mixedBoundaryStart + 40);
        Assertions.assertEquals((Object)(batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"name\":\"Thing 0\"}\n" + batchBoundary + "\nContent-Type: multipart/mixed; boundary=" + mixedBoundary + "\n\n--" + mixedBoundary + "\nContent-Type: application/http\nContent-ID: 1\n\nhttp/1.1 201 no text\nLocation: " + serverSettings.getServiceUrl(version) + "/Things(" + thingId + ")\n\n\n--" + mixedBoundary + "\nContent-Type: application/http\nContent-ID: 2\n\nhttp/1.1 200 no text\n\n\n--" + mixedBoundary + "--\n" + batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 404 no text\n\n{\"code\":404,\"type\":\"error\",\"message\":\"Not Found\"}\n" + batchBoundary + "--"), (Object)response);
    }

    @Test
    void test02BatchRequestWithChangeSetReferencingNewEntities() {
        LOGGER.info("  test02BatchRequestWithChangeSetReferencingNewEntities");
        String post1 = "{\r\n  \"name\": \"DS18B20\",\r\n  \"description\": \"DS18B20 is an air temperature sensor\",\r\n  \"encodingType\": \"application/pdf\",\r\n  \"metadata\": \"http://datasheets.maxim-ic.com/en/ds/DS18B20.pdf\"\r\n}";
        String post2 = "{\r\n  \"name\": \"Temperature Thing 5\",\r\n  \"description\": \"The temperature of thing 5\",\r\n  \"unitOfMeasurement\": {\r\n    \"name\": \"degree Celsius\",\r\n    \"symbol\": \"\u00b0C\",\r\n    \"definition\": \"http://unitsofmeasure.org/ucum.html#para-30\"\r\n  },\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGCOM/2.0/OM_Measurement\",\r\n  \"ObservedProperty\": {\"@iot.id\": " + OBSERVED_PROPS.get(0).getId().getJson() + "},\r\n  \"Sensor\": {\"@iot.id\": \"$sensor1\"}\r\n}";
        String response = this.postBatch("batch_36522ad7-fc75-4b56-8c71-56071383e77b", "--batch_36522ad7-fc75-4b56-8c71-56071383e77b\r\nContent-Type: multipart/mixed;boundary=changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\n\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\nContent-Type: application/http\r\nContent-ID: sensor1\r\n\r\nPOST /" + BatchTests.version.urlPart + "/Sensors HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/json\r\nContent-Length: " + post1.length() + "\r\n\r\n" + post1 + "\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd\r\nContent-Type: application/http\r\nContent-ID: any\r\n\r\nPOST /" + BatchTests.version.urlPart + "/Things(" + THINGS.get(0).getId().getUrl() + ")/Datastreams HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/json\r\nContent-Length: " + post2.length() + "\r\n\r\n" + post2 + "\r\n--changeset_77162fcd-b8da-41ac-a9f8-9357efbbd--\r\n--batch_36522ad7-fc75-4b56-8c71-56071383e77b--");
        String sensorId = this.getLastestEntityIdForPath(EntityType.SENSOR);
        String datastreamId = this.getLastestEntityIdForPath(EntityType.DATASTREAM);
        String batchBoundary = response.split("\n", 2)[0];
        int mixedBoundaryStart = response.indexOf("boundary=") + 9;
        String mixedBoundary = response.substring(mixedBoundaryStart, mixedBoundaryStart + 40);
        Assertions.assertEquals((Object)(batchBoundary + "\nContent-Type: multipart/mixed; boundary=" + mixedBoundary + "\n\n--" + mixedBoundary + "\nContent-Type: application/http\nContent-ID: sensor1\n\nhttp/1.1 201 no text\nLocation: " + serverSettings.getServiceUrl(version) + "/Sensors(" + sensorId + ")\n\n\n--" + mixedBoundary + "\nContent-Type: application/http\nContent-ID: any\n\nhttp/1.1 201 no text\nLocation: " + serverSettings.getServiceUrl(version) + "/Datastreams(" + datastreamId + ")\n\n\n--" + mixedBoundary + "--\n" + batchBoundary + "--"), (Object)response);
    }

    @Test
    void test03BatchRequestWithEncodedCharsInUrl() {
        LOGGER.info("  test03BatchRequestWithEncodedCharsInUrl");
        String response = this.postBatch("batch_test", "--batch_test\r\nContent-Type: application/http\r\n\r\nGET Things?$filter=properties/int%20eq%2010&$select=name HTTP/1.1\r\n\r\n\r\n--batch_test--");
        String batchBoundary = response.split("\n", 2)[0];
        Assertions.assertEquals((Object)(batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"@iot.count\":1,\"value\":[{\"name\":\"Thing 2\"}]}\n" + batchBoundary + "--"), (Object)response);
    }

    @Test
    void test04BatchRequestWithAbsoluteUri() {
        LOGGER.info("  test04BatchRequestWithAbsoluteUri");
        String response = this.postBatch("batch_test", "--batch_test\r\nContent-Type: application/http\r\n\r\nGET " + serverSettings.getServiceUrl(version) + "/Things?$filter=properties/int%20eq%2010&$select=name HTTP/1.1\r\n\r\n\r\n--batch_test\r\nContent-Type: application/http\r\n\r\nGET " + serverSettings.getServiceUrl(version) + "/Things?$filter=properties/int%20eq%2011&$select=name HTTP/1.1\r\n\r\n\r\n--batch_test--");
        String batchBoundary = response.split("\n", 2)[0];
        Assertions.assertEquals((Object)(batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"@iot.count\":1,\"value\":[{\"name\":\"Thing 2\"}]}\n" + batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"@iot.count\":1,\"value\":[{\"name\":\"Thing 3\"}]}\n" + batchBoundary + "--"), (Object)response);
    }

    @Test
    void test05BatchRequestWithResourcePathRelativeToBatchRequest() {
        LOGGER.info("  test05BatchRequestWithResourcePathRelativeToBatchRequest");
        String response = this.postBatch("batch_test", "--batch_test\r\nContent-Type: application/http\r\n\r\nGET Things?$filter=properties/int%20eq%2010&$select=name HTTP/1.1\r\n\r\n\r\n--batch_test\r\nContent-Type: application/http\r\n\r\nGET Things?$filter=properties/int%20eq%2011&$select=name HTTP/1.1\r\n\r\n\r\n--batch_test--");
        String batchBoundary = response.split("\n", 2)[0];
        Assertions.assertEquals((Object)(batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"@iot.count\":1,\"value\":[{\"name\":\"Thing 2\"}]}\n" + batchBoundary + "\nContent-Type: application/http\n\nhttp/1.1 200 no text\nContent-Type: application/json; charset=UTF-8\n\n{\"@iot.count\":1,\"value\":[{\"name\":\"Thing 3\"}]}\n" + batchBoundary + "--"), (Object)response);
    }

    @Test
    void test06JsonBatchRequest() {
        LOGGER.info("  test06JsonBatchRequest");
        String response = this.postBatch(null, "{\"requests\":[{\"id\": \"0\",\"method\": \"get\",\"url\": \"Things(" + THINGS.get(0).getId().getUrl() + ")?$select=name\"},{\"id\": \"1\",\"atomicityGroup\": \"group1\",\"method\": \"post\",\"url\": \"Things\",\"body\": {\"name\":\"New\",\"description\":\"Thing\"}},{\"id\": \"2\",\"atomicityGroup\": \"group1\",\"method\": \"patch\",\"url\": \"Things(" + THINGS.get(0).getId().getUrl() + ")\",\"body\": {\"name\":\"Json Patched\"}},{\"id\": \"3\",\"method\": \"get\",\"url\": \"Things(null)\"}]}");
        String thingId = this.getLastestEntityIdForPath(EntityType.THING);
        try {
            BatchResponseJson expected = (BatchResponseJson)this.mapper.readValue("{\"responses\":[{\"id\":\"0\",\"status\":200,\"body\":{\"name\":\"Patched\"}},{\"id\":\"1\",\"status\":201,\"location\":\"" + serverSettings.getServiceUrl(version) + "/Things(" + thingId + ")\"},{\"id\":\"2\",\"status\":200},{\"id\":\"3\",\"status\":404,\"body\":{\"code\":404,\"type\":\"error\",\"message\":\"Not a valid id: Path is not valid.\"}}]}", BatchResponseJson.class);
            BatchResponseJson actual = (BatchResponseJson)this.mapper.readValue(response, BatchResponseJson.class);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)"Response not as expected.");
        }
        catch (JsonProcessingException ex) {
            Assertions.fail((String)"Failed to parse response as json.");
        }
    }

    @Test
    void test07JsonBatchRequestWithChangeSetReferencingNewEntities() {
        LOGGER.info("  test07JsonBatchRequestWithChangeSetReferencingNewEntities");
        String post1 = "{\r\n  \"name\": \"DS18B20\",\r\n  \"description\": \"DS18B20 is an air temperature sensor\",\r\n  \"encodingType\": \"application/pdf\",\r\n  \"metadata\": \"http://datasheets.maxim-ic.com/en/ds/DS18B20.pdf\"\r\n}";
        String post2 = "{\r\n  \"name\": \"Temperature Thing 5\",\r\n  \"description\": \"The temperature of thing 5\",\r\n  \"unitOfMeasurement\": {\r\n    \"name\": \"degree Celsius\",\r\n    \"symbol\": \"\u00b0C\",\r\n    \"definition\": \"http://unitsofmeasure.org/ucum.html#para-30\"\r\n  },\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGCOM/2.0/OM_Measurement\",\r\n  \"ObservedProperty\": {\"@iot.id\": " + OBSERVED_PROPS.get(0).getId().getJson() + "},\r\n  \"Sensor\": {\"@iot.id\": \"$sensor1\"}\r\n}";
        String response = this.postBatch(null, "{\"requests\":[{\"id\": \"sensor1\",\"atomicityGroup\": \"group1\",\"method\": \"post\",\"url\": \"Sensors\",\"body\":" + post1 + "},{\"id\": \"any\",\"atomicityGroup\": \"group1\",\"method\": \"post\",\"url\": \"Things(" + THINGS.get(0).getId().getUrl() + ")/Datastreams\",\"body\":" + post2 + "}]}");
        String sensorId = this.getLastestEntityIdForPath(EntityType.SENSOR);
        String datastreamId = this.getLastestEntityIdForPath(EntityType.DATASTREAM);
        try {
            BatchResponseJson expected = (BatchResponseJson)this.mapper.readValue("{\"responses\":[{\"id\":\"sensor1\",\"status\":201,\"location\":\"" + serverSettings.getServiceUrl(version) + "/Sensors(" + sensorId + ")\"},{\"id\":\"any\",\"status\":201,\"location\":\"" + serverSettings.getServiceUrl(version) + "/Datastreams(" + datastreamId + ")\"}]}", BatchResponseJson.class);
            BatchResponseJson actual = (BatchResponseJson)this.mapper.readValue(response, BatchResponseJson.class);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)"Response not as expected.");
        }
        catch (JsonProcessingException ex) {
            Assertions.fail((String)"Failed to parse response as json.");
        }
    }

    private String postBatch(String boundary, String body) {
        String urlString = serverSettings.getServiceUrl(version) + "/$batch";
        try {
            HTTPMethods.HttpResponse httpResponse = HTTPMethods.doPost(urlString, body, (String)(boundary == null ? "application/json" : "multipart/mixed;boundary=" + boundary));
            Assertions.assertEquals((int)200, (int)httpResponse.code, (String)"Batch response should be 200");
            return httpResponse.response;
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return null;
        }
    }

    private String getLastestEntityIdForPath(EntityType entityType) {
        EntityHelper entityHelper = new EntityHelper(version, serverSettings);
        Object id = entityHelper.getAnyEntity(entityType, "$orderBy=id%20desc", 1).get("@iot.id");
        if (id instanceof Number) {
            return id.toString();
        }
        return "'" + id.toString() + "'";
    }

    public static class Implementation11
    extends BatchTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends BatchTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

