/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c03filtering;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class JsonPropertiesTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertiesTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public JsonPropertiesTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)JsonPropertiesTests.version.urlPart);
        try {
            JsonPropertiesTests.createEntities();
        }
        catch (ServiceFailureException | IOException | URISyntaxException ex) {
            LOGGER.error("Failed to set up.", ex);
        }
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        JsonPropertiesTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        JsonPropertiesTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException, IOException {
        for (int i = 0; i < 4; ++i) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("string", JsonPropertiesTests.generateString(i, 10));
            properties.put("boolean", i % 2 == 0);
            properties.put("int", i + 8);
            properties.put("intArray", JsonPropertiesTests.generateIntArray(i + 8, 5));
            properties.put("intIntArray", JsonPropertiesTests.generateIntIntArray(i + 8, 3));
            properties.put("objArray", JsonPropertiesTests.generateObjectList(i + 8, 3));
            Thing thing = new Thing("Thing " + i, "It's a thing.");
            thing.setProperties(properties);
            service.create((Entity)thing);
            THINGS.add(thing);
        }
        Location location = new Location("Location 1", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 52.0));
        location.getThings().add((Entity)THINGS.get(0).withOnlyId());
        service.create((Entity)location);
        LOCATIONS.add(location);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        O_PROPS.add(obsProp);
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "Cel"));
        datastream.setThing(THINGS.get(0));
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        ObjectMapper mapper = ObjectMapperFactory.get();
        String resultQualityObjectString = "{\"DQ_Status\":{  \"code\": 2,  \"label\": \"Niveau 1\",\n  \"comment\": \"Donn\u00e9e contr\u00f4l\u00e9e niveau 1 (donn\u00e9es contr\u00f4l\u00e9es)\"}}";
        String resultQualityArrayString = "[\n    {\n        \"nameOfMeasure\": \"DQ_Status\",\n        \"DQ_Result\": {\n            \"code\": 2,\n            \"label\": \"Niveau 1\",\n            \"comment\": \"Donn\u00e9e contr\u00f4l\u00e9e niveau 1 (donn\u00e9es contr\u00f4l\u00e9es)\"\n        }\n    },\n    {\n        \"nameOfMeasure\": \"DQ_Qualification\",\n        \"DQ_Result\": {\n            \"code\": 1,\n            \"label\": \"Correcte\",\n            \"comment\": \"Correcte\"\n        }\n    }\n\n]";
        JsonNode rqObject = mapper.readTree(resultQualityObjectString);
        JsonNode rqArray = mapper.readTree(resultQualityArrayString);
        for (int i = 0; i <= 12; ++i) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Observation o = new Observation((Object)i, datastream);
            parameters.put("string", JsonPropertiesTests.generateString(i, 10));
            parameters.put("boolean", i % 2 == 0);
            parameters.put("int", i);
            parameters.put("intArray", JsonPropertiesTests.generateIntArray(i, 5));
            parameters.put("intIntArray", JsonPropertiesTests.generateIntIntArray(i, 3));
            parameters.put("objArray", JsonPropertiesTests.generateObjectList(i, 3));
            o.setParameters(parameters);
            o.setResultQuality((Object)(i % 2 == 0 ? rqObject : rqArray));
            service.create((Entity)o);
            OBSERVATIONS.add(o);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Observation o = new Observation((Object)"badVales1", datastream);
        parameters.put("int", JsonPropertiesTests.generateString(13, 10));
        parameters.put("string", false);
        parameters.put("boolean", 13);
        parameters.put("objArray", JsonPropertiesTests.generateIntArray(13, 5));
        parameters.put("intArray", JsonPropertiesTests.generateIntIntArray(13, 3));
        parameters.put("intIntArray", JsonPropertiesTests.generateObjectList(13, 3));
        o.setParameters(parameters);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        parameters = new HashMap();
        o = new Observation((Object)"badVales2", datastream);
        parameters.put("boolean", JsonPropertiesTests.generateString(14, 10));
        parameters.put("int", true);
        parameters.put("string", 14);
        parameters.put("intIntArray", JsonPropertiesTests.generateIntArray(14, 5));
        parameters.put("objArray", JsonPropertiesTests.generateIntIntArray(14, 3));
        parameters.put("intArray", JsonPropertiesTests.generateObjectList(14, 3));
        o.setParameters(parameters);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        parameters = new HashMap();
        o = new Observation((Object)"badVales3", datastream);
        parameters.put("boolean", "true");
        parameters.put("int", "5");
        o.setParameters(parameters);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
        datastream = new Datastream("Datastream 2", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree Fahrenheit", "\u00b0F", "[degF]"));
        datastream.setThing(THINGS.get(0));
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
    }

    public static String generateString(int startLetter, int length) {
        StringBuilder sb = new StringBuilder();
        int curLetter = 97 + startLetter % 26;
        for (int i = 0; i < length; ++i) {
            sb.append((char)curLetter);
            curLetter = (char)(curLetter + '\u0001');
            if (curLetter <= 122) continue;
            curLetter = 97;
        }
        return sb.toString();
    }

    public static int[] generateIntArray(int startValue, int length) {
        int[] value = new int[length];
        int curVal = startValue;
        for (int i = 0; i < length; ++i) {
            value[i] = curVal++;
        }
        return value;
    }

    public static int[][] generateIntIntArray(int startValue, int length) {
        int[][] value = new int[length][];
        int curVal = startValue;
        for (int i = 0; i < length; ++i) {
            value[i] = JsonPropertiesTests.generateIntArray(curVal, length);
            ++curVal;
        }
        return value;
    }

    public static List<Object> generateObjectList(int startValue, int length) {
        ArrayList<Object> value = new ArrayList<Object>();
        int curVal = startValue;
        for (int i = 0; i < length; ++i) {
            HashMap<String, Object> newObject = new HashMap<String, Object>();
            newObject.put("string", JsonPropertiesTests.generateString(curVal, 10));
            newObject.put("boolean", curVal % 2 == 0);
            newObject.put("int", curVal);
            newObject.put("intArray", JsonPropertiesTests.generateIntArray(curVal, 3));
            value.add(newObject);
            ++curVal;
        }
        return value;
    }

    @Test
    void test01FetchLowLevelThingProperties() {
        LOGGER.info("  test01FetchLowLevelThingProperties");
        String urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/string";
        JsonNode json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "string", (String)THINGS.get(0).getProperties().get("string"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/boolean";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "boolean", (Boolean)THINGS.get(0).getProperties().get("boolean"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/int";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "int", (Integer)THINGS.get(0).getProperties().get("int"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/intArray";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intArray", (int[])THINGS.get(0).getProperties().get("intArray"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/intArray[1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intArray[1]", ((int[])THINGS.get(0).getProperties().get("intArray"))[1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/intIntArray[1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intIntArray[1]", ((int[][])THINGS.get(0).getProperties().get("intIntArray"))[1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/intIntArray[0][1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intIntArray[0][1]", ((int[][])THINGS.get(0).getProperties().get("intIntArray"))[0][1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/objArray[0]/string";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "string", (String)((Map)((List)THINGS.get(0).getProperties().get("objArray")).get(0)).get("string"), urlString);
    }

    @Test
    void test02FetchLowLevelObservationParameters() {
        LOGGER.info("  test02FetchLowLevelObservationParameters");
        String urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/string";
        JsonNode json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "string", (String)OBSERVATIONS.get(0).getParameters().get("string"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/boolean";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "boolean", (Boolean)OBSERVATIONS.get(0).getParameters().get("boolean"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/int";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "int", (Integer)OBSERVATIONS.get(0).getParameters().get("int"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/intArray";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intArray", (int[])OBSERVATIONS.get(0).getParameters().get("intArray"), urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/intArray[1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intArray[1]", ((int[])OBSERVATIONS.get(0).getParameters().get("intArray"))[1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/intIntArray[1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intIntArray[1]", ((int[][])OBSERVATIONS.get(0).getParameters().get("intIntArray"))[1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/intIntArray[0][1]";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "intIntArray[0][1]", ((int[][])OBSERVATIONS.get(0).getParameters().get("intIntArray"))[0][1], urlString);
        urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(0).getId().getUrl() + ")/parameters/objArray[0]/string";
        json = this.getJsonObjectForResponse(urlString);
        this.testResponseProperty(json, "string", (String)((Map)((List)OBSERVATIONS.get(0).getParameters().get("objArray")).get(0)).get("string"), urlString);
    }

    @Test
    void test03StringFilter() {
        LOGGER.info("  test03StringFilter");
        EntityUtils.testFilterResults(service.things(), "properties/string eq '" + THINGS.get(2).getProperties().get("string") + "'", Utils.getFromList(THINGS, 2));
        EntityUtils.testFilterResults(service.observations(), "parameters/string eq '" + OBSERVATIONS.get(2).getParameters().get("string") + "'", Utils.getFromList(OBSERVATIONS, 2));
        EntityUtils.testFilterResults(service.things(), "substringof('cdefgh', properties/string)", Utils.getFromList(THINGS, 0, 1, 2));
        EntityUtils.testFilterResults(service.observations(), "substringof('cdefgh', parameters/string)", Utils.getFromList(OBSERVATIONS, 0, 1, 2));
        EntityUtils.testFilterResults(service.things(), "properties/objArray[0]/string eq 'jklmnopqrs'", Utils.getFromList(THINGS, 1));
        EntityUtils.testFilterResults(service.observations(), "parameters/objArray[0]/string eq 'jklmnopqrs'", Utils.getFromList(OBSERVATIONS, 9));
        EntityUtils.testFilterResults(service.observations(), "parameters/int eq '5'", Utils.getFromList(OBSERVATIONS, 5, 15));
    }

    @Test
    void test04NumberFilter() {
        LOGGER.info("  test04NumberFilter");
        EntityUtils.testFilterResults(service.things(), "properties/int eq " + THINGS.get(2).getProperties().get("int"), Utils.getFromList(THINGS, 2));
        EntityUtils.testFilterResults(service.observations(), "parameters/int eq " + OBSERVATIONS.get(2).getParameters().get("int"), Utils.getFromList(OBSERVATIONS, 2));
        EntityUtils.testFilterResults(service.things(), "properties/int gt 9", Utils.getFromList(THINGS, 2, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/int gt 8", Utils.getFromList(OBSERVATIONS, 9, 10, 11, 12));
        EntityUtils.testFilterResults(service.things(), "properties/int lt 9", Utils.getFromList(THINGS, 0));
        EntityUtils.testFilterResults(service.observations(), "parameters/int lt 8", Utils.getFromList(OBSERVATIONS, 0, 1, 2, 3, 4, 5, 6, 7));
        EntityUtils.testFilterResults(service.things(), "properties/intArray[1] gt 10", Utils.getFromList(THINGS, 2, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/intArray[1] gt 9", Utils.getFromList(OBSERVATIONS, 9, 10, 11, 12));
        EntityUtils.testFilterResults(service.things(), "properties/intArray[1] lt 10", Utils.getFromList(THINGS, 0));
        EntityUtils.testFilterResults(service.observations(), "parameters/intArray[1] lt 9", Utils.getFromList(OBSERVATIONS, 0, 1, 2, 3, 4, 5, 6, 7));
        EntityUtils.testFilterResults(service.things(), "properties/intIntArray[1][0] gt 10", Utils.getFromList(THINGS, 2, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/intIntArray[1][0] gt 9", Utils.getFromList(OBSERVATIONS, 9, 10, 11, 12));
        EntityUtils.testFilterResults(service.things(), "properties/objArray[1]/intArray[0] gt 10", Utils.getFromList(THINGS, 2, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/objArray[1]/intArray[0] gt 9", Utils.getFromList(OBSERVATIONS, 9, 10, 11, 12));
    }

    @Test
    void test05BooleanFilter() {
        LOGGER.info("  test05BooleanFilter");
        EntityUtils.testFilterResults(service.things(), "properties/boolean eq " + THINGS.get(1).getProperties().get("boolean"), Utils.getFromList(THINGS, 1, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/boolean eq " + OBSERVATIONS.get(1).getParameters().get("boolean"), Utils.getFromList(OBSERVATIONS, 1, 3, 5, 7, 9, 11));
        EntityUtils.testFilterResults(service.things(), "properties/boolean", Utils.getFromList(THINGS, 0, 2));
        EntityUtils.testFilterResults(service.observations(), "parameters/boolean", Utils.getFromList(OBSERVATIONS, 0, 2, 4, 6, 8, 10, 12));
        EntityUtils.testFilterResults(service.things(), "not properties/boolean", Utils.getFromList(THINGS, 1, 3));
        EntityUtils.testFilterResults(service.observations(), "not parameters/boolean", Utils.getFromList(OBSERVATIONS, 1, 3, 5, 7, 9, 11));
        EntityUtils.testFilterResults(service.things(), "properties/objArray[1]/boolean", Utils.getFromList(THINGS, 1, 3));
        EntityUtils.testFilterResults(service.observations(), "parameters/objArray[1]/boolean", Utils.getFromList(OBSERVATIONS, 1, 3, 5, 7, 9, 11));
    }

    @Test
    void test06UnitOfMeasurementFilter() {
        LOGGER.info("  test06UnitOfMeasurementFilter");
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/symbol eq '" + DATASTREAMS.get(0).getUnitOfMeasurement().getSymbol() + "'", Utils.getFromList(DATASTREAMS, 0));
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/symbol eq '" + DATASTREAMS.get(1).getUnitOfMeasurement().getSymbol() + "'", Utils.getFromList(DATASTREAMS, 1));
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/name eq '" + DATASTREAMS.get(0).getUnitOfMeasurement().getName() + "'", Utils.getFromList(DATASTREAMS, 0));
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/name eq '" + DATASTREAMS.get(1).getUnitOfMeasurement().getName() + "'", Utils.getFromList(DATASTREAMS, 1));
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/definition eq '" + DATASTREAMS.get(0).getUnitOfMeasurement().getDefinition() + "'", Utils.getFromList(DATASTREAMS, 0));
        EntityUtils.testFilterResults(service.datastreams(), "unitOfMeasurement/definition eq '" + DATASTREAMS.get(1).getUnitOfMeasurement().getDefinition() + "'", Utils.getFromList(DATASTREAMS, 1));
    }

    @Test
    void test07PropertyCompare() {
        LOGGER.info("  test07PropertyCompare");
        EntityUtils.testFilterResults(service.observations(), "parameters/int eq Datastream/Thing/properties/int", Utils.getFromList(OBSERVATIONS, 8));
        EntityUtils.testFilterResults(service.observations(), "parameters/string eq Datastream/Thing/properties/string", Utils.getFromList(OBSERVATIONS, 0));
        EntityUtils.testFilterResults(service.observations(), "parameters/boolean eq Datastream/Thing/properties/boolean", Utils.getFromList(OBSERVATIONS, 0, 2, 4, 6, 8, 10, 12, 15));
    }

    @Test
    void test20ResultQualityFilter() {
        LOGGER.info("  test20ResultQualityFilter");
        EntityUtils.testFilterResults(service.observations(), "resultQuality/DQ_Status/code eq 2", Utils.getFromList(OBSERVATIONS, 0, 2, 4, 6, 8, 10, 12));
        EntityUtils.testFilterResults(service.observations(), "resultQuality[0]/DQ_Result/code eq 2", Utils.getFromList(OBSERVATIONS, 1, 3, 5, 7, 9, 11));
    }

    private JsonNode getJsonObjectForResponse(String urlString) {
        JsonNode json;
        urlString = urlString.replaceAll(Pattern.quote("["), "%5B").replaceAll(Pattern.quote("]"), "%5D");
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
        String message = "Incorrect response code (" + responseMap.code + ") for url: " + urlString;
        Assertions.assertEquals((int)200, (int)responseMap.code, (String)message);
        try {
            json = new ObjectMapper().readTree(responseMap.response);
        }
        catch (IOException ex) {
            Assertions.fail((String)("Server returned malformed JSON for request: " + urlString + " Exception: " + ex.getMessage()));
            return null;
        }
        if (!json.isObject()) {
            Assertions.fail((String)("Server did not return a JSON object for request: " + urlString));
        }
        return json;
    }

    private void testResponseProperty(JsonNode response, String propertyName, String expectedValue, String urlForError) {
        JsonNode value = response.get(propertyName);
        if (value == null || !value.isTextual()) {
            Assertions.fail((String)("field '" + propertyName + "' is not an string for request: " + urlForError));
            return;
        }
        String message = "field '" + propertyName + "' does not have the correct value for request: " + urlForError;
        Assertions.assertEquals((Object)expectedValue, (Object)value.textValue(), (String)message);
    }

    private void testResponseProperty(JsonNode response, String propertyName, Boolean expectedValue, String urlForError) {
        JsonNode value = response.get(propertyName);
        if (value == null || !value.isBoolean()) {
            Assertions.fail((String)("field '" + propertyName + "' is not an boolean for request: " + urlForError));
            return;
        }
        String message = "field '" + propertyName + "' does not have the correct value for request: " + urlForError;
        Assertions.assertEquals((Object)expectedValue, (Object)value.booleanValue(), (String)message);
    }

    private void testResponseProperty(JsonNode response, String propertyName, Integer expectedValue, String urlForError) {
        JsonNode value = response.get(propertyName);
        if (value == null || !value.isInt()) {
            Assertions.fail((String)("field '" + propertyName + "' is not an integer for request: " + urlForError));
            return;
        }
        String message = "field '" + propertyName + "' does not have the correct value for request: " + urlForError;
        Assertions.assertEquals((int)expectedValue, (int)value.intValue(), (String)message);
    }

    private void testResponseProperty(JsonNode response, String propertyName, int[] expectedValue, String urlForError) {
        JsonNode value = response.get(propertyName);
        if (value == null || !value.isArray()) {
            Assertions.fail((String)("field '" + propertyName + "' is not an array for request: " + urlForError));
            return;
        }
        String message = "array '" + propertyName + "' does not have the correct size for request: " + urlForError;
        Assertions.assertEquals((int)expectedValue.length, (int)value.size(), (String)message);
        int i = 0;
        Iterator it = value.elements();
        while (it.hasNext()) {
            JsonNode element = (JsonNode)it.next();
            if (!element.isInt()) {
                Assertions.fail((String)("array '" + propertyName + "' contains non-integer element '" + element.toString() + "' for request: " + urlForError));
            }
            message = "array '" + propertyName + "' contains incorrect value at position " + i + " for request: " + urlForError;
            Assertions.assertEquals((int)expectedValue[i], (int)element.intValue(), (String)message);
            ++i;
        }
    }

    public static class Implementation11
    extends JsonPropertiesTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends JsonPropertiesTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

