/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c03filtering;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservedPropertyDao;
import de.fraunhofer.iosb.ilt.sta.dao.ThingDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geojson.LineString;
import org.geojson.LngLatAlt;
import org.geojson.Point;
import org.geojson.Polygon;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public abstract class FilterTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public FilterTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)FilterTests.version.urlPart);
        FilterTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        FilterTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        FilterTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 2", "The second thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 3", "The third thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 4", "The fourth thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        Location location = new Location("Location 1.0", "First Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 1.1", "Second Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 52.0));
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 2", "Location of Thing 2.", "application/vnd.geo+json", (Object)new Point(8.0, 53.0));
        location.getThings().add((Entity)THINGS.get(1));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 3", "Location of Thing 3.", "application/vnd.geo+json", (Object)new Point(8.0, 54.0));
        location.getThings().add((Entity)THINGS.get(2));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 4", "Location of Thing 4.", "application/vnd.geo+json", (Object)new Polygon(new LngLatAlt[]{new LngLatAlt(8.0, 53.0), new LngLatAlt(7.0, 52.0), new LngLatAlt(7.0, 53.0), new LngLatAlt(8.0, 53.0)}));
        location.getThings().add((Entity)THINGS.get(3));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 5", "A line.", "application/vnd.geo+json", (Object)new LineString(new LngLatAlt[]{new LngLatAlt(5.0, 52.0), new LngLatAlt(5.0, 53.0)}));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 6", "A longer line.", "application/vnd.geo+json", (Object)new LineString(new LngLatAlt[]{new LngLatAlt(5.0, 52.0), new LngLatAlt(6.0, 53.0)}));
        service.create((Entity)location);
        LOCATIONS.add(location);
        location = new Location("Location 7", "The longest line.", "application/vnd.geo+json", (Object)new LineString(new LngLatAlt[]{new LngLatAlt(4.0, 52.0), new LngLatAlt(8.0, 52.0)}));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FilterTests.createSensor("Sensor 0", "The sensor with idx 0.", "text", "Some metadata.");
        FilterTests.createSensor("Sensor 1", "The sensor with idx 0.", "text", "Some metadata.");
        FilterTests.createSensor("Sensor 2", "The sensor with idx 0.", "text", "Some metadata.");
        FilterTests.createSensor("Sensor 3", "The sensor with idx 0.", "text", "Some metadata.");
        FilterTests.createObservedProperty("ObservedProperty 0", new URI("http://ucom.org/temperature"), "ObservedProperty with index 0.");
        FilterTests.createObservedProperty("ObservedProperty 1", new URI("http://ucom.org/humidity"), "ObservedProperty with index 1.");
        FilterTests.createObservedProperty("ObservedProperty 2", new URI("http://ucom.org/pressure"), "ObservedProperty with index 2.");
        FilterTests.createObservedProperty("ObservedProperty 3", new URI("http://ucom.org/turbidity"), "ObservedProperty with index 3.");
        UnitOfMeasurement uomTemp = new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T");
        FilterTests.createDatastream("Datastream 0", "Datastream 1 of thing 0, sensor 0.", "someType", uomTemp, THINGS.get(0), SENSORS.get(0), O_PROPS.get(0));
        FilterTests.createDatastream("Datastream 1", "Datastream 2 of thing 0, sensor 1.", "someType", uomTemp, THINGS.get(0), SENSORS.get(1), O_PROPS.get(1));
        FilterTests.createDatastream("Datastream 2", "Datastream 3 of thing 0, sensor 2.", "someType", uomTemp, THINGS.get(0), SENSORS.get(2), O_PROPS.get(2));
        FilterTests.createDatastream("Datastream 3", "Datastream 1 of thing 1, sensor 0.", "someType", uomTemp, THINGS.get(1), SENSORS.get(0), O_PROPS.get(0));
        FilterTests.createDatastream("Datastream 4", "Datastream 2 of thing 1, sensor 1.", "someType", uomTemp, THINGS.get(1), SENSORS.get(1), O_PROPS.get(1));
        FilterTests.createDatastream("Datastream 5", "Datastream 3 of thing 1, sensor 3.", "someType", uomTemp, THINGS.get(1), SENSORS.get(3), O_PROPS.get(3));
        ZonedDateTime startTime = ZonedDateTime.parse("2016-01-01T01:00:00.000Z");
        Interval startInterval = Interval.of((Instant)Instant.parse("2016-01-01T01:00:00.000Z"), (Instant)Instant.parse("2016-01-01T02:00:00.000Z"));
        FilterTests.createObservationSet(DATASTREAMS.get(0), 0L, startTime, startInterval, 6);
        FilterTests.createObservationSet(DATASTREAMS.get(1), 3L, startTime, startInterval, 6);
        FilterTests.createObservationSet(DATASTREAMS.get(2), 6L, startTime, startInterval, 6);
        FilterTests.createObservationSet(DATASTREAMS.get(3), 9L, startTime, startInterval, 6);
        FilterTests.createObservationSet(DATASTREAMS.get(4), 12L, startTime, startInterval, 6);
        FilterTests.createObservationSet(DATASTREAMS.get(5), 15L, startTime, startInterval, 6);
    }

    private static Sensor createSensor(String name, String desc, String type, String metadata) throws ServiceFailureException {
        int idx = SENSORS.size();
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("idx", idx);
        Sensor sensor = new Sensor(name, desc, type, (Object)metadata);
        sensor.setProperties(properties);
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        return sensor;
    }

    private static Datastream createDatastream(String name, String desc, String type, UnitOfMeasurement uom, Thing thing, Sensor sensor, ObservedProperty op) throws ServiceFailureException {
        int idx = DATASTREAMS.size();
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("idx", idx);
        Datastream ds = new Datastream(name, desc, type, uom);
        ds.setProperties(properties);
        ds.setThing(thing);
        ds.setSensor(sensor);
        ds.setObservedProperty(op);
        service.create((Entity)ds);
        DATASTREAMS.add(ds);
        return ds;
    }

    private static ObservedProperty createObservedProperty(String name, URI definition, String description) throws ServiceFailureException {
        int idx = O_PROPS.size();
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("idx", idx);
        ObservedProperty obsProp = new ObservedProperty(name, definition, description);
        obsProp.setProperties(properties);
        service.create((Entity)obsProp);
        O_PROPS.add(obsProp);
        return obsProp;
    }

    private static void createObservationSet(Datastream datastream, long resultStart, ZonedDateTime phenomenonTimeStart, Interval validTimeStart, int count) throws ServiceFailureException {
        for (int i = 0; i < count; ++i) {
            ZonedDateTime phenTime = phenomenonTimeStart.plus(i, ChronoUnit.HOURS);
            Interval validTime = Interval.of((Instant)validTimeStart.getStart().plus((long)count, ChronoUnit.HOURS), (Instant)validTimeStart.getEnd().plus((long)count, ChronoUnit.HOURS));
            FilterTests.createObservation(datastream, resultStart + (long)i, phenTime, validTime);
        }
    }

    private static Observation createObservation(Datastream datastream, long result, ZonedDateTime phenomenonTime, Interval validTime) throws ServiceFailureException {
        int idx = OBSERVATIONS.size();
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("idx", idx);
        Observation obs = new Observation((Object)result, datastream);
        obs.setPhenomenonTimeFrom(phenomenonTime);
        obs.setValidTime(validTime);
        obs.setParameters(parameters);
        if (idx % 2 == 0) {
            obs.setResultQuality((Object)idx);
        } else {
            obs.setResultQuality((Object)("number-" + idx));
        }
        service.create((Entity)obs);
        OBSERVATIONS.add(obs);
        return obs;
    }

    @Test
    void testIndirectFilter() throws ServiceFailureException {
        LOGGER.info("  testIndirectFilter");
        ThingDao doa = service.things();
        EntityUtils.testFilterResults(doa, "Locations/name eq 'Location 2'", Utils.getFromList(THINGS, 1));
        EntityUtils.testFilterResults(doa, "startswith(HistoricalLocations/Locations/name, 'Location 1')", Utils.getFromList(THINGS, 0));
    }

    @Test
    void testDeepIndirection() throws ServiceFailureException {
        LOGGER.info("  testDeepIndirection");
        ObservedPropertyDao doa = service.observedProperties();
        EntityUtils.testFilterResults(doa, "Datastreams/Thing/Datastreams/ObservedProperty/name eq 'ObservedProperty 0'", Utils.getFromList(O_PROPS, 0, 1, 2, 3));
        EntityUtils.testFilterResults(doa, "Datastreams/Thing/Datastreams/ObservedProperty/name eq 'ObservedProperty 3'", Utils.getFromList(O_PROPS, 0, 1, 3));
    }

    @Test
    void testNullEntityProperty() {
        LOGGER.info("  testNullEntityProperty");
        String requestUrl = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties";
        HTTPMethods.HttpResponse result = HTTPMethods.doGet(requestUrl);
        if (result.code != 204) {
            Assertions.fail((String)("Expected response code 204 on request " + requestUrl));
        }
    }

    @Test
    void testNullEntityPropertyValue() {
        LOGGER.info("  testNullEntityPropertyValue");
        String requestUrl = serverSettings.getServiceUrl(version) + "/Things(" + THINGS.get(0).getId().getUrl() + ")/properties/$value";
        HTTPMethods.HttpResponse result = HTTPMethods.doGet(requestUrl);
        if (result.code != 204) {
            Assertions.fail((String)("Expected response code 204 on request " + requestUrl));
        }
    }

    @Test
    void testStringResultQualityValue() {
        LOGGER.info("  testStringResultQualityValue");
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, "resultQuality eq 'number-1'", Utils.getFromList(OBSERVATIONS, 1));
    }

    @Test
    void testNumericResultQualityValue() {
        LOGGER.info("  testNumericResultQualityValue");
        ObservationDao doa = service.observations();
        EntityUtils.testFilterResults(doa, "resultQuality eq 2", Utils.getFromList(OBSERVATIONS, 2));
    }

    public static class Implementation11
    extends FilterTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends FilterTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

