/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c02cud;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public abstract class DeleteFilterTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteFilterTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static final ZonedDateTime T2015 = ZonedDateTime.parse("2015-01-01T06:00:00.000Z");
    private static final ZonedDateTime T600 = ZonedDateTime.parse("2016-01-01T06:00:00.000Z");
    private static final ZonedDateTime T659 = ZonedDateTime.parse("2016-01-01T06:59:00.000Z");
    private static final ZonedDateTime T700 = ZonedDateTime.parse("2016-01-01T07:00:00.000Z");
    private static final ZonedDateTime T701 = ZonedDateTime.parse("2016-01-01T07:01:00.000Z");
    private static final ZonedDateTime T759 = ZonedDateTime.parse("2016-01-01T07:59:00.000Z");
    private static final ZonedDateTime T800 = ZonedDateTime.parse("2016-01-01T08:00:00.000Z");
    private static final ZonedDateTime T801 = ZonedDateTime.parse("2016-01-01T08:01:00.000Z");
    private static final ZonedDateTime T900 = ZonedDateTime.parse("2016-01-01T09:00:00.000Z");
    private static final ZonedDateTime T2017 = ZonedDateTime.parse("2017-01-01T09:00:00.000Z");
    private static final Interval I2015 = Interval.of((Instant)T2015.toInstant(), (Instant)T2015.plus(1L, ChronoUnit.HOURS).toInstant());
    private static final Interval I600_659 = Interval.of((Instant)T600.toInstant(), (Instant)T659.toInstant());
    private static final Interval I600_700 = Interval.of((Instant)T600.toInstant(), (Instant)T700.toInstant());
    private static final Interval I600_701 = Interval.of((Instant)T600.toInstant(), (Instant)T701.toInstant());
    private static final Interval I700_800 = Interval.of((Instant)T700.toInstant(), (Instant)T800.toInstant());
    private static final Interval I701_759 = Interval.of((Instant)T701.toInstant(), (Instant)T759.toInstant());
    private static final Interval I759_900 = Interval.of((Instant)T759.toInstant(), (Instant)T900.toInstant());
    private static final Interval I800_900 = Interval.of((Instant)T800.toInstant(), (Instant)T900.toInstant());
    private static final Interval I801_900 = Interval.of((Instant)T801.toInstant(), (Instant)T900.toInstant());
    private static final Interval I659_801 = Interval.of((Instant)T659.toInstant(), (Instant)T801.toInstant());
    private static final Interval I700_759 = Interval.of((Instant)T700.toInstant(), (Instant)T759.toInstant());
    private static final Interval I700_801 = Interval.of((Instant)T700.toInstant(), (Instant)T801.toInstant());
    private static final Interval I659_800 = Interval.of((Instant)T659.toInstant(), (Instant)T800.toInstant());
    private static final Interval I701_800 = Interval.of((Instant)T701.toInstant(), (Instant)T800.toInstant());
    private static final Interval I2017 = Interval.of((Instant)T2017.toInstant(), (Instant)T2017.plus(1L, ChronoUnit.HOURS).toInstant());

    public DeleteFilterTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)DeleteFilterTests.version.urlPart);
        DeleteFilterTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        DeleteFilterTests.cleanup();
    }

    @AfterAll
    public static void tearDown() {
        LOGGER.info("Tearing down.");
        try {
            DeleteFilterTests.cleanup();
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to clean database.", (Throwable)ex);
        }
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        THINGS.add(thing);
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        thing.getLocations().add((Entity)location);
        service.create((Entity)thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(thing);
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        datastream = new Datastream("Datastream 2", "The alternate temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(thing);
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
    }

    private void recreateObservations() throws ServiceFailureException {
        EntityUtils.deleteAll(service.observations());
        OBSERVATIONS.clear();
        this.recreateObservations(DATASTREAMS.get(0));
        this.recreateObservations(DATASTREAMS.get(1));
    }

    private void recreateObservations(Datastream datastream) throws ServiceFailureException {
        this.createObservation(0.0, datastream, T600, T600, null);
        this.createObservation(1.0, datastream, T659, T659, null);
        this.createObservation(2.0, datastream, T700, T700, null);
        this.createObservation(3.0, datastream, T701, T701, null);
        this.createObservation(4.0, datastream, T759, T759, null);
        this.createObservation(5.0, datastream, T800, T800, null);
        this.createObservation(6.0, datastream, T801, T801, null);
        this.createObservation(7.0, datastream, T900, T900, null);
        this.createObservation(8.0, datastream, I600_659, null, I600_659);
        this.createObservation(9.0, datastream, I600_700, null, I600_700);
        this.createObservation(10.0, datastream, I600_701, null, I600_701);
        this.createObservation(11.0, datastream, I700_800, null, I700_800);
        this.createObservation(12.0, datastream, I701_759, null, I701_759);
        this.createObservation(13.0, datastream, I759_900, null, I759_900);
        this.createObservation(14.0, datastream, I800_900, null, I800_900);
        this.createObservation(15.0, datastream, I801_900, null, I801_900);
        this.createObservation(16.0, datastream, I659_801, null, I659_801);
        this.createObservation(17.0, datastream, I700_759, null, I700_759);
        this.createObservation(18.0, datastream, I700_801, null, I700_801);
        this.createObservation(19.0, datastream, I659_800, null, I659_800);
        this.createObservation(20.0, datastream, I701_800, null, I701_800);
        this.createObservation(21.0, datastream, T2015, T2015, null);
        this.createObservation(22.0, datastream, T2017, T2017, null);
        this.createObservation(23.0, datastream, I2015, null, I2015);
        this.createObservation(24.0, datastream, I2017, null, I2017);
    }

    private void createObservation(double result, Datastream ds, Interval pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        this.createObservation(result, ds, new TimeObject(pt), rt, vt);
    }

    private void createObservation(double result, Datastream ds, ZonedDateTime pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        this.createObservation(result, ds, new TimeObject(pt), rt, vt);
    }

    private void createObservation(double result, Datastream ds, TimeObject pt, ZonedDateTime rt, Interval vt) throws ServiceFailureException {
        Observation o = new Observation((Object)result, ds);
        o.setPhenomenonTime(pt);
        o.setResultTime(rt);
        o.setValidTime(vt);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    public void deleteAndCheck(BaseDao doa, String filter, List<? extends Entity> expected) {
        try {
            doa.query().filter(filter).delete();
            EntityList result = service.observations().query().list();
            EntityUtils.ResultTestResult check = EntityUtils.resultContains((EntityList<? extends Entity>)result, expected);
            String message = "Failed on filter: " + filter + " Cause: " + check.message;
            Assertions.assertTrue((boolean)check.testOk, (String)message);
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to call service.", (Throwable)ex);
            Assertions.fail((String)("Failed to call service." + ex.getReturnedContent()));
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to call service.", (Throwable)ex);
            Assertions.fail((String)("Failed to call service." + ex.getMessage()));
        }
    }

    @Test
    void testDeleteByTime() throws ServiceFailureException {
        LOGGER.info("  testDeleteByTime");
        this.recreateObservations();
        Datastream ds1 = DATASTREAMS.get(0);
        ObservationDao doaDs1 = ds1.observations();
        List<Observation> remaining = Utils.getFromListExcept(OBSERVATIONS, 0, 1, 21);
        this.deleteAndCheck((BaseDao)doaDs1, String.format("resultTime lt %s", T700), remaining);
        this.deleteAndCheck((BaseDao)doaDs1, String.format("validTime lt %s", T700), Utils.removeFromList(OBSERVATIONS, remaining, 8, 9, 23));
        this.deleteAndCheck((BaseDao)doaDs1, String.format("%s lt phenomenonTime", T800), Utils.removeFromList(OBSERVATIONS, remaining, 6, 7, 15, 22, 24));
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    public static class Implementation11
    extends DeleteFilterTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends DeleteFilterTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

