/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c02cud;

import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Extension;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.IdType;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class Capability2Tests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(Capability2Tests.class);
    private static final Map<EntityType, IdType> ID_TYPES = new HashMap<EntityType, IdType>();
    private static final List<Object> ACTUATOR_IDS = new ArrayList<Object>();
    private static final List<Object> TASK_IDS = new ArrayList<Object>();
    private static final List<Object> TASKINGCAPABILITY_IDS = new ArrayList<Object>();
    private static final List<Object> THING_IDS = new ArrayList<Object>();
    private static final List<Object> LOCATION_IDS = new ArrayList<Object>();
    private static final List<Object> HISTORICAL_LOCATION_IDS = new ArrayList<Object>();
    private static final List<Object> DATASTREAM_IDS = new ArrayList<Object>();
    private static final List<Object> OBSERVATION_IDS = new ArrayList<Object>();
    private static final List<Object> SENSOR_IDS = new ArrayList<Object>();
    private static final List<Object> OBSPROP_IDS = new ArrayList<Object>();
    private static final List<Object> FOI_IDS = new ArrayList<Object>();

    public Capability2Tests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)Capability2Tests.version.urlPart);
        Capability2Tests.deleteEverything();
        ID_TYPES.clear();
    }

    @Override
    protected void tearDownVersion() {
        Capability2Tests.deleteEverything();
        ID_TYPES.clear();
    }

    @AfterAll
    public static void tearDown() {
        LOGGER.info("Tearing down.");
        Capability2Tests.deleteEverything();
    }

    @Test
    void test01CreateInvalidEntitiesWithDeepInsert() {
        LOGGER.info("  test01CreateInvalidEntitiesWithDeepInsert");
        Object urlParameters = "{\n  \"name\": \"Office Building\",\n  \"description\": \"Office Building\",\n  \"properties\": {\n    \"reference\": \"Third Floor\"\n  },\n  \"Locations\": [\n    {\n      \"name\": \"West Roof\",\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"application/vnd.geo+json\"\n    }\n  ],\n  \"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"name\": \"Light exposure.\",\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n      \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      }\n    }\n  ]\n}";
        this.postInvalidEntity(EntityType.THING, (String)urlParameters);
        ArrayList<EntityType> entityTypesToCheck = new ArrayList<EntityType>();
        entityTypesToCheck.add(EntityType.THING);
        entityTypesToCheck.add(EntityType.LOCATION);
        entityTypesToCheck.add(EntityType.HISTORICAL_LOCATION);
        entityTypesToCheck.add(EntityType.DATASTREAM);
        entityTypesToCheck.add(EntityType.OBSERVED_PROPERTY);
        this.checkNotExisting(entityTypesToCheck);
        urlParameters = "{\"name\": \"Office Building\",\"description\": \"Office Building\"}";
        Object thingId = this.postEntity(EntityType.THING, (String)urlParameters).get("@iot.id");
        urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
        this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
        urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n   \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
        this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
        urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n   \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
        this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
        entityTypesToCheck.clear();
        entityTypesToCheck.add(EntityType.DATASTREAM);
        entityTypesToCheck.add(EntityType.SENSOR);
        entityTypesToCheck.add(EntityType.OBSERVATION);
        entityTypesToCheck.add(EntityType.FEATURE_OF_INTEREST);
        entityTypesToCheck.add(EntityType.OBSERVED_PROPERTY);
        this.checkNotExisting(entityTypesToCheck);
        urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n   \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n   }\n}";
        Object datastreamId = this.postEntity(EntityType.DATASTREAM, (String)urlParameters).get("@iot.id");
        urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
        this.postInvalidEntity(EntityType.OBSERVATION, (String)urlParameters);
        urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"FeatureOfInterest\": {\n  \t\"name\": \"A weather station.\",\n  \t\"description\": \"A weather station.\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  },\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
        this.postInvalidEntity(EntityType.OBSERVATION, (String)urlParameters);
        entityTypesToCheck.clear();
        entityTypesToCheck.add(EntityType.OBSERVATION);
        entityTypesToCheck.add(EntityType.FEATURE_OF_INTEREST);
        this.checkNotExisting(entityTypesToCheck);
        Capability2Tests.deleteEverything();
    }

    @Test
    void test02CreateEntities() {
        LOGGER.info("  test02CreateEntities");
        try {
            String urlParameters = "{\"name\":\"Test Thing\",\"description\":\"This is a Test Thing From TestNG\"}";
            JSONObject entity = this.postEntity(EntityType.THING, urlParameters);
            Object thingId = entity.get("@iot.id");
            THING_IDS.add(thingId);
            ID_TYPES.put(EntityType.THING, IdType.findFor(thingId));
            Object urlParameters2 = "{\n  \"name\": \"bow river\",\n  \"description\": \"bow river\",\n  \"encodingType\": \"application/vnd.geo+json\",\n  \"location\": { \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }\n}";
            JSONObject entity2 = this.postEntity(EntityType.LOCATION, (String)urlParameters2);
            Object locationId = entity2.get("@iot.id");
            LOCATION_IDS.add(locationId);
            ID_TYPES.put(EntityType.LOCATION, IdType.findFor(locationId));
            JSONObject locationEntity = entity2;
            urlParameters2 = "{\n  \"name\": \"Fuguro Barometer\",\n  \"description\": \"Fuguro Barometer\",\n  \"encodingType\": \"application/pdf\",\n  \"metadata\": \"Barometer\"\n}";
            entity2 = this.postEntity(EntityType.SENSOR, (String)urlParameters2);
            Object sensorId = entity2.get("@iot.id");
            SENSOR_IDS.add(sensorId);
            ID_TYPES.put(EntityType.SENSOR, IdType.findFor(sensorId));
            urlParameters2 = "{\n  \"name\": \"DewPoint Temperature\",\n  \"definition\": \"http://dbpedia.org/page/Dew_point\",\n  \"description\": \"The dewpoint temperature is the temperature to which the air must be cooled, at constant pressure, for dew to form. As the grass and other objects near the ground cool to the dewpoint, some of the water vapor in the atmosphere condenses into liquid water on the objects.\"\n}";
            entity2 = this.postEntity(EntityType.OBSERVED_PROPERTY, (String)urlParameters2);
            Object obsPropId = entity2.get("@iot.id");
            OBSPROP_IDS.add(obsPropId);
            ID_TYPES.put(EntityType.OBSERVED_PROPERTY, IdType.findFor(obsPropId));
            urlParameters2 = "{\n  \"name\": \"A weather station.\",\n  \"description\": \"A weather station.\",\n  \"encodingType\": \"application/vnd.geo+json\",\n  \"feature\": {\n    \"type\": \"Point\",\n    \"coordinates\": [\n      10,\n      10\n    ]\n  }\n}";
            entity2 = this.postEntity(EntityType.FEATURE_OF_INTEREST, (String)urlParameters2);
            Object foiId = entity2.get("@iot.id");
            FOI_IDS.add(foiId);
            ID_TYPES.put(EntityType.FEATURE_OF_INTEREST, IdType.findFor(foiId));
            urlParameters2 = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(THING_IDS.get(0)) + " },\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(OBSPROP_IDS.get(0)) + "},\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(SENSOR_IDS.get(0)) + " }\n}";
            entity2 = this.postEntity(EntityType.DATASTREAM, (String)urlParameters2);
            Object datastreamId = entity2.get("@iot.id");
            DATASTREAM_IDS.add(datastreamId);
            ID_TYPES.put(EntityType.DATASTREAM, IdType.findFor(datastreamId));
            urlParameters2 = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"result\": 8,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(DATASTREAM_IDS.get(0)) + "},\n  \"FeatureOfInterest\": {\"@iot.id\": " + Utils.quoteIdForJson(FOI_IDS.get(0)) + "}  \n}";
            entity2 = this.postEntity(EntityType.OBSERVATION, (String)urlParameters2);
            Object obsId1 = entity2.get("@iot.id");
            OBSERVATION_IDS.add(obsId1);
            ID_TYPES.put(EntityType.OBSERVATION, IdType.findFor(obsId1));
            urlParameters2 = "{\"Locations\":[{\"@iot.id\":" + Utils.quoteIdForJson(LOCATION_IDS.get(0)) + "}]}";
            this.patchEntity(EntityType.THING, (String)urlParameters2, THING_IDS.get(0));
            urlParameters2 = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00.000Z\",\n  \"resultTime\": \"2015-03-01T01:00:00.000Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(DATASTREAM_IDS.get(0)) + "}\n}";
            entity2 = this.postEntity(EntityType.OBSERVATION, (String)urlParameters2);
            this.checkForObservationResultTime(entity2, "2015-03-01T01:00:00.000Z");
            Object obsId2 = entity2.get("@iot.id");
            OBSERVATION_IDS.add(obsId2);
            Object automatedFOIId = this.checkAutomaticInsertionOfFOI(obsId2, locationEntity, null);
            FOI_IDS.add(automatedFOIId);
            urlParameters2 = "{\n  \"phenomenonTime\": \"2015-05-01T00:00:00.000Z\",\n  \"result\": 105,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(DATASTREAM_IDS.get(0)) + "}\n}";
            entity2 = this.postEntity(EntityType.OBSERVATION, (String)urlParameters2);
            this.checkForObservationResultTime(entity2, null);
            Object obsId3 = entity2.get("@iot.id");
            OBSERVATION_IDS.add(obsId3);
            this.checkAutomaticInsertionOfFOI(OBSERVATION_IDS.get(1), locationEntity, FOI_IDS.get(1));
            Object urlParameters3 = "{\n  \"name\": \"spear river\",\n  \"description\": \"spear river\",\n  \"encodingType\": \"application/vnd.geo+json\",\n  \"location\": { \"type\": \"Point\", \"coordinates\": [114.05, -51.05] }\n}";
            JSONObject entity3 = this.postEntity(EntityType.LOCATION, (String)urlParameters3);
            Object location2Id = entity3.get("@iot.id");
            LOCATION_IDS.add(location2Id);
            JSONObject location2Entity = entity3;
            urlParameters3 = "{\"Locations\":[{\"@iot.id\":" + Utils.quoteIdForJson(LOCATION_IDS.get(1)) + "}]}";
            this.patchEntity(EntityType.THING, (String)urlParameters3, THING_IDS.get(0));
            urlParameters3 = "{\n  \"phenomenonTime\": \"2015-03-01T01:00:00.000Z\",\n  \"resultTime\": \"2015-03-01T02:00:00.000Z\",\n  \"result\": 200,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(DATASTREAM_IDS.get(0)) + "}\n}";
            entity3 = this.postEntity(EntityType.OBSERVATION, (String)urlParameters3);
            Object obsId4 = entity3.get("@iot.id");
            OBSERVATION_IDS.add(obsId4);
            Object automatedFOI2Id = this.checkAutomaticInsertionOfFOI(obsId4, location2Entity, null);
            FOI_IDS.add(automatedFOI2Id);
            String message = "A new FoI should have been created, since the Thing moved.";
            Assertions.assertNotEquals((Object)automatedFOI2Id, (Object)FOI_IDS.get(1), (String)message);
            String urlParameters4 = "{\"name\":\"Test Thing 2\",\"description\":\"This is a second Test Thing From TestNG\",\"Locations\":[{\"@iot.id\": " + Utils.quoteIdForJson(LOCATION_IDS.get(0)) + "}]}";
            JSONObject entity4 = this.postEntity(EntityType.THING, urlParameters4);
            Object thing2Id = entity4.get("@iot.id");
            THING_IDS.add(thing2Id);
            Object urlParameters5 = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream 2.\",\n  \"description\": \"test datastream 2.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thing2Id) + " },\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(OBSPROP_IDS.get(0)) + "},\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(SENSOR_IDS.get(0)) + " }\n}";
            JSONObject entity5 = this.postEntity(EntityType.DATASTREAM, (String)urlParameters5);
            Object datastream2Id = entity5.get("@iot.id");
            DATASTREAM_IDS.add(datastream2Id);
            urlParameters5 = "{\n  \"phenomenonTime\": \"2015-03-01T03:00:00.000Z\",\n  \"resultTime\": \"2015-03-01T04:00:00.000Z\",\n  \"result\": 300,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastream2Id) + "}\n}";
            entity5 = this.postEntity(EntityType.OBSERVATION, (String)urlParameters5);
            Object obsId5 = entity5.get("@iot.id");
            OBSERVATION_IDS.add(obsId5);
            Object automatedFOI3Id = this.checkAutomaticInsertionOfFOI(obsId5, locationEntity, null);
            String message2 = "The generated FoI should be the same as the first generated FoI, since Thing2 has the same Location.";
            Assertions.assertEquals((Object)automatedFOI3Id, (Object)FOI_IDS.get(1), (String)message2);
            urlParameters5 = "{\n  \"time\": \"2015-03-01T00:40:00.000Z\",\n  \"Thing\":{\"@iot.id\": " + Utils.quoteIdForJson(THING_IDS.get(0)) + "},\n  \"Locations\": [{\"@iot.id\": " + Utils.quoteIdForJson(LOCATION_IDS.get(0)) + "}]  \n}";
            entity5 = this.postEntity(EntityType.HISTORICAL_LOCATION, (String)urlParameters5);
            Object histLocId = entity5.get("@iot.id");
            HISTORICAL_LOCATION_IDS.add(histLocId);
            ID_TYPES.put(EntityType.HISTORICAL_LOCATION, IdType.findFor(histLocId));
            if (serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ)) {
                urlParameters5 = "{\"name\":\"Test Thing\",\"description\":\"This is a Test Thing From TestNG\",\"encodingType\":\"none\",\"metadata\":\"none\"}";
                entity5 = this.postEntity(EntityType.ACTUATOR, (String)urlParameters5);
                Object id = entity5.get("@iot.id");
                ACTUATOR_IDS.add(id);
                ID_TYPES.put(EntityType.ACTUATOR, IdType.findFor(id));
                urlParameters5 = "{\"name\":\"Test Thing\",\"description\":\"This is a Test Thing From TestNG\",\"taskingParameters\":{},\"Actuator\":{\"@iot.id\": " + Utils.quoteIdForJson(ACTUATOR_IDS.get(0)) + "},\"Thing\":{\"@iot.id\": " + Utils.quoteIdForJson(THING_IDS.get(0)) + "}}";
                entity5 = this.postEntity(EntityType.TASKING_CAPABILITY, (String)urlParameters5);
                id = entity5.get("@iot.id");
                TASKINGCAPABILITY_IDS.add(id);
                ID_TYPES.put(EntityType.TASKING_CAPABILITY, IdType.findFor(id));
                urlParameters5 = "{\"taskingParameters\":{},\"TaskingCapability\":{\"@iot.id\": " + Utils.quoteIdForJson(TASKINGCAPABILITY_IDS.get(0)) + "}}";
                entity5 = this.postEntity(EntityType.TASK, (String)urlParameters5);
                id = entity5.get("@iot.id");
                TASK_IDS.add(id);
                ID_TYPES.put(EntityType.TASK, IdType.findFor(id));
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    @Test
    void test03CreateEntitiesWithDeepInsert() {
        LOGGER.info("  test03CreateEntitiesWithDeepInsert");
        try {
            Object urlParameters = "{\n  \"name\": \"Office Building\",\n  \"description\": \"Office Building\",\n  \"properties\": {\n    \"reference\": \"Third Floor\"\n  },\n  \"Locations\": [\n    {\n      \"name\": \"West Roof\",\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"application/vnd.geo+json\"\n    }\n  ],\n  \"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"name\": \"Light exposure.\",\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n      \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n      \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n      }\n    }\n  ]\n}";
            JSONObject entity = this.postEntity(EntityType.THING, (String)urlParameters);
            Object thingId = entity.get("@iot.id");
            JSONObject deepInsertedObj = new JSONObject("{\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"name\": \"Light exposure.\",\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\"\n    }\n");
            Object datastreamId = this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.THING, thingId, EntityType.DATASTREAM, deepInsertedObj);
            DATASTREAM_IDS.add(datastreamId);
            deepInsertedObj = new JSONObject("{\n      \"name\": \"West Roof\",\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"application/vnd.geo+json\"\n    }\n");
            LOCATION_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.THING, thingId, EntityType.LOCATION, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n      }\n");
            SENSOR_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.DATASTREAM, datastreamId, EntityType.SENSOR, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n");
            OBSPROP_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.DATASTREAM, datastreamId, EntityType.OBSERVED_PROPERTY, deepInsertedObj));
            THING_IDS.add(thingId);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n   \"Sensor\": {        \n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
            entity = this.postEntity(EntityType.DATASTREAM, (String)urlParameters);
            datastreamId = entity.get("@iot.id");
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Acme Fluxomatic 1000\",\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"application/pdf\",\n        \"metadata\": \"Light flux sensor\"\n      }\n");
            SENSOR_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.DATASTREAM, datastreamId, EntityType.SENSOR, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n");
            OBSPROP_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.DATASTREAM, datastreamId, EntityType.OBSERVED_PROPERTY, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n          \"phenomenonTime\": \"2015-03-01T00:10:00.000Z\",\n          \"result\": 10\n        }\n");
            OBSERVATION_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.DATASTREAM, datastreamId, EntityType.OBSERVATION, deepInsertedObj));
            DATASTREAM_IDS.add(datastreamId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"FeatureOfInterest\": {\n  \t\"name\": \"A weather station.\",\n  \t\"description\": \"A weather station.\",\n  \t\"encodingType\": \"application/vnd.geo+json\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  },\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
            entity = this.postEntity(EntityType.OBSERVATION, (String)urlParameters);
            Object obsId1 = entity.get("@iot.id");
            deepInsertedObj = new JSONObject("{\n  \"name\": \"A weather station.\",\n  \"description\": \"A weather station.\",\n  \"encodingType\": \"application/vnd.geo+json\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  }\n");
            FOI_IDS.add(this.checkRelatedEntity(serverSettings.getExtensions(), EntityType.OBSERVATION, obsId1, EntityType.FEATURE_OF_INTEREST, deepInsertedObj));
            OBSERVATION_IDS.add(obsId1);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    @Test
    void test04CreateInvalidEntities() {
        LOGGER.info("  test04CreateInvalidEntities");
        try {
            Object urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(THING_IDS.get(0)) + " },\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(OBSPROP_IDS.get(0)) + "}\n}";
            this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(THING_IDS.get(0)) + " },\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(SENSOR_IDS.get(0)) + " }\n}";
            this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(OBSPROP_IDS.get(0)) + "},\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(SENSOR_IDS.get(0)) + " }\n}";
            this.postInvalidEntity(EntityType.DATASTREAM, (String)urlParameters);
            urlParameters = "{\"name\":\"This is a Test Thing From TestNG\",\"description\":\"This is a Test Thing From TestNG\"}";
            Object thingId = this.postEntity(EntityType.THING, (String)urlParameters).get("@iot.id");
            THING_IDS.add(thingId);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"name\": \"test datastream.\",\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + Utils.quoteIdForJson(thingId) + " },\n  \"ObservedProperty\":{ \"@iot.id\":" + Utils.quoteIdForJson(OBSPROP_IDS.get(0)) + "},\n  \"Sensor\": { \"@iot.id\": " + Utils.quoteIdForJson(SENSOR_IDS.get(0)) + " }\n}";
            Object datastreamId = this.postEntity(EntityType.DATASTREAM, (String)urlParameters).get("@iot.id");
            DATASTREAM_IDS.add(datastreamId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"result\": 8,\n  \"FeatureOfInterest\": {\"@iot.id\": " + Utils.quoteIdForJson(FOI_IDS.get(0)) + "}  \n}";
            this.postInvalidEntity(EntityType.OBSERVATION, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00.000Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + Utils.quoteIdForJson(datastreamId) + "}\n}";
            this.postInvalidEntity(EntityType.OBSERVATION, (String)urlParameters);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    @Test
    void test05PatchEntities() {
        LOGGER.info("  test05PatchEntities");
        try {
            Object thingId = THING_IDS.get(0);
            JSONObject entity = this.getEntity(EntityType.THING, thingId);
            String urlParameters = "{\"description\":\"This is a PATCHED Test Thing From TestNG\"}";
            HashMap<String, String> diffs = new HashMap<String, String>();
            diffs.put("description", "This is a PATCHED Test Thing From TestNG");
            JSONObject updatedEntity = this.patchEntity(EntityType.THING, urlParameters, thingId);
            this.checkPatch(EntityType.THING, entity, updatedEntity, diffs);
            Object locationId = LOCATION_IDS.get(0);
            entity = this.getEntity(EntityType.LOCATION, locationId);
            urlParameters = "{\"location\": { \"type\": \"Point\", \"coordinates\": [114.05, -50] }}";
            diffs = new HashMap();
            diffs.put("location", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [114.05, -50] }}"));
            updatedEntity = this.patchEntity(EntityType.LOCATION, urlParameters, locationId);
            this.checkPatch(EntityType.LOCATION, entity, updatedEntity, diffs);
            Object histLocId = HISTORICAL_LOCATION_IDS.get(0);
            entity = this.getEntity(EntityType.HISTORICAL_LOCATION, histLocId);
            urlParameters = "{\"time\": \"2015-07-01T00:00:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("time", "2015-07-01T00:00:00.000Z");
            updatedEntity = this.patchEntity(EntityType.HISTORICAL_LOCATION, urlParameters, histLocId);
            this.checkPatch(EntityType.HISTORICAL_LOCATION, entity, updatedEntity, diffs);
            Object sensorId = SENSOR_IDS.get(0);
            entity = this.getEntity(EntityType.SENSOR, sensorId);
            urlParameters = "{\"metadata\": \"PATCHED\"}";
            diffs = new HashMap();
            diffs.put("metadata", "PATCHED");
            updatedEntity = this.patchEntity(EntityType.SENSOR, urlParameters, sensorId);
            this.checkPatch(EntityType.SENSOR, entity, updatedEntity, diffs);
            Object obsPropId = OBSPROP_IDS.get(0);
            entity = this.getEntity(EntityType.OBSERVED_PROPERTY, obsPropId);
            urlParameters = "{\"description\":\"PATCHED\"}";
            diffs = new HashMap();
            diffs.put("description", "PATCHED");
            updatedEntity = this.patchEntity(EntityType.OBSERVED_PROPERTY, urlParameters, obsPropId);
            this.checkPatch(EntityType.OBSERVED_PROPERTY, entity, updatedEntity, diffs);
            Object foiId = FOI_IDS.get(0);
            entity = this.getEntity(EntityType.FEATURE_OF_INTEREST, foiId);
            urlParameters = "{\"feature\":{ \"type\": \"Point\", \"coordinates\": [114.05, -51.05] }}";
            diffs = new HashMap();
            diffs.put("feature", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [114.05, -51.05] }"));
            updatedEntity = this.patchEntity(EntityType.FEATURE_OF_INTEREST, urlParameters, foiId);
            this.checkPatch(EntityType.FEATURE_OF_INTEREST, entity, updatedEntity, diffs);
            Object datastreamId = DATASTREAM_IDS.get(0);
            entity = this.getEntity(EntityType.DATASTREAM, datastreamId);
            urlParameters = "{\"description\": \"Patched Description\"}";
            diffs = new HashMap();
            diffs.put("description", "Patched Description");
            updatedEntity = this.patchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPatch(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            entity = updatedEntity;
            urlParameters = "{ \"unitOfMeasurement\": {\n    \"name\": \"Entropy2\",\n    \"symbol\": \"S2\",\n    \"definition\": \"http://qudt.org/vocab/unit#Entropy2\"\n  } }";
            diffs = new HashMap();
            diffs.put("unitOfMeasurement", (String)new JSONObject("{\"name\": \"Entropy2\",\"symbol\": \"S2\",\"definition\": \"http://qudt.org/vocab/unit#Entropy2\"}"));
            updatedEntity = this.patchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPatch(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            Object obsId1 = OBSERVATION_IDS.get(0);
            entity = this.getEntity(EntityType.OBSERVATION, obsId1);
            urlParameters = "{\"phenomenonTime\": \"2015-07-01T00:40:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("phenomenonTime", "2015-07-01T00:40:00.000Z");
            updatedEntity = this.patchEntity(EntityType.OBSERVATION, urlParameters, obsId1);
            this.checkPatch(EntityType.OBSERVATION, entity, updatedEntity, diffs);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    @Test
    void test06PutEntities() {
        LOGGER.info("  test06PutEntities");
        try {
            Object thingId = THING_IDS.get(0);
            JSONObject entity = this.getEntity(EntityType.THING, thingId);
            String urlParameters = "{\"name\":\"This is a Updated Test Thing From TestNG\",\"description\":\"This is a Updated Test Thing From TestNG\"}";
            HashMap<String, String> diffs = new HashMap<String, String>();
            diffs.put("name", "This is a Updated Test Thing From TestNG");
            diffs.put("description", "This is a Updated Test Thing From TestNG");
            JSONObject updatedEntity = this.updateEntity(EntityType.THING, urlParameters, thingId);
            this.checkPut(EntityType.THING, entity, updatedEntity, diffs);
            Object locationId = LOCATION_IDS.get(0);
            entity = this.getEntity(EntityType.LOCATION, locationId);
            urlParameters = "{\"encodingType\":\"application/vnd.geo+json\",\"name\":\"UPDATED NAME\",\"description\":\"UPDATED DESCRIPTION\",\"location\": { \"type\": \"Point\", \"coordinates\": [-114.05, 50] }}";
            diffs = new HashMap();
            diffs.put("name", "UPDATED NAME");
            diffs.put("description", "UPDATED DESCRIPTION");
            diffs.put("location", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 50] }}"));
            updatedEntity = this.updateEntity(EntityType.LOCATION, urlParameters, locationId);
            this.checkPut(EntityType.LOCATION, entity, updatedEntity, diffs);
            Object histLocId = HISTORICAL_LOCATION_IDS.get(0);
            entity = this.getEntity(EntityType.HISTORICAL_LOCATION, histLocId);
            urlParameters = "{\"time\": \"2015-08-01T00:00:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("time", "2015-08-01T00:00:00.000Z");
            updatedEntity = this.updateEntity(EntityType.HISTORICAL_LOCATION, urlParameters, histLocId);
            this.checkPut(EntityType.HISTORICAL_LOCATION, entity, updatedEntity, diffs);
            Object sensorId = SENSOR_IDS.get(0);
            entity = this.getEntity(EntityType.SENSOR, sensorId);
            urlParameters = "{\"name\": \"UPDATED\", \"description\": \"UPDATED\", \"encodingType\":\"application/pdf\", \"metadata\": \"UPDATED\"}";
            diffs = new HashMap();
            diffs.put("name", "UPDATED");
            diffs.put("description", "UPDATED");
            diffs.put("metadata", "UPDATED");
            updatedEntity = this.updateEntity(EntityType.SENSOR, urlParameters, sensorId);
            this.checkPut(EntityType.SENSOR, entity, updatedEntity, diffs);
            Object obsPropId = OBSPROP_IDS.get(0);
            urlParameters = "{\"name\":\"QWERTY\", \"definition\": \"ZXCVB\", \"name\":\"POIUYTREW\",\"description\":\"POIUYTREW\"}";
            diffs = new HashMap();
            diffs.put("name", "QWERTY");
            diffs.put("definition", "ZXCVB");
            diffs.put("description", "POIUYTREW");
            diffs.put("name", "POIUYTREW");
            updatedEntity = this.updateEntity(EntityType.OBSERVED_PROPERTY, urlParameters, obsPropId);
            this.checkPut(EntityType.OBSERVED_PROPERTY, entity, updatedEntity, diffs);
            Object foiId = FOI_IDS.get(0);
            entity = this.getEntity(EntityType.FEATURE_OF_INTEREST, foiId);
            urlParameters = "{\"encodingType\":\"application/vnd.geo+json\",\"feature\":{ \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }, \"description\":\"POIUYTREW\",\"name\":\"POIUYTREW\"}";
            diffs = new HashMap();
            diffs.put("feature", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }"));
            diffs.put("name", "POIUYTREW");
            diffs.put("description", "POIUYTREW");
            updatedEntity = this.updateEntity(EntityType.FEATURE_OF_INTEREST, urlParameters, foiId);
            this.checkPut(EntityType.FEATURE_OF_INTEREST, entity, updatedEntity, diffs);
            Object datastreamId = DATASTREAM_IDS.get(0);
            entity = this.getEntity(EntityType.DATASTREAM, datastreamId);
            urlParameters = "{\n  \"name\": \"Data coming from sensor on ISS.\",\n  \"description\": \"Data coming from sensor on ISS.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation\",\n  \"unitOfMeasurement\": {\n    \"name\": \"Entropy\",\n    \"symbol\": \"S\",\n    \"definition\": \"http://qudt.org/vocab/unit#Entropy\"\n  }\n}\n";
            diffs = new HashMap();
            diffs.put("name", "Data coming from sensor on ISS.");
            diffs.put("description", "Data coming from sensor on ISS.");
            diffs.put("observationType", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation");
            diffs.put("unitOfMeasurement", (String)new JSONObject("{\"name\": \"Entropy\",\"symbol\": \"S\",\"definition\": \"http://qudt.org/vocab/unit#Entropy\"}"));
            updatedEntity = this.updateEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPut(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            Object obsId1 = OBSERVATION_IDS.get(0);
            entity = this.getEntity(EntityType.OBSERVATION, obsId1);
            urlParameters = "{\"result\": \"99\", \"phenomenonTime\": \"2015-08-01T00:40:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("result", "99");
            diffs.put("phenomenonTime", "2015-08-01T00:40:00.000Z");
            updatedEntity = this.updateEntity(EntityType.OBSERVATION, urlParameters, obsId1);
            this.checkPut(EntityType.OBSERVATION, entity, updatedEntity, diffs);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    @Test
    void test07InvalidPatchEntities() {
        LOGGER.info("  test07InvalidPatchEntities");
        Object thingId = THING_IDS.get(0);
        Object urlParameters = "{\"Locations\": [\n    {\n      \"name\": \"West Roof\",\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"application/vnd.geo+json\"\n    }\n  ]}";
        this.invalidPatchEntity(EntityType.THING, (String)urlParameters, thingId);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      }}]}";
        this.invalidPatchEntity(EntityType.THING, (String)urlParameters, thingId);
        Object sensorId = SENSOR_IDS.get(0);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"}\n        ,\"Thing\":{\"@iot.id\":" + Utils.quoteIdForJson(thingId) + "}      }]}";
        this.invalidPatchEntity(EntityType.SENSOR, (String)urlParameters, sensorId);
        Object obsPropId = OBSPROP_IDS.get(0);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"}\n        ,\"Thing\":{\"@iot.id\":" + Utils.quoteIdForJson(thingId) + "}      }]}";
        this.invalidPatchEntity(EntityType.OBSERVED_PROPERTY, (String)urlParameters, obsPropId);
        Object datastreamId = DATASTREAM_IDS.get(0);
        urlParameters = "{\"ObservedProperty\": {\n  \t\"name\": \"Count\",\n\t\"definition\": \"http://qudt.org/vocab/unit#Dimensionless\",\n\t\"name\": \"Count is a dimensionless property.\",\n\t\"description\": \"Count is a dimensionless property.\"\n  } }";
        this.invalidPatchEntity(EntityType.DATASTREAM, (String)urlParameters, datastreamId);
        urlParameters = "{\"Sensor\": {\n  \t\"name\": \"Acme Traffic 2000\",  \n  \t\"description\": \"Acme Traffic 2000\",  \n  \t\"encodingType\": \"application/pdf\",\n  \t\"metadata\": \"Traffic counting device\"\n  }}";
        this.invalidPatchEntity(EntityType.DATASTREAM, (String)urlParameters, datastreamId);
        urlParameters = "{\"Thing\": {  \"name\": \"test\",  \"description\": \"test\" }}";
        this.invalidPatchEntity(EntityType.DATASTREAM, (String)urlParameters, datastreamId);
        urlParameters = "{\"Observations\": [\n    {\n      \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n      \"result\": 92122,\n      \"resultQuality\": \"High\"\n    }\n  ]}";
        this.invalidPatchEntity(EntityType.DATASTREAM, (String)urlParameters, datastreamId);
    }

    @Test
    void test08DeleteEntities() {
        int i;
        LOGGER.info("  test08DeleteEntities");
        for (i = 0; i < OBSERVATION_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.OBSERVATION, OBSERVATION_IDS.get(i));
        }
        for (i = 0; i < FOI_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.FEATURE_OF_INTEREST, FOI_IDS.get(i));
        }
        for (i = 0; i < DATASTREAM_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.DATASTREAM, DATASTREAM_IDS.get(i));
        }
        for (i = 0; i < OBSPROP_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.OBSERVED_PROPERTY, OBSPROP_IDS.get(i));
        }
        for (i = 0; i < SENSOR_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.SENSOR, SENSOR_IDS.get(i));
        }
        for (i = 0; i < HISTORICAL_LOCATION_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.HISTORICAL_LOCATION, HISTORICAL_LOCATION_IDS.get(i));
        }
        for (i = 0; i < LOCATION_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.LOCATION, LOCATION_IDS.get(i));
        }
        for (i = 0; i < THING_IDS.size(); ++i) {
            Capability2Tests.deleteEntity(EntityType.THING, THING_IDS.get(i));
        }
        this.checkDeleteIntegrityConstraint();
    }

    @Test
    void test09DeleteNoneexistentEntities() {
        LOGGER.info("  test09DeleteNoneexistentEntities");
        for (EntityType type : serverSettings.getEnabledEntityTypes()) {
            this.deleteNonExsistentEntity(type);
        }
    }

    private void checkDeleteIntegrityConstraint() {
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.THING, THING_IDS.get(0));
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.DATASTREAM, DATASTREAM_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.LOCATION, LOCATION_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.HISTORICAL_LOCATION, HISTORICAL_LOCATION_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        entityTypes.add(EntityType.LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.SENSOR, SENSOR_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.OBSERVED_PROPERTY, OBSPROP_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.FEATURE_OF_INTEREST, FOI_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.DATASTREAM);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        Capability2Tests.deleteEntity(EntityType.OBSERVATION, OBSERVATION_IDS.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.LOCATION);
        this.checkExisting(entityTypes);
    }

    private JSONObject getEntity(EntityType entityType, Object id) {
        if (id == null) {
            return null;
        }
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        HTTPMethods.HttpResponse response = null;
        try {
            response = HTTPMethods.doGet(urlString);
            return new JSONObject(response.response);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            LOGGER.error("Failed input: {}", (Object)response);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return null;
        }
    }

    private JSONObject postEntity(EntityType entityType, String urlParameters) {
        Object urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
        try {
            HTTPMethods.HttpResponse httpResponse = HTTPMethods.doPost((String)urlString, urlParameters);
            Object message = "Error during creation of entity " + entityType.name();
            Assertions.assertEquals((int)201, (int)httpResponse.code, (String)message);
            String id = httpResponse.response.substring(httpResponse.response.indexOf("(") + 1, httpResponse.response.indexOf(")"));
            urlString = (String)urlString + "(" + id + ")";
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet((String)urlString);
            int responseCode = responseMap.code;
            message = "The POSTed entity is not created.";
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return null;
        }
    }

    private void postInvalidEntity(EntityType entityType, String urlParameters) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, urlParameters);
        int responseCode = responseMap.code;
        String message = "The  " + entityType.name() + " should not be created due to integrity constraints. Expected response code 400|409, got: " + responseCode;
        Assertions.assertTrue((responseCode == 400 || responseCode == 409 ? 1 : 0) != 0, (String)message);
    }

    private static void deleteEntity(EntityType entityType, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = responseMap.code;
        String message = "DELETE does not work properly for " + entityType + " with id " + id + ". Returned with response code " + responseCode + ".";
        Assertions.assertEquals((int)200, (int)responseCode, (String)message);
        responseMap = HTTPMethods.doGet(urlString);
        responseCode = responseMap.code;
        message = "Deleted entity was not actually deleted : " + entityType + "(" + id + ").";
        Assertions.assertEquals((int)404, (int)responseCode, (String)message);
    }

    private void deleteNonExsistentEntity(EntityType entityType) {
        IdType idType = ID_TYPES.get((Object)entityType);
        if (idType == null) {
            LOGGER.error("Id type not known for entity type {}.", (Object)entityType);
            return;
        }
        Object id = idType.generateUnlikely();
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = responseMap.code;
        String message = "DELETE does not work properly for nonexistent " + entityType + " with id " + id + ". Returned with response code " + responseCode + ".";
        Assertions.assertEquals((int)404, (int)responseCode, (String)message);
    }

    private JSONObject updateEntity(EntityType entityType, String urlParameters, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doPut(urlString, urlParameters);
            int responseCode = responseMap.code;
            String message = "Error during updating(PUT) of entity " + entityType.name();
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return null;
        }
    }

    private JSONObject patchEntity(EntityType entityType, String urlParameters, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doPatch(urlString, urlParameters);
            int responseCode = responseMap.code;
            String message = "Error during updating(PATCH) of entity " + entityType.name();
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.response);
            return result;
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return null;
        }
    }

    private void invalidPatchEntity(EntityType entityType, String urlParameters, Object id) {
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPatch(urlString, urlParameters);
        int responseCode = responseMap.code;
        String message = "Error: Patching related entities inline must be illegal for entity " + entityType.name();
        Assertions.assertEquals((int)400, (int)responseCode, (String)message);
    }

    private void checkPatch(EntityType entityType, JSONObject oldEntity, JSONObject newEntity, Map diffs) {
        try {
            for (EntityType.EntityProperty property : entityType.getProperties()) {
                String message;
                String newValue;
                if (diffs.containsKey(property.name)) {
                    String diffValue = String.valueOf(diffs.get(property.name));
                    newValue = String.valueOf(newEntity.get(property.name));
                    message = "PATCH was not applied correctly for " + entityType + "'s " + property.name + ". Should have changed.";
                    this.assertParameterEquals(property.name, diffValue, newValue, message);
                    continue;
                }
                if (newEntity.has(property.name) && oldEntity.has(property.name)) {
                    String oldValue = String.valueOf(oldEntity.get(property.name));
                    newValue = String.valueOf(newEntity.get(property.name));
                    message = "PATCH was not applied correctly for " + entityType + "'s " + property.name + ". Value " + oldValue + " should not have changed to " + newValue;
                    this.assertParameterEquals(property.name, oldValue, newValue, message);
                    continue;
                }
                String message2 = "PATCH was not applied correctly for " + entityType + "'s " + property.name + ".";
                Assertions.assertEquals((Object)oldEntity.has(property.name), (Object)newEntity.has(property.name), (String)message2);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    private void checkPut(EntityType entityType, JSONObject oldEntity, JSONObject newEntity, Map diffs) {
        try {
            for (EntityType.EntityProperty property : entityType.getProperties()) {
                String message;
                if (diffs.containsKey(property.name)) {
                    message = "PUT was not applied correctly for " + entityType + ".";
                    String expected = diffs.get(property.name).toString();
                    String value = newEntity.get(property.name).toString();
                    this.assertParameterEquals(property.name, expected, value, message);
                    continue;
                }
                message = "PUT was not applied correctly for " + entityType + ".";
                if (oldEntity.has(property.name)) {
                    Assertions.assertTrue((boolean)this.equalsFixJson(oldEntity.get(property.name), newEntity.get(property.name)), (String)message);
                    continue;
                }
                Assertions.assertFalse((boolean)newEntity.has(property.name), (String)message);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    private boolean equalsFixJson(Object expected, Object given) {
        if (expected instanceof JSONObject && given instanceof JSONObject) {
            JSONObject jsonGiven = (JSONObject)given;
            JSONObject jsonExpected = (JSONObject)expected;
            return jsonGiven.toString().equals(jsonExpected.toString());
        }
        return expected.equals(given);
    }

    private Object checkAutomaticInsertionOfFOI(Object obsId, JSONObject locationObj, Object expectedFOIId) {
        String urlString = serverSettings.getServiceUrl(version) + "/Observations(" + Utils.quoteIdForUrl(obsId) + ")/FeatureOfInterest";
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            int responseCode = responseMap.code;
            Object message = "ERROR: FeatureOfInterest was not automatically created.";
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            JSONObject result = new JSONObject(responseMap.response);
            Object id = result.get("@iot.id");
            if (expectedFOIId != null) {
                message = "ERROR: the Observation should have linked to FeatureOfInterest with ID: " + expectedFOIId + ", but it is linked for FeatureOfInterest with Id: " + id + ".";
                Assertions.assertEquals((Object)expectedFOIId, (Object)id, (String)message);
            }
            message = "ERROR: Automatic created FeatureOfInterest does not match last Location of that Thing.";
            Assertions.assertEquals((Object)locationObj.getJSONObject("location").toString(), (Object)result.getJSONObject("feature").toString(), (String)message);
            return id;
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return -1;
        }
    }

    private Object checkRelatedEntity(Set<Extension> extensions, EntityType parentEntityType, Object parentId, EntityType relationEntityType, JSONObject relationObj) {
        boolean isCollection = true;
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), parentEntityType, parentId, relationEntityType, null);
        if (parentEntityType.getRelations(extensions).contains(relationEntityType.singular)) {
            isCollection = false;
        }
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            int responseCode = responseMap.code;
            String message = "ERROR: Deep inserted " + relationEntityType + " was not created or linked to " + parentEntityType;
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            JSONObject result = new JSONObject(responseMap.response);
            if (isCollection) {
                result = result.getJSONArray("value").getJSONObject(0);
            }
            Iterator iterator = relationObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                message = "ERROR: Deep inserted " + relationEntityType + " is not created correctly.";
                String expected = Objects.toString(relationObj.get(key));
                String value = Objects.toString(result.get(key));
                this.assertParameterEquals(key, expected, value, message);
            }
            return result.get("@iot.id");
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            return -1;
        }
    }

    private void assertParameterEquals(String key, String expected, String value, String message) {
        if (key.toLowerCase().contains("time") && !"null".equals(expected) && !"null".equals(value)) {
            if (expected.contains("/")) {
                String[] expParts = expected.split("/");
                String[] valParts = value.split("/");
                Assertions.assertEquals((Object)ZonedDateTime.parse(expParts[0]), (Object)ZonedDateTime.parse(valParts[0]), (String)message);
                Assertions.assertEquals((Object)ZonedDateTime.parse(expParts[1]), (Object)ZonedDateTime.parse(valParts[1]), (String)message);
            } else {
                Assertions.assertEquals((Object)ZonedDateTime.parse(expected), (Object)ZonedDateTime.parse(value), (String)message);
            }
        } else {
            Assertions.assertEquals((Object)expected, (Object)value, (String)message);
        }
    }

    private void checkForObservationResultTime(JSONObject observation, String resultTimeValue) {
        try {
            if (resultTimeValue == null) {
                String message = "The resultTime of the Observation " + observation.get("@iot.id") + " should have been null but it is now \"" + observation.get("resultTime").toString() + "\".";
                Assertions.assertEquals((Object)"null", (Object)observation.get("resultTime").toString(), (String)message);
            } else {
                String message = "The resultTime of the Observation " + observation.get("@iot.id") + " should have been \"" + resultTimeValue + "\" but it is now \"" + observation.get("resultTime").toString() + "\".";
                Assertions.assertEquals((Object)ZonedDateTime.parse(resultTimeValue), (Object)ZonedDateTime.parse(observation.get("resultTime").toString()), (String)message);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    private void checkNotExisting(List<EntityType> entityTypes) {
        for (EntityType entityType : entityTypes) {
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            try {
                JSONObject result = new JSONObject(responseMap.response);
                JSONArray array = result.getJSONArray("value");
                String message = entityType + " is found although it shouldn't.";
                Assertions.assertEquals((int)0, (int)array.length(), (String)message);
            }
            catch (JSONException e) {
                LOGGER.error("Exception: ", (Throwable)e);
                Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            }
        }
    }

    private void checkExisting(List<EntityType> entityTypes) {
        for (EntityType entityType : entityTypes) {
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            try {
                JSONObject result = new JSONObject(responseMap.response);
                JSONArray array = result.getJSONArray("value");
                String message = entityType + " is created although it shouldn't.";
                Assertions.assertTrue((array.length() > 0 ? 1 : 0) != 0, (String)message);
            }
            catch (JSONException e) {
                LOGGER.error("Exception: ", (Throwable)e);
                Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            }
        }
    }

    public static void deleteEverything() {
        Capability2Tests.deleteEntityType(EntityType.THING);
        Capability2Tests.deleteEntityType(EntityType.SENSOR);
        Capability2Tests.deleteEntityType(EntityType.OBSERVED_PROPERTY);
        Capability2Tests.deleteEntityType(EntityType.FEATURE_OF_INTEREST);
        Capability2Tests.deleteEntityType(EntityType.OBSERVATION);
        Capability2Tests.deleteEntityType(EntityType.DATASTREAM);
        Capability2Tests.deleteEntityType(EntityType.HISTORICAL_LOCATION);
        Capability2Tests.deleteEntityType(EntityType.LOCATION);
        if (serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ)) {
            Capability2Tests.deleteEntityType(EntityType.ACTUATOR);
            Capability2Tests.deleteEntityType(EntityType.TASK);
            Capability2Tests.deleteEntityType(EntityType.TASKING_CAPABILITY);
        }
        ACTUATOR_IDS.clear();
        TASK_IDS.clear();
        TASKINGCAPABILITY_IDS.clear();
        THING_IDS.clear();
        LOCATION_IDS.clear();
        HISTORICAL_LOCATION_IDS.clear();
        DATASTREAM_IDS.clear();
        SENSOR_IDS.clear();
        OBSERVATION_IDS.clear();
        OBSPROP_IDS.clear();
        FOI_IDS.clear();
    }

    private static void deleteEntityType(EntityType entityType) {
        JSONArray array = null;
        do {
            try {
                String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
                HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
                int responseCode = responseMap.code;
                JSONObject result = new JSONObject(responseMap.response);
                array = result.getJSONArray("value");
                for (int i = 0; i < array.length(); ++i) {
                    Object id = array.getJSONObject(i).get("@iot.id");
                    Capability2Tests.deleteEntity(entityType, id);
                }
            }
            catch (JSONException e) {
                LOGGER.error("Exception: ", (Throwable)e);
                Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
            }
        } while (array.length() > 0);
    }

    private void createEntitiesForDelete() {
        try {
            Capability2Tests.deleteEverything();
            String urlParameters = "{\n    \"name\": \"thing 1\",\n    \"description\": \"thing 1\",\n    \"properties\": {\n        \"reference\": \"first\"\n    },\n    \"Locations\": [\n        {\n            \"name\": \"location 1\",\n            \"description\": \"location 1\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -117.05,\n                    51.05\n                ]\n            },\n            \"encodingType\": \"application/vnd.geo+json\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n            },\n            \"name\": \"datastream 1\",\n            \"description\": \"datastream 1\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n                \"description\": \"observedProperty 1\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 1\",\n                \"description\": \"sensor 1\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Light flux sensor\"\n            }\n        }\n    ]\n}";
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, null, null, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, urlParameters);
            String response = responseMap.response;
            THING_IDS.add(Utils.idObjectFromPostResult(response));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, THING_IDS.get(0), EntityType.LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            JSONArray array = new JSONObject(response).getJSONArray("value");
            LOCATION_IDS.add(array.getJSONObject(0).get("@iot.id"));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, THING_IDS.get(0), EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            DATASTREAM_IDS.add(array.getJSONObject(0).get("@iot.id"));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, DATASTREAM_IDS.get(0), EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            SENSOR_IDS.add(new JSONObject(response).get("@iot.id"));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, DATASTREAM_IDS.get(0), EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            OBSPROP_IDS.add(new JSONObject(response).get("@iot.id"));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, THING_IDS.get(0), EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            HISTORICAL_LOCATION_IDS.add(array.getJSONObject(0).get("@iot.id"));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, DATASTREAM_IDS.get(0), EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 1 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.response;
            OBSERVATION_IDS.add(Utils.idObjectFromPostResult(response));
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, OBSERVATION_IDS.get(0), EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            FOI_IDS.add(new JSONObject(response).get("@iot.id"));
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing: " + e.getMessage()));
        }
    }

    public static class Implementation11
    extends Capability2Tests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends Capability2Tests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

