/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c02cud;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.builder.HistoricalLocationBuilder;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class AdditionalTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public AdditionalTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)AdditionalTests.version.urlPart);
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        AdditionalTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        AdditionalTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    @Test
    void test01MultipleLocations() throws ServiceFailureException {
        LOGGER.info("  test01MultipleLocations");
        EntityUtils.deleteAll(version, serverSettings, service);
        Thing thing = new Thing("Thing 1", "The first thing.");
        Location location1 = new Location("Location 1.0, Address", "The address of Thing 1.", "text/plain", (Object)"");
        thing.getLocations().add((Entity)location1);
        Location location2 = new Location("Location 1.0", "Location of Thing 1.", "application/geo+json", (Object)new Point(8.0, 51.0));
        thing.getLocations().add((Entity)location2);
        Location location3 = new Location("Location 1.0, Directions", "How to find Thing 1 in human language.", "text/plain", (Object)"");
        thing.getLocations().add((Entity)location3);
        service.create((Entity)thing);
        THINGS.add(thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        ObservedProperty obsProp = new ObservedProperty("Temperature", "http://ucom.org/temperature", "The temperature of the thing.");
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        datastream.setThing(thing);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        ObservationDao doa = service.observations();
        Observation observation = new Observation((Object)1.0, DATASTREAMS.get(0));
        doa.create(observation);
        OBSERVATIONS.add(observation);
        Observation found = (Observation)doa.find(observation.getId());
        FeatureOfInterest featureOfInterest = found.getFeatureOfInterest();
        Assertions.assertNotNull((Object)featureOfInterest, (String)"A FeatureOfInterest should have been generated, but got NULL.");
    }

    @Test
    void test02GeneratePhenomenonTime() throws ServiceFailureException {
        LOGGER.info("  test02GeneratePhenomenonTime");
        ObservationDao doa = service.observations();
        Observation observation = new Observation((Object)1.0, DATASTREAMS.get(0));
        doa.create(observation);
        OBSERVATIONS.add(observation);
        Observation found = (Observation)doa.find(observation.getId());
        Assertions.assertNotNull((Object)found.getPhenomenonTime(), (String)"phenomenonTime should be auto generated.");
    }

    @Test
    void test03HistoricalLocationThing() throws ServiceFailureException {
        LOGGER.info("  test03HistoricalLocationThing");
        EntityUtils.deleteAll(version, serverSettings, service);
        Thing thing = new Thing("Thing 1", "The first thing.");
        service.create((Entity)thing);
        Location location1 = new Location("Location 1.0", "Location Number 1.", "application/vnd.geo+json", (Object)new Point(8.0, 50.0));
        Location location2 = new Location("Location 2.0", "Location Number 2.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        Location location3 = new Location("Location 3.0", "Location Number 3.", "application/vnd.geo+json", (Object)new Point(8.0, 52.0));
        service.create((Entity)location1);
        service.create((Entity)location2);
        service.create((Entity)location3);
        thing.getLocations().add((Entity)location1.withOnlyId());
        service.update((Entity)thing);
        List histLocations = thing.historicalLocations().query().list().toList();
        Assertions.assertEquals((int)1, (int)histLocations.size(), (String)"Incorrect number of HistoricalLocations for Thing.");
        HistoricalLocation histLocation = (HistoricalLocation)histLocations.get(0);
        histLocation.setTime(ZonedDateTime.parse("2016-01-01T06:00:00.000Z"));
        service.update((Entity)histLocation);
        HistoricalLocation histLocation2 = (HistoricalLocation)((HistoricalLocationBuilder)((HistoricalLocationBuilder)((HistoricalLocationBuilder)HistoricalLocationBuilder.builder().location(location2)).time(ZonedDateTime.parse("2016-01-01T07:00:00.000Z"))).thing(thing.withOnlyId())).build();
        service.create((Entity)histLocation2);
        List thingLocations = thing.locations().query().list().toList();
        Assertions.assertEquals((int)1, (int)thingLocations.size(), (String)"Incorrect number of Locations for Thing.");
        Assertions.assertEquals((Object)location2, thingLocations.get(0));
        HistoricalLocation histLocation3 = (HistoricalLocation)((HistoricalLocationBuilder)((HistoricalLocationBuilder)((HistoricalLocationBuilder)HistoricalLocationBuilder.builder().location(location3)).time(ZonedDateTime.parse("2016-01-01T05:00:00.000Z"))).thing(thing.withOnlyId())).build();
        service.create((Entity)histLocation3);
        thingLocations = thing.locations().query().list().toList();
        Assertions.assertEquals((int)1, (int)thingLocations.size(), (String)"Incorrect number of Locations for Thing.");
        Assertions.assertEquals((Object)location2, thingLocations.get(0));
    }

    @Test
    void test04PostInvalidPath() throws ServiceFailureException {
        LOGGER.info("  test04PostInvalidPath");
        EntityUtils.deleteAll(version, serverSettings, service);
        Location location1 = new Location("LocationThing1", "Location of Thing 1", "application/geo+json", (Object)new Point(8.0, 50.0));
        service.create((Entity)location1);
        Thing thing1 = new Thing("Thing 1", "The first thing.");
        thing1.getLocations().add((Entity)location1.withOnlyId());
        service.create((Entity)thing1);
        Thing thing2 = new Thing("Thing 2", "The second thing.");
        thing2.getLocations().add((Entity)location1.withOnlyId());
        service.create((Entity)thing2);
        Sensor sensor1 = new Sensor("Test Thermometre", "Test Sensor", "None", (Object)"-");
        service.create((Entity)sensor1);
        ObservedProperty obsProp1 = new ObservedProperty("Temperature", "http://example.org", "-");
        service.create((Entity)obsProp1);
        Datastream datastream1 = new Datastream("Ds 1, Thing 1", "The datastream of Thing 1", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement", new UnitOfMeasurement("Degrees Celcius", "\u00b0C", "http://qudt.org/vocab/unit#DegreeCelsius"));
        datastream1.setThing(thing1);
        datastream1.setSensor(sensor1);
        datastream1.setObservedProperty(obsProp1);
        service.create((Entity)datastream1);
        Observation obs1 = new Observation((Object)1.0, datastream1);
        service.create((Entity)obs1);
        this.testGet(thing1, datastream1, thing2);
        String urlObsGood = serverSettings.getServiceUrl(version) + "/Things(" + thing1.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations(" + obs1.getId().getUrl() + ")";
        String urlObsBad = serverSettings.getServiceUrl(version) + "/Things(" + thing2.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations(" + obs1.getId().getUrl() + ")";
        this.testPut(urlObsGood, urlObsBad);
        this.testPatch(urlObsGood, urlObsBad);
        this.testDelete(urlObsBad, urlObsGood);
    }

    private void testGet(Thing thing1, Datastream datastream1, Thing thing2) {
        String url = serverSettings.getServiceUrl(version) + "/Things(" + thing1.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations";
        HTTPMethods.HttpResponse response = HTTPMethods.doGet(url);
        Assertions.assertEquals((int)200, (int)response.code, (String)("Get should return 201 Created for url " + url));
        url = serverSettings.getServiceUrl(version) + "/Things(" + thing2.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations";
        response = HTTPMethods.doGet(url);
        Assertions.assertEquals((int)404, (int)response.code, (String)("Get should return 404 Not Found for url " + url));
        url = serverSettings.getServiceUrl(version) + "/Things(" + thing1.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations";
        String observationJson = "{\n  \"phenomenonTime\": \"2015-03-01T03:00:00.000Z\",\n  \"result\": 300\n}";
        response = HTTPMethods.doPost(url, observationJson);
        Assertions.assertEquals((int)201, (int)response.code, (String)("Post should return 201 Created for url " + url));
        url = serverSettings.getServiceUrl(version) + "/Things(" + thing2.getId().getUrl() + ")/Datastreams(" + datastream1.getId().getUrl() + ")/Observations";
        response = HTTPMethods.doPost(url, observationJson);
        Assertions.assertNotEquals((int)201, (int)response.code, (String)("Post should not return 201 Created for url " + url));
    }

    private void testPut(String urlObsGood, String urlObsBad) {
        String observationJson = "{\n  \"phenomenonTime\": \"2015-03-01T03:00:00.000Z\",\n  \"result\": 301\n}";
        HTTPMethods.HttpResponse response = HTTPMethods.doPut(urlObsGood, observationJson);
        Assertions.assertEquals((int)200, (int)response.code, (String)("Post should return 200 Ok for url " + urlObsGood));
        observationJson = "{\n  \"phenomenonTime\": \"2015-03-01T03:00:00.000Z\",\n  \"result\": 302\n}";
        response = HTTPMethods.doPut(urlObsBad, observationJson);
        Assertions.assertEquals((int)404, (int)response.code, (String)("Post should return 404 Not Found for url " + urlObsBad));
    }

    private void testPatch(String urlObsGood, String urlObsBad) {
        String observationJson = "{\n  \"result\": 303\n}";
        HTTPMethods.HttpResponse response = HTTPMethods.doPatch(urlObsGood, observationJson);
        Assertions.assertEquals((int)200, (int)response.code, (String)("Post should return 200 Ok for url " + urlObsGood));
        observationJson = "{\n  \"result\": 304\n}";
        response = HTTPMethods.doPatch(urlObsBad, observationJson);
        Assertions.assertNotEquals((int)200, (int)response.code, (String)("Post should not return 200 Ok for url " + urlObsBad));
    }

    private void testDelete(String urlObsBad, String urlObsGood) {
        HTTPMethods.HttpResponse response = HTTPMethods.doDelete(urlObsBad);
        Assertions.assertEquals((int)404, (int)response.code, (String)("Post should return 404 Not Found for url " + urlObsBad));
        response = HTTPMethods.doGet(urlObsGood);
        Assertions.assertEquals((int)200, (int)response.code, (String)("Get should return 200 Ok for url " + urlObsGood));
        response = HTTPMethods.doDelete(urlObsGood);
        Assertions.assertEquals((int)200, (int)response.code, (String)("Post should return 200 Ok for url " + urlObsGood));
        response = HTTPMethods.doGet(urlObsGood);
        Assertions.assertEquals((int)404, (int)response.code, (String)("Get should return 404 Not Found for url " + urlObsGood));
    }

    @Test
    void test05RecreateAutomaticFoi() throws ServiceFailureException {
        LOGGER.info("  test05RecreateAutomaticFoi");
        EntityUtils.deleteAll(version, serverSettings, service);
        Location location1 = new Location("LocationThing1", "Location of Thing 1", "application/geo+json", (Object)new Point(8.0, 50.0));
        service.create((Entity)location1);
        Thing thing1 = new Thing("Thing 1", "The first thing.");
        thing1.getLocations().add((Entity)location1.withOnlyId());
        service.create((Entity)thing1);
        Sensor sensor1 = new Sensor("Test Thermometre", "Test Sensor", "None", (Object)"-");
        service.create((Entity)sensor1);
        ObservedProperty obsProp1 = new ObservedProperty("Temperature", "http://example.org", "-");
        service.create((Entity)obsProp1);
        Datastream datastream1 = new Datastream("Ds 1, Thing 1", "The datastream of Thing 1", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement", new UnitOfMeasurement("Degrees Celcius", "\u00b0C", "http://qudt.org/vocab/unit#DegreeCelsius"));
        datastream1.setThing(thing1);
        datastream1.setSensor(sensor1);
        datastream1.setObservedProperty(obsProp1);
        service.create((Entity)datastream1);
        Observation obs1 = new Observation((Object)1.0, datastream1);
        service.create((Entity)obs1);
        FeatureOfInterest foiGenerated1 = ((Observation)service.observations().find(obs1.getId())).getFeatureOfInterest();
        Assertions.assertNotNull((Object)foiGenerated1);
        service.delete((Entity)foiGenerated1);
        Observation obs2 = new Observation((Object)1.0, datastream1);
        service.create((Entity)obs2);
        FeatureOfInterest foiGenerated2 = ((Observation)service.observations().find(obs2.getId())).getFeatureOfInterest();
        Assertions.assertNotNull((Object)foiGenerated2);
        Assertions.assertNotEquals((Object)foiGenerated1, (Object)foiGenerated2);
    }

    public static class Implementation11
    extends AdditionalTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends AdditionalTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

