/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util.mqtt;

import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttBatchResult;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttHelper {
    public static final int WAIT_AFTER_INSERT = 100;
    public static final int WAIT_AFTER_CLEANUP = 500;
    public static final int WAIT_AFTER_SUBSCRIBE = 200;
    public static final int QOS = 2;
    public static final String CLIENT_ID = "STA-test_suite";
    private final String mqttServerUri;
    private final long mqttTimeout;
    private final ServerVersion version;
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttHelper.class);

    public static void waitMillis(long millis) {
        try {
            LOGGER.trace("      Sleeping {}", (Object)millis);
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public MqttHelper(ServerVersion version, String mqttServerUri, long mqttTimeout) {
        this.version = version;
        this.mqttServerUri = mqttServerUri;
        this.mqttTimeout = mqttTimeout;
    }

    public void publish(String topic, String message) {
        this.publish(topic, message, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic, String message, int qos, boolean retained) {
        MqttClient client = null;
        try {
            client = new MqttClient(this.mqttServerUri, CLIENT_ID);
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(true);
            client.connect(connOpts);
            client.publish(topic, message.getBytes(), qos, retained);
        }
        catch (MqttException ex) {
            LOGGER.error("Exception on server {} :", (Object)this.mqttServerUri, (Object)ex);
            Assertions.fail((String)("error publishing message on MQTT: " + ex.getMessage()));
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                    client.close();
                }
                catch (MqttException mqttException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MqttBatchResult<T> executeRequests(Callable<T> action, String ... topics) {
        MqttBatchResult<T> result = new MqttBatchResult<T>(topics.length);
        HashMap<String, Future<JSONObject>> tempResult = new HashMap<String, Future<JSONObject>>(topics.length);
        ExecutorService executor = Executors.newFixedThreadPool(topics.length);
        try {
            for (String topic : topics) {
                MqttListener listener = new MqttListener(this.mqttServerUri, topic);
                listener.connect();
                tempResult.put(topic, executor.submit(listener));
            }
            MqttHelper.waitMillis(200L);
            try {
                LOGGER.debug("  Calling action...");
                result.setActionResult(action.call());
            }
            catch (Exception ex) {
                LOGGER.error("Exception on server {} :", (Object)this.mqttServerUri, (Object)ex);
                Assertions.fail((String)("Topics: " + Arrays.toString(topics) + " Error executing : " + ex.getMessage()));
            }
            executor.shutdown();
            if (!executor.awaitTermination(this.mqttTimeout, TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
            }
            for (Map.Entry entry : tempResult.entrySet()) {
                result.addMessage((String)entry.getKey(), (JSONObject)((Future)entry.getValue()).get());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            LOGGER.error("Exception on server {} :", (Object)this.mqttServerUri, (Object)ex);
            Assertions.fail((String)("Topics: " + Arrays.toString(topics) + " Error subscribing to MQTT: " + ex.getMessage()));
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }

    public List<String> getRelativeTopicsForEntity(EntityType entityType, Map<EntityType, Object> ids) {
        ArrayList<String> result = new ArrayList<String>();
        switch (entityType) {
            case THING: {
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/Thing");
                result.add(this.getTopic(EntityType.OBSERVATION, ids) + "/Datastream/Thing");
                result.add(this.getTopic(EntityType.HISTORICAL_LOCATION, ids) + "/Thing");
                break;
            }
            case LOCATION: {
                break;
            }
            case SENSOR: {
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/Sensor");
                result.add(this.getTopic(EntityType.OBSERVATION, ids) + "/Datastream/Sensor");
                break;
            }
            case OBSERVED_PROPERTY: {
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/ObservedProperty");
                result.add(this.getTopic(EntityType.OBSERVATION, ids) + "/Datastream/ObservedProperty");
                break;
            }
            case FEATURE_OF_INTEREST: {
                result.add(this.getTopic(EntityType.OBSERVATION, ids) + "/FeatureOfInterest");
                break;
            }
            case DATASTREAM: {
                result.add(this.getTopic(EntityType.OBSERVATION, ids) + "/Datastream");
                break;
            }
            case OBSERVATION: {
                break;
            }
            case HISTORICAL_LOCATION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType '" + entityType.toString() + "'");
            }
        }
        return result;
    }

    public List<String> getRelativeTopicsForEntitySet(EntityType entityType, Map<EntityType, Object> ids) {
        ArrayList<String> result = new ArrayList<String>();
        switch (entityType) {
            case THING: {
                result.add(this.getTopic(EntityType.LOCATION, ids) + "/Things");
                break;
            }
            case LOCATION: {
                result.add(this.getTopic(EntityType.THING, ids) + "/Locations");
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/Thing/Locations");
                result.add(this.getTopic(EntityType.HISTORICAL_LOCATION, ids) + "/Thing/Locations");
                break;
            }
            case SENSOR: {
                break;
            }
            case OBSERVED_PROPERTY: {
                break;
            }
            case FEATURE_OF_INTEREST: {
                break;
            }
            case DATASTREAM: {
                result.add(this.getTopic(EntityType.THING, ids) + "/Datastreams");
                result.add(this.getTopic(EntityType.HISTORICAL_LOCATION, ids) + "/Thing/Datastreams");
                result.add(this.getTopic(EntityType.SENSOR, ids) + "/Datastreams");
                result.add(this.getTopic(EntityType.OBSERVED_PROPERTY, ids) + "/Datastreams");
                break;
            }
            case OBSERVATION: {
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/Observations");
                break;
            }
            case HISTORICAL_LOCATION: {
                result.add(this.getTopic(EntityType.THING, ids) + "/HistoricalLocations");
                result.add(this.getTopic(EntityType.DATASTREAM, ids) + "/Thing/HistoricalLocations");
                result.add(this.getTopic(EntityType.LOCATION, ids) + "/HistoricalLocations");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType '" + entityType.toString() + "'");
            }
        }
        return result;
    }

    public String getTopic(EntityType entityType, List<String> selectedProperties) {
        return this.getTopic(entityType) + "?$select=" + selectedProperties.stream().collect(Collectors.joining(","));
    }

    public String getTopic(EntityType entityType, Object id, String property) {
        return this.getTopic(entityType) + "(" + Utils.quoteIdForUrl(id) + ")/" + property;
    }

    public String getTopic(EntityType entityType, Object id) {
        return this.getTopic(entityType) + "(" + Utils.quoteIdForUrl(id) + ")";
    }

    public String getTopic(EntityType entityType) {
        return this.version.urlPart + "/" + entityType.plural;
    }

    private String getTopic(EntityType entityType, Map<EntityType, Object> ids) {
        return this.getTopic(entityType, ids.get((Object)entityType));
    }
}

