/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.f01auth;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import de.fraunhofer.iosb.ilt.sta.service.TokenManager;
import de.fraunhofer.iosb.ilt.sta.service.TokenManagerOpenIDConnect;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.TestSuite;
import de.fraunhofer.iosb.ilt.statests.f01auth.AbstractAuthTests;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyCloakAnonReadTests
extends AbstractAuthTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyCloakAnonReadTests.class);
    private static final Properties SERVER_PROPERTIES = new Properties();
    public static final String KEYCLOAK_FROST_CLIENT_ID = "frost-server";
    public static final String KEYCLOAK_FROST_CONFIG_SECRET = "5aa9087d-817f-47b6-92a1-2b5f7caac967";
    public static final String KEYCLOAK_TOKEN_PATH = "/realms/FROST-Test/protocol/openid-connect/token";

    public KeyCloakAnonReadTests(ServerVersion version) {
        super(version, SERVER_PROPERTIES, true);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)KeyCloakAnonReadTests.version.urlPart);
        super.setUpVersion();
    }

    @Override
    public SensorThingsService getServiceAdmin() {
        return KeyCloakAnonReadTests.setAuth(this.createService(), "admin", "admin");
    }

    @Override
    public SensorThingsService getServiceWrite() {
        return KeyCloakAnonReadTests.setAuth(this.createService(), "write", "write");
    }

    @Override
    public SensorThingsService getServiceRead() {
        return KeyCloakAnonReadTests.setAuth(this.createService(), "read", "read");
    }

    @Override
    public SensorThingsService getServiceAnonymous() {
        return this.createService();
    }

    public static SensorThingsService setAuth(SensorThingsService service, String username, String password) {
        KeycloakContainer keycloak = TestSuite.getInstance().getKeycloak();
        service.setTokenManager((TokenManager)new TokenManagerOpenIDConnect().setTokenServerUrl(keycloak.getAuthServerUrl() + KEYCLOAK_TOKEN_PATH).setClientId(KEYCLOAK_FROST_CLIENT_ID).setUserName(username).setPassword(password));
        return service;
    }

    static {
        SERVER_PROPERTIES.put("auth_provider", "de.fraunhofer.iosb.ilt.frostserver.auth.keycloak.KeycloakAuthProvider");
        SERVER_PROPERTIES.put("auth_keycloakConfigUrl", TestSuite.getInstance().getKeycloak().getAuthServerUrl() + "/realms/FROST-Test/clients-registrations/install/frost-server");
        SERVER_PROPERTIES.put("auth_keycloakConfigSecret", KEYCLOAK_FROST_CONFIG_SECRET);
        SERVER_PROPERTIES.put("auth_allowAnonymousRead", "true");
    }

    public static class Implementation11
    extends KeyCloakAnonReadTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends KeyCloakAnonReadTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

