/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c05multidatastream;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class MultiDatastreamObsPropTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDatastreamObsPropTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> OBSERVED_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<MultiDatastream> MULTIDATASTREAMS = new ArrayList<MultiDatastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public MultiDatastreamObsPropTests(ServerVersion version) {
        super(version);
    }

    @BeforeEach
    public void before() {
        Assumptions.assumeTrue((boolean)serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ), (String)"Conformance level 5 not checked since MultiDatastreams not listed in Service Root.");
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)MultiDatastreamObsPropTests.version.urlPart);
        Assumptions.assumeTrue((boolean)serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ), (String)"Conformance level 5 not checked since MultiDatastreams not listed in Service Root.");
        MultiDatastreamObsPropTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        MultiDatastreamObsPropTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        MultiDatastreamObsPropTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        OBSERVED_PROPS.clear();
        DATASTREAMS.clear();
        MULTIDATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        Thing thing = new Thing("Thing 1", "The first thing.");
        thing.getLocations().add((Entity)location.withOnlyId());
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 2", "The second thing.");
        thing.getLocations().add((Entity)location.withOnlyId());
        service.create((Entity)thing);
        THINGS.add(thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        sensor = new Sensor("Sensor 2", "The second sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        ObservedProperty obsProp = new ObservedProperty("ObservedProperty 1", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        obsProp = new ObservedProperty("ObservedProperty 2", new URI("http://ucom.org/humidity"), "The humidity of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        obsProp = new ObservedProperty("ObservedProperty 3", new URI("http://ucom.org/height"), "The height of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        obsProp = new ObservedProperty("ObservedProperty 4", new URI("http://ucom.org/depth"), "The depth of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        DATASTREAMS.add(datastream);
        datastream.setThing(THINGS.get(0).withOnlyId());
        datastream.setSensor(SENSORS.get(0).withOnlyId());
        datastream.setObservedProperty(OBSERVED_PROPS.get(0).withOnlyId());
        service.create((Entity)datastream);
        datastream = new Datastream("Datastream 2", "The temperature of thing 2, sensor 2.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        DATASTREAMS.add(datastream);
        datastream.setThing(THINGS.get(1).withOnlyId());
        datastream.setSensor(SENSORS.get(1).withOnlyId());
        datastream.setObservedProperty(OBSERVED_PROPS.get(0).withOnlyId());
        service.create((Entity)datastream);
    }

    private void checkResult(String test, EntityUtils.ResultTestResult result) {
        Assertions.assertTrue((boolean)result.testOk, (String)(test + " " + result.message));
    }

    private void checkObservedPropertiesFor(MultiDatastream md, ObservedProperty ... expectedObservedProps) throws ServiceFailureException {
        Object[] fetchedObservedProps2 = (ObservedProperty[])md.observedProperties().query().list().toArray((Object[])new ObservedProperty[0]);
        String message = "Incorrect Observed Properties returned.";
        Assertions.assertArrayEquals((Object[])expectedObservedProps, (Object[])fetchedObservedProps2, (String)message);
    }

    @Test
    void test01CreateMultiDatastreams() throws ServiceFailureException {
        LOGGER.info("  test01MultiDatastream");
        MultiDatastream md1 = new MultiDatastream();
        md1.setName("MultiDatastream 1");
        md1.setDescription("The first test MultiDatastream.");
        md1.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes1 = new ArrayList<String>();
        dataTypes1.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md1.setMultiObservationDataTypes(dataTypes1);
        md1.setThing(THINGS.get(0).withOnlyId());
        md1.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties = new ArrayList<ObservedProperty>();
        observedProperties.add(OBSERVED_PROPS.get(0).withOnlyId());
        md1.setObservedProperties(observedProperties);
        service.create((Entity)md1);
        MULTIDATASTREAMS.add(md1);
        MultiDatastream md2 = new MultiDatastream();
        md2.setName("MultiDatastream 2");
        md2.setDescription("The second test MultiDatastream.");
        md2.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        md2.addUnitOfMeasurement(new UnitOfMeasurement("percent", "%", "ucum:%"));
        md2.addUnitOfMeasurement(new UnitOfMeasurement("Metre", "m", "ucum:m"));
        md2.addUnitOfMeasurement(new UnitOfMeasurement("Metre", "m", "ucum:m"));
        ArrayList<String> dataTypes2 = new ArrayList<String>();
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md2.setMultiObservationDataTypes(dataTypes2);
        md2.setThing(THINGS.get(0).withOnlyId());
        md2.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties2 = new ArrayList<ObservedProperty>();
        observedProperties2.add(OBSERVED_PROPS.get(0).withOnlyId());
        observedProperties2.add(OBSERVED_PROPS.get(1).withOnlyId());
        observedProperties2.add(OBSERVED_PROPS.get(2).withOnlyId());
        observedProperties2.add(OBSERVED_PROPS.get(3).withOnlyId());
        md2.setObservedProperties(observedProperties2);
        service.create((Entity)md2);
        MULTIDATASTREAMS.add(md2);
        MultiDatastream md3 = new MultiDatastream();
        md3.setName("MultiDatastream 3");
        md3.setDescription("The third test MultiDatastream.");
        md3.addUnitOfMeasurement(new UnitOfMeasurement("percent", "%", "ucum:%"));
        md3.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes3 = new ArrayList<String>();
        dataTypes3.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes3.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md3.setMultiObservationDataTypes(dataTypes3);
        md3.setThing(THINGS.get(0).withOnlyId());
        md3.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties3 = new ArrayList<ObservedProperty>();
        observedProperties3.add(OBSERVED_PROPS.get(1).withOnlyId());
        observedProperties3.add(OBSERVED_PROPS.get(0).withOnlyId());
        md3.setObservedProperties(observedProperties3);
        service.create((Entity)md3);
        MULTIDATASTREAMS.add(md3);
        MultiDatastream md4 = new MultiDatastream();
        md4.setName("MultiDatastream 4");
        md4.setDescription("The fourth test MultiDatastream.");
        md4.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        md4.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes4 = new ArrayList<String>();
        dataTypes4.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes4.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md4.setMultiObservationDataTypes(dataTypes4);
        md4.setThing(THINGS.get(0).withOnlyId());
        md4.setSensor(SENSORS.get(1).withOnlyId());
        ArrayList<ObservedProperty> observedProperties4 = new ArrayList<ObservedProperty>();
        observedProperties4.add(OBSERVED_PROPS.get(0).withOnlyId());
        observedProperties4.add(OBSERVED_PROPS.get(0).withOnlyId());
        md4.setObservedProperties(observedProperties4);
        service.create((Entity)md4);
        MULTIDATASTREAMS.add(md4);
        Assertions.assertEquals((int)4, (int)MULTIDATASTREAMS.size());
    }

    @Test
    void test02MultiDatastreamObservedProperties1() throws ServiceFailureException {
        LOGGER.info("  test07MultiDatastreamObservedProperties1");
        ObservedProperty fetchedObservedProp = (ObservedProperty)service.observedProperties().find(OBSERVED_PROPS.get(0).getId());
        EntityList fetchedDatastreams = fetchedObservedProp.datastreams().query().list();
        this.checkResult("Check Datastreams linked to ObservedProperty 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, Utils.getFromList(DATASTREAMS, 0, 1)));
        EntityList fetchedMultiDatastreams = fetchedObservedProp.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to ObservedProperty 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, new ArrayList<MultiDatastream>(MULTIDATASTREAMS)));
    }

    @Test
    void test03MultiDatastreamObservedProperties2() throws ServiceFailureException {
        LOGGER.info("  test08MultiDatastreamObservedProperties2");
        ObservedProperty fetchedObservedProp = (ObservedProperty)service.observedProperties().find(OBSERVED_PROPS.get(1).getId());
        EntityList fetchedDatastreams = fetchedObservedProp.datastreams().query().list();
        this.checkResult("Check Datastreams linked to ObservedProperty 2.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, new ArrayList()));
        EntityList fetchedMultiDatastreams = fetchedObservedProp.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to ObservedProperty 2.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, Utils.getFromList(MULTIDATASTREAMS, 1, 2)));
    }

    @Test
    void test04ObservedPropertyOrder() throws ServiceFailureException {
        LOGGER.info("  test11ObservedPropertyOrder");
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(0), OBSERVED_PROPS.get(0));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(1), OBSERVED_PROPS.get(2), OBSERVED_PROPS.get(3));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(2), OBSERVED_PROPS.get(1), OBSERVED_PROPS.get(0));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(3), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(0));
    }

    @Test
    void test05UnLinkObsProp1() throws ServiceFailureException {
        LOGGER.info("  test12IncorrectObservation");
        MultiDatastream md2 = MULTIDATASTREAMS.get(1);
        ObservedProperty op2 = OBSERVED_PROPS.get(1);
        ObservedProperty op3 = OBSERVED_PROPS.get(2);
        String md2Id = md2.getId().getUrl();
        String op2Id = op2.getId().getUrl();
        String op3Id = op3.getId().getUrl();
        HTTPMethods.HttpResponse response = HTTPMethods.doDelete(serverSettings.getServiceUrl(version) + "/MultiDatastreams(" + md2Id + ")/ObservedProperties/$ref?$id=../../Observations(" + op2Id + ")");
        Assertions.assertEquals((int)400, (int)response.code);
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(1), OBSERVED_PROPS.get(2), OBSERVED_PROPS.get(3));
        response = HTTPMethods.doDelete(serverSettings.getServiceUrl(version) + "/MultiDatastreams(" + md2Id + ")/ObservedProperties(" + op2Id + ")/$ref");
        Assertions.assertEquals((int)204, (int)response.code);
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(2), OBSERVED_PROPS.get(3));
        response = HTTPMethods.doDelete(serverSettings.getServiceUrl(version) + "/MultiDatastreams(" + md2Id + ")/ObservedProperties/$ref?$id=../../ObservedProperties(" + op3Id + ")");
        Assertions.assertEquals((int)204, (int)response.code);
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(3));
        response = HTTPMethods.doDelete(serverSettings.getServiceUrl(version) + "/MultiDatastreams(" + md2Id + ")/ObservedProperties/$ref?$id=../../ObservedProperties(-1)");
        Assertions.assertEquals((int)404, (int)response.code);
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(3));
    }

    public static class Implementation11
    extends MultiDatastreamObsPropTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends MultiDatastreamObsPropTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

