/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c03filtering;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.geojson.GeoJsonObject;
import org.geojson.LineString;
import org.geojson.LngLatAlt;
import org.geojson.Point;
import org.geojson.Polygon;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public abstract class GeoTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoTests.class);
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<FeatureOfInterest> FEATURESOFINTEREST = new ArrayList<FeatureOfInterest>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<Thing> THINGS = new ArrayList<Thing>();

    public GeoTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)GeoTests.version.urlPart);
        GeoTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        GeoTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        GeoTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        FEATURESOFINTEREST.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        GeoTests.createThings();
        GeoTests.createSensor();
        GeoTests.createObsProp();
        GeoTests.createDatastreams();
        GeoTests.createLocation0();
        GeoTests.createLocation1();
        GeoTests.createLocation2();
        GeoTests.createLocation3();
        GeoTests.createLocation4();
        GeoTests.createLocation5();
        GeoTests.createLocation6();
        GeoTests.createLocation7();
    }

    private static void createThings() throws ServiceFailureException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 2", "The second thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 3", "The third thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 4", "The fourt thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
    }

    private static void createSensor() throws ServiceFailureException {
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
    }

    private static void createObsProp() throws ServiceFailureException, URISyntaxException {
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        O_PROPS.add(obsProp);
    }

    private static void createDatastreams() throws ServiceFailureException {
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(THINGS.get(0));
        datastream.setSensor(SENSORS.get(0));
        datastream.setObservedProperty(O_PROPS.get(0));
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        datastream = new Datastream("Datastream 2", "The temperature of thing 2, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(THINGS.get(1));
        datastream.setSensor(SENSORS.get(0));
        datastream.setObservedProperty(O_PROPS.get(0));
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
        datastream = new Datastream("Datastream 3", "The temperature of thing 3, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(THINGS.get(2));
        datastream.setSensor(SENSORS.get(0));
        datastream.setObservedProperty(O_PROPS.get(0));
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
    }

    private static void createLocation0() throws ServiceFailureException {
        Point gjo = new Point(8.0, 51.0);
        Location location = new Location("Location 1.0", "First Location of Thing 1.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 0", "This should be FoI #0.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
        Observation o = new Observation((Object)1, DATASTREAMS.get(0));
        o.setFeatureOfInterest(featureOfInterest);
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-01T01:01:01.000Z"));
        o.setValidTime(Interval.of((Instant)Instant.parse("2016-01-01T01:01:01.000Z"), (Instant)Instant.parse("2016-01-01T23:59:59.999Z")));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private static void createLocation1() throws ServiceFailureException {
        Point gjo = new Point(8.0, 52.0);
        Location location = new Location("Location 1.1", "Second Location of Thing 1.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 1", "This should be FoI #1.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
        Observation o = new Observation((Object)2, DATASTREAMS.get(0));
        o.setFeatureOfInterest(featureOfInterest);
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-02T01:01:01.000Z"));
        o.setValidTime(Interval.of((Instant)Instant.parse("2016-01-02T01:01:01.000Z"), (Instant)Instant.parse("2016-01-02T23:59:59.999Z")));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private static void createLocation2() throws ServiceFailureException {
        Point gjo = new Point(8.0, 53.0);
        Location location = new Location("Location 2", "Location of Thing 2.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().add((Entity)THINGS.get(1));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 2", "This should be FoI #2.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
        Observation o = new Observation((Object)3, DATASTREAMS.get(1));
        o.setFeatureOfInterest(featureOfInterest);
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-03T01:01:01.000Z"));
        o.setValidTime(Interval.of((Instant)Instant.parse("2016-01-03T01:01:01.000Z"), (Instant)Instant.parse("2016-01-03T23:59:59.999Z")));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private static void createLocation3() throws ServiceFailureException {
        Point gjo = new Point(8.0, 54.0);
        Location location = new Location("Location 3", "Location of Thing 3.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().add((Entity)THINGS.get(2));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 3", "This should be FoI #3.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
        Observation o = new Observation((Object)4, DATASTREAMS.get(2));
        o.setFeatureOfInterest(featureOfInterest);
        o.setPhenomenonTimeFrom(ZonedDateTime.parse("2016-01-04T01:01:01.000Z"));
        o.setValidTime(Interval.of((Instant)Instant.parse("2016-01-04T01:01:01.000Z"), (Instant)Instant.parse("2016-01-04T23:59:59.999Z")));
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private static void createLocation4() throws ServiceFailureException {
        Polygon gjo = new Polygon(new LngLatAlt[]{new LngLatAlt(8.0, 53.0), new LngLatAlt(7.0, 52.0), new LngLatAlt(7.0, 53.0), new LngLatAlt(8.0, 53.0)});
        Location location = new Location("Location 4", "Location of Thing 4.", "application/vnd.geo+json", (Object)gjo);
        location.getThings().add((Entity)THINGS.get(3));
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 4", "This should be FoI #4.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
    }

    private static void createLocation5() throws ServiceFailureException {
        LineString gjo = new LineString(new LngLatAlt[]{new LngLatAlt(5.0, 52.0), new LngLatAlt(5.0, 53.0)});
        Location location = new Location("Location 5", "A line.", "application/vnd.geo+json", (Object)gjo);
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 5", "This should be FoI #5.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
    }

    private static void createLocation6() throws ServiceFailureException {
        LineString gjo = new LineString(new LngLatAlt[]{new LngLatAlt(5.0, 52.0), new LngLatAlt(6.0, 53.0)});
        Location location = new Location("Location 6", "A longer line.", "application/vnd.geo+json", (Object)gjo);
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 6", "This should be FoI #6.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
    }

    private static void createLocation7() throws ServiceFailureException {
        LineString gjo = new LineString(new LngLatAlt[]{new LngLatAlt(4.0, 52.0), new LngLatAlt(8.0, 52.0)});
        Location location = new Location("Location 7", "The longest line.", "application/vnd.geo+json", (Object)gjo);
        service.create((Entity)location);
        LOCATIONS.add(location);
        FeatureOfInterest featureOfInterest = new FeatureOfInterest("FoI 7", "This should be FoI #7.", "application/geo+json", (GeoJsonObject)gjo);
        service.create((Entity)featureOfInterest);
        FEATURESOFINTEREST.add(featureOfInterest);
    }

    @Test
    void testGeoDistance() throws ServiceFailureException {
        LOGGER.info("  testGeoDistance");
        EntityUtils.testFilterResults(service.locations(), "geo.distance(location, geography'POINT(8 54.1)') lt 1", Utils.getFromList(LOCATIONS, 3));
        EntityUtils.testFilterResults(service.locations(), "geo.distance(location, geography'POINT(8 54.1)') gt 1", Utils.getFromList(LOCATIONS, 0, 1, 2, 4, 5, 6, 7));
        EntityUtils.testFilterResults(service.observations(), "geo.distance(FeatureOfInterest/feature, geography'POINT(8 54.1)') lt 1", Utils.getFromList(OBSERVATIONS, 3));
        EntityUtils.testFilterResults(service.observations(), "geo.distance(FeatureOfInterest/feature, geography'POINT(8 54.1)') gt 1", Utils.getFromList(OBSERVATIONS, 0, 1, 2));
    }

    @Test
    void testGeoIntersects() throws ServiceFailureException {
        LOGGER.info("  testGeoIntersects");
        EntityUtils.testFilterResults(service.locations(), "geo.intersects(location, geography'LINESTRING(7.5 51, 7.5 54)')", Utils.getFromList(LOCATIONS, 4, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.intersects(feature, geography'LINESTRING(7.5 51, 7.5 54)')", Utils.getFromList(FEATURESOFINTEREST, 4, 7));
        EntityUtils.testFilterResults(service.datastreams(), "geo.intersects(observedArea, geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))')", Utils.getFromList(DATASTREAMS, 0, 1));
    }

    @Test
    void testGeoLength() throws ServiceFailureException {
        LOGGER.info("  testGeoLength");
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) gt 1", Utils.getFromList(LOCATIONS, 6, 7));
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) ge 1", Utils.getFromList(LOCATIONS, 5, 6, 7));
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) eq 1", Utils.getFromList(LOCATIONS, 5));
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) ne 1", Utils.getFromList(LOCATIONS, 0, 1, 2, 3, 4, 6, 7));
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) le 4", Utils.getFromList(LOCATIONS, 0, 1, 2, 3, 4, 5, 6, 7));
        EntityUtils.testFilterResults(service.locations(), "geo.length(location) lt 4", Utils.getFromList(LOCATIONS, 0, 1, 2, 3, 4, 5, 6));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) gt 1", Utils.getFromList(FEATURESOFINTEREST, 6, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) ge 1", Utils.getFromList(FEATURESOFINTEREST, 5, 6, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) eq 1", Utils.getFromList(FEATURESOFINTEREST, 5));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) ne 1", Utils.getFromList(FEATURESOFINTEREST, 0, 1, 2, 3, 4, 6, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) le 4", Utils.getFromList(FEATURESOFINTEREST, 0, 1, 2, 3, 4, 5, 6, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "geo.length(feature) lt 4", Utils.getFromList(FEATURESOFINTEREST, 0, 1, 2, 3, 4, 5, 6));
    }

    @Test
    void testStContains() throws ServiceFailureException {
        LOGGER.info("  testStContains");
        EntityUtils.testFilterResults(service.locations(), "st_contains(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', location)", Utils.getFromList(LOCATIONS, 1, 2));
        EntityUtils.testFilterResults(service.observations(), "st_contains(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', FeatureOfInterest/feature)", Utils.getFromList(OBSERVATIONS, 1, 2));
        EntityUtils.testFilterResults(service.datastreams(), "st_contains(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', observedArea)", Utils.getFromList(DATASTREAMS, 1));
    }

    @Test
    void testStCrosses() throws ServiceFailureException {
        LOGGER.info("  testStCrosses");
        EntityUtils.testFilterResults(service.locations(), "st_crosses(geography'LINESTRING(7.5 51.5, 7.5 53.5)', location)", Utils.getFromList(LOCATIONS, 4, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_crosses(geography'LINESTRING(7.5 51.5, 7.5 53.5)', feature)", Utils.getFromList(FEATURESOFINTEREST, 4, 7));
    }

    @Test
    void testStDisjoint() throws ServiceFailureException {
        LOGGER.info("  testStDisjoint");
        EntityUtils.testFilterResults(service.locations(), "st_disjoint(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', location)", Utils.getFromList(LOCATIONS, 0, 3, 5, 6));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_disjoint(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', feature)", Utils.getFromList(FEATURESOFINTEREST, 0, 3, 5, 6));
    }

    @Test
    void testStEquals() throws ServiceFailureException {
        LOGGER.info("  testStEquals");
        EntityUtils.testFilterResults(service.locations(), "st_equals(location, geography'POINT(8 53)')", Utils.getFromList(LOCATIONS, 2));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_equals(feature, geography'POINT(8 53)')", Utils.getFromList(FEATURESOFINTEREST, 2));
    }

    @Test
    void testStIntersects() throws ServiceFailureException {
        LOGGER.info("  testStIntersects");
        EntityUtils.testFilterResults(service.locations(), "st_intersects(location, geography'LINESTRING(7.5 51, 7.5 54)')", Utils.getFromList(LOCATIONS, 4, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_intersects(feature, geography'LINESTRING(7.5 51, 7.5 54)')", Utils.getFromList(FEATURESOFINTEREST, 4, 7));
        EntityUtils.testFilterResults(service.datastreams(), "st_intersects(observedArea, geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))')", Utils.getFromList(DATASTREAMS, 0, 1));
    }

    @Test
    void testStOverlaps() throws ServiceFailureException {
        LOGGER.info("  testStOverlaps");
        EntityUtils.testFilterResults(service.locations(), "st_overlaps(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', location)", Utils.getFromList(LOCATIONS, 4));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_overlaps(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', feature)", Utils.getFromList(FEATURESOFINTEREST, 4));
    }

    @Test
    void testStRelate() throws ServiceFailureException {
        LOGGER.info("  testStRelate");
        EntityUtils.testFilterResults(service.locations(), "st_relate(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', location, 'T********')", Utils.getFromList(LOCATIONS, 1, 2, 4, 7));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_relate(geography'POLYGON((7.5 51.5, 7.5 53.5, 8.5 53.5, 8.5 51.5, 7.5 51.5))', feature, 'T********')", Utils.getFromList(FEATURESOFINTEREST, 1, 2, 4, 7));
    }

    @Test
    void testStTouches() throws ServiceFailureException {
        LOGGER.info("  testStTouches");
        EntityUtils.testFilterResults(service.locations(), "st_touches(geography'POLYGON((8 53, 7.5 54.5, 8.5 54.5, 8 53))', location)", Utils.getFromList(LOCATIONS, 2, 4));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_touches(geography'POLYGON((8 53, 7.5 54.5, 8.5 54.5, 8 53))', feature)", Utils.getFromList(FEATURESOFINTEREST, 2, 4));
    }

    @Test
    void testStWithin() throws ServiceFailureException {
        LOGGER.info("  testStWithin");
        EntityUtils.testFilterResults(service.locations(), "st_within(geography'POINT(7.5 52.75)', location)", Utils.getFromList(LOCATIONS, 4));
        EntityUtils.testFilterResults(service.featuresOfInterest(), "st_within(geography'POINT(7.5 52.75)', feature)", Utils.getFromList(FEATURESOFINTEREST, 4));
    }

    public static class Implementation11
    extends GeoTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends GeoTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

