/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c01sensingcore;

import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEntityCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEntityCreator.class);

    public static void maybeCreateTestEntities(ServerSettings serverSettings, ServerVersion version) {
        String rootUri = serverSettings.getServiceUrl(version);
        String responseObservations = TestEntityCreator.getEntities(rootUri, EntityType.OBSERVATION);
        String responseHistLocations = TestEntityCreator.getEntities(rootUri, EntityType.HISTORICAL_LOCATION);
        int countObservations = TestEntityCreator.countEntitiesInResponse(responseObservations);
        int countHistLocations = TestEntityCreator.countEntitiesInResponse(responseHistLocations);
        if (countHistLocations == 0 || countObservations == 0) {
            TestEntityCreator.createTestEntities(rootUri, serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ));
        }
    }

    private static void createTestEntities(String rootUri, boolean actuation) {
        String urlParameters = TestEntityCreator.getEntitiesJson();
        String urlString = ServiceUrlHelper.buildURLString(rootUri, EntityType.THING, null, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, urlParameters);
        String response = responseMap.response;
        Object id = HTTPMethods.idFromSelfLink(response);
        if (actuation) {
            String postContent = TestEntityCreator.getActuationJson();
            urlString = ServiceUrlHelper.buildURLString(rootUri, EntityType.THING, id, EntityType.TASKING_CAPABILITY, null);
            HTTPMethods.doPost(urlString, postContent);
        }
    }

    private static String getEntitiesJson() {
        return TestEntityCreator.pathToString("src/test/resources/entitiesDefault.json");
    }

    private static String getActuationJson() {
        return TestEntityCreator.pathToString("src/test/resources/entitiesDefaultActuation.json");
    }

    private static String pathToString(String path) throws RuntimeException {
        File file = new File(path);
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getEntities(String rootUri, EntityType entityType) {
        String urlString = rootUri;
        if (entityType != null) {
            urlString = ServiceUrlHelper.buildURLString(rootUri, entityType, null, null, null);
        }
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.response;
        int responseCode = responseMap.code;
        Assertions.assertEquals((int)200, (int)responseCode, (String)("Error during getting entities: " + (entityType != null ? entityType.name() : "root URI")));
        if (entityType != null) {
            Assertions.assertTrue((boolean)response.contains("value"), (String)("The GET entities response for entity type \"" + entityType + "\" does not match SensorThings API : missing \"value\" in response."));
        } else {
            Assertions.assertTrue((boolean)response.contains("value"), (String)"The GET entities response for service root URI does not match SensorThings API : missing \"value\" in response.");
        }
        return response;
    }

    private static int countEntitiesInResponse(String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            return entities.length();
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return 0;
        }
    }
}

