/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests;

import de.fraunhofer.iosb.ilt.statests.Requirement;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Extension;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ServerSettings {
    public static final Requirement TASKING_REQ = Requirement.IOT_TASKING_1_0_TASKING_CAPABILITY_PROPERTIES;
    public static final Requirement MULTIDATA_REQ = Requirement.IOT_SENSING_1_1_MULTI_DATASTREAM_CONSTRAINTS;
    private String serviceRootUrl = "";
    private String mqttUrl = "";
    private final Map<ServerVersion, Set<Requirement>> implementedRequirements = new HashMap<ServerVersion, Set<Requirement>>();
    private final Set<ServerVersion> implementedVersions = new LinkedHashSet<ServerVersion>();
    private final Set<Extension> extensions = EnumSet.noneOf(Extension.class);
    private final Set<EntityType> enabledEntityTypes = EnumSet.noneOf(EntityType.class);
    private final long mqttTimeOut = 30000L;

    public void setServiceRootUrl(String serviceRootUrl) {
        this.serviceRootUrl = serviceRootUrl.endsWith("/") ? serviceRootUrl.substring(0, serviceRootUrl.length() - 1) : serviceRootUrl;
    }

    public void initExtensionsAndTypes() {
        this.getExtensions().add(Extension.CORE);
        if (this.implementsRequirement(MULTIDATA_REQ) != null) {
            this.getExtensions().add(Extension.MULTI_DATASTREAM);
        }
        if (this.implementsRequirement(TASKING_REQ) != null) {
            this.getExtensions().add(Extension.ACTUATION);
        }
        for (EntityType entityType : EntityType.values()) {
            if (!this.extensions.contains((Object)entityType.getExtension())) continue;
            this.getEnabledEntityTypes().add(entityType);
        }
    }

    public String getServiceRootUrl() {
        return this.serviceRootUrl;
    }

    public String getServiceUrl(ServerVersion version) {
        return this.serviceRootUrl + "/" + version.urlPart;
    }

    public String getMqttUrl() {
        return this.mqttUrl;
    }

    public void setMqttUrl(String mqttUrl) {
        this.mqttUrl = mqttUrl;
    }

    public void addImplementedRequirement(ServerVersion version, Requirement requirement) {
        this.implementedRequirements.computeIfAbsent(version, t -> new HashSet()).add(requirement);
    }

    public void addImplementedRequirements(ServerVersion version, Set<Requirement> requirements) {
        this.implementedRequirements.computeIfAbsent(version, t -> new HashSet()).addAll(requirements);
    }

    public boolean implementsRequirement(ServerVersion version, Requirement req) {
        return this.implementedRequirements.computeIfAbsent(version, t -> new HashSet()).contains((Object)req);
    }

    public ServerVersion implementsRequirement(Requirement req) {
        for (Map.Entry<ServerVersion, Set<Requirement>> entry : this.implementedRequirements.entrySet()) {
            if (!entry.getValue().contains((Object)req)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<Extension> getExtensions() {
        return this.extensions;
    }

    public Set<EntityType> getEnabledEntityTypes() {
        return this.enabledEntityTypes;
    }

    public void addImplementedVersion(ServerVersion version) {
        this.implementedVersions.add(version);
    }

    public Set<ServerVersion> getImplementedVersions() {
        return this.implementedVersions;
    }

    public boolean implementsVersion(ServerVersion version) {
        return this.implementedVersions.contains((Object)version);
    }

    public long getMqttTimeOut() {
        return 30000L;
    }
}

