/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.Expand;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.PathElement;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
extends Expand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private String baseUrl;
    private String lastUrl;

    public Request() {
    }

    public Request(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public Request reNest() {
        this.getQuery().reNestExpands();
        return this;
    }

    @Override
    public boolean isToplevel() {
        return true;
    }

    @Override
    public String toString() {
        if (this.lastUrl == null) {
            this.buildUrl();
        }
        return this.lastUrl;
    }

    public String getLastUrl() {
        return this.lastUrl;
    }

    public String buildUrl() {
        StringBuilder urlString = new StringBuilder(this.baseUrl);
        for (PathElement element : this.getPath()) {
            urlString.append('/').append(element.toString());
        }
        urlString.append('?').append(this.getQuery().toString(false));
        this.lastUrl = urlString.toString();
        return this.lastUrl;
    }

    public JSONObject executeGet() {
        String fetchUrl = this.buildUrl();
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(fetchUrl);
        if (responseMap.code != 200) {
            String message = "Error during request: " + fetchUrl;
            Assertions.assertEquals((int)200, (int)responseMap.code, (String)message);
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(responseMap.response);
        }
        catch (JSONException ex) {
            LOGGER.error("Failed to parse response for request: " + fetchUrl, (Throwable)ex);
            Assertions.fail((String)("Failed to parse response for request: " + fetchUrl));
        }
        return jsonResponse;
    }

    @Override
    public Request clone() {
        Request clone = (Request)super.clone();
        clone.baseUrl = this.baseUrl;
        return clone;
    }
}

