/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Expand;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class Query {
    private Boolean count;
    private Long top;
    private Long skip;
    private final List<Expand> expand = new ArrayList<Expand>();
    private final List<String> select = new ArrayList<String>();
    private String orderBy;
    private String filter;
    private Expand parent;

    public void setParent(Expand parent) {
        this.parent = parent;
    }

    public String toString(boolean inExpand) {
        char separator = inExpand ? (char)';' : '&';
        boolean isCollection = this.parent.isCollection();
        StringBuilder sb = new StringBuilder();
        this.addSkipTopToString(isCollection, sb, separator);
        this.addSelectToString(sb, separator);
        this.addFilterToString(isCollection, sb, separator, inExpand);
        this.addExpandToString(sb, separator);
        if (this.orderBy != null && isCollection) {
            sb.append(separator).append("$orderby=").append(this.orderBy);
        }
        if (this.count != null && isCollection) {
            sb.append(separator).append("$count=").append(this.count);
        }
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return "";
    }

    private void addSkipTopToString(boolean isCollection, StringBuilder sb, char separator) {
        if (this.top != null && isCollection) {
            sb.append(separator).append("$top=").append(this.top);
        }
        if (this.skip != null && isCollection) {
            sb.append(separator).append("$skip=").append(this.skip);
        }
    }

    private void addSelectToString(StringBuilder sb, char separator) {
        if (!this.select.isEmpty()) {
            sb.append(separator).append("$select=");
            boolean firstDone = false;
            for (String property : this.select) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                sb.append(property);
            }
        }
    }

    private void addFilterToString(boolean isCollection, StringBuilder sb, char separator, boolean inExpand) {
        if (this.filter != null && isCollection) {
            sb.append(separator).append("$filter=");
            String filterString = this.filter;
            if (!inExpand) {
                filterString = Utils.urlEncode(filterString);
            }
            sb.append(filterString);
        }
    }

    private void addExpandToString(StringBuilder sb, char separator) {
        if (!this.expand.isEmpty()) {
            sb.append(separator).append("$expand=");
            boolean firstDone = false;
            for (Expand e : this.expand) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                String expandUrl = e.toString();
                sb.append(expandUrl);
            }
        }
    }

    public void reNestExpands() {
        ArrayList<Expand> newExpands = new ArrayList<Expand>();
        EnumMap<EntityType, Expand> expandMap = new EnumMap<EntityType, Expand>(EntityType.class);
        for (Expand oldExpand : this.expand) {
            Expand reNest = oldExpand.reNest();
            EntityType entityType = reNest.getEntityType();
            if (expandMap.containsKey((Object)entityType)) {
                Expand existing = (Expand)expandMap.get((Object)entityType);
                existing.getQuery().addExpand(reNest.getQuery().getExpand());
                existing.getQuery().reNestExpands();
                continue;
            }
            newExpands.add(reNest);
            expandMap.put(entityType, reNest);
        }
        this.expand.clear();
        this.expand.addAll(newExpands);
    }

    public boolean isEmpty() {
        return this.count == null && this.top == null && this.skip == null && this.expand.isEmpty() && this.select.isEmpty() && this.orderBy == null && this.filter == null;
    }

    public Boolean getCount() {
        return this.count;
    }

    public Query setCount(Boolean count) {
        this.count = count;
        return this;
    }

    public Long getTop() {
        return this.top;
    }

    public Query setTop(Long top) {
        this.top = top;
        return this;
    }

    public Long getSkip() {
        return this.skip;
    }

    public Query setSkip(Long skip) {
        this.skip = skip;
        return this;
    }

    public List<Expand> getExpand() {
        return this.expand;
    }

    public Query addExpand(Expand expand) {
        this.expand.add(expand);
        return this;
    }

    public Query addExpand(List<Expand> expand) {
        this.expand.addAll(expand);
        return this;
    }

    public List<String> getSelect() {
        return this.select;
    }

    public Query addSelect(String select) {
        this.select.add(select);
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Query setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public void duplicate(Query source) {
        this.count = source.count;
        this.filter = source.filter;
        this.orderBy = source.orderBy;
        this.skip = source.skip;
        this.top = source.top;
        for (Expand expand : source.expand) {
            this.expand.add(expand.clone());
        }
        for (String string : source.select) {
            this.select.add(string);
        }
    }
}

