/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMethods {
    public static final ContentType APPLICATION_JSON_PATCH = ContentType.create((String)"application/json-patch+json", (Charset)Consts.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPMethods.class);
    private static int countDelete = 0;
    private static int countGet = 0;
    private static int countPost = 0;
    private static int countPatch = 0;
    private static int countPut = 0;

    public static void resetStats() {
        countDelete = 0;
        countGet = 0;
        countPatch = 0;
        countPost = 0;
        countPut = 0;
    }

    public static void logStats() {
        LOGGER.info("Calls: {} Get, {} Post, {} Patch, {} Put, {} Delete", new Object[]{countGet, countPost, countPatch, countPut, countDelete});
    }

    public static HttpResponse doGet(String urlString) {
        HttpResponse result = null;
        LOGGER.debug("Getting: {}", (Object)urlString);
        ++countGet;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet(urlString);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                result = new HttpResponse(response.getStatusLine().getStatusCode());
                if (result.code == 200) {
                    result.setResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
                } else {
                    result.setResponse("");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception: ", (Throwable)e);
        }
        return result;
    }

    private static String responseToString(HttpURLConnection connection) throws IOException {
        if (connection.getInputStream().available() == 0) {
            return "";
        }
        try (Scanner scanner = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    public static HttpResponse doPost(String urlString, String postBody) {
        HttpResponse response = HTTPMethods.doPost(urlString, postBody, "application/json");
        if (response != null && response.code != 201) {
            response.setResponse("");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(String urlString, String postBody, String contentType) {
        HttpURLConnection connection = null;
        try {
            LOGGER.debug("Posting: {}", (Object)urlString);
            ++countPost;
            URL url = new URL(urlString);
            byte[] postData = postBody.getBytes(StandardCharsets.UTF_8);
            int postDataLength = postData.length;
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
            connection.setUseCaches(false);
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(postData);
            }
            HttpResponse result = new HttpResponse(connection.getResponseCode());
            if (connection.getResponseCode() == 201) {
                String locationHeader = connection.getHeaderField("location");
                if (locationHeader == null || locationHeader.isEmpty()) {
                    result.setResponse(HTTPMethods.responseToString(connection));
                } else {
                    result.setResponse(locationHeader);
                }
            } else if (connection.getResponseCode() == 200) {
                result.setResponse(HTTPMethods.responseToString(connection));
            } else {
                result.setResponse("");
            }
            HttpResponse httpResponse = result;
            return httpResponse;
        }
        catch (Exception e) {
            LOGGER.error("Exception: ", (Throwable)e);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPut(String urlString, String putBody) {
        HttpURLConnection connection = null;
        try {
            LOGGER.debug("Putting: {}", (Object)urlString);
            ++countPut;
            URI uri = new URI(urlString);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPut request = new HttpPut(uri);
            StringEntity params = new StringEntity(putBody, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)params);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpResponse result = new HttpResponse(response.getStatusLine().getStatusCode());
            result.setResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            httpClient.close();
            HttpResponse httpResponse = result;
            return httpResponse;
        }
        catch (Exception e) {
            LOGGER.error("Exception: ", (Throwable)e);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doDelete(String urlString) {
        HttpURLConnection connection = null;
        try {
            LOGGER.debug("Deleting: {}", (Object)urlString);
            ++countDelete;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestMethod("DELETE");
            connection.connect();
            HttpResponse result = new HttpResponse(connection.getResponseCode());
            result.setResponse("");
            HttpResponse httpResponse = result;
            return httpResponse;
        }
        catch (Exception e) {
            LOGGER.error("Exception: ", (Throwable)e);
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResponse doPatch(String urlString, String patchBody) {
        URI uri = null;
        try {
            LOGGER.debug("Patching: {}", (Object)urlString);
            ++countPatch;
            uri = new URI(urlString);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPatch request = new HttpPatch(uri);
            StringEntity params = new StringEntity(patchBody, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)params);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpResponse result = new HttpResponse(response.getStatusLine().getStatusCode());
            result.setResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            httpClient.close();
            return result;
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HttpResponse doJsonPatch(String urlString, String patchBody) {
        LOGGER.debug("Patching: {}", (Object)urlString);
        ++countPatch;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpResponse httpResponse;
            block14: {
                URI uri = new URI(urlString);
                HttpPatch request = new HttpPatch(uri);
                StringEntity params = new StringEntity(patchBody, APPLICATION_JSON_PATCH);
                request.setEntity((HttpEntity)params);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                try {
                    HttpResponse result = new HttpResponse(response.getStatusLine().getStatusCode());
                    result.setResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
                    httpResponse = result;
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return httpResponse;
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed to send JSON Patch.", (Throwable)e);
            return null;
        }
    }

    public static Object idFromSelfLink(String selfLink) {
        String idString = selfLink.substring(selfLink.indexOf("(") + 1, selfLink.indexOf(")"));
        if (idString.startsWith("'") && idString.endsWith("'")) {
            return idString.substring(1, idString.length() - 1);
        }
        try {
            return Long.parseLong(idString);
        }
        catch (NumberFormatException ex) {
            Assertions.fail((String)("Failed to parse returned ID (" + idString + "). String IDs must start and end with a single quote (')."));
            return idString;
        }
    }

    public static class HttpResponse {
        public final int code;
        public String response;

        public HttpResponse(int code) {
            this.code = code;
        }

        public HttpResponse(int code, String response) {
            this.code = code;
            this.response = response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public String toString() {
            return "HttpResponse: " + this.code + " " + this.response;
        }
    }
}

