/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.PathElement;
import de.fraunhofer.iosb.ilt.statests.util.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class Expand
implements Cloneable {
    private final List<PathElement> path = new ArrayList<PathElement>();
    private final Query query;

    public Expand() {
        this.query = new Query();
        this.query.setParent(this);
    }

    public Expand(Query query) {
        this.query = query;
        query.setParent(this);
    }

    public List<PathElement> getPath() {
        return this.path;
    }

    public Expand addElement(PathElement element) {
        this.path.add(element);
        return this;
    }

    public boolean isCollection() {
        return this.path.get(this.path.size() - 1).isCollection();
    }

    public EntityType getEntityType() {
        return this.path.get(this.path.size() - 1).getEntityType();
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstDone = false;
        for (PathElement element : this.path) {
            if (firstDone) {
                sb.append("/");
            } else {
                firstDone = true;
            }
            sb.append(element.toString());
        }
        if (!this.query.isEmpty()) {
            sb.append('(');
            sb.append(this.query.toString(true));
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean isToplevel() {
        return false;
    }

    public Expand reNest() {
        if (this.path.size() == 1) {
            return this;
        }
        this.query.reNestExpands();
        Query currentQuery = this.query;
        Expand currentExpand = null;
        for (int i = this.path.size() - 1; i >= 0; --i) {
            currentExpand = new Expand(currentQuery);
            currentExpand.addElement(this.path.get(i));
            currentQuery = new Query();
            currentQuery.addExpand(currentExpand);
        }
        return currentExpand;
    }

    public Expand clone() {
        Expand clone;
        try {
            clone = (Expand)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        for (PathElement item : this.path) {
            clone.path.add(item.clone());
        }
        clone.query.duplicate(this.query);
        return clone;
    }
}

