/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityCounts;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Expand;
import de.fraunhofer.iosb.ilt.statests.util.Extension;
import de.fraunhofer.iosb.ilt.statests.util.PathElement;
import de.fraunhofer.iosb.ilt.statests.util.Query;
import de.fraunhofer.iosb.ilt.statests.util.Request;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntityUtils.class.getName());

    private EntityUtils() {
    }

    public static ResultTestResult resultContains(EntityList<? extends Entity> result, Entity ... entities) {
        return EntityUtils.resultContains(result, new ArrayList<Entity>(Arrays.asList(entities)));
    }

    public static ResultTestResult resultContains(EntityList<? extends Entity> result, List<? extends Entity> expected) {
        long count = result.getCount();
        if (count != -1L && count != (long)expected.size()) {
            LOGGER.info("Result count ({}) not equal to expected count ({})", (Object)count, (Object)expected.size());
            return new ResultTestResult(false, "Result count " + count + " not equal to expected count (" + expected.size() + ")");
        }
        ArrayList<? extends Entity> testList = new ArrayList<Entity>(expected);
        Iterator it = result.fullIterator();
        while (it.hasNext()) {
            Entity next = (Entity)it.next();
            Entity inList = EntityUtils.findEntityIn(next, testList);
            if (testList.remove(inList)) continue;
            LOGGER.info("Entity with id {} found in result that is not expected.", (Object)next.getId());
            return new ResultTestResult(false, "Entity with id " + next.getId() + " found in result that is not expected.");
        }
        if (!testList.isEmpty()) {
            LOGGER.info("Expected entity not found in result.");
            return new ResultTestResult(false, testList.size() + " expected entities not in result.");
        }
        return new ResultTestResult(true, "Check ok.");
    }

    public static Entity findEntityIn(Entity entity, List<? extends Entity> entities) {
        Id id = entity.getId();
        for (Entity entity2 : entities) {
            if (!Objects.equals(entity2.getId(), id)) continue;
            return entity2;
        }
        return null;
    }

    public static void deleteAll(ServerVersion version, ServerSettings serverSettings, SensorThingsService sts) throws ServiceFailureException {
        EntityUtils.deleteAll(sts.things());
        EntityUtils.deleteAll(sts.locations());
        EntityUtils.deleteAll(sts.sensors());
        EntityUtils.deleteAll(sts.featuresOfInterest());
        EntityUtils.deleteAll(sts.observedProperties());
        EntityUtils.deleteAll(sts.observations());
        if (serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ)) {
            EntityUtils.deleteAll(sts.actuators());
            EntityUtils.deleteAll(sts.taskingCapabilities());
            EntityUtils.deleteAll(sts.tasks());
        }
    }

    public static <T extends Entity<T>> void deleteAll(BaseDao<T> doa) throws ServiceFailureException {
        boolean more = true;
        int count = 0;
        while (more) {
            EntityList entities = doa.query().list();
            if (entities.getCount() > 0L) {
                LOGGER.debug("{} to go.", (Object)entities.getCount());
            } else {
                more = false;
            }
            for (Entity entity : entities) {
                doa.delete(entity);
                ++count;
            }
        }
        LOGGER.debug("Deleted {} using {}.", (Object)count, (Object)doa.getClass().getName());
    }

    public static long findCountForRequest(Request request, EntityCounts entityCounts) {
        Object parentId = -1;
        long count = -1L;
        EntityType parentType = null;
        for (PathElement element : request.getPath()) {
            EntityType elementType = element.getEntityType();
            if (element.getId() != null) {
                parentId = element.getId();
                parentType = elementType;
                count = -1L;
                continue;
            }
            if (parentType == null) {
                if (!element.isCollection()) {
                    throw new IllegalArgumentException("Non-collection requested without parent.");
                }
                count = entityCounts.getCount(elementType);
                continue;
            }
            if (element.isCollection()) {
                count = entityCounts.getCount(parentType, parentId, elementType);
                parentType = null;
                parentId = -1;
                continue;
            }
            count = -1L;
        }
        return count;
    }

    public static void checkResponse(Set<Extension> extensions, JSONObject response, Request request, EntityCounts entityCounts) {
        try {
            if (request.isCollection()) {
                Long top;
                EntityUtils.checkCollection(extensions, response.getJSONArray("value"), request, entityCounts);
                Query expandQuery = request.getQuery();
                Boolean count = expandQuery.getCount();
                String countProperty = "@iot.count";
                if (count != null) {
                    String message;
                    if (count.booleanValue()) {
                        message = "Response should have property " + countProperty + " for request: '" + request.toString() + "'";
                        Assertions.assertTrue((boolean)response.has(countProperty), (String)message);
                    } else {
                        message = "Response should not have property " + countProperty + " for request: '" + request.toString() + "'";
                        Assertions.assertFalse((boolean)response.has(countProperty), (String)message);
                    }
                }
                long expectedCount = EntityUtils.findCountForRequest(request, entityCounts);
                if (response.has(countProperty) && expectedCount != -1L) {
                    long foundCount = response.getLong(countProperty);
                    String message = "Incorrect count for collection of " + request.getEntityType() + " for request: '" + request.toString() + "'";
                    Assertions.assertEquals((long)expectedCount, (long)foundCount, (String)message);
                }
                if ((top = expandQuery.getTop()) != null && expectedCount != -1L) {
                    long skip;
                    long expectedNumber;
                    int foundNumber = response.getJSONArray("value").length();
                    if ((long)foundNumber != (expectedNumber = Math.max(0L, Math.min(expectedCount - (skip = expandQuery.getSkip() == null ? 0L : expandQuery.getSkip()), top)))) {
                        Assertions.fail((String)("Requested " + top + " of " + expectedCount + ", expected " + expectedNumber + " with skip of " + skip + " but received " + foundNumber));
                    }
                    String nextLinkProperty = "@iot.nextLink";
                    if ((long)foundNumber + skip < expectedCount) {
                        String message = "Entity should have " + nextLinkProperty + " for request: '" + request.toString() + "'";
                        Assertions.assertTrue((boolean)response.has(nextLinkProperty), (String)message);
                    } else {
                        String message = "Entity should not have " + nextLinkProperty + " for request: '" + request.toString() + "'";
                        Assertions.assertFalse((boolean)response.has(nextLinkProperty), (String)message);
                    }
                }
            } else {
                EntityUtils.checkEntity(extensions, response, request, entityCounts);
            }
        }
        catch (JSONException ex) {
            String message = "Failure when checking response of query '" + request.getLastUrl() + "'";
            LOGGER.error(message, (Throwable)ex);
            Assertions.fail((String)message);
        }
    }

    public static void checkCollection(Set<Extension> extensions, JSONArray collection, Expand expand, EntityCounts entityCounts) throws JSONException {
        for (int i = 0; i < collection.length(); ++i) {
            EntityUtils.checkEntity(extensions, collection.getJSONObject(i), expand, entityCounts);
        }
    }

    public static void checkEntity(Set<Extension> extensions, JSONObject entity, Expand expand, EntityCounts entityCounts) throws JSONException {
        Iterator<String> message;
        EntityType entityType = expand.getEntityType();
        Query query = expand.getQuery();
        ArrayList<String> select = new ArrayList<String>(query.getSelect());
        if (select.isEmpty()) {
            select.add("id");
            select.addAll(entityType.getPropertyNames());
            if (expand.isToplevel()) {
                select.addAll(entityType.getRelations(extensions));
            }
        }
        if (select.contains("id")) {
            message = "Entity should have property @iot.id for request: '" + expand.toString() + "'";
            Assertions.assertTrue((boolean)entity.has("@iot.id"), (String)((Object)message));
        } else {
            message = "Entity should not have property @iot.id for request: '" + expand.toString() + "'";
            Assertions.assertFalse((boolean)entity.has("@iot.id"), (String)((Object)message));
        }
        for (EntityType.EntityProperty property : entityType.getProperties()) {
            String message2;
            if (select.contains(property.name)) {
                message2 = "Entity should have property " + property.name + " for request: '" + expand.toString() + "'";
                Assertions.assertTrue((entity.has(property.name) || property.optional ? 1 : 0) != 0, (String)message2);
                continue;
            }
            message2 = "Entity should not have property " + property.name + " for request: '" + expand.toString() + "'";
            Assertions.assertFalse((boolean)entity.has(property.name), (String)message2);
        }
        for (String relationName : entityType.getRelations(extensions)) {
            String message3;
            String propertyName = relationName + "@iot.navigationLink";
            if (select.contains(relationName)) {
                message3 = "Entity should have property " + propertyName + " for request: '" + expand.toString() + "'";
                Assertions.assertTrue((boolean)entity.has(propertyName), (String)message3);
                continue;
            }
            message3 = "Entity should not have property " + propertyName + " for request: '" + expand.toString() + "'";
            Assertions.assertFalse((boolean)entity.has(propertyName), (String)message3);
        }
        Object entityId = entity.opt("@iot.id");
        ArrayList<String> relations = new ArrayList<String>(entityType.getRelations(extensions));
        for (Expand subExpand : query.getExpand()) {
            String message4;
            long skip;
            long expectedNumber;
            Long top;
            PathElement path = subExpand.getPath().get(0);
            String propertyName = path.getPropertyName();
            if (!entity.has(propertyName)) {
                Assertions.fail((String)("Entity should have expanded " + propertyName + " for request: '" + expand.toString() + "'"));
            }
            if (subExpand.isCollection()) {
                EntityUtils.checkCollection(extensions, entity.getJSONArray(propertyName), subExpand, entityCounts);
            } else {
                EntityUtils.checkEntity(extensions, entity.getJSONObject(propertyName), subExpand, entityCounts);
            }
            relations.remove(propertyName);
            if (!subExpand.isCollection()) continue;
            Query expandQuery = subExpand.getQuery();
            Boolean count = expandQuery.getCount();
            String countProperty = propertyName + "@iot.count";
            boolean hasCountProperty = entity.has(countProperty);
            if (count != null) {
                if (count.booleanValue()) {
                    String message5 = "Entity should have property " + countProperty + " for request: '" + expand.toString() + "'";
                    Assertions.assertTrue((boolean)hasCountProperty, (String)message5);
                } else {
                    String message6 = "Entity should not have property " + countProperty + " for request: '" + expand.toString() + "'";
                    Assertions.assertFalse((boolean)hasCountProperty, (String)message6);
                }
            }
            long expectedCount = entityCounts.getCount(entityType, entityId, EntityType.getForRelation(propertyName));
            if (hasCountProperty && expectedCount != -1L) {
                long foundCount = entity.getLong(countProperty);
                String message7 = "Found incorrect count for " + countProperty;
                Assertions.assertEquals((long)expectedCount, (long)foundCount, (String)message7);
            }
            if ((top = expandQuery.getTop()) == null || expectedCount == -1L) continue;
            int foundNumber = entity.getJSONArray(propertyName).length();
            if ((long)foundNumber != (expectedNumber = Math.min(expectedCount - (skip = expandQuery.getSkip() == null ? 0L : expandQuery.getSkip()), top))) {
                Assertions.fail((String)("Requested " + top + " of " + expectedCount + ", expected " + expectedNumber + " with skip of " + skip + " but received " + foundNumber));
            }
            String nextLinkProperty = propertyName + "@iot.nextLink";
            if ((long)foundNumber + skip < expectedCount) {
                message4 = "Entity should have " + nextLinkProperty + " for expand " + subExpand.toString();
                Assertions.assertTrue((boolean)entity.has(nextLinkProperty), (String)message4);
                continue;
            }
            message4 = "Entity should have " + nextLinkProperty + " for expand " + subExpand.toString();
            Assertions.assertFalse((boolean)entity.has(nextLinkProperty), (String)message4);
        }
        for (String propertyName : relations) {
            if (!entity.has(propertyName)) continue;
            Assertions.fail((String)("Entity should not have expanded " + propertyName + " for request: '" + expand.toString() + "'"));
        }
    }

    public static String listEntities(List<? extends Entity> list) {
        StringBuilder result = new StringBuilder();
        for (Entity entity : list) {
            if (entity instanceof Observation) {
                result.append(((Observation)entity).getResult());
            } else {
                result.append(entity.getId());
            }
            result.append(", ");
        }
        if (result.length() == 0) {
            return "";
        }
        return result.substring(0, result.length() - 2);
    }

    public static <T extends Entity<T>> void testFilterResults(BaseDao<T> doa, String filter, List<T> expected) {
        try {
            EntityList result = doa.query().filter(filter).list();
            ResultTestResult check = EntityUtils.resultContains((EntityList<? extends Entity>)result, expected);
            String message = "Failed on filter: " + filter + " Cause: " + check.message;
            if (!check.testOk) {
                LOGGER.info("Failed filter: {}\nexpected {},\n     got {}.", new Object[]{filter, EntityUtils.listEntities(expected), EntityUtils.listEntities(result.toList())});
            }
            Assertions.assertTrue((boolean)check.testOk, (String)message);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Exception filtering doa {} using {} :", new Object[]{doa, filter, ex});
            Assertions.fail((String)("Failed to call service: " + ex.getMessage()));
        }
    }

    public static void filterForException(BaseDao doa, String filter, int expectedCode) {
        try {
            doa.query().filter(filter).list();
        }
        catch (StatusCodeException e) {
            String message = "Filter " + filter + " did not respond with " + expectedCode + ", but with " + e.getStatusCode() + ".";
            Assertions.assertEquals((int)expectedCode, (int)e.getStatusCode(), (String)message);
            return;
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Failed to call service for filter " + filter + " " + ex));
        }
        Assertions.fail((String)("Filter " + filter + " did not respond with " + expectedCode + "."));
    }

    public static class ResultTestResult {
        public final boolean testOk;
        public final String message;

        public ResultTestResult(boolean testOk, String message) {
            this.testOk = testOk;
            this.message = message;
        }
    }
}

