/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.util;

import de.fraunhofer.iosb.ilt.statests.util.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum EntityType {
    ACTUATOR("Actuator", "Actuators", Extension.ACTUATION),
    TASK("Task", "Tasks", Extension.ACTUATION),
    TASKING_CAPABILITY("TaskingCapability", "TaskingCapabilities", Extension.ACTUATION),
    THING("Thing", "Things"),
    LOCATION("Location", "Locations"),
    SENSOR("Sensor", "Sensors"),
    OBSERVED_PROPERTY("ObservedProperty", "ObservedProperties"),
    OBSERVATION("Observation", "Observations"),
    DATASTREAM("Datastream", "Datastreams"),
    FEATURE_OF_INTEREST("FeatureOfInterest", "FeaturesOfInterest"),
    HISTORICAL_LOCATION("HistoricalLocation", "HistoricalLocations");

    public final String singular;
    public final String plural;
    public final Extension extension;
    private final List<EntityProperty> properties = new ArrayList<EntityProperty>();
    private final Map<String, EntityProperty> propertiesByName = new HashMap<String, EntityProperty>();
    private final Map<String, EntityProperty> editablePropertiesByName = new HashMap<String, EntityProperty>();
    private final Map<Extension, List<String>> relations = new EnumMap<Extension, List<String>>(Extension.class);
    private static final Map<String, EntityType> NAMES_MAP;
    private static final Set<String> NAMES_PLURAL;

    public static EntityType getForRelation(String relation) {
        EntityType entityType = NAMES_MAP.get(relation);
        if (entityType == null) {
            throw new IllegalArgumentException("Unknown relation: " + relation);
        }
        return entityType;
    }

    public static boolean isPlural(String relation) {
        return NAMES_PLURAL.contains(relation);
    }

    private EntityType(String singular, String plural) {
        this.extension = Extension.CORE;
        this.singular = singular;
        this.plural = plural;
    }

    private EntityType(String singular, String plural, Extension extension) {
        this.extension = extension;
        this.singular = singular;
        this.plural = plural;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getRootEntitySet() {
        return this.plural;
    }

    public List<String> getRelations(Extension extension) {
        return this.relations.getOrDefault((Object)extension, Collections.emptyList());
    }

    public List<String> getRelations(Set<Extension> extensions) {
        ArrayList<String> value = new ArrayList<String>();
        for (Extension extension : extensions) {
            value.addAll(this.relations.getOrDefault((Object)extension, Collections.emptyList()));
        }
        return value;
    }

    public List<EntityProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Set<String> getPropertyNames() {
        return this.propertiesByName.keySet();
    }

    public Set<String> getEditablePropertyNames() {
        return this.editablePropertiesByName.keySet();
    }

    public EntityProperty getPropertyForName(String property) {
        return this.propertiesByName.get(property);
    }

    public void getHalfPropertiesRelations(Set<Extension> extensions, List<String> target, boolean even) {
        target.clear();
        target.add("id");
        boolean isEven = true;
        for (EntityProperty property : this.properties) {
            if (even == isEven) {
                target.add(property.name);
            }
            isEven = !isEven;
        }
        for (String relation : this.getRelations(extensions)) {
            if (even == isEven) {
                target.add(relation);
            }
            isEven = !isEven;
        }
    }

    private void addProperty(String name, boolean optional, boolean canSort) {
        this.addProperty(name, optional, canSort, true, "string");
    }

    private void addProperty(String name, boolean optional, boolean canSort, String jsonType) {
        this.addProperty(name, optional, canSort, true, jsonType);
    }

    private void addProperty(String name, boolean optional, boolean canSort, boolean canEdit, String jsonType) {
        EntityProperty property = new EntityProperty(name, optional, canSort, jsonType);
        this.properties.add(property);
        this.propertiesByName.put(name, property);
        if (canEdit) {
            this.editablePropertiesByName.put(name, property);
        }
    }

    private void addRelations(Extension extension, String ... relations) {
        this.relations.computeIfAbsent(extension, t -> new ArrayList()).addAll(Arrays.asList(relations));
    }

    static {
        NAMES_MAP = new HashMap<String, EntityType>();
        NAMES_PLURAL = new HashSet<String>();
        ACTUATOR.addProperty("name", false, true);
        ACTUATOR.addProperty("description", false, true);
        ACTUATOR.addProperty("encodingType", false, true);
        ACTUATOR.addProperty("metadata", false, true);
        ACTUATOR.addRelations(Extension.ACTUATION, EntityType.TASKING_CAPABILITY.plural);
        TASK.addProperty("creationTime", false, true);
        TASK.addProperty("taskingParameters", false, false, "object");
        TASK.addRelations(Extension.ACTUATION, EntityType.TASKING_CAPABILITY.singular);
        TASKING_CAPABILITY.addProperty("name", false, true);
        TASKING_CAPABILITY.addProperty("description", false, true);
        TASKING_CAPABILITY.addProperty("properties", true, false, "object");
        TASKING_CAPABILITY.addProperty("taskingParameters", false, false, "object");
        TASKING_CAPABILITY.addRelations(Extension.ACTUATION, EntityType.THING.singular, EntityType.ACTUATOR.singular, EntityType.TASK.plural);
        THING.addProperty("name", false, true);
        THING.addProperty("description", false, true);
        THING.addProperty("properties", true, false, "object");
        THING.addRelations(Extension.CORE, EntityType.DATASTREAM.plural, EntityType.HISTORICAL_LOCATION.plural, EntityType.LOCATION.plural);
        THING.addRelations(Extension.ACTUATION, EntityType.TASKING_CAPABILITY.plural);
        LOCATION.addProperty("name", false, true);
        LOCATION.addProperty("description", false, true);
        LOCATION.addProperty("encodingType", false, true);
        LOCATION.addProperty("location", false, false, "object");
        LOCATION.addRelations(Extension.CORE, EntityType.HISTORICAL_LOCATION.plural, EntityType.THING.plural);
        SENSOR.addProperty("name", false, true);
        SENSOR.addProperty("description", false, true);
        SENSOR.addProperty("encodingType", false, true);
        SENSOR.addProperty("metadata", false, true);
        SENSOR.addRelations(Extension.CORE, EntityType.DATASTREAM.plural);
        OBSERVED_PROPERTY.addProperty("name", false, true);
        OBSERVED_PROPERTY.addProperty("definition", false, true);
        OBSERVED_PROPERTY.addProperty("description", false, true);
        OBSERVED_PROPERTY.addRelations(Extension.CORE, EntityType.DATASTREAM.plural);
        OBSERVATION.addProperty("phenomenonTime", false, true);
        OBSERVATION.addProperty("result", false, true, "any");
        OBSERVATION.addProperty("resultTime", false, true);
        OBSERVATION.addProperty("resultQuality", true, true);
        OBSERVATION.addProperty("validTime", true, true);
        OBSERVATION.addProperty("parameters", true, true, "object");
        OBSERVATION.addRelations(Extension.CORE, EntityType.DATASTREAM.singular, EntityType.FEATURE_OF_INTEREST.singular);
        DATASTREAM.addProperty("name", false, true);
        DATASTREAM.addProperty("description", false, true);
        DATASTREAM.addProperty("unitOfMeasurement", false, false, true, "object");
        DATASTREAM.addProperty("observationType", false, true);
        DATASTREAM.addProperty("observedArea", true, false, false, "object");
        DATASTREAM.addProperty("phenomenonTime", true, true, false, "string");
        DATASTREAM.addProperty("resultTime", true, true, false, "string");
        DATASTREAM.addRelations(Extension.CORE, EntityType.THING.singular, EntityType.SENSOR.singular, EntityType.OBSERVED_PROPERTY.singular, EntityType.OBSERVATION.plural);
        FEATURE_OF_INTEREST.addProperty("name", false, true);
        FEATURE_OF_INTEREST.addProperty("description", false, true);
        FEATURE_OF_INTEREST.addProperty("encodingType", false, true);
        FEATURE_OF_INTEREST.addProperty("feature", false, false, "object");
        FEATURE_OF_INTEREST.addRelations(Extension.CORE, EntityType.OBSERVATION.plural);
        HISTORICAL_LOCATION.addProperty("time", false, true);
        HISTORICAL_LOCATION.addRelations(Extension.CORE, EntityType.THING.singular, EntityType.LOCATION.plural);
        for (EntityType entityType : EntityType.values()) {
            NAMES_MAP.put(entityType.singular, entityType);
            NAMES_MAP.put(entityType.plural, entityType);
            NAMES_PLURAL.add(entityType.plural);
        }
    }

    public static class EntityProperty {
        public final String name;
        public final boolean optional;
        public final boolean canSort;
        public final String jsonType;

        public EntityProperty(String name, boolean optional, boolean canSort, String jsonType) {
            this.name = name;
            this.optional = optional;
            this.canSort = canSort;
            this.jsonType = jsonType;
        }

        public String toString() {
            return this.name;
        }
    }
}

