/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.f01auth;

import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.TestSuite;
import de.fraunhofer.iosb.ilt.statests.f01auth.AbstractAuthTests;
import java.net.URL;
import java.util.Properties;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicAuthTests
extends AbstractAuthTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthTests.class);
    private static final Properties SERVER_PROPERTIES = new Properties();

    public BasicAuthTests(ServerVersion version) {
        super(version, SERVER_PROPERTIES, false);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)BasicAuthTests.version.urlPart);
        super.setUpVersion();
    }

    @Override
    public SensorThingsService getServiceAdmin() {
        return BasicAuthTests.setAuth(this.createService(), "admin", "admin");
    }

    @Override
    public SensorThingsService getServiceWrite() {
        return BasicAuthTests.setAuth(this.createService(), "write", "write");
    }

    @Override
    public SensorThingsService getServiceRead() {
        return BasicAuthTests.setAuth(this.createService(), "read", "read");
    }

    @Override
    public SensorThingsService getServiceAnonymous() {
        return this.createService();
    }

    public static SensorThingsService setAuth(SensorThingsService service, String username, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        URL url = service.getEndpoint();
        credsProvider.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        service.getClientBuilder().setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        service.rebuildHttpClient();
        return service;
    }

    static {
        SERVER_PROPERTIES.put("auth_provider", "de.fraunhofer.iosb.ilt.frostserver.auth.basic.BasicAuthProvider");
        SERVER_PROPERTIES.put("auth_allowAnonymousRead", "false");
        SERVER_PROPERTIES.put("auth_autoUpdateDatabase", "true");
        SERVER_PROPERTIES.put("auth_db_driver", "org.postgresql.Driver");
        SERVER_PROPERTIES.put("auth_db_url", TestSuite.getInstance().getPgConnectUrl());
        SERVER_PROPERTIES.put("auth_db_username", "sensorthings");
        SERVER_PROPERTIES.put("auth_db_password", "ChangeMe");
    }

    public static class Implementation11
    extends BasicAuthTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends BasicAuthTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

