/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.f01auth;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class AbstractAuthTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthTests.class);
    private static final String ADMIN_SHOULD_BE_ABLE_TO_CREATE = "Admin should be able to create.";
    private static final String ADMIN_SHOULD_BE_ABLE_TO_UPDATE = "Admin should be able to update.";
    private static final String ADMIN_SHOULD_BE_ABLE_TO_DELETE = "Admin should be able to delete.";
    private static final String WRITE_SHOULD_BE_ABLE_TO_CREATE = "Write should be able to create.";
    private static final String WRITE_SHOULD_BE_ABLE_TO_UPDATE = "Write should be able to update.";
    private static final String WRITE_SHOULD_NOT_BE_ABLE_TO_DELETE = "Write should NOT be able to delete.";
    private static final String READ_SHOULD_NOT_BE_ABLE_TO_CREATE = "read should NOT be able to create.";
    private static final String READ_SHOULD_NOT_BE_ABLE_TO_UPDATE = "read should NOT be able to update.";
    private static final String READ_SHOULD_NOT_BE_ABLE_TO_DELETE = "read should NOT be able to delete.";
    private static final String ANON_SHOULD_NOT_BE_ABLE_TO_READ = "anon should NOT be able to read.";
    private static final String ANON_SHOULD_NOT_BE_ABLE_TO_CREATE = "anon should NOT be able to create.";
    private static final String ANON_SHOULD_NOT_BE_ABLE_TO_UPDATE = "anon should NOT be able to update.";
    private static final String ANON_SHOULD_NOT_BE_ABLE_TO_DELETE = "anon should NOT be able to delete.";
    private static final int HTTP_CODE_200_OK = 200;
    private static final int HTTP_CODE_401_UNAUTHORIZED = 401;
    private static final int HTTP_CODE_403_FORBIDDEN = 403;
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> O_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();
    private static SensorThingsService serviceAdmin;
    private static SensorThingsService serviceWrite;
    private static SensorThingsService serviceRead;
    private static SensorThingsService serviceAnon;
    private final boolean anonymousReadAllowed;

    public AbstractAuthTests(ServerVersion serverVersion, Properties properties, boolean anonymousReadAllowed) {
        super(serverVersion, properties);
        this.anonymousReadAllowed = anonymousReadAllowed;
    }

    @Override
    protected void setUpVersion() {
        serviceAdmin = this.getServiceAdmin();
        serviceWrite = this.getServiceWrite();
        serviceRead = this.getServiceRead();
        serviceAnon = this.getServiceAnonymous();
    }

    protected SensorThingsService createService() {
        try {
            return new SensorThingsService(new URL(serverSettings.getServiceUrl(version)));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Serversettings contains malformed URL.", ex);
        }
    }

    public abstract SensorThingsService getServiceAdmin();

    public abstract SensorThingsService getServiceWrite();

    public abstract SensorThingsService getServiceRead();

    public abstract SensorThingsService getServiceAnonymous();

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        AbstractAuthTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        AbstractAuthTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, serviceAdmin);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        O_PROPS.clear();
        DATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    @Test
    void test01AdminUpdateDb() throws IOException {
        LOGGER.info("  test01AdminUpdateDb");
        this.getDatabaseStatus(serviceAdmin, 200);
    }

    @Test
    void test02WriteUpdateDb() throws IOException {
        LOGGER.info("  test02WriteUpdateDb");
        this.getDatabaseStatus(serviceWrite, 401, 403);
    }

    @Test
    void test03ReadUpdateDb() throws IOException {
        LOGGER.info("  test03ReadUpdateDb");
        this.getDatabaseStatus(serviceRead, 401, 403);
    }

    @Test
    void test04AnonUpdateDb() throws IOException {
        LOGGER.info("  test04AnonUpdateDb");
        this.getDatabaseStatus(serviceAnon, 401, 403);
    }

    private void getDatabaseStatus(SensorThingsService service, int ... expectedResponse) throws IOException {
        HttpGet getUpdateDb = new HttpGet(service.getEndpoint() + "../DatabaseStatus");
        CloseableHttpResponse response = service.execute((HttpRequestBase)getUpdateDb);
        int code = response.getStatusLine().getStatusCode();
        for (int expected : expectedResponse) {
            if (expected != code) continue;
            return;
        }
        LOGGER.info("Failed response: {}", (Object)org.apache.http.util.EntityUtils.toString((HttpEntity)response.getEntity()));
        Assertions.fail((String)("Unexpected return code: " + code + ", expected one of " + Arrays.toString(expectedResponse)));
    }

    private void expectStatusCodeException(String failMessage, Exception ex, int ... expected) {
        if (ex instanceof StatusCodeException) {
            StatusCodeException scex = (StatusCodeException)((Object)ex);
            int got = scex.getStatusCode();
            for (int want : expected) {
                if (got != want) continue;
                return;
            }
        }
        LOGGER.error(failMessage, (Throwable)ex);
        Assertions.fail((String)failMessage);
    }

    @Test
    void test05AdminCreate() {
        LOGGER.info("  test05AdminCreate");
        Thing thing = new Thing("AdminThing", "The Thing made by admin.");
        THINGS.add(thing);
        try {
            serviceAdmin.create((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error(ADMIN_SHOULD_BE_ABLE_TO_CREATE, (Throwable)ex);
            Assertions.fail((String)ADMIN_SHOULD_BE_ABLE_TO_CREATE);
        }
    }

    @Test
    void test06AdminRead() {
        LOGGER.info("  test06AdminRead");
        EntityUtils.testFilterResults(serviceAdmin.things(), "", THINGS);
    }

    @Test
    void test07AdminUpdate() {
        LOGGER.info("  test07AdminUpdate");
        Thing thing = THINGS.get(0);
        thing.setDescription("Updated Thing made by admin.");
        try {
            serviceAdmin.update((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error(ADMIN_SHOULD_BE_ABLE_TO_UPDATE, (Throwable)ex);
            Assertions.fail((String)ADMIN_SHOULD_BE_ABLE_TO_UPDATE);
        }
        EntityUtils.testFilterResults(serviceAdmin.things(), "", THINGS);
    }

    @Test
    void test08AdminDelete() {
        LOGGER.info("  test08AdminDelete");
        Thing thing = THINGS.get(0);
        THINGS.remove(0);
        try {
            serviceAdmin.delete((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error(ADMIN_SHOULD_BE_ABLE_TO_DELETE, (Throwable)ex);
            Assertions.fail((String)ADMIN_SHOULD_BE_ABLE_TO_DELETE);
        }
        EntityUtils.testFilterResults(serviceAdmin.things(), "", THINGS);
    }

    @Test
    void test09WriteCreate() {
        LOGGER.info("  test09WriteCreate");
        Thing thing = new Thing("WriteThing", "The Thing made by write.");
        THINGS.add(thing);
        try {
            serviceWrite.create((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error(WRITE_SHOULD_BE_ABLE_TO_CREATE, (Throwable)ex);
            Assertions.fail((String)WRITE_SHOULD_BE_ABLE_TO_CREATE);
        }
    }

    @Test
    void test10WriteRead() {
        LOGGER.info("  test10WriteRead");
        EntityUtils.testFilterResults(serviceWrite.things(), "", THINGS);
    }

    @Test
    void test11WriteUpdate() {
        LOGGER.info("  test11WriteUpdate");
        Thing thing = THINGS.get(0);
        thing.setDescription("Updated Thing made by write.");
        try {
            serviceWrite.update((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error(WRITE_SHOULD_BE_ABLE_TO_UPDATE, (Throwable)ex);
            Assertions.fail((String)WRITE_SHOULD_BE_ABLE_TO_UPDATE);
        }
        EntityUtils.testFilterResults(serviceWrite.things(), "", THINGS);
    }

    @Test
    void test12WriteDelete() {
        LOGGER.info("  test12WriteDelete");
        Thing thing = THINGS.get(0);
        try {
            serviceWrite.delete((Entity)thing);
            Assertions.fail((String)WRITE_SHOULD_NOT_BE_ABLE_TO_DELETE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(WRITE_SHOULD_NOT_BE_ABLE_TO_DELETE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceWrite.things(), "", THINGS);
    }

    @Test
    void test13ReadCreate() {
        LOGGER.info("  test13ReadCreate");
        Thing thing = new Thing("ReadThing", "The Thing made by read.");
        try {
            serviceRead.create((Entity)thing);
            Assertions.fail((String)READ_SHOULD_NOT_BE_ABLE_TO_CREATE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(READ_SHOULD_NOT_BE_ABLE_TO_CREATE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test14ReadRead() {
        LOGGER.info("  test14ReadRead");
        Thing thing = new Thing("WriteThing", "The Thing made by write.");
        THINGS.add(thing);
        try {
            serviceWrite.create((Entity)thing);
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to create test entity.");
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test15ReadUpdate() {
        LOGGER.info("  test15ReadUpdate");
        Thing thing = THINGS.get(0).withOnlyId();
        thing.setDescription("Read Updated Thing made by Admin.");
        try {
            serviceRead.update((Entity)thing);
            Assertions.fail((String)READ_SHOULD_NOT_BE_ABLE_TO_UPDATE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(READ_SHOULD_NOT_BE_ABLE_TO_UPDATE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test16ReadDelete() {
        LOGGER.info("  test16ReadDelete");
        Thing thing = THINGS.get(0);
        try {
            serviceRead.delete((Entity)thing);
            Assertions.fail((String)READ_SHOULD_NOT_BE_ABLE_TO_DELETE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(READ_SHOULD_NOT_BE_ABLE_TO_DELETE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test17AnonCreate() {
        LOGGER.info("  test17AnonCreate");
        Thing thing = new Thing("AnonThing", "The Thing made by anonymous.");
        try {
            serviceAnon.create((Entity)thing);
            Assertions.fail((String)ANON_SHOULD_NOT_BE_ABLE_TO_CREATE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(ANON_SHOULD_NOT_BE_ABLE_TO_CREATE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test18AnonRead() {
        LOGGER.info("  test18AnonRead");
        if (this.anonymousReadAllowed) {
            EntityUtils.testFilterResults(serviceAnon.things(), "", THINGS);
        } else {
            try {
                serviceAnon.things().query().list();
                Assertions.fail((String)ANON_SHOULD_NOT_BE_ABLE_TO_READ);
            }
            catch (ServiceFailureException ex) {
                this.expectStatusCodeException(ANON_SHOULD_NOT_BE_ABLE_TO_READ, (Exception)((Object)ex), 401, 403);
            }
        }
    }

    @Test
    void test19AnonUpdate() {
        LOGGER.info("  test19AnonUpdate");
        Thing thing = THINGS.get(0).withOnlyId();
        thing.setDescription("Anon Updated Thing made by Admin.");
        try {
            serviceAnon.update((Entity)thing);
            Assertions.fail((String)ANON_SHOULD_NOT_BE_ABLE_TO_UPDATE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(ANON_SHOULD_NOT_BE_ABLE_TO_UPDATE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }

    @Test
    void test20AnonDelete() {
        LOGGER.info("  test20AnonDelete");
        Thing thing = THINGS.get(0);
        try {
            serviceAnon.delete((Entity)thing);
            Assertions.fail((String)ANON_SHOULD_NOT_BE_ABLE_TO_DELETE);
        }
        catch (ServiceFailureException ex) {
            this.expectStatusCodeException(ANON_SHOULD_NOT_BE_ABLE_TO_DELETE, (Exception)((Object)ex), 401, 403);
        }
        EntityUtils.testFilterResults(serviceRead.things(), "", THINGS);
    }
}

