/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c08mqttsubscribe;

import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityHelper;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.DeepInsertInfo;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttBatchResult;
import de.fraunhofer.iosb.ilt.statests.util.mqtt.MqttHelper;
import java.net.URI;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.time4j.range.MomentInterval;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class Capability8Tests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(Capability8Tests.class);
    private static final List<EntityType> ENTITY_TYPES_FOR_CREATE = Arrays.asList(EntityType.THING, EntityType.LOCATION, EntityType.SENSOR, EntityType.OBSERVED_PROPERTY, EntityType.FEATURE_OF_INTEREST, EntityType.DATASTREAM, EntityType.OBSERVATION, EntityType.HISTORICAL_LOCATION);
    private static final List<EntityType> ENTITY_TYPES_FOR_DEEP_INSERT = Arrays.asList(EntityType.THING, EntityType.DATASTREAM, EntityType.OBSERVATION);
    private static final Map<EntityType, Object> IDS = new HashMap<EntityType, Object>();
    private static EntityHelper entityHelper;
    private static MqttHelper mqttHelper;

    public Capability8Tests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)Capability8Tests.version.urlPart);
        entityHelper = new EntityHelper(version, serverSettings);
        mqttHelper = new MqttHelper(version, serverSettings.getMqttUrl(), serverSettings.getMqttTimeOut());
    }

    @Override
    protected void tearDownVersion() {
        entityHelper.deleteEverything();
        entityHelper = null;
        mqttHelper = null;
        IDS.clear();
    }

    @AfterAll
    public static void tearDown() {
        LOGGER.info("Tearing down.");
        entityHelper.deleteEverything();
        entityHelper = null;
        mqttHelper = null;
        IDS.clear();
    }

    @Test
    void check01SubscribeToEntitySetInsert() {
        LOGGER.info("  checkSubscribeToEntitySetInsert");
        this.deleteCreatedEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.debug("    {}", (Object)entityType);
            MqttBatchResult<Object> result = mqttHelper.executeRequests(this.getInsertEntityAction((EntityType)((Object)entityType)), mqttHelper.getTopic((EntityType)((Object)entityType)));
            IDS.put((EntityType)((Object)entityType), result.getActionResult());
            Capability8Tests.assertJsonEqualsWithLinkResolving(entityHelper.getEntity((EntityType)((Object)entityType), result.getActionResult()), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType)));
        });
        LOGGER.debug("    FoI creation");
        entityHelper.deleteEntityType(EntityType.OBSERVATION);
        IDS.remove((Object)EntityType.OBSERVATION);
        entityHelper.deleteEntityType(EntityType.FEATURE_OF_INTEREST);
        IDS.remove((Object)EntityType.FEATURE_OF_INTEREST);
        MqttBatchResult<Object> result = mqttHelper.executeRequests(this.getInsertEntityAction(EntityType.OBSERVATION), mqttHelper.getTopic(EntityType.OBSERVATION), mqttHelper.getTopic(EntityType.FEATURE_OF_INTEREST));
        IDS.put(EntityType.OBSERVATION, result.getActionResult());
    }

    @Test
    void check02SubscribeToEntitySetUpdatePATCH() {
        LOGGER.info("  checkSubscribeToEntitySetUpdatePATCH");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePatchEntityAction((EntityType)((Object)entityType)), mqttHelper.getTopic((EntityType)((Object)entityType)));
            Capability8Tests.assertJsonEqualsWithLinkResolving(result.getActionResult(), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType)));
        });
    }

    @Test
    void check03SubscribeToEntitySetUpdatePUT() {
        LOGGER.info("  checkSubscribeToEntitySetUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePutEntityAction((EntityType)((Object)entityType)), mqttHelper.getTopic((EntityType)((Object)entityType)));
            Capability8Tests.assertJsonEqualsWithLinkResolving(result.getActionResult(), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType)));
        });
    }

    @Test
    void check04SubscribeToEntitySetWithMultipleSelectInsert() {
        LOGGER.info("  checkSubscribeToEntitySetWithMultipleSelectInsert");
        this.deleteCreatedEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            List<String> selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), true);
            this.checkSubscribeSelectInsert((EntityType)((Object)entityType), selectedProperties);
            selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), false);
            this.checkSubscribeSelectInsert((EntityType)((Object)entityType), selectedProperties);
        });
    }

    @Test
    void check05SubscribeToEntitySetWithMultipleSelectUpdatePATCH() {
        LOGGER.info("  checkSubscribeToEntitySetWithMultipleSelectUpdatePATCH");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            List<String> selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), true);
            this.checkSubscribePatch((EntityType)((Object)entityType), selectedProperties);
            selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), false);
            this.checkSubscribePatch((EntityType)((Object)entityType), selectedProperties);
        });
    }

    @Test
    void check06SubscribeToEntitySetWithMultipleSelectUpdatePUT() {
        LOGGER.info("  checkSubscribeToEntitySetWithMultipleSelectUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            List<String> selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), true);
            this.checkSubscribePut((EntityType)((Object)entityType), selectedProperties);
            selectedProperties = this.getSelectedProperties((EntityType)((Object)entityType), false);
            this.checkSubscribePut((EntityType)((Object)entityType), selectedProperties);
        });
    }

    @Test
    void check07SubscribeToEntitySetWithRelativeTopicUpdatePUT() {
        LOGGER.info("  checkSubscribeToEntitySetWithRelativeTopicUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            List<String> relativeTopics = mqttHelper.getRelativeTopicsForEntitySet((EntityType)((Object)entityType), IDS);
            if (!relativeTopics.isEmpty()) {
                MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePutEntityAction((EntityType)((Object)entityType)), relativeTopics.toArray(new String[relativeTopics.size()]));
                result.getMessages().entrySet().stream().forEach(entry -> {
                    try {
                        Object lastestId = entityHelper.getLastestEntityId((EntityType)((Object)entityType));
                        String filter = "id%20eq%20" + Utils.quoteIdForUrl(lastestId);
                        JSONObject expectedResult = entityHelper.getEntity((String)entry.getKey() + "?$filter=" + filter).getJSONArray("value").getJSONObject(0);
                        Capability8Tests.assertJsonEqualsWithLinkResolving(expectedResult, (JSONObject)entry.getValue(), (String)entry.getKey());
                    }
                    catch (JSONException ex) {
                        LOGGER.error("Exception:", (Throwable)ex);
                        Assertions.fail((String)("Could not get expected result for MQTT subscription from server: " + ex.getMessage()));
                    }
                });
            }
        });
    }

    @Test
    void check08SubscribeToEntitySetsWithDeepInsert() {
        LOGGER.info("  checkSubscribeToEntitySetsWithDeepInsert");
        this.deleteCreatedEntities();
        ENTITY_TYPES_FOR_DEEP_INSERT.stream().forEach(entityType -> {
            MqttHelper.waitMillis(500L);
            LOGGER.info("    {}", (Object)entityType);
            DeepInsertInfo deepInsertInfo = entityHelper.getDeepInsertInfo((EntityType)((Object)entityType));
            ArrayList<String> topics = new ArrayList<String>(deepInsertInfo.getSubEntityTypes().size() + 1);
            topics.add(mqttHelper.getTopic(deepInsertInfo.getEntityType()));
            deepInsertInfo.getSubEntityTypes().stream().forEach(subType -> topics.add(mqttHelper.getTopic((EntityType)((Object)((Object)subType)))));
            MqttBatchResult<Object> result = mqttHelper.executeRequests(this.getDeepInsertEntityAction((EntityType)((Object)entityType)), topics.toArray(new String[topics.size()]));
            IDS.put((EntityType)((Object)entityType), result.getActionResult());
            JSONObject entity = entityHelper.getEntity(deepInsertInfo.getEntityType(), result.getActionResult());
            Optional<JSONObject> rootResult = result.getMessages().entrySet().stream().filter(x -> ((String)x.getKey()).equals(mqttHelper.getTopic(deepInsertInfo.getEntityType()))).map(x -> (JSONObject)x.getValue()).findFirst();
            if (!rootResult.isPresent()) {
                Assertions.fail((String)"Deep insert MQTT result is missing root entity");
            }
            Capability8Tests.assertJsonEqualsWithLinkResolving(entity, rootResult.get(), mqttHelper.getTopic(deepInsertInfo.getEntityType()));
            deepInsertInfo.getSubEntityTypes().stream().forEach(subType -> {
                JSONObject subEntity = this.getSubEntityByRoot(deepInsertInfo.getEntityType(), result.getActionResult(), (EntityType)((Object)((Object)subType)));
                Optional<JSONObject> subResult = result.getMessages().entrySet().stream().filter(x -> ((String)x.getKey()).equals(mqttHelper.getTopic((EntityType)((Object)((Object)subType))))).map(x -> (JSONObject)x.getValue()).findFirst();
                if (!subResult.isPresent()) {
                    Assertions.fail((String)("Deep insert MQTT result is missing entity " + subEntity.toString()));
                }
                Capability8Tests.assertJsonEqualsWithLinkResolving(subEntity, subResult.get(), mqttHelper.getTopic((EntityType)((Object)((Object)subType))));
            });
        });
    }

    @Test
    void check09SubscribeToEntityUpdatePATCH() {
        LOGGER.info("  checkSubscribeToEntityUpdatePATCH");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePatchEntityAction((EntityType)((Object)entityType)), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType)));
            Capability8Tests.assertJsonEqualsWithLinkResolving(result.getActionResult(), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType)));
        });
    }

    @Test
    void check10SubscribeToEntityUpdatePUT() {
        LOGGER.info("  checkSubscribeToEntityUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePutEntityAction((EntityType)((Object)entityType)), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType)));
            Capability8Tests.assertJsonEqualsWithLinkResolving(result.getActionResult(), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType)));
        });
    }

    @Test
    void check11SubscribeToEntityWithRelativeTopicUpdatePUT() {
        LOGGER.info("  checkSubscribeToEntityWithRelativeTopicUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            List<String> relativeTopics = mqttHelper.getRelativeTopicsForEntity((EntityType)((Object)entityType), IDS);
            if (!relativeTopics.isEmpty()) {
                MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(this.getUpdatePutEntityAction((EntityType)((Object)entityType)), relativeTopics.toArray(new String[relativeTopics.size()]));
                result.getMessages().entrySet().stream().forEach(entry -> {
                    JSONObject expectedResult = entityHelper.getEntity((String)entry.getKey());
                    Capability8Tests.assertJsonEqualsWithLinkResolving(expectedResult, (JSONObject)entry.getValue(), (String)entry.getKey());
                });
            }
        });
    }

    @Test
    void check12SubscribeToPropertyUpdatePATCH() {
        LOGGER.info("  checkSubscribeToPropertyUpdatePATCH");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            Map<String, Object> changes = entityHelper.getEntityChanges((EntityType)((Object)entityType));
            for (String property : entityType.getPropertyNames()) {
                HashMap<String, Object> propertyChange = new HashMap<String, Object>(0);
                Object change = changes.get(property);
                if (change == null) continue;
                propertyChange.put(property, change);
                MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(() -> entityHelper.patchEntity((EntityType)((Object)entityType), (Map<String, Object>)propertyChange, IDS.get(entityType)), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType), property));
                Capability8Tests.assertJsonEqualsWithLinkResolving(new JSONObject(propertyChange), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType), property));
            }
        });
    }

    @Test
    void check13SubscribeToPropertyUpdatePUT() {
        LOGGER.info("  checkSubscribeToPropertyUpdatePUT");
        this.deleteCreatedEntities();
        this.createEntities();
        MqttHelper.waitMillis(500L);
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            LOGGER.info("    {}", (Object)entityType);
            Map<String, Object> changes = entityHelper.getEntityChanges((EntityType)((Object)entityType));
            for (String property : entityType.getPropertyNames()) {
                HashMap<String, Object> propertyChange = new HashMap<String, Object>(0);
                Object change = changes.get(property);
                if (change == null) continue;
                propertyChange.put(property, change);
                MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(() -> entityHelper.putEntity((EntityType)((Object)entityType), (Map<String, Object>)propertyChange, IDS.get(entityType)), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType), property));
                Capability8Tests.assertJsonEqualsWithLinkResolving(new JSONObject(propertyChange), result.getMessages().values().iterator().next(), mqttHelper.getTopic((EntityType)((Object)entityType), IDS.get(entityType), property));
            }
        });
    }

    @Test
    void check14SubscribeToHistoricalLocationSetUpdateThingLocations() {
        LOGGER.info("  checkSubscribeToHistoricalLocationSetUpdateThingLocations");
        this.deleteCreatedEntities();
        this.createEntities();
        try {
            Object locId2 = this.getInsertEntityAction(EntityType.LOCATION).call();
            MqttHelper.waitMillis(500L);
            Callable<JSONObject> updateLocationOfThing = () -> entityHelper.patchEntity(EntityType.THING, entityHelper.getThingChangesLocation(locId2), IDS.get((Object)EntityType.THING));
            MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(updateLocationOfThing, mqttHelper.getTopic(EntityType.HISTORICAL_LOCATION));
            JSONObject lastHistLoc = entityHelper.getAnyEntity(EntityType.HISTORICAL_LOCATION, "$orderby=time%20desc", 10);
            Capability8Tests.assertJsonEqualsWithLinkResolving(lastHistLoc, result.getMessages().values().iterator().next(), mqttHelper.getTopic(EntityType.HISTORICAL_LOCATION));
        }
        catch (Exception ex) {
            Assertions.fail((String)("Could not create second Location: " + ex.getMessage()));
        }
    }

    private void createEntities() {
        ENTITY_TYPES_FOR_CREATE.stream().forEach(entityType -> {
            try {
                IDS.put((EntityType)((Object)entityType), this.getInsertEntityAction((EntityType)((Object)entityType)).call());
            }
            catch (Exception ex) {
                Assertions.fail((String)"Could not create entities");
            }
        });
    }

    private void deleteCreatedEntities() {
        entityHelper.deleteEverything();
        IDS.clear();
    }

    private void prunePropertiesToChanges(List<String> selectedProperties, Map<String, Object> changes) {
        if (changes.size() != selectedProperties.size()) {
            Iterator<String> it = selectedProperties.iterator();
            while (it.hasNext()) {
                String property = it.next();
                if (changes.containsKey(property)) continue;
                it.remove();
            }
        }
    }

    private void checkSubscribeSelectInsert(EntityType entityType, List<String> selectedProperties) {
        if (selectedProperties.isEmpty()) {
            return;
        }
        MqttBatchResult<Object> result = mqttHelper.executeRequests(this.getInsertEntityAction(entityType), mqttHelper.getTopic(entityType, selectedProperties));
        IDS.put(entityType, result.getActionResult());
        JSONObject entity = entityHelper.getEntity(entityType, result.getActionResult());
        this.filterEntity(entity, selectedProperties);
        Capability8Tests.assertJsonEqualsWithLinkResolving(entity, result.getMessages().values().iterator().next(), mqttHelper.getTopic(entityType, selectedProperties));
    }

    private void checkSubscribePut(EntityType entityType, List<String> selectedProperties) {
        if (selectedProperties.isEmpty()) {
            return;
        }
        Map<String, Object> changes = entityHelper.getEntityChanges(entityType, selectedProperties);
        this.prunePropertiesToChanges(selectedProperties, changes);
        MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(() -> entityHelper.putEntity(entityType, changes, IDS.get((Object)entityType)), mqttHelper.getTopic(entityType, selectedProperties));
        Capability8Tests.assertJsonEqualsWithLinkResolving(new JSONObject(changes), result.getMessages().values().iterator().next(), mqttHelper.getTopic(entityType, selectedProperties));
    }

    private void checkSubscribePatch(EntityType entityType, List<String> selectedProperties) {
        if (selectedProperties.isEmpty()) {
            return;
        }
        Map<String, Object> changes = entityHelper.getEntityChanges(entityType, selectedProperties);
        this.prunePropertiesToChanges(selectedProperties, changes);
        MqttBatchResult<JSONObject> result = mqttHelper.executeRequests(() -> entityHelper.patchEntity(entityType, changes, IDS.get((Object)entityType)), mqttHelper.getTopic(entityType, selectedProperties));
        Capability8Tests.assertJsonEqualsWithLinkResolving(new JSONObject(changes), result.getMessages().values().iterator().next(), mqttHelper.getTopic(entityType, selectedProperties));
    }

    private JSONObject filterEntity(JSONObject entity, List<String> selectedProperties) {
        Iterator iterator = entity.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (selectedProperties.contains(key)) continue;
            iterator.remove();
        }
        return entity;
    }

    private Callable<Object> getDeepInsertEntityAction(EntityType entityType) {
        Callable<Object> trigger = () -> {
            switch (entityType) {
                case THING: {
                    return entityHelper.createThingWithDeepInsert();
                }
                case DATASTREAM: {
                    return entityHelper.createDatastreamWithDeepInsert(IDS.get((Object)EntityType.THING));
                }
                case OBSERVATION: {
                    return entityHelper.createObservationWithDeepInsert(IDS.get((Object)EntityType.DATASTREAM));
                }
            }
            throw new IllegalArgumentException("Unknown EntityType '" + entityType.toString() + "'");
        };
        return trigger;
    }

    private Callable<Object> getInsertEntityAction(EntityType entityType) {
        Callable<Object> trigger = () -> {
            switch (entityType) {
                case THING: {
                    return entityHelper.createThing();
                }
                case DATASTREAM: {
                    return entityHelper.createDatastream(IDS.get((Object)EntityType.THING), IDS.get((Object)EntityType.OBSERVED_PROPERTY), IDS.get((Object)EntityType.SENSOR));
                }
                case FEATURE_OF_INTEREST: {
                    return entityHelper.createFeatureOfInterest();
                }
                case HISTORICAL_LOCATION: {
                    return entityHelper.createHistoricalLocation(IDS.get((Object)EntityType.THING), IDS.get((Object)EntityType.LOCATION));
                }
                case LOCATION: {
                    return entityHelper.createLocation(IDS.get((Object)EntityType.THING));
                }
                case OBSERVATION: {
                    if (IDS.get((Object)EntityType.FEATURE_OF_INTEREST) == null) {
                        return entityHelper.createObservation(IDS.get((Object)EntityType.DATASTREAM));
                    }
                    return entityHelper.createObservation(IDS.get((Object)EntityType.DATASTREAM), IDS.get((Object)EntityType.FEATURE_OF_INTEREST));
                }
                case OBSERVED_PROPERTY: {
                    return entityHelper.createObservedProperty();
                }
                case SENSOR: {
                    return entityHelper.createSensor();
                }
            }
            throw new IllegalArgumentException("Unknown EntityType '" + entityType.toString() + "'");
        };
        return trigger;
    }

    private String getPathToRelatedEntity(EntityType sourceEntityType, EntityType destinationEntityType) {
        LinkedList<BFSStructure> queue = new LinkedList<BFSStructure>();
        queue.offer(new BFSStructure(sourceEntityType, ""));
        while (queue.peek() != null) {
            BFSStructure currentElement = (BFSStructure)queue.poll();
            List<String> relations = currentElement.entityType.getRelations(serverSettings.getExtensions());
            for (String relation : relations) {
                EntityType relatedType = EntityType.getForRelation(relation);
                if (relatedType.equals((Object)destinationEntityType)) {
                    return currentElement.path + (String)(currentElement.path.isEmpty() ? relation : "/" + relation);
                }
                queue.offer(new BFSStructure(relatedType, currentElement.path + (String)(currentElement.path.isEmpty() ? relation : "/" + relation)));
            }
        }
        return "";
    }

    private List<String> getSelectedProperties(EntityType entityType, boolean even) {
        int i;
        ArrayList<String> allProperties = new ArrayList<String>(entityType.getEditablePropertyNames());
        ArrayList<String> selectedProperties = new ArrayList<String>(allProperties.size() / 2);
        int n = i = even ? 0 : 1;
        while (i < allProperties.size()) {
            selectedProperties.add((String)allProperties.get(i));
            i += 2;
        }
        return selectedProperties;
    }

    private JSONObject getSubEntityByRoot(EntityType rootEntityType, Object rootId, EntityType subtEntityType) {
        try {
            Object path = this.getPathToRelatedEntity(subtEntityType, rootEntityType);
            path = "/" + subtEntityType.getRootEntitySet() + "?$count=true&$filter=" + (String)path + "/id%20eq%20" + Utils.quoteIdForUrl(rootId);
            JSONObject result = entityHelper.getEntity((String)path);
            if (result.getInt("@iot.count") != 1) {
                Assertions.fail((String)"Invalid result with size != 1");
            }
            JSONObject subEntity = result.getJSONArray("value").getJSONObject(0);
            return subEntity;
        }
        catch (JSONException ex) {
            LOGGER.error("Exception:", (Throwable)ex);
            Assertions.fail((String)("Invalid JSON: " + ex.getMessage()));
            throw new IllegalStateException();
        }
    }

    private Callable<JSONObject> getUpdatePatchEntityAction(EntityType entityType) {
        return () -> entityHelper.updateEntitywithPATCH(entityType, IDS.get((Object)entityType));
    }

    private Callable<JSONObject> getUpdatePutEntityAction(EntityType entityType) {
        return () -> entityHelper.updateEntitywithPUT(entityType, IDS.get((Object)entityType));
    }

    private static void assertJsonEqualsWithLinkResolving(JSONObject expected, JSONObject received, String topic) {
        Object message = "";
        boolean equals = Capability8Tests.jsonEqualsWithLinkResolving(expected, received, topic);
        if (!equals) {
            message = "Expected " + expected.toString() + " got " + received.toString() + " for topic " + topic;
        }
        Assertions.assertTrue((boolean)equals, (String)message);
    }

    private static boolean jsonEqualsWithLinkResolving(JSONArray arr1, JSONArray arr2, String topic) {
        if (arr1.length() != arr2.length()) {
            return false;
        }
        for (int i = 0; i < arr1.length(); ++i) {
            Object val1 = arr1.get(i);
            if (!(val1 instanceof JSONObject ? !Capability8Tests.jsonEqualsWithLinkResolving((JSONObject)val1, arr2.getJSONObject(i), topic) : (val1 instanceof JSONArray ? !Capability8Tests.jsonEqualsWithLinkResolving((JSONArray)val1, arr2.getJSONArray(i), topic) : !val1.equals(arr2.get(i))))) continue;
            return false;
        }
        return true;
    }

    private static boolean jsonEqualsWithLinkResolving(JSONObject obj1, JSONObject obj2, String topic) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        if (obj1.getClass() != obj2.getClass()) {
            return false;
        }
        if (obj1.length() != obj2.length()) {
            return false;
        }
        Iterator iterator = obj1.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (!obj2.has(key)) {
                return false;
            }
            try {
                Object val1 = obj1.get(key);
                if (val1 == null) {
                    return obj2.get(key) == null;
                }
                if (val1 instanceof JSONObject) {
                    if (Capability8Tests.jsonEqualsWithLinkResolving((JSONObject)val1, obj2.getJSONObject(key), topic)) continue;
                    return false;
                }
                if (val1 instanceof JSONArray) {
                    JSONArray arr1 = (JSONArray)val1;
                    JSONArray arr2 = obj2.getJSONArray(key);
                    if (Capability8Tests.jsonEqualsWithLinkResolving(arr1, arr2, topic)) continue;
                    return false;
                }
                if (key.toLowerCase().endsWith("time")) {
                    if (Capability8Tests.checkTimeEquals(val1.toString(), obj2.get(key).toString())) continue;
                    return false;
                }
                if (topic != null && !topic.isEmpty() && key.endsWith("@iot.navigationLink")) {
                    String navLink2;
                    String selfLink2;
                    URI baseUri2;
                    String absoluteUri2;
                    String navLink1;
                    String version = topic.substring(0, topic.indexOf("/"));
                    String selfLink1 = obj1.getString("@iot.selfLink");
                    URI baseUri1 = URI.create(selfLink1.substring(0, selfLink1.indexOf(version))).resolve(topic);
                    String absoluteUri1 = baseUri1.resolve(navLink1 = obj1.getString(key)).toString();
                    if (absoluteUri1.equals(absoluteUri2 = (baseUri2 = URI.create((selfLink2 = obj2.getString("@iot.selfLink")).substring(0, selfLink2.indexOf(version))).resolve(topic)).resolve(navLink2 = obj2.getString(key)).toString())) continue;
                    return false;
                }
                if (val1.equals(obj2.get(key))) continue;
                return false;
            }
            catch (JSONException ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkTimeEquals(String val1, String val2) {
        if (val1.equals(val2)) {
            return true;
        }
        try {
            ZonedDateTime dateTime1 = ZonedDateTime.parse(val1);
            ZonedDateTime dateTime2 = ZonedDateTime.parse(val2);
            return dateTime1.isEqual(dateTime2);
        }
        catch (Exception dateTime1) {
            try {
                MomentInterval interval1 = MomentInterval.parseISO((String)val1);
                MomentInterval interval2 = MomentInterval.parseISO((String)val2);
                return interval1.equals((Object)interval2);
            }
            catch (RuntimeException | ParseException ex) {
                Assertions.fail((String)"time properies could neither be parsed as time nor as interval");
                return false;
            }
        }
    }

    private class BFSStructure {
        EntityType entityType;
        String path;

        public BFSStructure(EntityType entityType, String path) {
            this.entityType = entityType;
            this.path = path;
        }
    }

    public static class Implementation11
    extends Capability8Tests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends Capability8Tests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

