/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c05multidatastream;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.c05multidatastream.EntityTypeMds;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class MultiDatastreamTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiDatastreamTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> OBSERVED_PROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<MultiDatastream> MULTIDATASTREAMS = new ArrayList<MultiDatastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public MultiDatastreamTests(ServerVersion version) {
        super(version);
    }

    @BeforeEach
    public void before() {
        Assumptions.assumeTrue((boolean)serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ), (String)"Conformance level 5 not checked since MultiDatastreams not listed in Service Root.");
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)MultiDatastreamTests.version.urlPart);
        Assumptions.assumeTrue((boolean)serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ), (String)"Conformance level 5 not checked since MultiDatastreams not listed in Service Root.");
        MultiDatastreamTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        MultiDatastreamTests.cleanup();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        MultiDatastreamTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        OBSERVED_PROPS.clear();
        DATASTREAMS.clear();
        MULTIDATASTREAMS.clear();
        OBSERVATIONS.clear();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        Thing thing = new Thing("Thing 1", "The first thing.");
        thing.getLocations().add((Entity)location.withOnlyId());
        service.create((Entity)thing);
        THINGS.add(thing);
        thing = new Thing("Thing 2", "The second thing.");
        thing.getLocations().add((Entity)location.withOnlyId());
        service.create((Entity)thing);
        THINGS.add(thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        sensor = new Sensor("Sensor 2", "The second sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor);
        SENSORS.add(sensor);
        ObservedProperty obsProp = new ObservedProperty("ObservedProperty 1", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        obsProp = new ObservedProperty("ObservedProperty 2", new URI("http://ucom.org/humidity"), "The humidity of the thing.");
        service.create((Entity)obsProp);
        OBSERVED_PROPS.add(obsProp);
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        DATASTREAMS.add(datastream);
        datastream.setThing(THINGS.get(0).withOnlyId());
        datastream.setSensor(SENSORS.get(0).withOnlyId());
        datastream.setObservedProperty(OBSERVED_PROPS.get(0).withOnlyId());
        service.create((Entity)datastream);
        datastream = new Datastream("Datastream 2", "The temperature of thing 2, sensor 2.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        DATASTREAMS.add(datastream);
        datastream.setThing(THINGS.get(1).withOnlyId());
        datastream.setSensor(SENSORS.get(1).withOnlyId());
        datastream.setObservedProperty(OBSERVED_PROPS.get(0).withOnlyId());
        service.create((Entity)datastream);
        MultiDatastreamTests.createObservation(DATASTREAMS.get(0).withOnlyId(), -1.0);
        MultiDatastreamTests.createObservation(DATASTREAMS.get(1).withOnlyId(), 0.0);
    }

    private static void createObservation(Datastream ds, double result) throws ServiceFailureException {
        Observation o = new Observation((Object)result, ds);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private static void createObservation(MultiDatastream ds, double ... result) throws ServiceFailureException {
        Observation o = new Observation((Object)result, ds);
        service.create((Entity)o);
        OBSERVATIONS.add(o);
    }

    private void updateForException(String test, Entity entity) {
        try {
            service.update(entity);
        }
        catch (ServiceFailureException ex) {
            return;
        }
        Assertions.fail((String)(test + " Update did not respond with 400 Bad Request."));
    }

    private void checkResult(String test, EntityUtils.ResultTestResult result) {
        Assertions.assertTrue((boolean)result.testOk, (String)(test + " " + result.message));
    }

    private void checkObservedPropertiesFor(MultiDatastream md, ObservedProperty ... expectedObservedProps) throws ServiceFailureException {
        Object[] fetchedObservedProps2 = (ObservedProperty[])md.observedProperties().query().list().toArray((Object[])new ObservedProperty[0]);
        String message = "Incorrect Observed Properties returned.";
        Assertions.assertArrayEquals((Object[])expectedObservedProps, (Object[])fetchedObservedProps2, (String)message);
    }

    @Test
    void test01MultiDatastream() throws ServiceFailureException {
        LOGGER.info("  test01MultiDatastream");
        MultiDatastream md1 = new MultiDatastream();
        md1.setName("MultiDatastream 1");
        md1.setDescription("The first test MultiDatastream.");
        md1.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes1 = new ArrayList<String>();
        dataTypes1.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md1.setMultiObservationDataTypes(dataTypes1);
        md1.setThing(THINGS.get(0).withOnlyId());
        md1.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties = new ArrayList<ObservedProperty>();
        observedProperties.add(OBSERVED_PROPS.get(0).withOnlyId());
        md1.setObservedProperties(observedProperties);
        service.create((Entity)md1);
        MULTIDATASTREAMS.add(md1);
        MultiDatastream md2 = new MultiDatastream();
        md2.setName("MultiDatastream 2");
        md2.setDescription("The second test MultiDatastream.");
        md2.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        md2.addUnitOfMeasurement(new UnitOfMeasurement("percent", "%", "ucum:%"));
        ArrayList<String> dataTypes2 = new ArrayList<String>();
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes2.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md2.setMultiObservationDataTypes(dataTypes2);
        md2.setThing(THINGS.get(0).withOnlyId());
        md2.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties2 = new ArrayList<ObservedProperty>();
        observedProperties2.add(OBSERVED_PROPS.get(0).withOnlyId());
        observedProperties2.add(OBSERVED_PROPS.get(1).withOnlyId());
        md2.setObservedProperties(observedProperties2);
        service.create((Entity)md2);
        MULTIDATASTREAMS.add(md2);
        MultiDatastream md3 = new MultiDatastream();
        md3.setName("MultiDatastream 3");
        md3.setDescription("The third test MultiDatastream.");
        md3.addUnitOfMeasurement(new UnitOfMeasurement("percent", "%", "ucum:%"));
        md3.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes3 = new ArrayList<String>();
        dataTypes3.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes3.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md3.setMultiObservationDataTypes(dataTypes3);
        md3.setThing(THINGS.get(0).withOnlyId());
        md3.setSensor(SENSORS.get(0).withOnlyId());
        ArrayList<ObservedProperty> observedProperties3 = new ArrayList<ObservedProperty>();
        observedProperties3.add(OBSERVED_PROPS.get(1).withOnlyId());
        observedProperties3.add(OBSERVED_PROPS.get(0).withOnlyId());
        md3.setObservedProperties(observedProperties3);
        service.create((Entity)md3);
        MULTIDATASTREAMS.add(md3);
        MultiDatastream md4 = new MultiDatastream();
        md4.setName("MultiDatastream 4");
        md4.setDescription("The fourth test MultiDatastream.");
        md4.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        md4.addUnitOfMeasurement(new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        ArrayList<String> dataTypes4 = new ArrayList<String>();
        dataTypes4.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        dataTypes4.add("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement");
        md4.setMultiObservationDataTypes(dataTypes4);
        md4.setThing(THINGS.get(0).withOnlyId());
        md4.setSensor(SENSORS.get(1).withOnlyId());
        ArrayList<ObservedProperty> observedProperties4 = new ArrayList<ObservedProperty>();
        observedProperties4.add(OBSERVED_PROPS.get(0).withOnlyId());
        observedProperties4.add(OBSERVED_PROPS.get(0).withOnlyId());
        md4.setObservedProperties(observedProperties4);
        service.create((Entity)md4);
        MULTIDATASTREAMS.add(md4);
        Assertions.assertEquals((int)4, (int)MULTIDATASTREAMS.size());
    }

    @Test
    void test02ObservationInMultiDatastream() throws ServiceFailureException {
        LOGGER.info("  test02ObservationInMultiDatastream");
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(0).withOnlyId(), 1.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(0).withOnlyId(), 2.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(0).withOnlyId(), 3.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(1).withOnlyId(), 4.0, 1.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(1).withOnlyId(), 5.0, 2.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(1).withOnlyId(), 6.0, 3.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(2).withOnlyId(), 7.0, 4.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(2).withOnlyId(), 8.0, 5.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(2).withOnlyId(), 9.0, 6.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(3).withOnlyId(), 10.0, 7.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(3).withOnlyId(), 11.0, 8.0);
        MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(3).withOnlyId(), 12.0, 9.0);
        Assertions.assertEquals((int)14, (int)OBSERVATIONS.size());
    }

    @Test
    void test03ObservationInMultiDatastreamIncorrect() throws ServiceFailureException {
        LOGGER.info("  test03ObservationInMultiDatastreamIncorrect");
        try {
            Observation o = new Observation((Object)1, MULTIDATASTREAMS.get(1).withOnlyId());
            service.create((Entity)o);
            Assertions.fail((String)"Service should have rejected posting non-array result to a multidatastream.");
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
        try {
            MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(0).withOnlyId(), 1.0, 2.0);
            Assertions.fail((String)"Service should have rejected posting 2 results to a multidatastream with only 1 observed property.");
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
        try {
            MultiDatastreamTests.createObservation(MULTIDATASTREAMS.get(1).withOnlyId(), 1.0);
            Assertions.fail((String)"Service should have rejected posting 1 result to a multidatastream with 2 observed properties.");
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
    }

    private JsonNode getJsonObject(String urlString) {
        JsonNode json;
        urlString = urlString.replaceAll(Pattern.quote("["), "%5B").replaceAll(Pattern.quote("]"), "%5D");
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
        String message = "Error getting Observations using Data Array: Code " + responseMap.code;
        Assertions.assertEquals((int)200, (int)responseMap.code, (String)message);
        try {
            json = new ObjectMapper().readTree(responseMap.response);
        }
        catch (IOException ex) {
            Assertions.fail((String)("Server returned malformed JSON for request: " + urlString + " Exception: " + ex));
            return null;
        }
        if (!json.isObject()) {
            Assertions.fail((String)("Server did not return a JSON object for request: " + urlString));
        }
        return json;
    }

    private JsonNode getJsonValue(String urlString) {
        JsonNode json = this.getJsonObject(urlString);
        JsonNode value = json.get("value");
        if (value == null || !value.isArray()) {
            Assertions.fail((String)("value field is not an array for request: " + urlString));
        }
        return value;
    }

    private void entitiesHaveOneOf(JsonNode value, String EntityName, String ... properties) {
        for (JsonNode valueItem : value) {
            if (!valueItem.isObject()) {
                Assertions.fail((String)("item in " + EntityName + " array is not an object."));
                return;
            }
            for (String property : properties) {
                if (!valueItem.has(property)) continue;
                return;
            }
            Assertions.fail((String)("item in " + EntityName + " array does not contain any of " + Arrays.toString(properties)));
        }
    }

    @Test
    void test04Json() throws ServiceFailureException {
        LOGGER.info("  test04Json");
        JsonNode json = this.getJsonValue(serverSettings.getServiceUrl(version) + "/Things");
        this.entitiesHaveOneOf(json, "Things", "MultiDatastreams@iot.navigationLink");
        json = this.getJsonValue(serverSettings.getServiceUrl(version) + "/Sensors");
        this.entitiesHaveOneOf(json, "Sensors", "MultiDatastreams@iot.navigationLink");
        json = this.getJsonValue(serverSettings.getServiceUrl(version) + "/ObservedProperties");
        this.entitiesHaveOneOf(json, "ObservedProperties", "MultiDatastreams@iot.navigationLink");
        json = this.getJsonValue(serverSettings.getServiceUrl(version) + "/Observations");
        this.entitiesHaveOneOf(json, "Observations", "MultiDatastream@iot.navigationLink", "Datastream@iot.navigationLink");
        json = this.getJsonValue(serverSettings.getServiceUrl(version) + "/MultiDatastreams");
        for (String property : EntityTypeMds.MULTI_DATASTREAM.getProperties()) {
            this.entitiesHaveOneOf(json, "MultiDatastreams", property);
        }
        for (String relation : EntityTypeMds.MULTI_DATASTREAM.getRelations()) {
            this.entitiesHaveOneOf(json, "MultiDatastreams", relation + "@iot.navigationLink");
        }
        String urlString = serverSettings.getServiceUrl(version) + "/Observations(" + OBSERVATIONS.get(5).getId().getUrl() + ")/result[0]";
        json = this.getJsonObject(urlString);
        JsonNode value = json.get("result[0]");
        if (value == null || !value.isNumber()) {
            Assertions.fail((String)("Did not get a numeric value for result[0] for url: " + urlString));
        } else {
            String message = "Did not get correct value for url: " + urlString;
            Assertions.assertEquals((int)4, (int)value.asInt(), (String)message);
        }
    }

    @Test
    void test05MultiDatastreamThings() throws ServiceFailureException {
        LOGGER.info("  test05MultiDatastreamThings");
        Thing fetchedThing = (Thing)service.things().find(THINGS.get(0).getId());
        EntityList fetchedDatastreams = fetchedThing.datastreams().query().list();
        this.checkResult("Check Datastreams linked to Thing 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, (Entity)DATASTREAMS.get(0)));
        EntityList fetchedMultiDatastreams = fetchedThing.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to Thing 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, new ArrayList<MultiDatastream>(MULTIDATASTREAMS)));
    }

    @Test
    void test06MultiDatastreamSensors() throws ServiceFailureException {
        LOGGER.info("  test06MultiDatastreamSensors");
        Sensor fetchedSensor = (Sensor)service.sensors().find(SENSORS.get(0).getId());
        EntityList fetchedDatastreams = fetchedSensor.datastreams().query().list();
        this.checkResult("Check Datastreams linked to Sensor 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, (Entity)DATASTREAMS.get(0)));
        EntityList fetchedMultiDatastreams = fetchedSensor.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to Sensor 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, Utils.getFromList(MULTIDATASTREAMS, 0, 1, 2)));
    }

    @Test
    void test07MultiDatastreamObservedProperties1() throws ServiceFailureException {
        LOGGER.info("  test07MultiDatastreamObservedProperties1");
        ObservedProperty fetchedObservedProp = (ObservedProperty)service.observedProperties().find(OBSERVED_PROPS.get(0).getId());
        EntityList fetchedDatastreams = fetchedObservedProp.datastreams().query().list();
        this.checkResult("Check Datastreams linked to ObservedProperty 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, Utils.getFromList(DATASTREAMS, 0, 1)));
        EntityList fetchedMultiDatastreams = fetchedObservedProp.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to ObservedProperty 1.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, new ArrayList<MultiDatastream>(MULTIDATASTREAMS)));
    }

    @Test
    void test08MultiDatastreamObservedProperties2() throws ServiceFailureException {
        LOGGER.info("  test08MultiDatastreamObservedProperties2");
        ObservedProperty fetchedObservedProp = (ObservedProperty)service.observedProperties().find(OBSERVED_PROPS.get(1).getId());
        EntityList fetchedDatastreams = fetchedObservedProp.datastreams().query().list();
        this.checkResult("Check Datastreams linked to ObservedProperty 2.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedDatastreams, new ArrayList()));
        EntityList fetchedMultiDatastreams = fetchedObservedProp.multiDatastreams().query().list();
        this.checkResult("Check MultiDatastreams linked to ObservedProperty 2.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, Utils.getFromList(MULTIDATASTREAMS, 1, 2)));
    }

    @Test
    void test09ObservationLinks1() throws ServiceFailureException {
        LOGGER.info("  test09ObservationLinks1");
        Observation fetchedObservation = (Observation)service.observations().find(OBSERVATIONS.get(0).getId());
        Datastream fetchedDatastream = fetchedObservation.getDatastream();
        String message = "Observation has wrong or no Datastream";
        Assertions.assertEquals((Object)DATASTREAMS.get(0), (Object)fetchedDatastream, (String)message);
        MultiDatastream fetchedMultiDatastream = fetchedObservation.getMultiDatastream();
        message = "Observation should not have a MultiDatastream";
        Assertions.assertEquals(null, (Object)fetchedMultiDatastream, (String)message);
    }

    @Test
    void test10ObservationLinks2() throws ServiceFailureException {
        LOGGER.info("  test10ObservationLinks2");
        Observation fetchedObservation = (Observation)service.observations().find(OBSERVATIONS.get(2).getId());
        Datastream fetchedDatastream = fetchedObservation.getDatastream();
        String message = "Observation should not have a Datastream";
        Assertions.assertEquals(null, (Object)fetchedDatastream, (String)message);
        MultiDatastream fetchedMultiDatastream = fetchedObservation.getMultiDatastream();
        message = "Observation has wrong or no MultiDatastream";
        Assertions.assertEquals((Object)MULTIDATASTREAMS.get(0), (Object)fetchedMultiDatastream, (String)message);
    }

    @Test
    void test11ObservedPropertyOrder() throws ServiceFailureException {
        LOGGER.info("  test11ObservedPropertyOrder");
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(0), OBSERVED_PROPS.get(0));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(1), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(1));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(2), OBSERVED_PROPS.get(1), OBSERVED_PROPS.get(0));
        this.checkObservedPropertiesFor(MULTIDATASTREAMS.get(3), OBSERVED_PROPS.get(0), OBSERVED_PROPS.get(0));
    }

    @Test
    void test12IncorrectObservation() throws ServiceFailureException {
        LOGGER.info("  test12IncorrectObservation");
        Observation modifiedObservation = OBSERVATIONS.get(0).withOnlyId();
        modifiedObservation.setMultiDatastream(MULTIDATASTREAMS.get(0).withOnlyId());
        this.updateForException("Linking Observation to Datastream AND MultiDatastream.", (Entity)modifiedObservation);
    }

    @Test
    void test13IncorrectObservedProperty() throws ServiceFailureException {
        LOGGER.info("  test13IncorrectObservedProperty");
        ObservedProperty modifiedObservedProp = OBSERVED_PROPS.get(1).withOnlyId();
        modifiedObservedProp.getMultiDatastreams().add((Entity)MULTIDATASTREAMS.get(0).withOnlyId());
        this.updateForException("Linking MultiDatastream to Observed property.", (Entity)modifiedObservedProp);
    }

    @Test
    void test14FetchObservationsByMultiDatastream() throws ServiceFailureException {
        LOGGER.info("  test14FetchObservationsByMultiDatastream");
        EntityList observations = MULTIDATASTREAMS.get(0).observations().query().list();
        this.checkResult("Looking for all observations", EntityUtils.resultContains((EntityList<? extends Entity>)observations, Utils.getFromList(OBSERVATIONS, 2, 3, 4)));
        observations = MULTIDATASTREAMS.get(1).observations().query().list();
        this.checkResult("Looking for all observations", EntityUtils.resultContains((EntityList<? extends Entity>)observations, Utils.getFromList(OBSERVATIONS, 5, 6, 7)));
        observations = MULTIDATASTREAMS.get(2).observations().query().list();
        this.checkResult("Looking for all observations", EntityUtils.resultContains((EntityList<? extends Entity>)observations, Utils.getFromList(OBSERVATIONS, 8, 9, 10)));
        observations = MULTIDATASTREAMS.get(3).observations().query().list();
        this.checkResult("Looking for all observations", EntityUtils.resultContains((EntityList<? extends Entity>)observations, Utils.getFromList(OBSERVATIONS, 11, 12, 13)));
    }

    @Test
    void test15Observations() throws ServiceFailureException {
        LOGGER.info("  test15Observations");
        EntityList fetchedObservations = service.observations().query().list();
        this.checkResult("Looking for all observations", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedObservations, new ArrayList<Observation>(OBSERVATIONS)));
    }

    @Test
    void test16DeleteObservedProperty() throws ServiceFailureException {
        LOGGER.info("  test16DeleteObservedProperty");
        service.delete((Entity)OBSERVED_PROPS.get(1));
        EntityList fetchedMultiDatastreams = service.multiDatastreams().query().list();
        this.checkResult("Checking if MultiDatastreams are automatically deleted.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, Utils.getFromList(MULTIDATASTREAMS, 0, 3)));
        EntityList fetchedObservations = service.observations().query().list();
        this.checkResult("Checking if Observations are automatically deleted.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedObservations, Utils.getFromList(OBSERVATIONS, 0, 1, 2, 3, 4, 11, 12, 13)));
    }

    @Test
    void test17DeleteSensor() throws ServiceFailureException {
        LOGGER.info("  test17DeleteSensor");
        service.delete((Entity)SENSORS.get(1));
        EntityList fetchedMultiDatastreams = service.multiDatastreams().query().list();
        this.checkResult("Checking if MultiDatastreams are automatically deleted.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, Utils.getFromList(MULTIDATASTREAMS, 0)));
    }

    @Test
    void test18DeleteThing() throws ServiceFailureException {
        LOGGER.info("  test18DeleteThing");
        service.delete((Entity)THINGS.get(0));
        EntityList fetchedMultiDatastreams = service.multiDatastreams().query().list();
        this.checkResult("Checking if MultiDatastreams are automatically deleted.", EntityUtils.resultContains((EntityList<? extends Entity>)fetchedMultiDatastreams, new ArrayList()));
    }

    public static class Implementation11
    extends MultiDatastreamTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends MultiDatastreamTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

