/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c05multidatastream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum EntityTypeMds {
    THING("Thing", "Things"),
    LOCATION("Location", "Locations"),
    SENSOR("Sensor", "Sensors"),
    OBSERVED_PROPERTY("ObservedProperty", "ObservedProperties"),
    OBSERVATION("Observation", "Observations"),
    DATASTREAM("Datastream", "Datastreams"),
    MULTI_DATASTREAM("MultiDatastream", "MultiDatastreams"),
    FEATURE_OF_INTEREST("FeatureOfInterest", "FeaturesOfInterest"),
    HISTORICAL_LOCATION("HistoricalLocation", "HistoricalLocations");

    public final String singular;
    public final String plural;
    private final List<String> properties = new ArrayList<String>();
    private final List<String> relations = new ArrayList<String>();
    private static final Map<String, EntityTypeMds> NAMES_MAP;
    private static final Set<String> NAMES_PLURAL;

    public static EntityTypeMds getForRelation(String relation) {
        EntityTypeMds entityType = NAMES_MAP.get(relation);
        if (entityType == null) {
            throw new IllegalArgumentException("Unknown relation: " + relation);
        }
        return entityType;
    }

    public static boolean isPlural(String relation) {
        return NAMES_PLURAL.contains(relation);
    }

    private EntityTypeMds(String singular, String plural) {
        this.singular = singular;
        this.plural = plural;
    }

    public String getRootEntitySet() {
        return this.plural;
    }

    public List<String> getRelations() {
        return Collections.unmodifiableList(this.relations);
    }

    public List<String> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    private void addProperties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
    }

    private void addRelations(String ... relations) {
        this.relations.addAll(Arrays.asList(relations));
    }

    static {
        NAMES_MAP = new HashMap<String, EntityTypeMds>();
        NAMES_PLURAL = new HashSet<String>();
        THING.addProperties("name", "description");
        THING.addRelations(EntityTypeMds.DATASTREAM.plural, EntityTypeMds.MULTI_DATASTREAM.plural, EntityTypeMds.HISTORICAL_LOCATION.plural, EntityTypeMds.LOCATION.plural);
        LOCATION.addProperties("name", "description", "encodingType", "location");
        LOCATION.addRelations(EntityTypeMds.HISTORICAL_LOCATION.plural, EntityTypeMds.THING.plural);
        SENSOR.addProperties("name", "description", "encodingType", "metadata");
        SENSOR.addRelations(EntityTypeMds.DATASTREAM.plural, EntityTypeMds.MULTI_DATASTREAM.plural);
        OBSERVED_PROPERTY.addProperties("name", "definition", "description");
        OBSERVED_PROPERTY.addRelations(EntityTypeMds.DATASTREAM.plural, EntityTypeMds.MULTI_DATASTREAM.plural);
        OBSERVATION.addProperties("phenomenonTime", "result", "resultTime");
        OBSERVATION.addRelations(EntityTypeMds.DATASTREAM.singular, EntityTypeMds.MULTI_DATASTREAM.singular, EntityTypeMds.FEATURE_OF_INTEREST.singular);
        DATASTREAM.addProperties("name", "description", "unitOfMeasurement", "observationType");
        DATASTREAM.addRelations(EntityTypeMds.THING.singular, EntityTypeMds.SENSOR.singular, EntityTypeMds.OBSERVED_PROPERTY.singular, EntityTypeMds.OBSERVATION.plural);
        MULTI_DATASTREAM.addProperties("name", "description", "unitOfMeasurements", "observationType", "multiObservationDataTypes");
        MULTI_DATASTREAM.addRelations(EntityTypeMds.THING.singular, EntityTypeMds.SENSOR.singular, EntityTypeMds.OBSERVED_PROPERTY.plural, EntityTypeMds.OBSERVATION.plural);
        FEATURE_OF_INTEREST.addProperties("name", "description", "encodingType", "feature");
        FEATURE_OF_INTEREST.addRelations(EntityTypeMds.OBSERVATION.plural);
        HISTORICAL_LOCATION.addProperties("time");
        HISTORICAL_LOCATION.addRelations(EntityTypeMds.THING.singular, EntityTypeMds.LOCATION.plural);
        for (EntityTypeMds entityType : EntityTypeMds.values()) {
            NAMES_MAP.put(entityType.singular, entityType);
            NAMES_MAP.put(entityType.plural, entityType);
            NAMES_PLURAL.add(entityType.plural);
        }
    }
}

