/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c03filtering;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityCounts;
import de.fraunhofer.iosb.ilt.statests.util.EntityPropertiesSampleValue;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.Expand;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.PathElement;
import de.fraunhofer.iosb.ilt.statests.util.Query;
import de.fraunhofer.iosb.ilt.statests.util.Request;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import de.fraunhofer.iosb.ilt.statests.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Capability3Tests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(Capability3Tests.class);
    private static Object thingId1;
    private static Object thingId2;
    private static Object datastreamId1;
    private static Object datastreamId2;
    private static Object datastreamId3;
    private static Object datastreamId4;
    private static Object locationId1;
    private static Object locationId2;
    private static Object historicalLocationId1;
    private static Object historicalLocationId2;
    private static Object historicalLocationId3;
    private static Object historicalLocationId4;
    private static Object sensorId1;
    private static Object sensorId2;
    private static Object sensorId3;
    private static Object sensorId4;
    private static Object observedPropertyId1;
    private static Object observedPropertyId2;
    private static Object observedPropertyId3;
    private static Object observationId1;
    private static Object observationId7;
    private static Object featureOfInterestId1;
    private static Object featureOfInterestId2;
    private static final EntityCounts ENTITYCOUNTS;

    public Capability3Tests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)Capability3Tests.version.urlPart);
        Capability3Tests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        ENTITYCOUNTS.clear();
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        EntityUtils.deleteAll(version, serverSettings, service);
        ENTITYCOUNTS.clear();
    }

    @Test
    void readEntitiesWithSelectQO() {
        LOGGER.info("  readEntitiesWithSelectQO");
        this.checkSelectForEntityType(EntityType.THING);
        this.checkSelectForEntityType(EntityType.LOCATION);
        this.checkSelectForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkSelectForEntityType(EntityType.DATASTREAM);
        this.checkSelectForEntityType(EntityType.SENSOR);
        this.checkSelectForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkSelectForEntityType(EntityType.OBSERVATION);
        this.checkSelectForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkSelectForEntityTypeRelations(EntityType.THING, thingId1);
        this.checkSelectForEntityTypeRelations(EntityType.LOCATION, locationId1);
        this.checkSelectForEntityTypeRelations(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkSelectForEntityTypeRelations(EntityType.DATASTREAM, datastreamId1);
        this.checkSelectForEntityTypeRelations(EntityType.SENSOR, sensorId1);
        this.checkSelectForEntityTypeRelations(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkSelectForEntityTypeRelations(EntityType.OBSERVATION, observationId1);
        this.checkSelectForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
    }

    @Test
    void readEntitiesWithExpandQO() {
        LOGGER.info("  readEntitiesWithExpandQO");
        this.checkExpandForEntityType(EntityType.THING);
        this.checkExpandForEntityType(EntityType.LOCATION);
        this.checkExpandForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkExpandForEntityType(EntityType.DATASTREAM);
        this.checkExpandForEntityType(EntityType.SENSOR);
        this.checkExpandForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkExpandForEntityType(EntityType.OBSERVATION);
        this.checkExpandForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkExpandForEntityTypeRelations(EntityType.THING, thingId1);
        this.checkExpandForEntityTypeRelations(EntityType.LOCATION, locationId1);
        this.checkExpandForEntityTypeRelations(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkExpandForEntityTypeRelations(EntityType.DATASTREAM, datastreamId1);
        this.checkExpandForEntityTypeRelations(EntityType.SENSOR, sensorId1);
        this.checkExpandForEntityTypeRelations(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkExpandForEntityTypeRelations(EntityType.OBSERVATION, observationId1);
        this.checkExpandForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
        this.checkExpandForEntityTypeMultilevel(EntityType.THING);
        this.checkExpandForEntityTypeMultilevel(EntityType.LOCATION);
        this.checkExpandForEntityTypeMultilevel(EntityType.HISTORICAL_LOCATION);
        this.checkExpandForEntityTypeMultilevel(EntityType.DATASTREAM);
        this.checkExpandForEntityTypeMultilevel(EntityType.SENSOR);
        this.checkExpandForEntityTypeMultilevel(EntityType.OBSERVED_PROPERTY);
        this.checkExpandForEntityTypeMultilevel(EntityType.OBSERVATION);
        this.checkExpandForEntityTypeMultilevel(EntityType.FEATURE_OF_INTEREST);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.THING, thingId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.LOCATION, locationId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.DATASTREAM, datastreamId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.SENSOR, sensorId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.OBSERVATION, observationId1);
        this.checkExpandForEntityTypeMultilevelRelations(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
        this.checkNestedExpandForEntity(EntityType.THING, thingId1);
        this.checkNestedExpandForEntity(EntityType.LOCATION, locationId1);
        this.checkNestedExpandForEntity(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkNestedExpandForEntity(EntityType.DATASTREAM, datastreamId1);
        this.checkNestedExpandForEntity(EntityType.SENSOR, sensorId1);
        this.checkNestedExpandForEntity(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkNestedExpandForEntity(EntityType.OBSERVATION, observationId1);
        this.checkNestedExpandForEntity(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
    }

    @Test
    void readEntitiesWithTopQO() {
        LOGGER.info("  readEntitiesWithTopQO");
        this.checkTopForEntityType(EntityType.THING);
        this.checkTopForEntityType(EntityType.LOCATION);
        this.checkTopForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkTopForEntityType(EntityType.DATASTREAM);
        this.checkTopForEntityType(EntityType.SENSOR);
        this.checkTopForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkTopForEntityType(EntityType.OBSERVATION);
        this.checkTopForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkTopForEntityTypeRelation(EntityType.THING, thingId1);
        this.checkTopForEntityTypeRelation(EntityType.LOCATION, locationId1);
        this.checkTopForEntityTypeRelation(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkTopForEntityTypeRelation(EntityType.DATASTREAM, datastreamId1);
        this.checkTopForEntityTypeRelation(EntityType.SENSOR, sensorId1);
        this.checkTopForEntityTypeRelation(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkTopForEntityTypeRelation(EntityType.OBSERVATION, observationId1);
        this.checkTopForEntityTypeRelation(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
    }

    @Test
    void readEntitiesWithSkipQO() {
        LOGGER.info("  readEntitiesWithSkipQO");
        this.checkSkipForEntityType(EntityType.THING);
        this.checkSkipForEntityType(EntityType.LOCATION);
        this.checkSkipForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkSkipForEntityType(EntityType.DATASTREAM);
        this.checkSkipForEntityType(EntityType.SENSOR);
        this.checkSkipForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkSkipForEntityType(EntityType.OBSERVATION);
        this.checkSkipForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkSkipForEntityTypeRelation(EntityType.THING, thingId1);
        this.checkSkipForEntityTypeRelation(EntityType.LOCATION, locationId1);
        this.checkSkipForEntityTypeRelation(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkSkipForEntityTypeRelation(EntityType.DATASTREAM, datastreamId1);
        this.checkSkipForEntityTypeRelation(EntityType.SENSOR, sensorId1);
        this.checkSkipForEntityTypeRelation(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkSkipForEntityTypeRelation(EntityType.OBSERVATION, observationId1);
        this.checkSkipForEntityTypeRelation(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
    }

    @Test
    void readEntitiesWithOrderbyQO() {
        LOGGER.info("  readEntitiesWithOrderbyQO");
        this.checkOrderbyForEntityType(EntityType.THING);
        this.checkOrderbyForEntityType(EntityType.LOCATION);
        this.checkOrderbyForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkOrderbyForEntityType(EntityType.DATASTREAM);
        this.checkOrderbyForEntityType(EntityType.SENSOR);
        this.checkOrderbyForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkOrderbyForEntityType(EntityType.OBSERVATION);
        this.checkOrderbyForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkOrderbyForEntityTypeRelations(EntityType.THING);
        this.checkOrderbyForEntityTypeRelations(EntityType.LOCATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkOrderbyForEntityTypeRelations(EntityType.SENSOR);
        this.checkOrderbyForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkOrderbyForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test
    void readEntitiesWithCountQO() {
        LOGGER.info("  readEntitiesWithCountQO");
        this.checkCountForEntityType(EntityType.THING);
        this.checkCountForEntityType(EntityType.LOCATION);
        this.checkCountForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkCountForEntityType(EntityType.DATASTREAM);
        this.checkCountForEntityType(EntityType.SENSOR);
        this.checkCountForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkCountForEntityType(EntityType.OBSERVATION);
        this.checkCountForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkCountForEntityTypeRelations(EntityType.THING, thingId1);
        this.checkCountForEntityTypeRelations(EntityType.LOCATION, locationId1);
        this.checkCountForEntityTypeRelations(EntityType.HISTORICAL_LOCATION, historicalLocationId1);
        this.checkCountForEntityTypeRelations(EntityType.DATASTREAM, datastreamId1);
        this.checkCountForEntityTypeRelations(EntityType.SENSOR, sensorId1);
        this.checkCountForEntityTypeRelations(EntityType.OBSERVED_PROPERTY, observedPropertyId1);
        this.checkCountForEntityTypeRelations(EntityType.OBSERVATION, observationId1);
        this.checkCountForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1);
    }

    @Test
    void readEntitiesWithFilterQO() throws UnsupportedEncodingException {
        LOGGER.info("  readEntitiesWithFilterQO");
        this.checkFilterForEntityType(EntityType.THING);
        this.checkFilterForEntityType(EntityType.LOCATION);
        this.checkFilterForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkFilterForEntityType(EntityType.DATASTREAM);
        this.checkFilterForEntityType(EntityType.SENSOR);
        this.checkFilterForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkFilterForEntityType(EntityType.OBSERVATION);
        this.checkFilterForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkFilterForEntityTypeRelations(EntityType.THING);
        this.checkFilterForEntityTypeRelations(EntityType.LOCATION);
        this.checkFilterForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkFilterForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkFilterForEntityTypeRelations(EntityType.SENSOR);
        this.checkFilterForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkFilterForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkFilterForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test
    void checkQueriesPriorityOrdering() {
        LOGGER.info("  checkQueriesPriorityOrdering");
        try {
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?$count=true&$top=1&$skip=2&$orderby=phenomenonTime%20asc&$filter=result%20gt%20'3'");
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            String message = "There is problem for GET Observations using multiple Query Options! HTTP status code: " + responseMap.code;
            Assertions.assertEquals((int)200, (int)responseMap.code, (String)message);
            String response = responseMap.response;
            JSONArray array = new JSONObject(response).getJSONArray("value");
            message = "The query order of execution is not correct. The expected count is 6. The service returned " + new JSONObject(response).getLong("@iot.count");
            Assertions.assertEquals((long)6L, (long)new JSONObject(response).getLong("@iot.count"), (String)message);
            message = "The query asked for top 1. The service rerurned " + array.length() + " entities.";
            Assertions.assertEquals((int)1, (int)array.length(), (String)message);
            message = "The query order of execution is not correct. The expected Observation result is 6. It is " + array.getJSONObject(0).get("result").toString();
            Assertions.assertEquals((Object)"6", (Object)array.getJSONObject(0).get("result").toString(), (String)message);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test
    void checkAndOrPrecendece() throws UnsupportedEncodingException {
        LOGGER.info("  checkAndOrPrecendece");
        String filter = "$filter=result eq 2 and result eq 1 or result eq 1";
        String fetchError = "There is problem for GET Observations using " + filter;
        String error = filter + "  should return all Observations with a result of 1.";
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
        filter = "$filter=(result eq 2 and result eq 1) or result eq 1";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return all Observations with a result of 1.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
        filter = "$filter=result eq 2 and (result eq 1 or result eq 1)";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return no results.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 0, "1", fetchError, error);
        filter = "$filter=not result lt 1 and not result gt 1";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return all Observations with a result of 1.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
    }

    @Test
    void checkArithmeticPrecendece() throws UnsupportedEncodingException {
        LOGGER.info("  checkArithmeticPrecendece");
        String filter = "$filter=1 add result mul 2 sub -1 eq 4";
        String fetchError = "There is problem for GET Observations using " + filter;
        String error = filter + "  should return all Observations with a result of 1.";
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
        filter = "$filter=6 div 2 sub result eq 2";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return all Observations with a result of 1.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
        filter = "$filter=1 add 2.0 mod (result add 1) eq 1";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return all Observations with a result of 1.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
        filter = "$filter=14 div (result add 1) mod 3 mul 3 eq 3";
        fetchError = "There is problem for GET Observations using " + filter;
        error = filter + "  should return all Observations with a result of 1.";
        urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, null, null, "?" + URLEncoder.encode(filter, "UTF-8"));
        this.checkResults(urlString, 1, "1", fetchError, error);
    }

    private void checkResults(String urlString, int expectedCount, String expectedResult, String fetchError, String resultError) {
        try {
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            String message = fetchError + ": " + responseMap.code;
            Assertions.assertEquals((int)200, (int)responseMap.code, (String)message);
            String response = responseMap.response;
            JSONArray array = new JSONObject(response).getJSONArray("value");
            int length = array.length();
            message = resultError + " Expected " + expectedCount + " Observations. got " + length + ".";
            Assertions.assertEquals((int)expectedCount, (int)length, (String)message);
            for (int i = 0; i < length; ++i) {
                JSONObject obs = array.getJSONObject(i);
                String result = obs.get("result").toString();
                String msg = resultError + " The expected Observation result is " + expectedResult + ", but the given result is " + result;
                Assertions.assertEquals((Object)expectedResult, (Object)result, (String)msg);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkOrderbyForEntityTypeRelations(EntityType entityType) {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        try {
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.response;
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            Object id = array.getJSONObject(0).get("@iot.id");
            for (String relation : relations) {
                if (!EntityType.isPlural(relation)) continue;
                EntityType relationEntityType = EntityType.getForRelation(relation);
                List<EntityType.EntityProperty> properties = relationEntityType.getProperties();
                for (EntityType.EntityProperty property : properties) {
                    String message;
                    int i;
                    if (!property.canSort) continue;
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$orderby=" + property.name);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        message = "The ordering is not correct for EntityType " + entityType + " orderby property " + property;
                        this.compareWithPrevious(i, array, property.name, Order.LE, message);
                    }
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$orderby=" + property.name + "%20asc");
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        message = "The ordering is not correct for EntityType " + entityType + " orderby asc property " + property;
                        this.compareWithPrevious(i, array, property.name, Order.LE, message);
                    }
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$orderby=" + property.name + "%20desc");
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        message = "The ordering is not correct for EntityType " + entityType + " orderby desc property " + property;
                        this.compareWithPrevious(i, array, property.name, Order.GE, message);
                    }
                }
                ArrayList<String> orderbyPropeties = new ArrayList<String>();
                Object orderby = "?$orderby=";
                Object orderbyAsc = "?$orderby=";
                Object orderbyDesc = "?$orderby=";
                for (EntityType.EntityProperty property : properties) {
                    String message;
                    String orderProperty;
                    int compare;
                    Iterator iterator;
                    int i;
                    if (!property.canSort) continue;
                    if (((String)orderby).charAt(((String)orderby).length() - 1) != '=') {
                        orderby = (String)orderby + ",";
                    }
                    orderby = (String)orderby + property.name;
                    orderbyPropeties.add(property.name);
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, (String)orderby);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        iterator = orderbyPropeties.iterator();
                        while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.LE, message = "The ordering is not correct for EntityType " + entityType + " orderby property " + orderProperty)) == 0) {
                        }
                    }
                    if (((String)orderbyAsc).charAt(((String)orderbyAsc).length() - 1) != '=') {
                        orderbyAsc = (String)orderbyAsc + ",";
                    }
                    orderbyAsc = (String)orderbyAsc + property + "%20asc";
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, (String)orderbyAsc);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        iterator = orderbyPropeties.iterator();
                        while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.LE, message = "The ordering is not correct for EntityType " + entityType + " orderby asc property " + orderProperty)) == 0) {
                        }
                    }
                    if (((String)orderbyDesc).charAt(((String)orderbyDesc).length() - 1) != '=') {
                        orderbyDesc = (String)orderbyDesc + ",";
                    }
                    orderbyDesc = (String)orderbyDesc + property + "%20desc";
                    urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, (String)orderbyDesc);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.response;
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        iterator = orderbyPropeties.iterator();
                        while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.GE, message = "The ordering is not correct for EntityType " + entityType + " orderby desc property " + orderProperty)) == 0) {
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkOrderbyForEntityType(EntityType entityType) {
        List<EntityType.EntityProperty> properties = entityType.getProperties();
        try {
            for (EntityType.EntityProperty property : properties) {
                String msg;
                int i;
                if (!property.canSort) continue;
                String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$orderby=" + property.name);
                HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
                String response = responseMap.response;
                JSONArray array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    msg = "The default ordering is not correct for EntityType " + entityType + " orderby property " + property.name;
                    this.compareWithPrevious(i, array, property.name, Order.LE, msg);
                }
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$orderby=" + property.name + "%20asc");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    msg = "The ascending ordering is not correct for EntityType " + entityType + " orderby asc property " + property.name;
                    this.compareWithPrevious(i, array, property.name, Order.LE, msg);
                }
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$orderby=" + property.name + "%20desc");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    msg = "The descending ordering is not correct for EntityType " + entityType + " orderby desc property " + property.name;
                    this.compareWithPrevious(i, array, property.name, Order.GE, msg);
                }
            }
            ArrayList<String> orderbyPropeties = new ArrayList<String>();
            Object orderby = "?$orderby=";
            Object orderbyAsc = "?$orderby=";
            Object orderbyDesc = "?$orderby=";
            for (EntityType.EntityProperty property : properties) {
                String message;
                String orderProperty;
                int compare;
                Iterator iterator;
                int i;
                if (!property.canSort) continue;
                if (((String)orderby).charAt(((String)orderby).length() - 1) != '=') {
                    orderby = (String)orderby + ",";
                }
                orderby = (String)orderby + property.name;
                orderbyPropeties.add(property.name);
                String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, (String)orderby);
                HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
                String response = responseMap.response;
                JSONArray array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    iterator = orderbyPropeties.iterator();
                    while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.LE, message = "The ordering is not correct for EntityType " + entityType + " orderby property " + orderProperty)) == 0) {
                    }
                }
                if (((String)orderbyAsc).charAt(((String)orderbyAsc).length() - 1) != '=') {
                    orderbyAsc = (String)orderbyAsc + ",";
                }
                orderbyAsc = (String)orderbyAsc + property + "%20asc";
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, (String)orderbyAsc);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    iterator = orderbyPropeties.iterator();
                    while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.LE, message = "The ordering is not correct for EntityType " + entityType + " orderby asc property " + orderProperty)) == 0) {
                    }
                }
                if (((String)orderbyDesc).charAt(((String)orderbyDesc).length() - 1) != '=') {
                    orderbyDesc = (String)orderbyDesc + ",";
                }
                orderbyDesc = (String)orderbyDesc + property + "%20desc";
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, (String)orderbyDesc);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    iterator = orderbyPropeties.iterator();
                    while (iterator.hasNext() && (compare = this.compareWithPrevious(i, array, orderProperty = (String)iterator.next(), Order.GE, message = "The ordering is not correct for EntityType " + entityType + " orderby desc property " + orderProperty)) == 0) {
                    }
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing " + entityType + ":\n" + e.getMessage()));
        }
    }

    private int compareWithPrevious(int idx, JSONArray array, String property, Order order, String message) throws JSONException {
        JSONObject jObj1 = array.getJSONObject(idx - 1);
        JSONObject jObj2 = array.getJSONObject(idx);
        int result = this.compareObjects(property, jObj1, jObj2, order, message);
        return result;
    }

    private int compareObjects(String property, JSONObject jObj1, JSONObject jObj2, Order order, String message) throws JSONException {
        Object o1 = null;
        Object o2 = null;
        if (jObj1.has(property)) {
            o1 = jObj1.get(property);
        }
        if (jObj2.has(property)) {
            o2 = jObj2.get(property);
        }
        int result = o1 == null || o2 == null || o1 == JSONObject.NULL || o2 == JSONObject.NULL ? 0 : this.compareForOrder(property, o1, o2);
        String fullMessage = message + " Checking: '" + Objects.toString(o1) + "' " + order + " '" + Objects.toString(o2) + "'";
        switch (order) {
            case LT: {
                Assertions.assertTrue((result < 0 ? 1 : 0) != 0, (String)fullMessage);
                break;
            }
            case LE: {
                Assertions.assertTrue((result <= 0 ? 1 : 0) != 0, (String)fullMessage);
                break;
            }
            case EQ: {
                Assertions.assertTrue((result == 0 ? 1 : 0) != 0, (String)fullMessage);
                break;
            }
            case GE: {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0, (String)fullMessage);
                break;
            }
            case GT: {
                Assertions.assertTrue((result > 0 ? 1 : 0) != 0, (String)fullMessage);
                break;
            }
            default: {
                throw new AssertionError((Object)order.name());
            }
        }
        return result;
    }

    private int compareForOrder(String property, Object o1, Object o2) {
        if (property.toLowerCase().endsWith("time")) {
            String t1s = Objects.toString(o1);
            String t2s = Objects.toString(o2);
            if (t1s.contains("/")) {
                String[] t1Parts = t1s.split("/");
                String[] t2Parts = t2s.split("/");
                int result = ZonedDateTime.parse(t1Parts[0]).compareTo(ZonedDateTime.parse(t2Parts[0]));
                if (result != 0) {
                    return result;
                }
                return ZonedDateTime.parse(t1Parts[1]).compareTo(ZonedDateTime.parse(t2Parts[1]));
            }
            ZonedDateTime t1 = ZonedDateTime.parse(t1s);
            ZonedDateTime t2 = ZonedDateTime.parse(t2s);
            return t1.compareTo(t2);
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            if (o1.getClass().isAssignableFrom(o2.getClass())) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o2.getClass().isAssignableFrom(o1.getClass())) {
                return -((Comparable)o2).compareTo(o1);
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    private void checkSkipForEntityType(EntityType entityType) {
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        request.getQuery().setTop(12L).setSkip(1L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setSkip(2L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setSkip(3L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setSkip(4L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setSkip(12L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
    }

    private void checkSkipForEntityTypeRelation(EntityType entityType, Object entityId) {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            if (!EntityType.isPlural(relation)) continue;
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural, entityId)).addElement(new PathElement(relation));
            request.getQuery().setTop(12L).setSkip(1L);
            JSONObject response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkTopForEntityType(EntityType entityType) {
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        request.getQuery().setTop(1L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(2L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(3L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(4L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(5L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(12L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setTop(13L);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
    }

    private void checkTopForEntityTypeRelation(EntityType entityType, Object entityId) {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            if (!EntityType.isPlural(relation)) continue;
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural, entityId)).addElement(new PathElement(relation));
            Query query = request.getQuery();
            query.setTop(3L);
            JSONObject response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkSelectForEntityType(EntityType entityType) {
        List<EntityType.EntityProperty> properties = entityType.getProperties();
        this.checkSelectSingleProperty(entityType, properties);
        this.checkSelectMultipleProperties(entityType, properties);
        this.checkSelectNavigationProperty(entityType);
    }

    private void checkSelectSingleProperty(EntityType entityType, List<EntityType.EntityProperty> properties) {
        for (EntityType.EntityProperty property : properties) {
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural));
            request.getQuery().addSelect(property.name);
            JSONObject response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkSelectMultipleProperties(EntityType entityType, List<EntityType.EntityProperty> properties) {
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        for (EntityType.EntityProperty property : properties) {
            request.getQuery().addSelect(property.name);
            JSONObject response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkSelectNavigationProperty(EntityType entityType) {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural));
            request.getQuery().addSelect(relation);
            JSONObject response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkSelectForEntityTypeRelations(EntityType entityType, Object entityId) {
        List<String> parentRelations = entityType.getRelations(serverSettings.getExtensions());
        for (String parentRelation : parentRelations) {
            JSONObject response;
            EntityType relationEntityType = EntityType.getForRelation(parentRelation);
            List<EntityType.EntityProperty> properties = relationEntityType.getProperties();
            for (EntityType.EntityProperty property : properties) {
                Request request = new Request(serverSettings.getServiceUrl(version));
                request.addElement(new PathElement(entityType.plural, entityId));
                request.addElement(new PathElement(parentRelation));
                request.getQuery().addSelect(property.name);
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural, entityId));
            request.addElement(new PathElement(parentRelation));
            for (EntityType.EntityProperty property : properties) {
                request.getQuery().addSelect(property.name);
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
        }
    }

    private void checkExpandForEntityType(EntityType entityType) {
        JSONObject response;
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural));
            request.getQuery().addExpand(new Expand().addElement(new PathElement(relation)));
            response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        for (String relation : relations) {
            request.getQuery().addExpand(new Expand().addElement(new PathElement(relation)));
            response = request.executeGet();
            EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
        }
    }

    private void checkExpandForEntityTypeRelations(EntityType entityType, Object entityId) {
        PathElement entityPathElement = new PathElement(entityType.plural, entityId);
        List<String> parentRelations = entityType.getRelations(serverSettings.getExtensions());
        for (String parentRelation : parentRelations) {
            JSONObject response;
            EntityType parentRelationEntityType = EntityType.getForRelation(parentRelation);
            PathElement parentRelationPathElement = new PathElement(parentRelation);
            List<String> relations = parentRelationEntityType.getRelations(serverSettings.getExtensions());
            for (String relation : relations) {
                Request request = new Request(serverSettings.getServiceUrl(version));
                request.addElement(entityPathElement);
                request.addElement(parentRelationPathElement);
                request.getQuery().addExpand(new Expand().addElement(new PathElement(relation)));
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(entityPathElement);
            request.addElement(parentRelationPathElement);
            for (String relation : relations) {
                request.getQuery().addExpand(new Expand().addElement(new PathElement(relation)));
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
        }
    }

    private void checkExpandForEntityTypeMultilevelRelations(EntityType entityType, Object entityId) {
        PathElement entityPathElement = new PathElement(entityType.plural, entityId);
        List<String> parentRelations = entityType.getRelations(serverSettings.getExtensions());
        for (String parentRelation : parentRelations) {
            JSONObject response;
            Expand expand;
            EntityType parentRelationEntityType = EntityType.getForRelation(parentRelation);
            PathElement parentRelationPathElement = new PathElement(parentRelation);
            List<String> relations = parentRelationEntityType.getRelations(serverSettings.getExtensions());
            for (String relation : relations) {
                EntityType relationType = EntityType.getForRelation(relation);
                List<String> secondLevelRelations = relationType.getRelations(serverSettings.getExtensions());
                for (String secondLevelRelation : secondLevelRelations) {
                    Request request = new Request(serverSettings.getServiceUrl(version));
                    request.addElement(entityPathElement);
                    request.addElement(parentRelationPathElement);
                    expand = new Expand().addElement(new PathElement(relation)).addElement(new PathElement(secondLevelRelation));
                    request.getQuery().addExpand(expand);
                    response = request.executeGet();
                    request.reNest();
                    EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
                }
            }
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(entityPathElement);
            request.addElement(parentRelationPathElement);
            for (String relation : relations) {
                EntityType relationType = EntityType.getForRelation(relation);
                List<String> secondLevelRelations = relationType.getRelations(serverSettings.getExtensions());
                for (String secondLevelRelation : secondLevelRelations) {
                    expand = new Expand().addElement(new PathElement(relation)).addElement(new PathElement(secondLevelRelation));
                    request.getQuery().addExpand(expand);
                    response = request.executeGet();
                    EntityUtils.checkResponse(serverSettings.getExtensions(), response, request.clone().reNest(), ENTITYCOUNTS);
                }
            }
        }
    }

    private void checkExpandForEntityTypeMultilevel(EntityType entityType) {
        JSONObject response;
        Expand expand;
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            EntityType relationType = EntityType.getForRelation(relation);
            List<String> secondLevelRelations = relationType.getRelations(serverSettings.getExtensions());
            for (String secondLevelRelation : secondLevelRelations) {
                Request request = new Request(serverSettings.getServiceUrl(version));
                request.addElement(new PathElement(entityType.plural));
                expand = new Expand().addElement(new PathElement(relation)).addElement(new PathElement(secondLevelRelation));
                request.getQuery().addExpand(expand);
                response = request.executeGet();
                request.reNest();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
        }
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        for (String relation : relations) {
            EntityType relationType = EntityType.getForRelation(relation);
            List<String> secondLevelRelations = relationType.getRelations(serverSettings.getExtensions());
            for (String secondLevelRelation : secondLevelRelations) {
                expand = new Expand().addElement(new PathElement(relation)).addElement(new PathElement(secondLevelRelation));
                request.getQuery().addExpand(expand);
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request.clone().reNest(), ENTITYCOUNTS);
            }
        }
    }

    private void checkNestedExpandForEntity(EntityType entityType, Object entityId) {
        PathElement collectionPathElement = new PathElement(entityType.plural);
        PathElement entityPathElement = new PathElement(entityType.plural, entityId);
        Request request2 = new Request(serverSettings.getServiceUrl(version));
        request2.addElement(collectionPathElement);
        boolean even = true;
        long skip = 0L;
        List<String> parentRelations = entityType.getRelations(serverSettings.getExtensions());
        for (String parentRelation : parentRelations) {
            EntityType parentRelationEntityType = EntityType.getForRelation(parentRelation);
            List<String> childRelations = parentRelationEntityType.getRelations(serverSettings.getExtensions());
            for (String childRelation : childRelations) {
                EntityType childRelationEntityType = EntityType.getForRelation(childRelation);
                Request request = new Request(serverSettings.getServiceUrl(version));
                request.addElement(entityPathElement);
                Query query = request.getQuery();
                entityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query.getSelect(), even);
                query.setCount(even);
                query.setTop(2L);
                query.setSkip(skip);
                Expand expand = new Expand().addElement(new PathElement(parentRelation));
                query.addExpand(expand);
                even = !even;
                skip = 1L - skip;
                query = expand.getQuery();
                query.setCount(even);
                query.setTop(2L);
                query.setSkip(skip);
                parentRelationEntityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query.getSelect(), even);
                expand = new Expand().addElement(new PathElement(childRelation));
                query.addExpand(expand);
                even = !even;
                skip = 1L - skip;
                query = expand.getQuery();
                childRelationEntityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query.getSelect(), even);
                query.setCount(even);
                query.setTop(2L);
                query.setSkip(skip);
                even = !even;
                skip = 1L - skip;
                JSONObject response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
                request.getPath().clear();
                request.addElement(collectionPathElement);
                response = request.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request, ENTITYCOUNTS);
            }
            Query query1 = request2.getQuery();
            Expand expand = new Expand().addElement(new PathElement(parentRelation));
            query1.addExpand(expand);
            entityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query1.getSelect(), even);
            query1.setCount(even);
            even = !even;
            Query query2 = expand.getQuery();
            for (String childRelation : childRelations) {
                parentRelationEntityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query2.getSelect(), even);
                query2.setCount(even);
                EntityType childRelationEntityType = EntityType.getForRelation(childRelation);
                expand = new Expand().addElement(new PathElement(childRelation));
                query2.addExpand(expand);
                even = !even;
                Query query3 = expand.getQuery();
                childRelationEntityType.getHalfPropertiesRelations(serverSettings.getExtensions(), query3.getSelect(), even);
                query3.setCount(even);
                even = !even;
                JSONObject response = request2.executeGet();
                EntityUtils.checkResponse(serverSettings.getExtensions(), response, request2, ENTITYCOUNTS);
                even = !even;
            }
        }
    }

    private void checkCountForEntityType(EntityType entityType) {
        Request request = new Request(serverSettings.getServiceUrl(version));
        request.addElement(new PathElement(entityType.plural));
        request.getQuery().setCount(true);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        request.getQuery().setCount(false);
        EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
    }

    private void checkCountForEntityTypeRelations(EntityType entityType, Object entityId) {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        for (String relation : relations) {
            if (!EntityType.isPlural(relation)) continue;
            Request request = new Request(serverSettings.getServiceUrl(version));
            request.addElement(new PathElement(entityType.plural, entityId)).addElement(new PathElement(relation));
            Query query = request.getQuery();
            query.setCount(true);
            EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
            query.setCount(false);
            EntityUtils.checkResponse(serverSettings.getExtensions(), request.executeGet(), request, ENTITYCOUNTS);
        }
    }

    private void checkFilterForEntityType(EntityType entityType) throws UnsupportedEncodingException {
        List<EntityType.EntityProperty> properties = entityType.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            EntityType.EntityProperty property = properties.get(i);
            ArrayList<String> filteredProperties = new ArrayList<String>();
            ArrayList<Comparable> samplePropertyValues = new ArrayList<Comparable>();
            if (!property.canSort) continue;
            filteredProperties.add(property.name);
            Object propertyValue = EntityPropertiesSampleValue.getPropertyValueFor(entityType, i);
            if (propertyValue == null) continue;
            samplePropertyValues.add((Comparable)propertyValue);
            propertyValue = URLEncoder.encode(propertyValue.toString(), "UTF-8");
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20lt%20" + (Comparable)propertyValue);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -2);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20le%20" + (Comparable)propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -1);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20eq%20" + (Comparable)propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 0);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20ne%20" + (Comparable)propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -3);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20ge%20" + (Comparable)propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 1);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, "?$filter=" + property.name + "%20gt%20" + (Comparable)propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 2);
        }
    }

    private void checkFilterForEntityTypeRelations(EntityType entityType) throws UnsupportedEncodingException {
        List<String> relations = entityType.getRelations(serverSettings.getExtensions());
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.response;
        JSONArray array = null;
        try {
            array = new JSONObject(response).getJSONArray("value");
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
        if (array.length() == 0) {
            return;
        }
        Object id = null;
        try {
            id = array.getJSONObject(0).get("@iot.id");
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
        for (String relation : relations) {
            if (!EntityType.isPlural(relation)) {
                return;
            }
            EntityType relationEntityType = EntityType.getForRelation(relation);
            List<EntityType.EntityProperty> properties = relationEntityType.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                ArrayList<String> filteredProperties = new ArrayList<String>();
                ArrayList<Comparable> samplePropertyValues = new ArrayList<Comparable>();
                EntityType.EntityProperty property = properties.get(i);
                if (!property.canSort) continue;
                filteredProperties.add(property.name);
                Object propertyValue = EntityPropertiesSampleValue.getPropertyValueFor(relationEntityType, i);
                if (propertyValue == null) continue;
                samplePropertyValues.add((Comparable)propertyValue);
                propertyValue = URLEncoder.encode(propertyValue.toString(), "UTF-8");
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20lt%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -2);
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20le%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -1);
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20eq%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 0);
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20ne%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -3);
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20ge%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 1);
                urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, relationEntityType, "?$filter=" + property.name + "%20gt%20" + (Comparable)propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.response;
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 2);
            }
        }
    }

    private void checkPropertiesForFilter(String response, List<String> properties, List<Comparable> values, int operator) {
        try {
            JSONObject entities = new JSONObject(response);
            JSONArray entityArray = entities.getJSONArray("value");
            for (int i = 0; i < entityArray.length(); ++i) {
                JSONObject entity = entityArray.getJSONObject(i);
                block13: for (int j = 0; j < properties.size(); ++j) {
                    Object value;
                    Object propertyValue = "";
                    try {
                        propertyValue = entity.get(properties.get(j));
                    }
                    catch (JSONException e) {
                        Assertions.fail((String)("The entity does not have property " + properties.get(j)));
                    }
                    if (propertyValue == null) {
                        Assertions.fail((String)("The entity has null value for property " + properties.get(j)));
                    }
                    if ((value = values.get(j)) instanceof String && ((String)value).charAt(0) == '\'') {
                        String sValue = (String)value;
                        value = sValue.substring(1, sValue.length() - 1);
                        if (!(propertyValue instanceof String)) {
                            propertyValue = propertyValue.toString();
                        }
                    } else if (value instanceof ZonedDateTime) {
                        propertyValue = ZonedDateTime.parse(propertyValue.toString());
                    }
                    int result = value.compareTo(propertyValue);
                    switch (operator) {
                        case -3: {
                            String message = properties.get(j) + " should not be equal to " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertNotEquals((int)0, (int)result, (String)message);
                            continue block13;
                        }
                        case -2: {
                            String message = properties.get(j) + " should be less than " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertTrue((result > 0 ? 1 : 0) != 0, (String)message);
                            continue block13;
                        }
                        case -1: {
                            String message = properties.get(j) + " should be less than or equal to " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertTrue((result >= 0 ? 1 : 0) != 0, (String)message);
                            continue block13;
                        }
                        case 0: {
                            String message = properties.get(j) + " should be equal to than " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertEquals((int)0, (int)result, (String)message);
                            continue block13;
                        }
                        case 1: {
                            String message = properties.get(j) + " should be greate than or equal to " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertTrue((result <= 0 ? 1 : 0) != 0, (String)message);
                            continue block13;
                        }
                        case 2: {
                            String message = properties.get(j) + " should be greater than " + (Comparable)value + ". But the property value is " + propertyValue;
                            Assertions.assertTrue((result < 0 ? 1 : 0) != 0, (String)message);
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing " + properties + ":\n" + e.getMessage()));
        }
    }

    private static Object postAndGetId(String urlString, String postContent) {
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doPost(urlString, postContent);
        String response = responseMap.response;
        return Utils.idObjectFromPostResult(response);
    }

    private static void createEntities() {
        try {
            Object urlParameters = "{\n    \"name\": \"thing 1\",\n    \"description\": \"thing 1\",\n    \"properties\": {\n        \"reference\": \"first\"\n    },\n    \"Locations\": [\n        {\n            \"name\": \"location 1\",\n            \"description\": \"location 1\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -117.05,\n                    51.05\n                ]\n            },\n            \"encodingType\": \"application/vnd.geo+json\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 1\",\n            \"description\": \"datastream 1\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/LuminousFlux\",\n                \"description\": \"observedProperty 1\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 1\",\n                \"description\": \"sensor 1\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Light flux sensor\"\n            }\n        },\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Centigrade\",\n                \"symbol\": \"C\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 2\",\n            \"description\": \"datastream 2\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Tempretaure\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/Tempreture\",\n                \"description\": \"observedProperty 2\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 2\",\n                \"description\": \"sensor 2\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Tempreture sensor\"\n            }\n        }\n    ]\n}";
            String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, null, null, null);
            thingId1 = Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId1, EntityType.LOCATION, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.response;
            JSONArray array = new JSONObject(response).getJSONArray("value");
            locationId1 = array.getJSONObject(0).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId1, EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            if ("datastream 1".equals(array.getJSONObject(0).get("name"))) {
                datastreamId1 = array.getJSONObject(0).get("@iot.id");
                datastreamId2 = array.getJSONObject(1).get("@iot.id");
            } else {
                datastreamId1 = array.getJSONObject(1).get("@iot.id");
                datastreamId2 = array.getJSONObject(0).get("@iot.id");
            }
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId1, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            sensorId1 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId1, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            observedPropertyId1 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId2, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            sensorId2 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId2, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            observedPropertyId2 = new JSONObject(response).get("@iot.id");
            urlParameters = "{\n    \"name\": \"thing 2\",\n    \"description\": \"thing 2\",\n    \"properties\": {\n        \"reference\": \"second\"\n    },\n    \"Locations\": [\n        {\n            \"name\": \"location 2\",\n            \"description\": \"location 2\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -100.05,\n                    50.05\n                ]\n            },\n            \"encodingType\": \"application/vnd.geo+json\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 3\",\n            \"description\": \"datastream 3\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Second Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/LuminousFlux\",\n                \"description\": \"observedProperty 3\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 3\",\n                \"description\": \"sensor 3\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Second Light flux sensor\"\n            }\n        },\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Centigrade\",\n                \"symbol\": \"C\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 2\",\n            \"description\": \"datastream 2\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"@iot.id\": " + Utils.quoteIdForJson(observedPropertyId2) + "\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 4 \",\n                \"description\": \"sensor 4 \",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Second Tempreture sensor\"\n            }\n        }\n    ]\n}";
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, null, null, null);
            thingId2 = Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId2, EntityType.LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            locationId2 = array.getJSONObject(0).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId2, EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            if ("datastream 3".equals(array.getJSONObject(0).get("name"))) {
                datastreamId3 = array.getJSONObject(0).get("@iot.id");
                datastreamId4 = array.getJSONObject(1).get("@iot.id");
            } else {
                datastreamId4 = array.getJSONObject(0).get("@iot.id");
                datastreamId3 = array.getJSONObject(1).get("@iot.id");
            }
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId3, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            sensorId3 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId3, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            observedPropertyId3 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId4, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            sensorId4 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId1, null, null);
            urlParameters = "{\"Locations\": [\n    {\n      \"@iot.id\": " + Utils.quoteIdForJson(locationId2) + "\n    }\n  ]}";
            HTTPMethods.doPatch(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId2, null, null);
            urlParameters = "{\"Locations\": [\n    {\n      \"@iot.id\": " + Utils.quoteIdForJson(locationId1) + "\n    }\n  ]}";
            HTTPMethods.doPatch(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId1, EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            historicalLocationId1 = array.getJSONObject(0).get("@iot.id");
            historicalLocationId2 = array.getJSONObject(1).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.THING, thingId2, EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            array = new JSONObject(response).getJSONArray("value");
            historicalLocationId3 = array.getJSONObject(0).get("@iot.id");
            historicalLocationId4 = array.getJSONObject(1).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId1, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 1 \n   }";
            observationId1 = Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-02T00:00:00Z\",\n  \"result\": 2 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-03T00:00:00Z\",\n  \"result\": 3 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId2, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-04T00:00:00Z\",\n  \"result\": 4 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-05T00:00:00Z\",\n  \"result\": 5 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-06T00:00:00Z\",\n  \"result\": 6 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId3, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-07T00:00:00Z\",\n  \"result\": 7 \n   }";
            observationId7 = Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-08T00:00:00Z\",\n  \"result\": 8 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-09T00:00:00Z\",\n  \"result\": 9 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.DATASTREAM, datastreamId4, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-10T00:00:00Z\",\n  \"result\": 10 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-11T00:00:00Z\",\n  \"result\": 11 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-12T00:00:00Z\",\n  \"result\": 12 \n   }";
            Capability3Tests.postAndGetId(urlString, (String)urlParameters);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, observationId1, EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            featureOfInterestId1 = new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), EntityType.OBSERVATION, observationId7, EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.response;
            featureOfInterestId2 = new JSONObject(response).get("@iot.id");
            ENTITYCOUNTS.setGlobalCount(EntityType.DATASTREAM, 4L);
            ENTITYCOUNTS.setGlobalCount(EntityType.FEATURE_OF_INTEREST, 2L);
            ENTITYCOUNTS.setGlobalCount(EntityType.HISTORICAL_LOCATION, 4L);
            ENTITYCOUNTS.setGlobalCount(EntityType.LOCATION, 2L);
            ENTITYCOUNTS.setGlobalCount(EntityType.OBSERVATION, 12L);
            ENTITYCOUNTS.setGlobalCount(EntityType.OBSERVED_PROPERTY, 3L);
            ENTITYCOUNTS.setGlobalCount(EntityType.SENSOR, 4L);
            ENTITYCOUNTS.setGlobalCount(EntityType.THING, 2L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId1, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId2, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId1, EntityType.HISTORICAL_LOCATION, 2L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId2, EntityType.HISTORICAL_LOCATION, 2L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId1, EntityType.DATASTREAM, 2L);
            ENTITYCOUNTS.setCount(EntityType.THING, thingId2, EntityType.DATASTREAM, 2L);
            ENTITYCOUNTS.setCount(EntityType.LOCATION, locationId1, EntityType.THING, 1L);
            ENTITYCOUNTS.setCount(EntityType.LOCATION, locationId2, EntityType.THING, 1L);
            ENTITYCOUNTS.setCount(EntityType.LOCATION, locationId1, EntityType.HISTORICAL_LOCATION, 2L);
            ENTITYCOUNTS.setCount(EntityType.LOCATION, locationId2, EntityType.HISTORICAL_LOCATION, 2L);
            ENTITYCOUNTS.setCount(EntityType.HISTORICAL_LOCATION, historicalLocationId1, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.HISTORICAL_LOCATION, historicalLocationId2, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.HISTORICAL_LOCATION, historicalLocationId3, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.HISTORICAL_LOCATION, historicalLocationId4, EntityType.LOCATION, 1L);
            ENTITYCOUNTS.setCount(EntityType.DATASTREAM, datastreamId1, EntityType.OBSERVATION, 3L);
            ENTITYCOUNTS.setCount(EntityType.DATASTREAM, datastreamId2, EntityType.OBSERVATION, 3L);
            ENTITYCOUNTS.setCount(EntityType.DATASTREAM, datastreamId3, EntityType.OBSERVATION, 3L);
            ENTITYCOUNTS.setCount(EntityType.DATASTREAM, datastreamId4, EntityType.OBSERVATION, 3L);
            ENTITYCOUNTS.setCount(EntityType.SENSOR, sensorId1, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.SENSOR, sensorId2, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.SENSOR, sensorId3, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.SENSOR, sensorId4, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.OBSERVED_PROPERTY, observedPropertyId1, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.OBSERVED_PROPERTY, observedPropertyId2, EntityType.DATASTREAM, 2L);
            ENTITYCOUNTS.setCount(EntityType.OBSERVED_PROPERTY, observedPropertyId3, EntityType.DATASTREAM, 1L);
            ENTITYCOUNTS.setCount(EntityType.FEATURE_OF_INTEREST, featureOfInterestId1, EntityType.OBSERVATION, 6L);
            ENTITYCOUNTS.setCount(EntityType.FEATURE_OF_INTEREST, featureOfInterestId2, EntityType.OBSERVATION, 6L);
        }
        catch (JSONException e) {
            LOGGER.error("Exception: ", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    static {
        ENTITYCOUNTS = new EntityCounts();
    }

    private static enum Order {
        LT,
        LE,
        EQ,
        GE,
        GT;

    }

    public static class Implementation11
    extends Capability3Tests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends Capability3Tests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

