/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c02cud;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultTypesTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultTypesTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();
    private static final List<Observation> OBSERVATIONS = new ArrayList<Observation>();

    public ResultTypesTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)ResultTypesTests.version.urlPart);
        ResultTypesTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        ResultTypesTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        DATASTREAMS.clear();
        DATASTREAMS.clear();
    }

    @AfterAll
    public static void tearDown() {
        LOGGER.info("Tearing down.");
        try {
            ResultTypesTests.cleanup();
        }
        catch (ServiceFailureException ex) {
            LOGGER.error("Failed to clean database.", (Throwable)ex);
        }
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        THINGS.add(thing);
        Location location = new Location("Location 1.0", "Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 51.0));
        thing.getLocations().add((Entity)location);
        service.create((Entity)thing);
        Sensor sensor = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        ObservedProperty obsProp = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        Datastream datastream = new Datastream("Datastream 1", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream.setThing(thing);
        datastream.setSensor(sensor);
        datastream.setObservedProperty(obsProp);
        service.create((Entity)datastream);
        DATASTREAMS.add(datastream);
    }

    @Test
    void testBooleanResult() throws ServiceFailureException {
        LOGGER.info("  testBooleanResult");
        ObservationDao doa = service.observations();
        Observation b1 = new Observation((Object)Boolean.TRUE, DATASTREAMS.get(0));
        doa.create(b1);
        OBSERVATIONS.add(b1);
        Observation b2 = new Observation((Object)Boolean.FALSE, DATASTREAMS.get(0));
        doa.create(b2);
        OBSERVATIONS.add(b2);
        Observation found = (Observation)doa.find(b1.getId());
        String message = "Expected result to be a Boolean.";
        Assertions.assertEquals((Object)b1.getResult(), (Object)found.getResult(), (String)message);
        found = (Observation)doa.find(b2.getId());
        message = "Expected result to be a Boolean.";
        Assertions.assertEquals((Object)b2.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testStringResult() throws ServiceFailureException {
        LOGGER.info("  testStringResult");
        ObservationDao doa = service.observations();
        Observation b1 = new Observation((Object)"fourty two", DATASTREAMS.get(0));
        doa.create(b1);
        OBSERVATIONS.add(b1);
        Observation found = (Observation)doa.find(b1.getId());
        String message = "Expected result to be a String.";
        Assertions.assertEquals((Object)b1.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testNumericResult() throws ServiceFailureException {
        LOGGER.info("  testNumericResult");
        ObservationDao doa = service.observations();
        Observation b1 = new Observation((Object)1, DATASTREAMS.get(0));
        doa.create(b1);
        OBSERVATIONS.add(b1);
        Observation found = (Observation)doa.find(b1.getId());
        String message = "Expected result to be a Number.";
        Assertions.assertEquals((Object)b1.getResult(), (Object)found.getResult(), (String)message);
        Observation b2 = new Observation((Object)BigDecimal.valueOf(1.23), DATASTREAMS.get(0));
        doa.create(b2);
        OBSERVATIONS.add(b2);
        found = (Observation)doa.find(b2.getId());
        message = "Expected result to be a Number.";
        Assertions.assertEquals((Object)b2.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testObjectResult() throws ServiceFailureException {
        LOGGER.info("  testObjectResult");
        ObservationDao doa = service.observations();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("number", BigDecimal.valueOf(1.23));
        result.put("string", "One comma twentythree");
        result.put("boolean", Boolean.TRUE);
        Observation o1 = new Observation(result, DATASTREAMS.get(0));
        doa.create(o1);
        OBSERVATIONS.add(o1);
        Observation found = (Observation)doa.find(o1.getId());
        String message = "Expected result Maps are not equal.";
        Assertions.assertEquals((Object)o1.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testArrayResult() throws ServiceFailureException {
        LOGGER.info("  testArrayResult");
        ObservationDao doa = service.observations();
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BigDecimal.valueOf(1.23));
        result.add("One comma twentythree");
        result.add(Boolean.TRUE);
        Observation o1 = new Observation(result, DATASTREAMS.get(0));
        doa.create(o1);
        OBSERVATIONS.add(o1);
        Observation found = (Observation)doa.find(o1.getId());
        String message = "Expected result Arrays are not equal.";
        Assertions.assertEquals((Object)o1.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testNullResult() throws ServiceFailureException {
        LOGGER.info("  testNullResult");
        ObservationDao doa = service.observations();
        Observation o1 = new Observation(null, DATASTREAMS.get(0));
        doa.create(o1);
        OBSERVATIONS.add(o1);
        Observation found = (Observation)doa.find(o1.getId());
        String message = "Expected result to be Null.";
        Assertions.assertEquals((Object)o1.getResult(), (Object)found.getResult(), (String)message);
        Observation o2 = new Observation((Object)BigDecimal.valueOf(1.23), DATASTREAMS.get(0));
        doa.create(o2);
        OBSERVATIONS.add(o2);
        o2 = o2.withOnlyId();
        o2.setResult(null);
        doa.update((Entity)o2);
        found = (Observation)doa.find(o2.getId());
        message = "Expected result to be Null.";
        Assertions.assertEquals((Object)o2.getResult(), (Object)found.getResult(), (String)message);
    }

    @Test
    void testResultQualityObject() throws ServiceFailureException, IOException {
        LOGGER.info("  testResultQualityObject");
        ObservationDao doa = service.observations();
        Observation o1 = new Observation((Object)1.0, DATASTREAMS.get(0));
        ObjectMapper mapper = ObjectMapperFactory.get();
        String resultQualityString = "{\"DQ_Status\":{  \"code\": \"http://id.eaufrance.fr/nsa/446#2\",  \"label\": \"Niveau 1\",\n  \"comment\": \"Donn\u00e9e contr\u00f4l\u00e9e niveau 1 (donn\u00e9es contr\u00f4l\u00e9es)\"}}";
        o1.setResultQuality((Object)mapper.readTree(resultQualityString));
        doa.create(o1);
        OBSERVATIONS.add(o1);
        Observation found = (Observation)doa.find(o1.getId());
        String message = "resultQuality not stored correctly.";
        Assertions.assertEquals((Object)o1.getResultQuality(), (Object)mapper.valueToTree(found.getResultQuality()), (String)message);
    }

    @Test
    void testResultQualityArray() throws ServiceFailureException, IOException {
        LOGGER.info("  testResultQualityArray");
        ObservationDao doa = service.observations();
        Observation o1 = new Observation((Object)1.0, DATASTREAMS.get(0));
        ObjectMapper mapper = ObjectMapperFactory.get();
        String resultQualityString = "[\n    {\n        \"nameOfMeasure\": \"DQ_Status\",\n        \"DQ_Result\": {\n            \"code\": \"http://id.eaufrance.fr/nsa/446#2\",\n            \"label\": \"Niveau 1\",\n            \"comment\": \"Donn\u00e9e contr\u00f4l\u00e9e niveau 1 (donn\u00e9es contr\u00f4l\u00e9es)\"\n        }\n    },\n    {\n        \"nameOfMeasure\": \"DQ_Qualification\",\n        \"DQ_Result\": {\n            \"code\": \"http://id.eaufrance.fr/nsa/414#1\",\n            \"label\": \"Correcte\",\n            \"comment\": \"Correcte\"\n        }\n    }\n\n]";
        o1.setResultQuality((Object)mapper.readTree(resultQualityString));
        doa.create(o1);
        OBSERVATIONS.add(o1);
        Observation found = (Observation)doa.find(o1.getId());
        String message = "resultQuality not stored correctly.";
        Assertions.assertEquals((Object)o1.getResultQuality(), (Object)mapper.valueToTree(found.getResultQuality()), (String)message);
    }

    public static class Implementation11
    extends ResultTypesTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends ResultTypesTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

