/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c02cud;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.JsonPointerException;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.CopyOperation;
import com.github.fge.jsonpatch.MoveOperation;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geojson.Point;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonPatchTests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPatchTests.class);
    private static final List<Thing> THINGS = new ArrayList<Thing>();
    private static final List<Location> LOCATIONS = new ArrayList<Location>();
    private static final List<Sensor> SENSORS = new ArrayList<Sensor>();
    private static final List<ObservedProperty> OPROPS = new ArrayList<ObservedProperty>();
    private static final List<Datastream> DATASTREAMS = new ArrayList<Datastream>();

    public JsonPatchTests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() throws ServiceFailureException, URISyntaxException {
        LOGGER.info("Setting up for version {}.", (Object)JsonPatchTests.version.urlPart);
        EntityUtils.deleteAll(version, serverSettings, service);
        JsonPatchTests.createEntities();
    }

    @Override
    protected void tearDownVersion() throws ServiceFailureException {
        JsonPatchTests.cleanup();
    }

    private static void cleanup() throws ServiceFailureException {
        EntityUtils.deleteAll(version, serverSettings, service);
        THINGS.clear();
        LOCATIONS.clear();
        SENSORS.clear();
        OPROPS.clear();
        DATASTREAMS.clear();
    }

    @AfterAll
    public static void deleteEverything() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        JsonPatchTests.cleanup();
    }

    private static void createEntities() throws ServiceFailureException, URISyntaxException {
        Thing thing = new Thing("Thing 1", "The first thing.");
        service.create((Entity)thing);
        THINGS.add(thing);
        Location location = new Location("Location Des Dings von ILT", "First Location of Thing 1.", "application/vnd.geo+json", (Object)new Point(8.0, 49.0));
        location.getThings().add((Entity)THINGS.get(0));
        service.create((Entity)location);
        LOCATIONS.add(location);
        Sensor sensor1 = new Sensor("Sensor 1", "The first sensor.", "text", (Object)"Some metadata.");
        service.create((Entity)sensor1);
        SENSORS.add(sensor1);
        Sensor sensor2 = new Sensor("Sensor 2", "The second sensor", "text", (Object)"Some metadata.");
        service.create((Entity)sensor2);
        SENSORS.add(sensor2);
        ObservedProperty obsProp1 = new ObservedProperty("Temperature", new URI("http://ucom.org/temperature"), "The temperature of the thing.");
        service.create((Entity)obsProp1);
        OPROPS.add(obsProp1);
        ObservedProperty obsProp2 = new ObservedProperty("Humidity", new URI("http://ucom.org/humidity"), "The humidity of the thing.");
        service.create((Entity)obsProp2);
        OPROPS.add(obsProp2);
        Datastream datastream1 = new Datastream("Datastream Temp", "The temperature of thing 1, sensor 1.", "someType", new UnitOfMeasurement("degree celcius", "\u00b0C", "ucum:T"));
        datastream1.setThing(THINGS.get(0).withOnlyId());
        datastream1.setSensor(SENSORS.get(0).withOnlyId());
        datastream1.setObservedProperty(OPROPS.get(0).withOnlyId());
        service.create((Entity)datastream1);
        DATASTREAMS.add(datastream1);
        Datastream datastream2 = new Datastream("Datastream LF", "The humidity of thing 1, sensor 2.", "someType", new UnitOfMeasurement("relative humidity", "%", "ucum:Humidity"));
        datastream2.setThing(THINGS.get(0).withOnlyId());
        datastream2.setSensor(SENSORS.get(1).withOnlyId());
        datastream2.setObservedProperty(OPROPS.get(1).withOnlyId());
        service.create((Entity)datastream2);
        DATASTREAMS.add(datastream2);
    }

    @Test
    void jsonPatchThingTest() throws ServiceFailureException, JsonPointerException, IOException {
        LOGGER.info("  jsonPatchThingTest");
        Thing thingOnlyId = THINGS.get(0).withOnlyId();
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(new AddOperation(new JsonPointer("/properties"), new ObjectMapper().readTree("{\"key1\": 1}")));
        service.patch((Entity)thingOnlyId, operations);
        Thing updatedThing = (Thing)service.things().find(thingOnlyId.getId());
        String message = "properties/key1 was not added correctly.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedThing.getProperties().get("key1")), (String)message);
        operations.clear();
        operations.add(new CopyOperation(new JsonPointer("/properties/key1"), new JsonPointer("/properties/keyCopy1")));
        operations.add(new MoveOperation(new JsonPointer("/properties/key1"), new JsonPointer("/properties/key2")));
        service.patch((Entity)thingOnlyId, operations);
        updatedThing = (Thing)service.things().find(thingOnlyId.getId());
        message = "properties/keyCopy1 does not exist after copy.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedThing.getProperties().get("keyCopy1")), (String)message);
        message = "properties/key1 still exists after move.";
        Assertions.assertEquals(null, updatedThing.getProperties().get("key1"), (String)message);
        message = "properties/key2 does not exist after move.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedThing.getProperties().get("key2")), (String)message);
    }

    @Test
    void jsonPatchDatastreamTest() throws ServiceFailureException, JsonPointerException, IOException {
        LOGGER.info("  jsonPatchDatastreamTest");
        Datastream dsOnlyId = DATASTREAMS.get(0).withOnlyId();
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(new AddOperation(new JsonPointer("/properties"), new ObjectMapper().readTree("{\"key1\": 1}")));
        service.patch((Entity)dsOnlyId, operations);
        Datastream updatedDs = (Datastream)service.datastreams().find(dsOnlyId.getId());
        String message = "properties/key1 was not added correctly.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedDs.getProperties().get("key1")), (String)message);
        operations.clear();
        operations.add(new CopyOperation(new JsonPointer("/properties/key1"), new JsonPointer("/properties/keyCopy1")));
        operations.add(new MoveOperation(new JsonPointer("/properties/key1"), new JsonPointer("/properties/key2")));
        service.patch((Entity)dsOnlyId, operations);
        updatedDs = (Datastream)service.datastreams().find(dsOnlyId.getId());
        message = "properties/keyCopy1 does not exist after copy.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedDs.getProperties().get("keyCopy1")), (String)message);
        message = "properties/key1 still exists after move.";
        Assertions.assertEquals(null, updatedDs.getProperties().get("key1"), (String)message);
        message = "properties/key2 does not exist after move.";
        Assertions.assertEquals((Integer)1, (Integer)((Integer)updatedDs.getProperties().get("key2")), (String)message);
    }

    public static class Implementation11
    extends JsonPatchTests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends JsonPatchTests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

