/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests.c01sensingcore;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.statests.AbstractTestClass;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.c01sensingcore.TestEntityCreator;
import de.fraunhofer.iosb.ilt.statests.util.EntityType;
import de.fraunhofer.iosb.ilt.statests.util.EntityUtils;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import de.fraunhofer.iosb.ilt.statests.util.ServiceUrlHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Capability1Tests
extends AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(Capability1Tests.class);
    private final int resourcePathLevel = 4;

    public Capability1Tests(ServerVersion version) {
        super(version);
    }

    @Override
    protected void setUpVersion() {
        LOGGER.info("Setting up for version {}.", (Object)Capability1Tests.version.urlPart);
        TestEntityCreator.maybeCreateTestEntities(Capability1Tests.getServerSettings(), version);
    }

    @BeforeAll
    public static void setUp() {
        LOGGER.info("Setting up.");
    }

    @AfterAll
    public static void tearDown() throws ServiceFailureException {
        LOGGER.info("Tearing down.");
        EntityUtils.deleteAll(version, serverSettings, service);
    }

    @Test
    void readEntitiesAndCheckResponse() {
        LOGGER.info("  readEntitiesAndCheckResponse");
        Assertions.assertTrue((boolean)serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ), (String)"Actuation entities not registered.");
        for (EntityType entityType : serverSettings.getEnabledEntityTypes()) {
            String response = this.getEntities(entityType);
            this.checkEntitiesAllAspectsForResponse(entityType, response);
        }
    }

    @Test
    void readNonexistentEntity() {
        LOGGER.info("  readNonexistentEntity");
        for (EntityType entityType : serverSettings.getEnabledEntityTypes()) {
            this.readNonexistentEntityWithEntityType(entityType);
        }
    }

    @Test
    void readEntityAndCheckResponse() {
        LOGGER.info("  readEntityAndCheckResponse");
        for (EntityType entityType : serverSettings.getEnabledEntityTypes()) {
            String response = this.readEntityWithEntityType(entityType);
            this.checkEntityAllAspectsForResponse(entityType, response);
        }
    }

    @Test
    void readPropertyOfEntityAndCheckResponse() {
        LOGGER.info("  readPropertyOfEntityAndCheckResponse");
        for (EntityType entityType : serverSettings.getEnabledEntityTypes()) {
            this.readPropertyOfEntityWithEntityType(entityType);
        }
    }

    private void readPropertyOfEntityWithEntityType(EntityType entityType) {
        try {
            String response = this.getEntities(entityType);
            Object id = new JSONObject(response).getJSONArray("value").getJSONObject(0).get("@iot.id");
            for (EntityType.EntityProperty property : entityType.getProperties()) {
                this.checkGetPropertyOfEntity(entityType, id, property);
                this.checkGetPropertyValueOfEntity(entityType, id, property);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception handling " + entityType, (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkGetPropertyOfEntity(EntityType entityType, Object id, EntityType.EntityProperty property) {
        try {
            HTTPMethods.HttpResponse responseMap = this.getEntity(entityType, id, property.name);
            int responseCode = responseMap.code;
            if (responseCode == 204) {
                return;
            }
            String message = "Reading property \"" + property.name + "\" of the existing " + entityType.name() + " with id " + id + " failed.";
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            String response = responseMap.response;
            JSONObject entity = new JSONObject(response);
            try {
                message = "Reading property \"" + property.name + "\"of \"" + entityType + "\" fails.";
                Assertions.assertNotNull((Object)entity.get(property.name), (String)message);
            }
            catch (JSONException e) {
                Assertions.fail((String)("Reading property \"" + property.name + "\"of \"" + entityType + "\" fails."));
            }
            message = "The response for getting property " + property.name + " of a " + entityType + " returns more properties!";
            Assertions.assertEquals((int)1, (int)entity.length(), (String)message);
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkGetPropertyValueOfEntity(EntityType entityType, Object id, EntityType.EntityProperty property) {
        HTTPMethods.HttpResponse responseMap = this.getEntity(entityType, id, property.name + "/$value");
        int responseCode = responseMap.code;
        if (responseCode != 200 && property.optional) {
            return;
        }
        if (responseCode == 204) {
            return;
        }
        String message = "Reading property value of \"" + property + "\" of the exitixting " + entityType.name() + " with id " + id + " failed.";
        Assertions.assertEquals((int)200, (int)responseCode, (String)message);
        String response = responseMap.response;
        if ("object".equalsIgnoreCase(property.jsonType)) {
            message = "Reading property value of \"" + property + "\" of \"" + entityType + "\" fails.";
            Assertions.assertEquals((int)0, (int)response.indexOf("{"), (String)message);
        } else {
            message = "Reading property value of \"" + property + "\" of \"" + entityType + "\" fails.";
            Assertions.assertEquals((int)-1, (int)response.indexOf("{"), (String)message);
        }
    }

    @Test
    void checkResourcePaths() {
        LOGGER.info("  checkResourcePaths");
        for (EntityType entityType : serverSettings.getEnabledEntityTypes()) {
            this.readRelatedEntityOfEntityWithEntityType(entityType);
        }
    }

    private void readRelatedEntityOfEntityWithEntityType(EntityType entityType) {
        ArrayList<String> entityTypes = new ArrayList<String>();
        ArrayList<Object> ids = new ArrayList<Object>();
        entityTypes.add(entityType.plural);
        this.readRelatedEntity(entityTypes, ids);
    }

    private void readRelatedEntity(List<String> entityTypes, List<Object> ids) {
        if (entityTypes.size() > 4) {
            return;
        }
        String urlString = null;
        try {
            String headName = entityTypes.get(entityTypes.size() - 1);
            EntityType headEntity = EntityType.getForRelation(headName);
            boolean isPlural = EntityType.isPlural(headName);
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityTypes, ids, null);
            HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
            int code = responseMap.code;
            String message = "Reading relation of the entity failed: " + entityTypes.toString();
            Assertions.assertEquals((int)200, (int)code, (String)message);
            String response = responseMap.response;
            Object id = isPlural ? new JSONObject(response).getJSONArray("value").getJSONObject(0).get("@iot.id") : new JSONObject(response).get("@iot.id");
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityTypes, ids, "$ref");
            responseMap = HTTPMethods.doGet(urlString);
            code = responseMap.code;
            message = "Reading relation of the entity failed: " + entityTypes.toString();
            Assertions.assertEquals((int)200, (int)code, (String)message);
            response = responseMap.response;
            this.checkAssociationLinks(response, entityTypes, ids);
            if (entityTypes.size() == 4) {
                return;
            }
            if (EntityType.isPlural(headName)) {
                ids.add(id);
            } else {
                ids.add(null);
            }
            for (String relation : headEntity.getRelations(serverSettings.getExtensions())) {
                entityTypes.add(relation);
                this.readRelatedEntity(entityTypes, ids);
                entityTypes.remove(entityTypes.size() - 1);
            }
            ids.remove(ids.size() - 1);
        }
        catch (JSONException e) {
            LOGGER.error("Failed to parse response for " + urlString, (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkAssociationLinks(String response, List<String> entityTypes, List<Object> ids) {
        block8: {
            try {
                String message;
                if (EntityType.isPlural(entityTypes.get(entityTypes.size() - 1))) {
                    String message2 = "The GET entities Association Link response does not match SensorThings API : missing \"value\" in response.: " + entityTypes.toString() + ids.toString();
                    Assertions.assertTrue((boolean)response.contains("value"), (String)message2);
                    JSONArray value = new JSONObject(response).getJSONArray("value");
                    int count = 0;
                    for (int i = 0; i < value.length() && count < 2; ++i) {
                        ++count;
                        JSONObject obj = value.getJSONObject(i);
                        try {
                            message2 = "The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString();
                            Assertions.assertNotNull((Object)obj.get("@iot.selfLink"), (String)message2);
                        }
                        catch (JSONException e) {
                            Assertions.fail((String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                        }
                        message2 = "The Association Link contains properties other than self-link.: " + entityTypes.toString() + ids.toString();
                        Assertions.assertEquals((int)1, (int)obj.length(), (String)message2);
                    }
                    break block8;
                }
                JSONObject obj = new JSONObject(response);
                try {
                    message = "The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString();
                    Assertions.assertNotNull((Object)obj.get("@iot.selfLink"), (String)message);
                }
                catch (JSONException e) {
                    Assertions.fail((String)("The Association Link does not contain self-links.: " + entityTypes.toString() + ids.toString()));
                }
                message = "The Association Link contains properties other than self-link.: " + entityTypes.toString() + ids.toString();
                Assertions.assertEquals((int)1, (int)obj.length(), (String)message);
            }
            catch (JSONException e) {
                LOGGER.error("Exception:", (Throwable)e);
                Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        }
    }

    private String readEntityWithEntityType(EntityType entityType) {
        try {
            String response = this.getEntities(entityType);
            Object id = new JSONObject(response).getJSONArray("value").getJSONObject(0).get("@iot.id");
            HTTPMethods.HttpResponse responseMap = this.getEntity(entityType, id, null);
            int responseCode = responseMap.code;
            String message = "Reading existing " + entityType.name() + " with id " + id + " failed.";
            Assertions.assertEquals((int)200, (int)responseCode, (String)message);
            response = responseMap.response;
            return response;
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private void readNonexistentEntityWithEntityType(EntityType entityType) {
        long id = Long.MAX_VALUE;
        int responseCode = this.getEntity((EntityType)entityType, (Object)Long.valueOf((long)id), null).code;
        String message = "Reading non-existing " + entityType.name() + " with id " + id + " failed.";
        Assertions.assertEquals((int)404, (int)responseCode, (String)message);
    }

    @Test
    void checkServiceRootUri() {
        LOGGER.info("  checkServiceRootUri");
        try {
            String response = this.getEntities(null);
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            HashMap<String, Boolean> addedLinks = new HashMap<String, Boolean>();
            addedLinks.put("Things", false);
            addedLinks.put("Locations", false);
            addedLinks.put("HistoricalLocations", false);
            addedLinks.put("Datastreams", false);
            addedLinks.put("Sensors", false);
            addedLinks.put("Observations", false);
            addedLinks.put("ObservedProperties", false);
            addedLinks.put("FeaturesOfInterest", false);
            if (serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ)) {
                addedLinks.put("MultiDatastreams", false);
            }
            if (serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ)) {
                addedLinks.put("Actuators", false);
                addedLinks.put("TaskingCapabilities", false);
                addedLinks.put("Tasks", false);
            }
            for (int i = 0; i < entities.length(); ++i) {
                JSONObject entity = entities.getJSONObject(i);
                if (!entity.has("name") || !entity.has("url")) {
                    Assertions.fail((String)"Service root URI component does not have proper JSON keys: name and value.");
                }
                String name = entity.getString("name");
                String nameUrl = entity.getString("url");
                addedLinks.put(name, true);
                if ("MultiDatastreams".equals(name)) {
                    String message = "The URL for MultiDatastreams in Service Root URI is not compliant to SensorThings API.";
                    Assertions.assertEquals((Object)(serverSettings.getServiceUrl(version) + "/MultiDatastreams"), (Object)nameUrl, (String)message);
                    continue;
                }
                try {
                    EntityType entityType = EntityType.getForRelation(name);
                    String message = "The URL for " + entityType.plural + " in Service Root URI is not compliant to SensorThings API.";
                    Assertions.assertEquals((Object)(serverSettings.getServiceUrl(version) + "/" + entityType.plural), (Object)nameUrl, (String)message);
                    continue;
                }
                catch (IllegalArgumentException exc) {
                    Assertions.fail((String)("There is a component in Service Root URI response that is not in SensorThings API : " + name));
                }
            }
            for (String key : addedLinks.keySet()) {
                String message = "The Service Root URI response does not contain " + key;
                Assertions.assertTrue((boolean)((Boolean)addedLinks.get(key)), (String)message);
            }
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred during testing!", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private String getEntities(EntityType entityType) {
        String urlString = serverSettings.getServiceUrl(version);
        if (entityType != null) {
            urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, null, null, null);
        }
        HTTPMethods.HttpResponse responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.response;
        int responseCode = responseMap.code;
        Object message = "Error during getting entities: " + (entityType != null ? entityType.name() : "root URI");
        Assertions.assertEquals((int)200, (int)responseCode, (String)message);
        if (entityType != null) {
            message = "The GET entities response for entity type \"" + entityType + "\" does not match SensorThings API : missing \"value\" in response.";
            Assertions.assertTrue((boolean)response.contains("\"value\""), (String)message);
        } else {
            message = "The GET entities response for service root URI does not match SensorThings API : missing \"value\" in response.";
            Assertions.assertTrue((boolean)response.contains("value"), (String)message);
        }
        return response;
    }

    private HTTPMethods.HttpResponse getEntity(EntityType entityType, Object id, String property) {
        if (id == null) {
            return null;
        }
        String urlString = ServiceUrlHelper.buildURLString(serverSettings.getServiceUrl(version), entityType, id, null, property);
        return HTTPMethods.doGet(urlString);
    }

    private void checkEntitiesAllAspectsForResponse(EntityType entityType, String response) {
        this.checkEntitiesControlInformation(response);
        this.checkEntitiesProperties(entityType, response);
        this.checkEntitiesRelations(entityType, response);
    }

    private void checkEntityAllAspectsForResponse(EntityType entityType, String response) {
        this.checkEntityControlInformation(response);
        this.checkEntityProperties(entityType, response);
        this.checkEntityRelations(entityType, response);
    }

    private void checkEntitiesControlInformation(String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityControlInformation(entity);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityControlInformation(Object response) {
        try {
            String message;
            JSONObject entity = new JSONObject(response.toString());
            try {
                message = "The entity does not have mandatory control information : @iot.id";
                Assertions.assertNotNull((Object)entity.get("@iot.id"), (String)message);
            }
            catch (JSONException e) {
                Assertions.fail((String)"The entity does not have mandatory control information : @iot.id");
            }
            try {
                message = "The entity does not have mandatory control information : @iot.selfLink";
                Assertions.assertNotNull((Object)entity.get("@iot.selfLink"), (String)message);
            }
            catch (JSONException e) {
                Assertions.fail((String)"The entity does not have mandatory control information : @iot.selfLink");
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesProperties(EntityType entityType, String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityProperties(entityType, entity);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityProperties(EntityType entityType, Object response) {
        try {
            JSONObject entity = new JSONObject(response.toString());
            for (EntityType.EntityProperty property : entityType.getProperties()) {
                if (property.optional) continue;
                try {
                    String message = "Entity type \"" + entityType + "\" does not have mandatory property: \"" + property + "\".";
                    Assertions.assertNotNull((Object)entity.get(property.name), (String)message);
                }
                catch (JSONException e) {
                    Assertions.fail((String)("Entity type \"" + entityType + "\" does not have mandatory property: \"" + property + "\"."));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesRelations(EntityType entityType, String response) {
        try {
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray entities = jsonResponse.getJSONArray("value");
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityRelations(entityType, entity);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityRelations(EntityType entityType, Object response) {
        try {
            JSONObject entity = new JSONObject(response.toString());
            for (String relation : entityType.getRelations(serverSettings.getExtensions())) {
                try {
                    String message = "Entity type \"" + entityType + "\" does not have mandatory relation: \"" + relation + "\".";
                    Assertions.assertNotNull((Object)entity.get(relation + "@iot.navigationLink"), (String)message);
                }
                catch (JSONException e) {
                    Assertions.fail((String)("Entity type \"" + entityType + "\" does not have mandatory relation: \"" + relation + "\"."));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("Exception:", (Throwable)e);
            Assertions.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    public static class Implementation11
    extends Capability1Tests {
        public Implementation11() {
            super(ServerVersion.v_1_1);
        }
    }

    public static class Implementation10
    extends Capability1Tests {
        public Implementation10() {
            super(ServerVersion.v_1_0);
        }
    }
}

