/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import de.fraunhofer.iosb.ilt.frostserver.FrostMqttServer;
import de.fraunhofer.iosb.ilt.frostserver.http.common.DatabaseStatus;
import de.fraunhofer.iosb.ilt.frostserver.http.common.ServletMain;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.statests.HttpContextListener;
import de.fraunhofer.iosb.ilt.statests.Requirement;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.c01sensingcore.Capability1CoreOnlyTests;
import de.fraunhofer.iosb.ilt.statests.c01sensingcore.Capability1Tests;
import de.fraunhofer.iosb.ilt.statests.c02cud.AdditionalTests;
import de.fraunhofer.iosb.ilt.statests.c02cud.Capability2Tests;
import de.fraunhofer.iosb.ilt.statests.c02cud.DeleteFilterTests;
import de.fraunhofer.iosb.ilt.statests.c02cud.JsonPatchTests;
import de.fraunhofer.iosb.ilt.statests.c02cud.ResultTypesTests;
import de.fraunhofer.iosb.ilt.statests.c03filtering.Capability3Tests;
import de.fraunhofer.iosb.ilt.statests.c03filtering.DateTimeTests;
import de.fraunhofer.iosb.ilt.statests.c03filtering.FilterTests;
import de.fraunhofer.iosb.ilt.statests.c03filtering.GeoTests;
import de.fraunhofer.iosb.ilt.statests.c03filtering.JsonPropertiesTests;
import de.fraunhofer.iosb.ilt.statests.c04batch.BatchTests;
import de.fraunhofer.iosb.ilt.statests.c05multidatastream.MdDateTimeTests;
import de.fraunhofer.iosb.ilt.statests.c05multidatastream.MultiDatastreamTests;
import de.fraunhofer.iosb.ilt.statests.c06dataarrays.DataArrayTests;
import de.fraunhofer.iosb.ilt.statests.c07mqttcreate.Capability7Tests;
import de.fraunhofer.iosb.ilt.statests.c08mqttsubscribe.Capability8Tests;
import de.fraunhofer.iosb.ilt.statests.f01auth.BasicAuthAnonReadTests;
import de.fraunhofer.iosb.ilt.statests.f01auth.BasicAuthTests;
import de.fraunhofer.iosb.ilt.statests.f01auth.KeyCloakAnonReadTests;
import de.fraunhofer.iosb.ilt.statests.f01auth.KeyCloakTests;
import de.fraunhofer.iosb.ilt.statests.f02customlinks.CustomLinksTests;
import de.fraunhofer.iosb.ilt.statests.f03metadata.MetadataTests;
import de.fraunhofer.iosb.ilt.statests.util.HTTPMethods;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@SelectClasses(value={Capability1CoreOnlyTests.Implementation10.class, Capability1CoreOnlyTests.Implementation11.class, Capability1Tests.Implementation10.class, Capability1Tests.Implementation11.class, Capability2Tests.Implementation10.class, Capability2Tests.Implementation11.class, AdditionalTests.Implementation10.class, AdditionalTests.Implementation11.class, DeleteFilterTests.Implementation10.class, DeleteFilterTests.Implementation11.class, JsonPatchTests.Implementation10.class, JsonPatchTests.Implementation11.class, ResultTypesTests.Implementation10.class, ResultTypesTests.Implementation11.class, Capability3Tests.Implementation10.class, Capability3Tests.Implementation11.class, DateTimeTests.Implementation10.class, DateTimeTests.Implementation11.class, FilterTests.Implementation10.class, FilterTests.Implementation11.class, GeoTests.Implementation10.class, GeoTests.Implementation11.class, JsonPropertiesTests.Implementation10.class, JsonPropertiesTests.Implementation11.class, BatchTests.Implementation10.class, BatchTests.Implementation11.class, MultiDatastreamTests.Implementation10.class, MultiDatastreamTests.Implementation11.class, MdDateTimeTests.Implementation10.class, MdDateTimeTests.Implementation11.class, DataArrayTests.Implementation10.class, DataArrayTests.Implementation11.class, Capability7Tests.Implementation10.class, Capability7Tests.Implementation11.class, Capability8Tests.Implementation10.class, Capability8Tests.Implementation11.class, BasicAuthTests.Implementation10.class, BasicAuthTests.Implementation11.class, BasicAuthAnonReadTests.Implementation10.class, BasicAuthAnonReadTests.Implementation11.class, KeyCloakTests.Implementation10.class, KeyCloakTests.Implementation11.class, KeyCloakAnonReadTests.Implementation10.class, KeyCloakAnonReadTests.Implementation11.class, CustomLinksTests.Implementation10.class, CustomLinksTests.Implementation11.class, MetadataTests.Implementation10.class, MetadataTests.Implementation11.class, SuiteFinaliser.class})
@Suite
@Testcontainers
public class TestSuite {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuite.class);
    public static final String KEY_HAS_MULTI_DATASTREAM = "hasMultiDatastream";
    public static final String KEY_HAS_ACTUATION = "hasActuation";
    public static final String VAL_PERSISTENCE_MANAGER = "de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager";
    public static final String VAL_ID_TYPE_DEFAULT = "UUID";
    public static final String VAL_ID_TYPE_OBSERVATIONS = "LONG";
    public static final String VAL_ID_TYPE_HIST_LOCATIONS = "LONG";
    public static final String VAL_PG_DB = "sensorthings";
    public static final String VAL_PG_USER = "sensorthings";
    public static final String VAL_PG_PASS = "ChangeMe";
    private static TestSuite instance;
    private final Map<Properties, Server> httpServers = new HashMap<Properties, Server>();
    private final Map<Properties, FrostMqttServer> mqttServers = new HashMap<Properties, FrostMqttServer>();
    private final Map<Properties, ServerSettings> serverSettings = new HashMap<Properties, ServerSettings>();
    private String pgConnectUrl;
    private final AtomicInteger nextId = new AtomicInteger(1);
    @Container
    private final GenericContainer pgServer = new GenericContainer("postgis/postgis:11-2.5-alpine").withEnv("POSTGRES_DB", "sensorthings").withEnv("POSTGRES_USER", "sensorthings").withEnv("POSTGRES_PASSWORD", "ChangeMe").withExposedPorts(new Integer[]{5432});
    @Container
    private final GenericContainer mqttBus = new GenericContainer("eclipse-mosquitto").withExposedPorts(new Integer[]{1883}).withClasspathResourceMapping("mosquitto.conf", "/mosquitto/config/mosquitto.conf", BindMode.READ_ONLY);
    @Container
    private final KeycloakContainer keycloak = new KeycloakContainer().withRealmImportFile("keycloak/FROST-Test.json");

    public static TestSuite getInstance() {
        if (instance == null) {
            instance = new TestSuite();
            try {
                TestSuite.setUpClass();
            }
            catch (IOException | InterruptedException | RuntimeException ex) {
                LOGGER.error("Failed to initialise.", (Throwable)ex);
            }
        }
        return instance;
    }

    public TestSuite() {
        if (instance == null) {
            instance = this;
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }

    @BeforeAll
    public static void setUpClass() throws IOException, InterruptedException {
        LOGGER.info("Starting Servers...");
    }

    @AfterAll
    public static void tearDownClass() {
        HTTPMethods.logStats();
        LOGGER.info("Stopping Servers...");
        TestSuite.getInstance().stopAllServers();
    }

    public String getPgConnectUrl() {
        try {
            this.maybeStartPostgres();
        }
        catch (IOException | InterruptedException | UnsupportedOperationException ex) {
            LOGGER.error("Failed to start database", (Throwable)ex);
        }
        return this.pgConnectUrl;
    }

    public ServerSettings getServerSettings(Properties parameters) throws IOException, InterruptedException {
        this.maybeStartServers(parameters);
        return this.serverSettings.get(parameters);
    }

    public Server getServer(Properties parameters) throws IOException, InterruptedException {
        this.maybeStartServers(parameters);
        return this.httpServers.get(parameters);
    }

    public KeycloakContainer getKeycloak() {
        if (!this.keycloak.isRunning()) {
            this.keycloak.start();
        }
        return this.keycloak;
    }

    private synchronized void maybeStartPostgres() throws InterruptedException, UnsupportedOperationException, IOException {
        if (!this.pgServer.isRunning()) {
            this.pgServer.start();
            this.mqttBus.start();
            Container.ExecResult execResult = this.pgServer.execInContainer(new String[]{"psql", "-Usensorthings", "-dsensorthings", "-c CREATE EXTENSION IF NOT EXISTS \"uuid-ossp\";"});
            LOGGER.info("Installing extension uuid-ossp: {} {}", (Object)execResult.getStdout(), (Object)execResult.getStderr());
            this.pgConnectUrl = "jdbc:postgresql://" + this.pgServer.getContainerIpAddress() + ":" + this.pgServer.getFirstMappedPort() + "/sensorthings";
        }
    }

    private synchronized void maybeStartServers(Properties parameters) throws IOException, InterruptedException {
        if (!this.serverSettings.containsKey(parameters)) {
            this.startServers(parameters);
        }
    }

    private synchronized void startServers(Properties parameters) throws IOException, InterruptedException {
        if (this.serverSettings.containsKey(parameters)) {
            return;
        }
        this.maybeStartPostgres();
        try {
            LOGGER.info("Testing if Mosquitto works...");
            MqttClient client = new MqttClient("tcp://127.0.0.1:" + this.mqttBus.getFirstMappedPort(), MqttClient.generateClientId(), (MqttClientPersistence)new MemoryPersistence());
            client.connect();
            client.disconnect();
            LOGGER.info("Mosquitto works.");
        }
        catch (MqttException ex) {
            throw new RuntimeException("Failed to connect to bus!", ex);
        }
        this.startHttpServer(parameters);
        this.startMqttServer(parameters);
    }

    private void startHttpServer(Properties parameters) {
        parameters.put("bus.topicName", "FROST-BUS-" + this.nextId.getAndIncrement());
        LOGGER.info("HTTP Server starting...");
        ServerSettings serverSetting = new ServerSettings();
        this.serverSettings.put(parameters, serverSetting);
        HashMap paramsMap = new HashMap();
        parameters.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(t, u) -> paramsMap.put(t.toString(), u.toString())));
        Server myServer = new Server(0);
        HandlerCollection contextHandlerCollection = new HandlerCollection(true, new Handler[0]);
        myServer.setHandler((Handler)contextHandlerCollection);
        try {
            myServer.start();
        }
        catch (Exception ex) {
            LOGGER.error("Exception starting server!");
            throw new IllegalStateException(ex);
        }
        Connector[] connectors = myServer.getConnectors();
        ServerConnector connecor = (ServerConnector)connectors[0];
        serverSetting.setServiceRootUrl("http://localhost:" + connecor.getLocalPort());
        ServletContextHandler handler = new ServletContextHandler();
        handler.getServletContext().setExtendedListenerTypes(true);
        handler.setInitParameter("logSensitiveData", Boolean.TRUE.toString());
        handler.setInitParameter("serviceRootUrl", serverSetting.getServiceRootUrl());
        handler.setInitParameter("tempPath", System.getProperty("java.io.tmpdir"));
        handler.setInitParameter("plugins.coreModel.idType", VAL_ID_TYPE_DEFAULT);
        handler.setInitParameter("plugins.coreModel.idType.observation", "LONG");
        handler.setInitParameter("plugins.coreModel.idType.historicalLocation", "LONG");
        handler.setInitParameter("persistence.persistenceManagerImplementationClass", VAL_PERSISTENCE_MANAGER);
        handler.setInitParameter("persistence.autoUpdateDatabase", "true");
        handler.setInitParameter("persistence.db.driver", "org.postgresql.Driver");
        handler.setInitParameter("persistence.db.url", this.pgConnectUrl);
        handler.setInitParameter("persistence.db.username", "sensorthings");
        handler.setInitParameter("persistence.db.password", VAL_PG_PASS);
        handler.setInitParameter("bus.busImplementationClass", "de.fraunhofer.iosb.ilt.frostserver.messagebus.MqttMessageBus");
        handler.setInitParameter("bus.mqttBroker", "tcp://" + this.mqttBus.getContainerIpAddress() + ":" + this.mqttBus.getFirstMappedPort());
        handler.setInitParameter("bus.sendWorkerPoolSize", Integer.toString(20));
        handler.setInitParameter("bus.sendQueueSize", Integer.toString(10000));
        handler.setInitParameter("bus.maxInFlight", Integer.toString(10000));
        handler.getInitParams().putAll(paramsMap);
        handler.addEventListener((EventListener)((Object)new HttpContextListener()));
        handler.addServlet(DatabaseStatus.class, "/DatabaseStatus");
        handler.addServlet(ServletMain.class, "/*");
        contextHandlerCollection.addHandler((Handler)handler);
        try {
            handler.start();
        }
        catch (Exception ex) {
            LOGGER.error("Exception starting server!");
            throw new IllegalStateException(ex);
        }
        LOGGER.info("Server started.");
        this.httpServers.put(parameters, myServer);
        this.findImplementedVersions(serverSetting);
        this.checkServiceRootUri(serverSetting);
        serverSetting.initExtensionsAndTypes();
    }

    private void startMqttServer(Properties parameters) throws IOException {
        LOGGER.info("MQTT Server starting...");
        ServerSettings serverSetting = this.serverSettings.get(parameters);
        int mqttPort = this.findRandomPort();
        int mqttWsPort = this.findRandomPort();
        LOGGER.info("Generated random ports {}, {}", (Object)mqttPort, (Object)mqttWsPort);
        Properties properties = new Properties();
        properties.put("serviceRootUrl", serverSetting.getServiceRootUrl());
        Path tempDir = Files.createTempDirectory("FROST-Tests", new FileAttribute[0]);
        properties.put("tempPath", tempDir.toString());
        properties.put("mqtt.mqttServerImplementationClass", "de.fraunhofer.iosb.ilt.frostserver.mqtt.moquette.MoquetteMqttServer");
        properties.put("mqtt.Enabled", "true");
        properties.put("mqtt.Port", "" + mqttPort);
        properties.put("mqtt.QoS", "2");
        properties.put("mqtt.SubscribeMessageQueueSize", "100");
        properties.put("mqtt.SubscribeThreadPoolSize", "20");
        properties.put("mqtt.CreateMessageQueueSize", "100");
        properties.put("mqtt.CreateThreadPoolSize", "10");
        properties.put("mqtt.Host", "0.0.0.0");
        properties.put("mqtt.internalHost", "localhost");
        properties.put("mqtt.WebsocketPort", "" + mqttWsPort);
        properties.put("plugins.coreModel.idType", VAL_ID_TYPE_DEFAULT);
        properties.put("plugins.coreModel.idType.observation", "LONG");
        properties.put("plugins.coreModel.idType.historicalLocation", "LONG");
        properties.put("persistence.persistenceManagerImplementationClass", VAL_PERSISTENCE_MANAGER);
        properties.put("persistence.db.driver", "org.postgresql.Driver");
        properties.put("persistence.db.url", "jdbc:postgresql://" + this.pgServer.getContainerIpAddress() + ":" + this.pgServer.getFirstMappedPort() + "/sensorthings");
        properties.put("persistence.db.username", "sensorthings");
        properties.put("persistence.db.password", VAL_PG_PASS);
        properties.put("bus.busImplementationClass", "de.fraunhofer.iosb.ilt.frostserver.messagebus.MqttMessageBus");
        properties.put("bus.mqttBroker", "tcp://" + this.mqttBus.getContainerIpAddress() + ":" + this.mqttBus.getFirstMappedPort());
        if (parameters != null) {
            properties.putAll((Map<?, ?>)parameters);
        }
        CoreSettings coreSettings = new CoreSettings(properties);
        FrostMqttServer server = new FrostMqttServer(coreSettings);
        server.start();
        serverSetting.setMqttUrl("tcp://localhost:" + mqttPort);
        LOGGER.info("MQTT Server started on port {}", (Object)mqttPort);
        this.mqttServers.put(parameters, server);
    }

    public void stopServer(Properties parameters) {
        if (!this.httpServers.containsKey(parameters)) {
            return;
        }
        Server httpServer = this.httpServers.get(parameters);
        if (httpServer != null) {
            try {
                httpServer.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Exception stopping server!");
                throw new IllegalStateException(ex);
            }
        }
        this.httpServers.remove(parameters);
        FrostMqttServer mqttServer = this.mqttServers.get(parameters);
        if (mqttServer != null) {
            try {
                mqttServer.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Exception stopping server!");
                throw new IllegalStateException(ex);
            }
        }
        this.mqttServers.remove(parameters);
        this.serverSettings.remove(parameters);
    }

    public synchronized void stopAllServers() {
        ArrayList<Thread> shutdownThreads = new ArrayList<Thread>();
        for (Properties props : this.httpServers.keySet().toArray(new Properties[this.httpServers.size()])) {
            Thread t = new Thread(() -> this.stopServer(props));
            shutdownThreads.add(t);
            t.start();
        }
        for (Thread t : shutdownThreads) {
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted!", (Throwable)ex);
            }
        }
        this.keycloak.stop();
        this.pgServer.stop();
        this.mqttBus.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findRandomPort() {
        int port;
        ServerSocket s = null;
        try {
            s = new ServerSocket(0);
            port = s.getLocalPort();
            s.close();
            s = null;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to find a port. Using default 11883", (Throwable)ex);
            int n = 11883;
            return n;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to close port.", (Throwable)ex);
                }
            }
        }
        return port;
    }

    public void findImplementedVersions(ServerSettings serverSettings) {
        for (ServerVersion version : ServerVersion.values()) {
            String implemented;
            String rootUri = serverSettings.getServiceUrl(version);
            HTTPMethods.HttpResponse response = HTTPMethods.doGet(rootUri);
            if (response.code == 200) {
                serverSettings.addImplementedVersion(version);
                implemented = "is";
            } else {
                implemented = "not";
            }
            LOGGER.info("Version {} {} implemented.", (Object)version.urlPart, (Object)implemented);
        }
    }

    public void checkServiceRootUri(ServerSettings serverSettings) {
        for (ServerVersion version : serverSettings.getImplementedVersions()) {
            this.checkServiceRootUri(serverSettings, version);
        }
    }

    public void checkServiceRootUri(ServerSettings serverSettings, ServerVersion version) {
        JSONArray entities;
        JSONObject jsonResponse;
        String rootUri = serverSettings.getServiceUrl(version);
        HTTPMethods.HttpResponse response = HTTPMethods.doGet(rootUri);
        if (response == null || response.code != 200) {
            Assertions.fail((String)("Cannot fetch service root url from " + rootUri + "."));
            return;
        }
        try {
            jsonResponse = new JSONObject(response.response);
            entities = jsonResponse.getJSONArray("value");
        }
        catch (JSONException e) {
            LOGGER.error("The service response for the root URI '" + rootUri + "' is not JSON.", (Throwable)e);
            Assertions.fail((String)("The service response for the root URI '" + rootUri + "' is not JSON."));
            return;
        }
        boolean hasActuation = false;
        boolean hasMultiDatastream = false;
        block14: for (int i = 0; i < entities.length(); ++i) {
            String name;
            try {
                JSONObject entity = entities.getJSONObject(i);
                if (!entity.has("name")) {
                    Assertions.fail((String)"The name component of Service root URI response is not available.");
                    return;
                }
                name = entity.getString("name");
            }
            catch (JSONException e) {
                LOGGER.error("The service response for the root URI '" + rootUri + "' is not JSON.", (Throwable)e);
                Assertions.fail((String)("The service response for the root URI '" + rootUri + "' is not JSON."));
                return;
            }
            switch (name) {
                case "Actuators": 
                case "Tasks": 
                case "TaskingCapabilities": {
                    hasActuation = true;
                    continue block14;
                }
                case "MultiDatastreams": {
                    hasMultiDatastream = true;
                    continue block14;
                }
            }
        }
        if (version == ServerVersion.v_1_0) {
            if (hasMultiDatastream) {
                serverSettings.addImplementedRequirement(version, ServerSettings.MULTIDATA_REQ);
            }
            if (hasActuation) {
                serverSettings.addImplementedRequirement(version, ServerSettings.TASKING_REQ);
            }
        }
        if (version == ServerVersion.v_1_1) {
            JSONObject serverSettingsObject = jsonResponse.getJSONObject("serverSettings");
            JSONArray conformanceArray = serverSettingsObject.getJSONArray("conformance");
            for (Object reqItem : conformanceArray.toList()) {
                Set<Requirement> allMatching = Requirement.getAllMatching(reqItem.toString());
                if (allMatching.isEmpty()) {
                    LOGGER.info("Server implements unknown requirement: {}", reqItem);
                }
                serverSettings.addImplementedRequirements(version, allMatching);
            }
            if (hasActuation && !serverSettings.implementsRequirement(version, ServerSettings.TASKING_REQ)) {
                Assertions.fail((String)("Server lists Actuation entities, but does not claim reqirement " + ServerSettings.TASKING_REQ.getName()));
            }
            if (hasMultiDatastream && !serverSettings.implementsRequirement(version, ServerSettings.MULTIDATA_REQ)) {
                Assertions.fail((String)("Server lists the MultiDatastream entity, but does not claim reqirement " + ServerSettings.MULTIDATA_REQ.getName()));
            }
        }
    }

    public static class SuiteFinaliser {
        @Test
        public void finalTest() {
            LOGGER.info("Stopping Servers...");
            Assertions.assertDoesNotThrow(() -> TestSuite.getInstance().stopAllServers());
        }
    }
}

