/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.statests;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import de.fraunhofer.iosb.ilt.statests.ServerSettings;
import de.fraunhofer.iosb.ilt.statests.ServerVersion;
import de.fraunhofer.iosb.ilt.statests.TestSuite;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestClass.class);
    protected static ServerVersion version;
    protected static ServerSettings serverSettings;
    protected static SensorThingsService service;
    private static final Properties defaultProperties;

    public AbstractTestClass(ServerVersion serverVersion) {
        this.init(serverVersion, defaultProperties);
    }

    public AbstractTestClass(ServerVersion serverVersion, Properties properties) {
        this.init(serverVersion, properties);
    }

    private void init(ServerVersion serverVersion, Properties properties) {
        block5: {
            try {
                LOGGER.trace("Init for version {} on {}.", (Object)serverVersion.urlPart, this.getClass());
                if (serverVersion.equals((Object)version)) break block5;
                if (version != null) {
                    this.tearDownVersion();
                }
                version = serverVersion;
                LOGGER.trace("Setting up for version {}.", (Object)AbstractTestClass.version.urlPart);
                TestSuite suite = TestSuite.getInstance();
                serverSettings = suite.getServerSettings(properties);
                try {
                    service = new SensorThingsService(new URL(serverSettings.getServiceUrl(version)));
                }
                catch (MalformedURLException ex) {
                    LOGGER.error("Failed to create URL", (Throwable)ex);
                }
                this.setUpVersion();
            }
            catch (ServiceFailureException | IOException | InterruptedException | RuntimeException | URISyntaxException ex) {
                LOGGER.error("init failed.", ex);
            }
        }
    }

    protected abstract void setUpVersion() throws ServiceFailureException, URISyntaxException;

    protected void tearDownVersion() throws ServiceFailureException {
    }

    @AfterAll
    public static final void cleanupAbstractClass() {
        version = null;
        serverSettings = null;
        service = null;
    }

    public static ServerVersion getVersion() {
        return version;
    }

    public static ServerSettings getServerSettings() {
        return serverSettings;
    }

    public static SensorThingsService getService() {
        return service;
    }

    static {
        defaultProperties = new Properties();
        defaultProperties.put("plugins.actuation.enable", "true");
        defaultProperties.put("plugins.multiDatastream.enable", "true");
        defaultProperties.put("extension.filterDelete.enable", "true");
    }
}

