/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.ServiceOpenApi;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OADoc;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAPath;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.util.HashMap;
import java.util.Map;

public final class GeneratorContext {
    public static final String PARAM_RECURSE = "depth";
    public static final String PARAM_ADD_REF = "ref";
    public static final String PARAM_ADD_PROPS = "properties";
    public static final String PARAM_ADD_VALUE = "value";
    public static final String PARAM_ADD_EDITING = "editing";
    private OADoc document;
    private int recurse = 1;
    private boolean addRef = false;
    private boolean addEntityProperties = false;
    private boolean addValue = false;
    private boolean addEditing = false;
    private Version version = Version.V_1_0;
    private String serviceRootUrl;
    private String base = "/v1.0";
    private final CoreSettings settings;
    private final Map<String, OAPath> pathTargets = new HashMap<String, OAPath>();
    private final Map<String, OAResponse> responseTargets = new HashMap<String, OAResponse>();

    public GeneratorContext(CoreSettings settings) {
        this.settings = settings;
    }

    public GeneratorContext initFromRequest(ServiceRequest request) {
        this.recurse = ServiceOpenApi.paramValueAsInt(request, PARAM_RECURSE, this.recurse);
        this.addRef = ServiceOpenApi.paramValueAsBool(request, PARAM_ADD_REF, this.addRef);
        this.addEntityProperties = ServiceOpenApi.paramValueAsBool(request, PARAM_ADD_PROPS, this.addEntityProperties);
        this.addValue = ServiceOpenApi.paramValueAsBool(request, PARAM_ADD_VALUE, this.addValue);
        this.addEditing = ServiceOpenApi.paramValueAsBool(request, PARAM_ADD_EDITING, this.addEditing);
        this.version = request.getVersion();
        this.serviceRootUrl = this.settings.getQueryDefaults().getServiceRootUrl();
        this.base = "/" + this.version.urlPart;
        return this;
    }

    public CoreSettings getSettings() {
        return this.settings;
    }

    public boolean isAddEditing() {
        return this.addEditing;
    }

    public GeneratorContext setAddEditing(boolean addEditing) {
        this.addEditing = addEditing;
        return this;
    }

    public boolean isAddEntityProperties() {
        return this.addEntityProperties;
    }

    public GeneratorContext setAddEntityProperties(boolean addEntityProperties) {
        this.addEntityProperties = addEntityProperties;
        return this;
    }

    public boolean isAddRef() {
        return this.addRef;
    }

    public GeneratorContext setAddRef(boolean addRef) {
        this.addRef = addRef;
        return this;
    }

    public boolean isAddValue() {
        return this.addValue;
    }

    public GeneratorContext setAddValue(boolean addValue) {
        this.addValue = addValue;
        return this;
    }

    public String getServiceRootUrl() {
        return this.serviceRootUrl;
    }

    public String getBase() {
        return this.base;
    }

    public GeneratorContext setBase(String base) {
        this.base = base;
        return this;
    }

    public OADoc getDocument() {
        return this.document;
    }

    public GeneratorContext setDocument(OADoc document) {
        this.document = document;
        return this;
    }

    public Map<String, OAPath> getPathTargets() {
        return this.pathTargets;
    }

    public int getRecurse() {
        return this.recurse;
    }

    public GeneratorContext setRecurse(int recurse) {
        this.recurse = recurse;
        return this;
    }

    public Map<String, OAResponse> getResponseTargets() {
        return this.responseTargets;
    }

    public Version getVersion() {
        return this.version;
    }

    public GeneratorContext setVersion(Version version) {
        this.version = version;
        return this;
    }
}

