/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OASchema;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OAParameter {
    @JsonProperty(value="$ref")
    private String ref;
    private String name;
    private In in = In.PATH;
    private String description;
    private Boolean required = false;
    private OASchema schema;

    public OAParameter(String refName) {
        this.ref = "#/components/parameters/" + refName;
        this.in = null;
        this.required = null;
    }

    public OAParameter(String name, String description, OASchema schema) {
        this.name = name;
        this.description = description;
        this.schema = schema;
        this.required = true;
    }

    public OAParameter(String name, In in, String description, OASchema schema) {
        this.name = name;
        this.description = description;
        this.schema = schema;
        this.in = in;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public In getIn() {
        return this.in;
    }

    public void setIn(In in) {
        this.in = in;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public OASchema getSchema() {
        return this.schema;
    }

    public void setSchema(OASchema schema) {
        this.schema = schema;
    }

    public static enum In {
        QUERY,
        HEADER,
        PATH,
        COOKIE;

    }
}

