/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAHeader;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAParameter;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAResponse;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OASchema;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OAComponents {
    private Map<String, OASchema> schemas;
    private Map<String, OAParameter> parameters;
    private Map<String, OAResponse> responses;
    private Map<String, OAHeader> headers;

    public Map<String, OASchema> getSchemas() {
        return this.schemas;
    }

    public void addSchema(String name, OASchema schema) {
        if (this.schemas == null) {
            this.schemas = new TreeMap<String, OASchema>();
        }
        this.schemas.put(name, schema);
    }

    public boolean hasSchema(String name) {
        if (this.schemas == null) {
            return false;
        }
        return this.schemas.containsKey(name);
    }

    public OASchema getSchema(String name) {
        if (this.schemas == null) {
            return null;
        }
        return this.schemas.get(name);
    }

    public Map<String, OAParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, OAParameter param) {
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, OAParameter>();
        }
        this.parameters.put(name, param);
    }

    public boolean hasParameter(String name) {
        if (this.parameters == null) {
            return false;
        }
        return this.parameters.containsKey(name);
    }

    public OAParameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public Map<String, OAResponse> getResponses() {
        return this.responses;
    }

    public void addResponse(String name, OAResponse value) {
        if (this.responses == null) {
            this.responses = new TreeMap<String, OAResponse>();
        }
        this.responses.put(name, value);
    }

    public boolean hasResponse(String name) {
        if (this.responses == null) {
            return false;
        }
        return this.responses.containsKey(name);
    }

    public OAResponse getResponse(String name) {
        if (this.responses == null) {
            return null;
        }
        return this.responses.get(name);
    }

    public Map<String, OAHeader> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, OAHeader value) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, OAHeader>();
        }
        this.headers.put(name, value);
    }

    public boolean hasHeader(String name) {
        if (this.headers == null) {
            return false;
        }
        return this.headers.containsKey(name);
    }

    public OAHeader getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }
}

