/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimpleSet;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OASchema {
    @JsonProperty(value="$ref")
    private String ref;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Type type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Format format;
    private String description;
    @JsonProperty(value="default")
    private String deflt;
    private OASchema items;
    private Map<String, OASchema> properties;
    private Boolean additionalProperties;
    private Boolean readOnly;

    public OASchema(Type type, Format format) {
        this.type = type;
        this.format = format;
    }

    public OASchema(String ref) {
        this.ref = ref;
    }

    public OASchema(Version version, PropertyType propertyType) {
        switch (version.urlPart) {
            case "v1.0": 
            case "v1.1": {
                this.type = Type.STRING;
                return;
            }
        }
        String propertyName = propertyType.getName();
        if ("TM_Period".equals(propertyName) || "TM_Object".equals(propertyName)) {
            this.type = Type.OBJECT;
            this.addSubtypeComplex(version, (TypeComplex)propertyType);
            return;
        }
        switch (propertyType.getName()) {
            case "Edm.Binary": {
                this.type = Type.STRING;
                this.format = Format.BINARY;
                break;
            }
            case "Edm.Boolean": {
                this.type = Type.BOOLEAN;
                break;
            }
            case "Edm.Int16": 
            case "Edm.Int32": {
                this.type = Type.INTEGER;
                this.format = Format.INT32;
                break;
            }
            case "Edm.Int64": {
                this.type = Type.INTEGER;
                this.format = Format.INT64;
                break;
            }
            case "Edm.Double": 
            case "Edm.Decimal": {
                this.type = Type.NUMBER;
                this.format = Format.DOUBLE;
                break;
            }
            case "Edm.DateTimeOffset": {
                this.type = Type.STRING;
                this.format = Format.DATETIME;
                break;
            }
            case "Edm.Date": {
                this.type = Type.STRING;
                this.format = Format.DATE;
                break;
            }
            case "Object": {
                this.type = Type.OBJECT;
                break;
            }
            case "Edm.Untyped": 
            case "ANY": {
                this.type = null;
                break;
            }
            case "Edm.String": {
                this.type = Type.STRING;
                break;
            }
            case "Edm.Geometry": 
            case "Geometry": {
                this.type = Type.OBJECT;
                break;
            }
            default: {
                if (propertyType instanceof TypeComplex) {
                    TypeComplex typeComplex = (TypeComplex)propertyType;
                    this.type = Type.OBJECT;
                    this.addSubtypeComplex(version, typeComplex);
                    break;
                }
                if (propertyType instanceof TypeSimpleSet) {
                    TypeSimpleSet typeSimpleSet = (TypeSimpleSet)propertyType;
                    this.type = Type.ARRAY;
                    this.setItems(new OASchema(version, typeSimpleSet.getContaintedType()));
                    break;
                }
                this.type = Type.STRING;
            }
        }
    }

    private void addSubtypeComplex(Version version, TypeComplex typeComplex) {
        for (Map.Entry subPropEntry : typeComplex.getPropertiesByName().entrySet()) {
            String subPropName = (String)subPropEntry.getKey();
            Property subProp = (Property)subPropEntry.getValue();
            this.addProperty(subPropName, new OASchema(version, subProp.getType()));
        }
    }

    public void addProperty(String name, OASchema property) {
        if (this.properties == null) {
            this.properties = new TreeMap<String, OASchema>();
        }
        this.properties.put(name, property);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDeflt() {
        return this.deflt;
    }

    public void setDeflt(String deflt) {
        this.deflt = deflt;
    }

    public OASchema getItems() {
        return this.items;
    }

    public void setItems(OASchema items) {
        this.items = items;
    }

    public Map<String, OASchema> getProperties() {
        return this.properties;
    }

    public Boolean getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static enum Type {
        STRING,
        NUMBER,
        INTEGER,
        OBJECT,
        ARRAY,
        BOOLEAN;

    }

    public static enum Format {
        BINARY,
        INT32,
        INT64,
        FLOAT,
        DOUBLE,
        DATE,
        DATETIME;

    }
}

