/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.ServiceOpenApi;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginOpenApi
implements PluginService,
PluginRootDocument,
ConfigDefaults {
    @DefaultValueBoolean(value=false)
    public static final String TAG_ENABLE_OPENAPI = "openApi.enable";
    private static final String REQUIREMENT_OPENAPI = "https://fraunhoferiosb.github.io/FROST-Server/extensions/OpenAPI.html";
    private CoreSettings settings;
    private boolean enabled;

    public void init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        this.enabled = pluginSettings.getBoolean(TAG_ENABLE_OPENAPI, this.getClass());
        if (this.enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
        }
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.add(REQUIREMENT_OPENAPI);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<Version> getVersions() {
        return Arrays.asList(Version.V_1_0, Version.V_1_1, PluginOData.VERSION_ODATA_40, PluginOData.VERSION_ODATA_401);
    }

    public Collection<String> getVersionedUrlPaths() {
        return Arrays.asList("/api");
    }

    public Collection<String> getRequestTypes() {
        return Arrays.asList("openApi");
    }

    public String getRequestTypeFor(Version version, String path, HttpMethod method, String contentType) {
        if (HttpMethod.GET.equals((Object)method) && path.equals("/api")) {
            return "openApi";
        }
        throw new IllegalArgumentException("Method " + method + "not valid for path " + path);
    }

    public ServiceResponse execute(Service service, ServiceRequest request, ServiceResponse response) {
        return new ServiceOpenApi(this.settings).executeRequest(request, response);
    }
}

