/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAHeader;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OAMediaType;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OAResponse {
    @JsonProperty(value="$ref")
    private String ref;
    private String description;
    private Map<String, OAHeader> headers;
    private Map<String, OAMediaType> content;

    public void addHeader(String name, OAHeader header) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, OAHeader>();
        }
        this.headers.put(name, header);
    }

    public boolean hasHeader(String name) {
        if (this.headers == null) {
            return false;
        }
        return this.headers.containsKey(name);
    }

    public OAHeader getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void addContent(String name, OAMediaType item) {
        if (this.content == null) {
            this.content = new TreeMap<String, OAMediaType>();
        }
        this.content.put(name, item);
    }

    public boolean hasContent(String name) {
        if (this.content == null) {
            return false;
        }
        return this.content.containsKey(name);
    }

    public OAMediaType getContent(String name) {
        if (this.content == null) {
            return null;
        }
        return this.content.get(name);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, OAHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, OAHeader> headers) {
        this.headers = headers;
    }

    public Map<String, OAMediaType> getContent() {
        return this.content;
    }

    public void setContent(Map<String, OAMediaType> content) {
        this.content = content;
    }
}

